<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################


If Len(request.Form("return")) Then Response.Redirect ("manage_app_pools.asp?appname=" & Request("appname"))

message = ""
If Len(Request.QueryString("tc")) Then
  Select Case Request.QueryString("tc")
	Case "1"
	  message = "<TR><TH colspan=""2""><font color=""#99FFFF"">Task Completed</font></TH></TR>"
	Case "0"
	  message = "<TR><TH colspan=""2""><font color=""#FF3300"">Task Not Completed</font></TH></TR>"
  End Select
End If

errmesg = ""

'The follow are subs that DO the work
Select Case LCase(Request("action"))
  Case "do_delete"
    Call Do_Delete()
  Case "change_periodicrestartrequests"
    Call Change_periodicrestartrequests()
  Case "change_periodicrestarttime"
    Call Change_PeriodicRestartTime()
  Case "change_periodicrestartschedule"
    Call Change_PeriodicRestartSchedule(errmesg)
  Case "change_periodicrestartmemory"
    Call Change_PeriodicRestartMemory()
  Case "change_periodicrestartprivatememory"
    Call Change_PeriodicRestartPrivateMemory()
  Case "change_idletimeout"
    Call Change_IdleTimeout()
  Case "change_apppoolqueuelength"
    Call Change_AppPoolQueueLength()
  Case "change_cpulimit"
    Call Change_CPULimit()
  Case "change_maxprocesses"
    Call Change_MaxProcesses()
  Case "change_pingingenabled"
    Call Change_PingingEnabled()
  Case "change_rapidfailprotection"
    Call Change_RapidFailProtection()
  Case "change_timelimits"
    Call Change_TimeLimits()
End Select
%>
<!-- #INCLUDE FILE="common\head.inc" -->
<!-- #INCLUDE FILE="common\Functions.inc" -->
<DIV id="maincontent">
<%
'The follow are subs that SHOW and return output
Select Case LCase(Request("action"))
  Case "periodicrestartrequests"
    Call periodicrestartrequests()
  Case "periodicrestarttime"
    Call PeriodicRestartTime()
  Case "periodicrestartschedule"
    Call PeriodicRestartSchedule(errmesg)
  Case "change_periodicrestartschedule"
    Call PeriodicRestartSchedule(errmesg)
  Case "periodicrestartmemory"
    Call PeriodicRestartMemory()
  Case "periodicrestartprivatememory"
    Call PeriodicRestartPrivateMemory()
  Case "idletimeout"
    Call IdleTimeout()
  Case "apppoolqueuelength"
    Call AppPoolQueueLength()
  Case "cpulimit"
    Call CPULimit()
  Case "maxprocesses"
    Call MaxProcesses()
  Case "pingingenabled"
    Call PingingEnabled()
  Case "rapidfailprotection"
    Call RapidFailProtection()
  Case "timelimits"
    Call TimeLimits()
  Case "showassocsites"
    Call ShowAssocSites()
  Case "delete"
    Call ShowDelete()

End Select

Sub periodicrestartrequests()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
%>

<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_periodicrestartrequests">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=2>Manage Periodic Recycle by Requests for <%=AppPool.Name%></TH></TR>
  <TR>
    <TH>Current</TH>
    <TD><% If AppPool.periodicrestartrequests = 0 Then Response.write "0, Disabled" Else Response.write AppPool.periodicrestartrequests %></TD>
  </TR>
  <TR><TH>New</TH><TD><input type="text" name="periodicrestartrequests" id="GiveMeFocus" value="<%=AppPool.periodicrestartrequests%>" size="10"></TD></TR>

  <TR><TH>&nbsp;</TH>
      <TD>
        <UL class="config_note">
          <LI>Recycle the Application when the amount of requests hits this amount.</LI>
          <LI>Enter 0 (zero) to disable Recycle By Requests</LI>
        </UL>
      </TD>
  </TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD></TR>
</table>
</form>
<%
End Sub

Sub PeriodicRestartTime()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
%>

<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_PeriodicRestartTime">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=2>Manage Periodic Restart by Time in Minutes for <%=AppPool.Name%></TH></TR>
  <TR>
    <TH>Current</TH>
    <TD><% If AppPool.PeriodicRestartTime = 0 Then Response.write "0, Disabled" Else Response.write AppPool.PeriodicRestartTime %></TD>
  </TR>
  <TR><TH>New</TH><TD><input type="text" name="PeriodicRestartTime" id="GiveMeFocus" value="<%=AppPool.PeriodicRestartTime%>" size="10"></TD></TR>

  <TR><TH>&nbsp;</TH>
      <TD>
        <UL class="config_note">
          <LI>Recycle the Application when the amount of time in minutes exceeds this amount.</LI>
          <LI>Enter 0 (zero) to disable Recycle By Time (in Minutes)</LI>
          <LI>1440 minutes is 24 hours</LI>
        </UL>
      </TD>
  </TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD></TR>
</table>
</form>
<%
End Sub

Sub PeriodicRestartSchedule(errmesg)
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  PRS = AppPool.PeriodicRestartSchedule
  If Ubound(PRS) >= 0 Then
     PRSDisp = "<tr><td>"
     PRSDisp = PRSDisp & "<form method=""post"" action=""manage_app_pools_cfg.asp?action=change_PeriodicRestartSchedule&prs=remove&appname=" & Request("appname") & """>"
     PRSDisp = PRSDisp & "<select multiple name=""remPRS"" size=""" & Ubound(PRS)+1 & """>"
     cnt = 0
     For cnt = 0 to UBound(PRS)
       PRSDisp = PRSDisp & "<option value=""" & PRS(cnt) & """>" & PRS(cnt) & "</option>"
     Next
     PRSDisp = PRSDisp & "</SELECT></TD><TD><input type=""submit"" value=""Remove Time(s)""></TD></FORM></TR>"
  Else
    PRSDisp = "<TD colspan=""2"">No Times Scheduled</TD>"
  End If
%>

<TABLE width="75%">
  <TR><TH colspan="2">Manage Periodic Restart by Schedule for <%=AppPool.Name%></TH></TR>
  <TR><TD colspan="2">Times are in 24 hour format!</TD></TR>
  <TR><TH>Current Times</TH><TD>&nbsp;</TD></TR>
  <%=PRSDisp %>

  <form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_PeriodicRestartSchedule&prs=add&appname=<%=Request("appname")%>">
  <TR><TH>Add a Time</TH><TD>&nbsp;</TD></TR>
  <TR>
    <TD>
      <input type="text" name="newPRS" size="4" maxlength="5"><br>
      Please enter in 24 hour format.<br>
      Example, 16:00 is 4:00PM
    </TD>
    <TD><input type="submit" value="Add Time"></TD>
  </TR>
  </form>

  <TR><TD class="err" colspan="2">&nbsp;<%=errmesg%></TD></TR>

  <form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_PeriodicRestartSchedule&appname=<%=Request("appname")%>">
  <TR><TD colspan="2"><input type="submit" name="return" value="Manage Pool"></TD></TR>
  </form>
</table>
</form>
<%
End Sub

Sub PeriodicRestartMemory()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_PeriodicRestartMemory">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=2>Manage Recycle by Memory used for <%=AppPool.Name%></TH></TR>
  <TR>
    <TH>Current</TH>
    <TD><% If AppPool.PeriodicRestartMemory = 0 Then Response.write "0, Disabled" Else Response.write AppPool.PeriodicRestartMemory / 1024 %></TD>
  </TR>
  <TR><TH>New</TH><TD><input type="text" name="PeriodicRestartMemory" id="GiveMeFocus" value="<%=AppPool.PeriodicRestartMemory /1024%>" size="10"></TD></TR>

  <TR><TH>&nbsp;</TH>
      <TD>
        <UL class="config_note">
          <LI>Amount can not be greater then 2000000.</LI>
          <LI>Enter 0 (zero) to disable Recycle By Memory used</LI>
        </UL>
      </TD>
  </TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD></TR>
  <TR><TH class="err" colspan="2"><%=Request("errmesg")%></TH></TR>
</table>
</form>
<%
End Sub

Sub PeriodicRestartPrivateMemory()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_PeriodicRestartPrivateMemory">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=2>Manage Recycle by Virtual Memory used for <%=AppPool.Name%></TH></TR>
  <TR>
    <TH>Current</TH>
    <TD><% If AppPool.PeriodicRestartPrivateMemory = 0 Then Response.write "0, Disabled" Else Response.write AppPool.PeriodicRestartPrivateMemory / 1024 %></TD>
  </TR>
  <TR><TH>New</TH><TD><input type="text" name="PeriodicRestartPrivateMemory" id="GiveMeFocus" value="<%=AppPool.PeriodicRestartPrivateMemory /1024%>" size="10"></TD></TR>

  <TR><TH>&nbsp;</TH>
      <TD>
        <UL class="config_note">
          <LI>Amount can not be greater then 2000000.</LI>
          <LI>Enter 0 (zero) to disable Recycle By Virtual Memory used</LI>
        </UL>
      </TD>
  </TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD></TR>
  <TR><TH class="err" colspan="2"><%=Request("errmesg")%></TH></TR>
</table>
</form>
<%
End Sub

Sub IdleTimeout()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_IdleTimeout">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=2>Manage Shutdown after Idle Timeout for <%=AppPool.Name%></TH></TR>
  <TR>
    <TH>Current</TH>
    <TD><% If AppPool.IdleTimeout = 0 Then Response.write "0, Disabled" Else Response.write AppPool.IdleTimeout%> Minutes</TD>
  </TR>
  <TR><TH>New</TH><TD><input type="text" name="IdleTimeout" id="GiveMeFocus" value="<%=AppPool.IdleTimeout%>" size="10"></TD></TR>

  <TR><TH>&nbsp;</TH>
      <TD>
        <UL class="config_note">
          <LI>Amount can not be greater then 4000000.</LI>
          <LI>Enter 0 (zero) to disable Shutdown By Idle Timeout</LI>
        </UL>
      </TD>
  </TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD></TR>
  <TR><TH class="err" colspan="2"><%=Request("errmesg")%></TH></TR>
</table>
</form>
<%
End Sub

Sub AppPoolQueueLength()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_AppPoolQueueLength">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=2>Manage Limiting of Request Queue for <%=AppPool.Name%></TH></TR>
  <TR>
    <TH>Current</TH>
    <TD><% If AppPool.AppPoolQueueLength = 65535 Then Response.write "0, Disabled" Else Response.write AppPool.AppPoolQueueLength%> Requests</TD>
  </TR>
  <TR><TH>New</TH><TD><input type="text" name="AppPoolQueueLength" id="GiveMeFocus" value="<%=AppPool.AppPoolQueueLength%>" size="10"></TD></TR>

  <TR><TH>&nbsp;</TH>
      <TD>
        <UL class="config_note">
          <LI>Amount can not be greater then 65535.</LI>
          <LI>Enter 0 (zero) or 65535 to disable Limiting of Requests</LI>
        </UL>
      </TD>
  </TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD></TR>
  <TR><TH class="err" colspan="2"><%=Request("errmesg")%></TH></TR>
</table>
</form>
<%
End Sub

Sub CPULimit()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_CPULimit">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=4>Manage CPU Limiting for <%=AppPool.Name%></TH></TR>
  <TR>
    <TH>Current CPU Limit</TH>
    <TD><% If AppPool.CPULimit = 0 Then Response.write "0, Disabled" Else Response.write (AppPool.CPULimit/1000)%>%</TD>
    <TH>New</TH>
    <TD><input type="text" name="CPULimit" id="GiveMeFocus" value="<%=(AppPool.CPULimit/1000)%>" size="10" ></TD>
  </TR>
  <TR>
    <TH>Current CPU Refresh Interval</TH>
    <TD><% Response.write AppPool.CPUResetInterval%> Minutes</TD>
    <TH>New</TH>
    <TD><input type="text" name="CPUResetInterval" value="<%=AppPool.CPUResetInterval%>" size="10" ></TD>
  </TR>
  <TR><TH>Action When Limit Reached</TH>
    <TD>
      <Select name="CPUAction">
        <OPTION VALUE="0" <%If AppPool.CPUAction = 0 Then Response.write "SELECTED" %>>No Action</OPTION>
        <OPTION VALUE="1" <%If AppPool.CPUAction = 1 Then Response.write "SELECTED" %>>Shutdown</OPTION>
      </Select>
    </TD>
    <TD colspan="2">&nbsp;</TD>
  </TR>

  <TR><TH>&nbsp;</TH>
    <TD colspan="3">
      <UL class="config_note">
        <LI>CPU Limit amount can not be greater then 100.</LI>
        <LI>Enter 0 (zero) for CPU Limit to disable Limiting of the CPU</LI>
      </UL>
    </TD>
  </TR>
  <TR>
    <TH>&nbsp;</TH>
    <TD colspan="3"><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD>
  </TR>
  <TR><TH class="err" colspan="4"><%=Request("errmesg")%></TH></TR>
</table>
</form>
<%
End Sub

Sub MaxProcesses()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_MaxProcesses">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan="2">Manage MaxProcesses for <%=AppPool.Name%></TH></TR>
  <TR>
    <TH>Current Max Processes</TH>
    <TD><%=AppPool.MaxProcesses%></TD>
  </TR>
  <TR>
    <TH>New Max Processes</TH>
    <TD><input type="text" name="MaxProcesses" id="GiveMeFocus" value="<%=AppPool.MaxProcesses%>" size="10" ></TD>
  </TR>
  <TR><TH>Orphan Worker Processes</TH>
    <TD>
      <Select name="OrphanWorkerProcess">
        <OPTION VALUE="0" <%If AppPool.OrphanWorkerProcess = False Then Response.write "SELECTED" %>>No</OPTION>
        <OPTION VALUE="1" <%If AppPool.OrphanWorkerProcess = True Then Response.write "SELECTED" %>>Yes</OPTION>
      </Select>
      <br>Should be used only for debugging purposes!!
    </TD>
  </TR>
  <% If AppPool.OrphanWorkerProcess = True Then %>
  <TR>
    <TH>Run this application when a Worker Process is Orphaned</TH>
    <TD><input type="text" name="OrphanActionExe" value="<%=AppPool.OrphanActionExe%>" size="30" ></TD>
  </TR>
  <TR>
    <TH>Optional Parameters to pass</TH>
    <TD><input type="text" name="OrphanActionParams" value="<%=AppPool.OrphanActionParams%>" size="15" ></TD>
  </TR>
  <% Else %>
    <Input type="Hidden" name="OrphanActionExe" value="">
    <Input type="Hidden" name="OrphanActionParams" value="">
  <% End If %>
  <TR><TH>&nbsp;</TH>
    <TD>
      <UL class="config_note">
        <LI>Max Processes can not exceed 4000000</LI>
        <LI>Max Processes can not be disabled. The minimum value is 1</LI>
        <LI>Orphan Worker Process: When a worker process that fails to respond to pings and suffers fatal errors, it will be orphaned in the application pool.</LI>
      </UL>
    </TD>
  </TR>
  <TR>
    <TH>&nbsp;</TH>
    <TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD>
  </TR>
  <TR><TH class="err" colspan="2"><%=Request("errmesg")%></TH></TR>
</table>
</form>
<%
End Sub

Sub PingingEnabled()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_PingingEnabled">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=2>Manage Pinging of Processes for <%=AppPool.Name%></TH></TR>
  <TR>
    <TH>Pinging</TH>
    <TD>
      <Select name="PingingEnabled">
        <OPTION VALUE="0" <%If AppPool.PingingEnabled = False Then Response.write "SELECTED" %>>Disabled</OPTION>
        <OPTION VALUE="1" <%If AppPool.PingingEnabled = True Then Response.write "SELECTED" %>>Enabled</OPTION>
      </Select>
    </TD>
  </TR>
  <TR>
    <TH>Interval (in Seconds)</TH>
    <TD><input type="text" name="PingInterval" value="<%=AppPool.PingInterval%>" size="5"></TD>
  </TR>
  <TR>
    <TH>Timeout (in Seconds)</TH>
    <TD><input type="text" name="PingResponseTime" value="<%=AppPool.PingResponseTime%>" size="5" ></TD>
  </TR>

  <TR><TH>&nbsp;</TH>
      <TD>
        <UL class="config_note">
          <LI>Interval and Timeout must be between 1 and 4000000</LI>
        </UL>
      </TD>
  </TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD></TR>
  <TR><TH class="err" colspan="2" ><%=Request("errmesg")%></TH></TR>
</table>
</form>
<%
End Sub

Sub RapidFailProtection()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_RapidFailProtection">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=2>Manage Rapid Fail Protection for <%=AppPool.Name%></TH></TR>
  <TR>
    <TH>Rapid Fail Protection</TH>
    <TD>
      <Select name="RapidFailProtection">
        <OPTION VALUE="0" <%If AppPool.RapidFailProtection = False Then Response.write "SELECTED" %>>Disabled</OPTION>
        <OPTION VALUE="1" <%If AppPool.RapidFailProtection = True Then Response.write "SELECTED" %>>Enabled</OPTION>
      </Select>
    </TD>
  </TR>
  <TR>
    <TH>Time Period (in Minutes)</TH>
    <TD><input type="text" name="RapidFailProtectionInterval" value="<%=AppPool.RapidFailProtectionInterval%>" size="5"></TD>
  </TR>
  <TR>
    <TH>Failures</TH>
    <TD><input type="text" name="RapidFailProtectionMaxCrashes" value="<%=AppPool.RapidFailProtectionMaxCrashes%>" size="5" ></TD>
  </TR>

  <TR><TH>&nbsp;</TH>
      <TD>
        <UL class="config_note">
          <LI>Time Period and Failures must be between 1 and 4000000</LI>
        </UL>
      </TD>
  </TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD></TR>
  <TR><TH class="err" colspan="2" ><%=Request("errmesg")%></TH></TR>
</table>
</form>
<%
End Sub

Sub TimeLimits()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=change_timelimits">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=2>Manage Startup/Shutdown Time Limits for <%=AppPool.Name%></TH></TR>
  <TR>
    <TH>Startup</TH>
    <TD><input type="text" name="StartupTimeLimit" value="<%=AppPool.StartupTimeLimit%>" size="5" > Seconds</TD>
  </TR>
  <TR>
    <TH>Shutdown</TH>
    <TD><input type="text" name="ShutdownTimeLimit" value="<%=AppPool.ShutdownTimeLimit%>" size="5" > Seconds</TD>
  </TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD></TR>
  <TR><TH class="err" colspan="2"><%=Request("errmesg")%></TH></TR>
</table>
</form>
<%
End Sub

Sub ShowAssocSites()
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp?">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=2>Sites configured to use: <%=Request("appname")%></TH></TR>
<%
  Set objComp = GetObject("IIS://" & Application("Server") & "/W3SVC")
    flag = 0
    For each site in objComp
      If IsNumeric(site.name) Then
        Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & site.Name & "/ROOT")
'         Response.write site.name & " : " & objSiteRoot.AppPoolID & "<br>"
        If LCase(objSiteRoot.AppPoolID) = LCase(Request("appname")) Then
          flag = 1
          Response.write "<TR><TD>" & Site.ServerComment & "</TD><TD><a class=""man_link"" href=""manage_w3svc.asp?site=" & site.Name & """>Manage</a></TD></TR>"
        End If
      End If
    Next
    If flag = 0 Then Response.write "<TR><TD colspan=""2"">There are currently no sites configured to use this application pool</TD></TR>"
%>
  <TR><TH>&nbsp;</TH><TD><input type="submit" name="return" value="Manage Pool"></TD></TR>
</table>
</form>
<%
End Sub

Sub ShowDelete()
' Check to see if there are any Applications/Sites associated
  Set objComp = GetObject("IIS://" & Application("Server") & "/W3SVC")
    flag = 0
    For each site in objComp
      If IsNumeric(site.name) Then
        Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & site.Name & "/ROOT")
        If LCase(objSiteRoot.AppPoolID) = LCase(Request("appname")) Then flag = 1
      End If
    Next
If flag = 0 Then
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp?action=do_delete">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan=2>Delete the Application Pool: <%=Request("appname")%></TH></TR>
  <TR><TD colspan=2>Are you SURE you want to delete this application pool?</TD></TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Delete" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Pool"></TD></TR>
</table>
</form>
<%
Else
%>
<form name="theform" method="post" action="manage_app_pools_cfg.asp">
<TABLE width="75%">
  <Input type="Hidden" name="appname" value="<%=Request("appname")%>">
  <TR><TH colspan="3">Delete the Application Pool: <%=Request("appname")%></TH></TR>
  <TR><TH>&nbsp;</TH><TD colspan="2">You can not delete an Application Pool while there are associated applications.</TD></TR>
  <TR><TH>&nbsp;</TH><TD>Reassign the applications to another pool to continue</TD><TD><a class="man_link" href="manage_app_pools_cfg.asp?action=ShowAssocSites&appname=<%=Server.URLEncode(Request("appname"))%>">Manage</a></TD></TR>
  <TR><TH>&nbsp;</TH><TD colspan="2"><input type="submit" name="return" value="Manage Pool"></TD></TR>
</table>
</form>
<%
End If
End Sub





'##########
'Below is where the action takes place.
'All subs will redirect back to the Application Pool's display page.

Sub Change_periodicrestartrequests()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  AppPool.periodicrestartrequests = Trim(Request("periodicrestartrequests"))
  AppPool.SetInfo
  Set AppPool = nothing
  Response.Redirect ("manage_app_pools.asp?appname=" & Request("appname") & "&tc=1")
End Sub
Sub Change_PeriodicRestartTime()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  AppPool.PeriodicRestartTime = Trim(Request("PeriodicRestartTime"))
  AppPool.SetInfo
  Set AppPool = nothing
  Response.Redirect ("manage_app_pools.asp?appname=" & Request("appname") & "&tc=1")
End Sub

Sub Change_PeriodicRestartSchedule(errmesg)
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  PRS = AppPool.PeriodicRestartSchedule
  Dim TmpPRS(), pos
  Select Case LCase(Request("prs"))
    Case "remove"
      pos = 0
      For i = 1 To Request("remPRS").Count 'Loop through the selected times to remove
        For x = 0 to UBound(PRS) 'Loop through configured times
          If PRS(x) <> Request("remPRS").Item(i) Then
            ReDim Preserve TmpPRS(pos)
            TmpPRS(pos) = PRS(x) 'Keep the time
            pos = pos + 1
          End If
        Next
      Next
    Case "add"
      If InStr(Request("newPRS"),":") = False Then
        errmesg = "Invalid Time Format"
      Else
        newTime = Split(Request("newPRS"),":")
        If Len(newTime(0)) <> 2 OR Len(newTime(1)) <> 2 OR newTime(0) > 24 OR newTime(1) > 60 Then
          errmesg = "Invalid Time Format"
        Else 'Should be good
          If UBound(PRS) >= 0 Then 'already have times scheduled
            ReDim TmpPRS(UBound(PRS)+1)
            For i = 0 To UBound(PRS) 'Copy the data
              TmpPRS(i) = PRS(i)
            Next
            TmpPRS(UBound(TmpPRS)) = Request("newPRS") 'Add the new time
          Else
            ReDim TmpPRS(0)
            TmpPRS(0) = Request("newPRS")
          End If
        End If
      End If
  End Select
  If errmesg = "" Then
    AppPool.PeriodicRestartSchedule = TmpPRS
    AppPool.SetInfo
  End If
  Set AppPool = nothing
End Sub

Sub Change_PeriodicRestartMemory()
  If Request("PeriodicRestartMemory") > 2000000 Then
    response.Redirect("manage_app_pools_cfg.asp?action=PeriodicRestartMemory&appname=" & Request("appname") & "&errmesg=Invalid Number")
  End If
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  AppPool.PeriodicRestartMemory = Trim(Request("PeriodicRestartMemory")) * 1024
  AppPool.SetInfo
  Set AppPool = nothing
  Response.Redirect ("manage_app_pools.asp?appname=" & Request("appname") & "&tc=1")
End Sub

Sub Change_PeriodicRestartPrivateMemory()
  If Request("PeriodicRestartPrivateMemory") > 2000000 Then
    response.Redirect("manage_app_pools_cfg.asp?action=PeriodicRestartPrivateMemory&appname=" & Request("appname") & "&errmesg=Invalid Number")
  End If
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  AppPool.PeriodicRestartPrivateMemory = Trim(Request("PeriodicRestartPrivateMemory")) * 1024
  AppPool.SetInfo
  Set AppPool = nothing
  Response.Redirect ("manage_app_pools.asp?appname=" & Request("appname") & "&tc=1")
End Sub

Sub Change_IdleTimeout()
  If Request("IdleTimeout") > 4000000 Then
    response.Redirect("manage_app_pools_cfg.asp?action=IdleTimeout&appname=" & Request("appname") & "&errmesg=Invalid Number")
  End If
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  AppPool.IdleTimeout = Trim(Request("IdleTimeout"))
  AppPool.SetInfo
  Set AppPool = nothing
  Response.Redirect ("manage_app_pools.asp?appname=" & Request("appname") & "&tc=1")
End Sub

Sub Change_AppPoolQueueLength()
  If Request("AppPoolQueueLength") > 65535 Then
    response.Redirect("manage_app_pools_cfg.asp?action=AppPoolQueueLength&appname=" & Request("appname") & "&errmesg=Invalid Number")
  End If
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  If Trim(Request("AppPoolQueueLength")) = 0 Then AppPQL = 65535 Else AppPQL = Trim(Request("AppPoolQueueLength"))
  AppPool.AppPoolQueueLength = AppPQL
  AppPool.SetInfo
  Set AppPool = nothing
  Response.Redirect ("manage_app_pools.asp?appname=" & Request("appname") & "&tc=1")
End Sub

Sub Change_CPULimit()
  If Request("CPULimit") > 100 Then response.Redirect("manage_app_pools_cfg.asp?action=CPULimit&appname=" & Request("appname") & "&errmesg=Invalid CPU Limit")
  If Request("CPUResetInterval") > 1440 Then response.Redirect("manage_app_pools_cfg.asp?action=CPULimit&appname=" & Request("appname") & "&errmesg=Invalid CPU Refresh Interval")

  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))

  If Trim(Request("CPULimit")) = 0 Then
    AppPool.CPULimit = 0
  Else
    AppPool.CPULimit = (Trim(Request("CPULimit"))*1000)
    AppPool.CPUResetInterval = Trim(Request("CPUResetInterval"))
    AppPool.CPUAction = Request("CPUAction")
  End If
  AppPool.SetInfo
  Set AppPool = nothing
  Response.Redirect ("manage_app_pools.asp?appname=" & Request("appname") & "&tc=1")
End Sub

Sub Change_MaxProcesses()
  If Request("MaxProcesses") > 4000000 Or Request("MaxProcesses")< 1 Then response.Redirect("manage_app_pools_cfg.asp?action=MaxProcesses&appname=" & Request("appname") & "&errmesg=Invalid Max Process Limit")

  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  AppPool.MaxProcesses = Trim(Request("MaxProcesses"))
  OWP = 0
  If Trim(Request("OrphanWorkerProcess")) <> AppPool.OrphanWorkerProcess Then
    AppPool.OrphanWorkerProcess = Trim(Request("OrphanWorkerProcess"))
    If Trim(Request("OrphanWorkerProcess")) = 1 Then OWP = 1 'Refresh the page to display the extra options
  End If

  If AppPool.OrphanWorkerProcess = True Then 'No need to update otherwise
    If Trim(Request("OrphanActionExe")) <> AppPool.OrphanActionExe Then AppPool.OrphanActionExe = Trim(Request("OrphanActionExe"))
    If Trim(Request("OrphanActionParams")) <> AppPool.OrphanActionParams Then AppPool.OrphanActionParams = Trim(Request("OrphanActionParams"))
  End If

  AppPool.SetInfo
  Set AppPool = nothing
  If OWP = 1 Then response.Redirect("manage_app_pools_cfg.asp?action=MaxProcesses&appname=" & Request("appname"))
  Response.Redirect ("manage_app_pools.asp?appname=" & Request("appname") & "&tc=1")
End Sub

Sub Change_PingingEnabled()
  If Request("PingInterval") < 1 OR Request("PingInterval") > 4000000 Then response.Redirect("manage_app_pools_cfg.asp?action=PingingEnabled&appname=" & Request("appname") & "&errmesg=Invalid Number, Interval")
  If Request("PingResponseTime") < 1 OR Request("PingResponseTime") > 4000000 Then response.Redirect("manage_app_pools_cfg.asp?action=PingingEnabled&appname=" & Request("appname") & "&errmesg=Invalid Number, Timeout")

  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  If Request("PingingEnabled") = 0 Then AppPool.PingingEnabled = False Else AppPool.PingingEnabled = True
  AppPool.PingInterval = Trim(Request("PingInterval"))
  AppPool.PingResponseTime = Trim(Request("PingResponseTime"))

  AppPool.SetInfo
  Set AppPool = nothing
  Response.Redirect ("manage_app_pools.asp?appname=" & Request("appname") & "&tc=1")
End Sub

Sub Change_RapidFailProtection()
  If Request("RapidFailProtectionInterval") < 1 OR Request("RapidFailProtectionInterval") > 4000000 Then response.Redirect("manage_app_pools_cfg.asp?action=RapidFailProtection&appname=" & Request("appname") & "&errmesg=Invalid Number, Time Period")
  If Request("RapidFailProtectionMaxCrashes") < 1 OR Request("RapidFailProtectionMaxCrashes") > 4000000 Then response.Redirect("manage_app_pools_cfg.asp?action=RapidFailProtection&appname=" & Request("appname") & "&errmesg=Invalid Number, Failures")

  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  If Request("RapidFailProtection") = 0 Then AppPool.RapidFailProtection = False Else AppPool.RapidFailProtection = True
  AppPool.RapidFailProtectionInterval = Trim(Request("RapidFailProtectionInterval"))
  AppPool.RapidFailProtectionMaxCrashes = Trim(Request("RapidFailProtectionMaxCrashes"))

  AppPool.SetInfo
  Set AppPool = nothing
  Response.Redirect ("manage_app_pools.asp?appname=" & Request("appname") & "&tc=1")
End Sub

Sub Change_TimeLimits()
  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
  AppPool.StartupTimeLimit = Trim(Request("startuptimelimit"))
  AppPool.ShutdownTimeLimit = Trim(Request("shutdowntimelimit"))
  AppPool.SetInfo
  Set AppPool = nothing
  If Request("IdleTimeout") > 4000000 Then
    Response.Redirect("manage_app_pools_cfg.asp?action=TimeLimits&appname=" & Request("appname") & "&errmesg=" & err.description)
  Else
    Response.Redirect("manage_app_pools.asp?appname=" & Request("appname") & "&tc=1")
  End If
End Sub

Sub Do_Delete()
  Set AppPools = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools")
    AppPools.delete "IISApplicationPool", Request("appname")
    If err Then
      Response.Redirect("errs.asp?p=manage_app_pools_cfg&e=apppools&func=delete&f=1")
    Else
      Response.Redirect("display_services.asp?action=apools&svc=W3SVC")
    End If
  Set AppPools = Nothing
End Sub

%>
</div>
</Body>
</HTML>

