<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################
%>

<!-- #INCLUDE FILE="common\IPFuncs.inc" -->
<!-- #INCLUDE FILE="common\Functions.inc" -->
<%
If Len(request("return")) Then Response.Redirect ("display_services.asp?svc=W3SVC")
If Len(Request("install")) Then
  Call Install_Site
Else
  Call Show_Install
End If


Sub Show_Install

Set objRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
Set objGroups = GetObject("WinNT://" & Application("domain") & "/" & Application("Server"))
  objGroups.Filter = Array("group")
  glist = "<select multiple name=""groups"">"
	For Each group in objGroups
	  If LCase(group.name) = LCase(Application("DESTINATION_GROUP")) Then
		glist = glist & "<option value=""" & group.name & """ SELECTED>" & group.name & "</option>"
	  Else
		glist = glist & "<option value=""" & group.name & """>" & group.name & "</option>"
	  End If
	Next
  glist = glist & "</select>"
loglist = "<select multiple name=""logep"" size=""10"">"
loglist = loglist & "<option value=""date"" selected>Date</option>"
loglist = loglist & "<option value=""time"" selected>Time</option>"
loglist = loglist & "<option value=""c_ip"" selected>Client IP</option>"
loglist = loglist & "<option value=""cs_username"">Client Username</option>"
loglist = loglist & "<option value=""s_sitename"">Service Name</option>"
loglist = loglist & "<option value=""s_computername"">Server Name</option>"
loglist = loglist & "<option value=""s_ip"">Server IP Address</option>"
loglist = loglist & "<option value=""s_port"">Server Port</option>"
loglist = loglist & "<option value=""cs_method"" selected>Method</option>"
loglist = loglist & "<option value=""cs_uri_stem"" selected>URI Stem</option>"
loglist = loglist & "<option value=""cs_uri_query"" selected>URI Query</option>"
loglist = loglist & "<option value=""sc_status"" selected>Protocol Status</option>"
loglist = loglist & "<option value=""sc_win32_status"">Win32 Status</option>"
loglist = loglist & "<option value=""sc_bytes"" selected>Bytes Sent</option>"
loglist = loglist & "<option value=""cs_bytes"" selected>Bytes Recieved</option>"
loglist = loglist & "<option value=""time_taken"">Time Taken</option>"
loglist = loglist & "<option value=""cs_version"">Protocol Version</option>"
loglist = loglist & "<option value=""cs_host"">Host</option>"
loglist = loglist & "<option value=""cs_user_agent"">User Agent</option>"
loglist = loglist & "<option value=""cs_cookie"">Cookie</option>"
loglist = loglist & "<option value=""cs_referer"">Referer</option>"
loglist = loglist & "</select>"
%>

<!-- #INCLUDE FILE="common\head.inc" -->

<DIV id="maincontent">
<DIV id="instab">
<form method="POST">

<TABLE width="100%">
  <TR>
	  <TH colspan="2">Website Installation</TH>
  </TR>
  <TR>
	  <TH>Domain Name:</TH>
    <TD><input type="text" name="domname" id="GiveMeFocus" size="40"><br><input type="CheckBox" name="dnhhyn" value="yes" CHECKED>Use as host header?</TD>
  </TR>
  <TR>
	  <TH>IP Address & Port:</TH>
    <TD><%= ReturnNextFreeIPAddress(Application("Pri_Srv_IP")) %>&nbsp;:&nbsp;<input type="text" name="port" value="80" size="4"></TD>
  </TR>
  <TR>
	  <TH>Additional Host Header:</TH>
    <TD><input type="text" name="hh" size="40"></TD>
  </TR>
  <TR>
	  <TH>User Name:</TH>
    <TD><input type="text" name="username">
        &nbsp;<input type="checkbox" name="createuser" value="yes" Checked>Create User?
        &nbsp;<input type="checkbox" name="allowftp" value="yes" Checked>FTP Access</TD>
  </TR>
  <TR>
	  <TH>User's Password:</TH><TD><input type="text" name="password"></TD>
  </TR>
  <TR>
	  <TH>User's Full Name:</TH><TD><input type="text" name="userfn"></TD>
  </TR>
  <TR>
	<TH>User's Description:</TH><TD><input type="text" name="userdesc" size="40"><br><input type="CheckBox" checked name="wwwdesc" value="yes">Use domain as description?</TD>
  </TR>
  <TR>
	<TH>Group:</TH><TD><%=glist%></TD>
  </TR>
  <TR>
	  <TH>Website File Path:</TH>
    <TD><input type="text" name="homedir" value="<%=Application("PHYSICAL_SITE_LOCATION_ROOT")%>" size="40">
        <br>
        <input type="radio" value="" name="usepath" checked>Enter a name?
        <input type="radio" value="user" name="usepath">Use <b>username</b>?
        <input type="radio" value="domain" name="usepath">Use <b>domain</b>?
    </TD>
  </TR>
  <TR>
	<TH>Front Page SE's:</TH>
	<TD>
    <input type="radio" value="2002" name="fptype" checked>2002
    <input type="radio" value="2000" name="fptype">2000
    <input type="radio" value="none" name="fptype">None
	</TD>
  </TR>
  <TR>
	<TH>CGI-BIN:</TH>
	<TD>
    <input type="radio" value="yes" name="create_cgibin" checked>Yes
    <input type="radio" value="no" name="create_cgibin">No
	</TD>
  </TR>
  <TR>
	<TH>Default Documents:</TH><TD><input type="text" name="DefDoc" value="<%=objRoot.DefaultDoc%>" size="40"></TD>
  </TR>
  <TR>
	<TH>Authentication:</TH>
	<TD>
	  <select name="authlev">
		<OPTION value=0>No Access</option>
		  <OPTION value=1>Anonymous Only</option>
		  <OPTION value=2>Basic(Clear Text) Only, No Anonymous</option>
		  <OPTION value=3>Basic(Clear Text) and Anonymous</option>
		  <OPTION value=4>NTLM Only</option>
		  <OPTION value=5 SELECTED>NTLM and Anonymous</option>
		  <OPTION value=6>Basic and NTLM, No Anonymous</option>
		  <OPTION value=7>Basic, NTLM, and Anonymous</option>
		</select>
	</TD>
  </TR>
  <TR><TH>&nbsp;</TH><TD>&nbsp;</TD></TR>
  <TR>
  <% If Application("IISVer") = 5 Then %>
	<TH>Application Memory Level:</TH>
	<TD>
	  <SELECT Name="applev">
			<OPTION value="0" SELECTED>Low (IIS Process)</option>
			<OPTION value="2">Medium (Pooled Process)</option>
			<OPTION value="1">High (Isolated)</option>
		</SELECT>
	</TD>
  <% ElseIf Application("IISVer") = 6 Then %>
	<TH>Application Pool:</TH>
	<TD>
	  <SELECT Name="appPoolName">
	  <%
      Set AppPools = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools")
        For Each AppPool in AppPools
          tmpStr = "<OPTION value=""" & AppPool.Name & """ "
          If AppPool.Name = "DefaultAppPool" Then tmpStr = tmpStr & "SELECTED"
          tmpStr = tmpStr & ">" & AppPool.Name & "</OPTION>"
          Response.write tmpStr
          tmpStr = ""
        Next
      Set AppPools = Nothing
    %>
		</SELECT>
		<BR>
		<input type="radio" value="existing" name="APNN">Use Existing
		<input type="radio" value="domain" name="APNN" CHECKED>Create a new one using <b>Domain</b> name?<br>
		<input type="radio" value="create" name="APNN">Create a new one named:<br>
		<input type="text" name="NewAPN" size="40">
  </TR>
  <% End If %>
  <TR>
	<TH>Application Options</TH>
	  <TD>
	  <TABLE>
			<TR>
			  <TD><input type="checkbox" name="sessionstate" value="yes" Checked>Session State</TD>
			  <TD><input type="checkbox" name="aspbuffer" value="yes" Checked>Buffering</TD>
			  <TD><input type="checkbox" name="parentpath" value="yes" Checked>Parent Paths</TD>
		  </TR>
		  <TR>
			  <TD colspan="2"><input type="checkbox" name="cdebug" value="yes" Checked>Client Side Debugging</TD>
			  <TD><input type="checkbox" name="sdebug" value="yes">Server Side Debugging</TD>
		  </TR>
		</TABLE>
	</TD>
  </TR>
  <TR>
	<TH>Access Permissions</TH>
	<TD>
	  <input type="checkbox" name="Read" value="yes" Checked>Read
	  <input type="checkbox" name="Script" value="yes" Checked>Script
	  <input type="checkbox" name="Write" value="yes">Write
	  <input type="checkbox" name="Execute" value="yes">Execute
	  <input type="checkbox" name="DirBrowse" value="yes">Browse Dir
	  <input type="checkbox" name="ContentIndex" value="yes">Content Indexed
	</TD>
  </TR>


  <TR>
	<TH>Performance:</TH>
	<TD>
    <% If Application("IISVer") = 5 Then %>
	    <Select Name="perftune">
		  	<option value=0 SELECTED>Fewer than 10,000</option>
		  	<option value=1>Fewer than 100,000</option>
		  	<option value=2>More than 100,000</option>
		  </Select>
		  Hits expected per day.
    <% ElseIf Application("IISVer") = 6 Then %>
      Limit Network Bandwith available to this website?
      <input type="radio" name="lnb" value="no" CHECKED>No
      <input type="radio" name="lnb" value="yes">Yes
      <input type="text" name="lnba" value="1024" size="5">
    <% End If %>
	</TD>
  </TR>

  <TR>
	  <TH>Max Connections:</TH>
    <TD>
      <% 
        maxcons = objRoot.maxconnections
        If maxcons = -1 Then maxcons = 2000000000
      %>
      <input type="text" name="maxcons" value="<%=maxcons%>" size="10"> (2000000000 = Unlimited)
    </TD>
  </TR>

  <TR>
	  <TH>Connection Timeout:</TH><TD><input type="text" name="conntimeout" value="<%=objRoot.ConnectionTimeout%>" size="5"></TD>
  </TR>
  <TR>
	  <TH>Log File Path:</TH><TD><input type="text" name="lfp" size="40" value="<%=objRoot.LogFileDirectory%>"><br><input type="CheckBox" value="yes" checked name="lfpyn">Make Log file path a sub directory?</TD>
  </TR>
  <TR>
	  <TH>Log File Ext. Properties:</TH><TD><%=loglist%></TD>
  </TR>
  <TR>
	  <TH>Log File Time Period:</TH>
	<TD>
	  <SELECT Name="lftp">
			<OPTION value="0" <% If objRoot.LogFilePeriod = 0 Then Response.Write "SELECTED" %>>Hourly</option>
			<OPTION value="1" <% If objRoot.LogFilePeriod = 1 Then Response.Write "SELECTED" %>>Daily</option>
			<OPTION value="2" <% If objRoot.LogFilePeriod = 2 Then Response.Write "SELECTED" %>>Monthly</option>
			<OPTION value="3" <% If objRoot.LogFilePeriod = 3 Then Response.Write "SELECTED" %>>Unlimited</option>
			<OPTION value="4" <% If objRoot.LogFilePeriod = 4 Then Response.Write "SELECTED" %>>Reaches Size:</option>
		</SELECT>
		&nbsp;(Reaches Size)<input type="text" size="10" name="lfsize" value="<%=objRoot.LogFileTruncateSize%>">&nbsp;KB
	</TD>
  </TR>
  <TR>
	<TH>Log File Roll-Over Time:</TH>
	<TD><input type="checkbox" name="lfrt">Use Local Time for File Naming and Roll-Over?</TD>
  </TR>
  <TR>
	<TH>Start?</TH>
	<TD>
	  <input type="checkbox" name="start" value="yes" checked>Start website after creation?
	</TD>
  </TR>
  <TR>
    <TH>&nbsp;</TH>
    <TD>
      <input type="submit" name="install" value="Install">
      &nbsp;&nbsp;
      <input type="submit" name="return" value="Return">
    </TD>
  </TR>
</table>

</form>

</div>
</div>
</body>
</html>

<%

End Sub

Sub Install_Site

On Error Resume Next

Set w3svc = GetObject("IIS://" & Application("SERVER") & "/w3svc")
  Index = 1
  bDone = False
	While (Not bDone)
	  Err.Clear
	  Set SiteObj = GetObject("IIS://" & Application("SERVER") & "/w3svc/" & Index)
	  If (Err.Number = 0) Then
		  Index = Index + 1
	  Else
		  Err.Clear
		  Set NewWebServer = w3svc.Create("IIsWebServer", Index)
		  NewWebServer.SetInfo
		  If (Err.Number <> 0) Then
		    Index = Index + 1
		  Else
		    Err.Clear
		    Set SiteObj = GetObject("IIS://" & Application("SERVER") & "/w3svc/" & Index)
		    If (Err.Number = 0) Then
  			  bDone = True
		    Else
	  		  Index = Index + 1
		    End If
		  End If
	  End If
	  If (Index > 10000) Then
		  response.redirect "errs.asp?e=i1"
	  End If
	Wend

If (err.number = 0) Then
'No errors so far and we have a site ready to install to.
'Prepare the binding string
BindingString = Array(0)

If Request("ipadd") = "All Unassigned" Then
  If Request("dnhhyn") = "yes" Then
    BindingString(0) = ":" & Request("port") & ":" & Request("domname")
  End If
  If Request("ahhyn") = "yes" Then
    ReDim Preserve BindingString(1)
    BindingString(1) = ":" & Request("port") & ":" & Request("hh")
  End If
Else
  If Request("dnhhyn") = "yes" Then
    BindingString(0) = Request("ipadd") & ":" & Request("port") & ":" & Request("domname")
  Else
    BindingString(0) = Request("ipadd") & ":" & Request("port") & ":"
  End If
  If Len(Request("hh")) Then
    ReDim Preserve BindingString(1)
    BindingString(1) = Request("ipadd") & ":" & Request("port") & ":" & Request("hh")
  End If
End If

'Set the Home and Log directories
HomeDir = Request("homedir")
LogFilePath = Request("lfp")

'Strip the trailing slash
If Right(HomeDir,1) = "\" Then HomeDir = Left(HomeDir,(Len(HomeDir)-1))

If Right(LogFilePath,1) = "\" Then LogFilePath = Left(LogFilePath,(Len(LogFilePath)-1))

'Based on form input, built the right paths
If LCase(Request("usepath")) = "user" Then HomeDir = HomeDir & "\" & Request("username")
If LCase(Request("usepath")) = "domain" Then HomeDir = HomeDir & "\" & Request("domname")
If LCase(Request("lfpyn")) = "yes" Then LogFilePath = HomeDir & "\log"

'Check and create where needed
Set fso = CreateObject("Scripting.FileSystemObject")
err.clear
  If fso.FolderExists(HomeDir) = False Then
    patharr = Split(HomeDir,"\")
    bldpath = patharr(0) 'just add the drive letter now
    For px = 1 to UBound(Patharr)
      bldpath = bldpath & "\" & patharr(px)
      If fso.FolderExists(bldpath) = False Then fso.CreateFolder(bldpath)
    Next
  End If
  err.clear
  If LCase(Request("create_cgibin")) = "yes" Then
    If fso.FolderExists(Homedir & "\cgi-bin") = False Then fso.CreateFolder(Homedir & "\cgi-bin")
  End If
  err.clear
  If fso.FolderExists(LogFilePath) = False Then
    patharr = Split(LogFilePath,"\")
    bldpath = patharr(0) 'just add the drive letter now
    For px = 1 to UBound(Patharr)
      bldpath = bldpath & "\" & patharr(px)
      If fso.FolderExists(bldpath) = False Then fso.CreateFolder(bldpath)
    Next
  End If

'check for existing default doc's
defdocs = Split(Request("defdoc"), ",")
Set fldrchk = fso.GetFolder(HomeDir)
fndfldr = False
For each folder in fldrchk.subfolders
  If Instr(Request("defdoc"), folder.name) Then fndfldr = True
Next
'If one of the default docs exists, there's no need to make one!
If fndfldr = False Then
   domainname = LCase(Request("domname"))
	  path = Server.MapPath("./data/default.dft")
  set ReadInDefFile = fso.OpenTextFile(path,1,0,0)
   	buffer = ReadInDefFile.readall
    ReadInDefFile.close

  Set RegEx = New RegExp
    RegEx.Global = True
	  RegEx.pattern = "#DOM#"
	  buffer = RegEx.Replace(buffer,domainname)
  Set RegEx = Nothing

  Set homepage = fso.CreateTextFile( HomeDir & "\" & defdocs(0),True)
    homepage.Write buffer
    homepage.close
End If

'OK, most of the stuff is ready, start setting the properties...
	SiteObj.FrontPageWeb = True
	SiteObj.EnableDefaultDoc = True
  SiteObj.ServerBindings = BindingString
  SiteObj.ServerSize = Request("perftune")
  SiteObj.ServerComment = Request("domname")
  SiteObj.MaxConnections = Request("maxcons")
	SiteObj.ConnectionTimeout = Request("conntimeout")
	SiteObj.LogFileDirectory = LogFilePath
	If InStr(LCase(Request("logep")),"cs_bytes") Then SiteObj.LogExtFileBytesRecv = True
	If InStr(LCase(Request("logep")),"sc_bytes") Then SiteObj.LogExtFileBytesSent = True
	If InStr(LCase(Request("logep")),"c_ip") Then SiteObj.LogExtFileClientIp = True
	If InStr(LCase(Request("logep")),"sc_status") Then SiteObj.LogExtFileHttpStatus = True
	If InStr(LCase(Request("logep")),"cs_method") Then SiteObj.LogExtFileMethod = True
	If InStr(LCase(Request("logep")),"time") Then SiteObj.LogExtFileTime = True
	If InStr(LCase(Request("logep")),"cs_uri_stem") Then SiteObj.LogExtFileUriStem = True
	If InStr(LCase(Request("logep")),"cs_user_agent") Then SiteObj.LogExtFileUserAgent = True
	If InStr(LCase(Request("logep")),"cs_referer") Then SiteObj.LogExtFileReferer = True
  SiteObj.SetInfo

  'Now create the root directory object.
  Set SiteRootObj = SiteObj.Create("IIsWebVirtualDir", "ROOT")
	  SiteRootObj.Path = HomeDir
	  If LCase(Request("Read")) = "yes" Then SiteRootObj.AccessRead	 = True
	  If LCase(Request("Write")) = "yes" Then SiteRootObj.AccessWrite   = True
	  If LCase(Request("Execute")) = "yes" Then SiteRootObj.AccessExecute = True
	  If LCase(Request("Script")) = "yes" Then SiteRootObj.AccessScript  = True
	  If LCase(Request("DirBrowse")) = "yes" Then SiteRootObj.EnableDirBrowsing = True
	  If LCase(Request("ContentIndex")) = "yes" Then SiteRootObj.ContentIndexed = True
	  SiteRootObj.EnableDefaultDoc = True
	  SiteRootObj.DefaultDoc = Request("defdoc")
	  SiteRootObj.AuthFlags = Request("authlev")
    SiteRootObj.Setinfo

    If Application("IISVer") = 5 Then
      SiteRootObj.AppCreate2 True
      SiteRootObj.AppIsolated = Request("applev")
      SiteRootObj.AppFriendlyName = "Default Application"
    End If

    If Application("IISVer") = 6 Then
      bCreate = False
      Select Case Request("APNN")
        Case "existing"
          SiteRootObj.AppFriendlyName = Request("domname")
          SiteRootObj.AppPoolID = Request("appPoolName")
          SiteRootObj.SetInfo
          SiteRootObj.AppCreate2 "2"
        Case "domain"
          bCreate = True
          AppName = Request("domname")
        Case "create"
          bCreate = True
          AppName = Request("NewAPN")
      End Select

      If bCreate = True Then
        bFound = False
        Set AppPools = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools")
        For each AppPool in AppPools
          If AppPool.Name = appname Then bFound = True
        Next
        If bFound = False Then 'Not found so create it
        Set NewAppPool = AppPools.Create("IIsApplicationPool",AppName)
          NewAppPool.SetInfo
        End If
        SiteRootObj.AppFriendlyName = Request("domname")
        SiteRootObj.AppPoolID = AppName
        SiteRootObj.SetInfo
        SiteRootObj.AppCreate2 "2"
      End If
    End If

	If LCase(Request("sessionstate")) = "yes" Then
	  SiteRootObj.AspAllowSessionState = True
	Else
	  SiteRootObj.AspAllowSessionState = False
	End If

	If LCase(Request("aspbuffer")) = "yes" Then
	  SiteRootObj.AspBufferingOn = True
	Else
	  SiteRootObj.AspBufferingOn = False
	End If

	 If LCase(Request("parentpath")) = "yes" Then
	   SiteRootObj.AspEnableParentPaths = True
	 Else
	   SiteRootObj.AspEnableParentPaths = False
	 End If

	 If LCase(Request("cdebug")) = "yes" Then
	   SiteRootObj.AppAllowClientDebug = True
	 Else
	   SiteRootObj.AppAllowClientDebug = False
	 End If

	 If LCase(Request("sdebug")) = "yes" Then
	   SiteRootObj.AppAllowDebugging = True
	 Else
	   SiteRootObj.AppAllowDebugging = False
	 End If
   
   SiteRootObj.SetInfo

   Set RootObj = GetObject("IIS://" & Application("SERVER") & "/w3svc/" & Index & "/ROOT")

   If LCase(Request("create_cgibin")) = "yes" Then
     'Set the CGI-BIN
     Set SiteCGIObj = RootObj.Create("IIsWebVirtualDir", "cgi-bin")
	     SiteCGIObj.Path = HomeDir & "\cgi-bin"
	     SiteCGIObj.AccessRead = True
	     SiteCGIObj.AccessWrite = False ' Having R/W/X is a major security risk!!! Do not allow WRITE!
	     SiteCGIObj.AccessExecute  = True
	     If LCase(Request("Script")) = "yes" Then SiteCGIObj.AccessScript  = True
	     If LCase(Request("ContentIndex")) = "yes" Then SiteCGIObj.ContentIndexed = True
 	     If LCase(Request("DirBrowse")) = "yes" Then SiteCGIObj.EnableDirBrowsing = True
	   SiteCGIObj.SetInfo
   End If

   If Application("IISVer") = 5 Then 
     If Request("start") = "yes" Then SiteObj.Start
   ElseIf Application("IISVer") = 6 Then
     If Request("start") = "no" Then SiteObj.Stop
   End If

   'Create an FTP virtual directory
   If LCase(Request("allowftp")) = "yes" Then
	   Set vRoot = GetObject("IIS://" & Application("SERVER") & "/MSFTPSVC/1/root")
	   Set vDir = vRoot.Create("IIsFtpVirtualDir",Request("username"))
	   vDir.Path =HomeDir
	   vDir.AccessRead = True
	   vDir.AccessWrite = True
	   vDir.SetInfo
   End If

  Set WshShell = CreateObject("WScript.Shell")

  If Request("fptype") <> "none" Then
	  Select Case Request("fptype")
      Case "2002"
	      vtiPath = "C:\Program Files\Common Files\Microsoft Shared\Web Server Extensions\50\bin"
        strCmdLine = chr(34) & "C:\Program Files\Common Files\Microsoft Shared\Web Server Extensions\50\BIN\owsadm.exe" & chr(34) & " -o install -u Administrator -p /LM/W3SVC/" & index & " -sp publish"
      Case "2000"
	      vtiPath = "C:\Program Files\Common Files\Microsoft Shared\Web Server Extensions\40\bin"
	      strCmdLine = chr(34) & "C:\Program Files\Common Files\Microsoft Shared\Web Server Extensions\40\BIN\fpsrvadm.exe" & chr(34) & " -o install -u Administrator -t msiis -m " & index & " -p 80"
	  End Select

    Set FPDir = RootObj.Create("IIsWebVirtualDir", "_vti_bin")
    FPDir.Path = vtiPath
    FPDir.AccessRead = True
	  FPDir.ContentIndexed = False
	  FPDir.AccessScript = True
    FPDir.AccessExecute  = True
	  FPDir.EnableDirBrowsing = False
	  FPDir.SetInfo

    oRun = WshShell.Run( strCmdLine, 0, True )

  End If

  If Request("createuser") = "yes" Then
    'Create the User and add to groups specified
    Descript = Request("userdesc")
    If LCase(Request("wwwdesc")) = "yes" Then Descript = Request("domname")

    Set objDomain = GetObject("WinNT://" & Application("domain") & "/" & Application("Server"))
    Set objUser = objDomain.Create("user", Request("username"))
  	  objUser.FullName = Request("userfn")
	    objUser.HomeDirectory = HomeDir
	    objUser.Description = Descript
	    objUser.SetPassword(Trim(Request("password")))
	    Flags = objUser.Get("UserFlags")
	    objUser.Put "UserFlags", Flags Or UF_PASSWD_CANT_CHANGE Or UF_DONT_EXPIRE_PASSWD
	  objUser.SetInfo

    grps = Split(Request("groups"), ",",-1,1)
    For i = 0 to Ubound(grps)
	    Set ObjGroup = GetObject("WinNT://" & Application("domain") & "/" & Application("Server") & "/" & grps(i) & ",group")
	    Set ObjUser = GetObject("WinNT://" & Application("domain") & "/" & Application("Server") & "/" & Request("username") & ",user")
	    objGroup.Add(objUser.ADSPath)
    Next
    If Request("fptype") = "2002" Then
	    'Set the proper username to the proper role.
      strCmdLine = chr(34) & "C:\Program Files\Common Files\Microsoft Shared\Web Server Extensions\50\bin\owsadm.exe" & chr(34) & " -o roleusers -c add -n advauthor -p /LM/W3SVC/" & index & " -w http://" & Request("domname") & " -u " & Request("username")
	    oRun = WshShell.Run( strCmdLine, 0, True )
    End If
    strCmdLine = "cmd /c echo Y | cacls " & HomeDir & " /e /c /g Administrator:f administrators:f system:f " & Request("Username") & ":f iusr_" & Application("Server") & ":r iwam_" & Application("Server") & ":r"
	    oRun = WshShell.Run( strCmdLine, 0, True )
    strCmdLine = "cmd /c echo Y | cacls " & LogDirPath & " /e /c /g Administrator:f administrators:f system:f " & Request("Username") & ":f "
	    oRun = WshShell.Run( strCmdLine, 0, True )
  End If

  Response.Redirect "manage_w3svc.asp?site=" & Index
Else
  Response.redirect "errs.asp?p=install_w3svc&e=i&f=1"
End If

End Sub

%>
