<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################
%>

<!-- #INCLUDE FILE="common\Functions.inc" -->
<!-- #INCLUDE FILE="common\Functions_Logging.inc" -->
<!-- #INCLUDE FILE="common\IPFuncs.inc" -->
<%
On Error Resume Next

If Len(request("return")) Then
  If Request("site") = 0 Then
    Response.Redirect ("manage_msftpsvc_master.asp")
  Else
    Response.Redirect ("manage_msftpsvc.asp?site=" & Request("site"))
  End If
End If

If Len(request("returnvd")) Then Response.Redirect ("ftpsvc_site_config.asp?action=vdirs&site=" & Request("site"))
If Len(request("createvd")) Then Response.Redirect ("ftpsvc_site_config.asp?action=newvdir&site=" & Request("site"))

If LCase(Request("action")) = "do_delete" Then Do_Delete()

%>
<!-- #INCLUDE FILE="common\head.inc" -->
<DIV id="maincontent">
<%

If Len(Request("site")) Then site = Request("site")
If Len(Request("vdir")) Then vd = Request("vdir")

errs = ""
If LCase(Request("cvdir")) = "create" Then
  Create_VDir(errs)
  Show_VDirs(errs)
End If

Select Case LCase(Request("action"))
  Case "vdirs"
    Call Show_VDirs(errs)
  Case "homedir"
    Call HomeDir(errs)
  Case "change_homedir"
    Call ChangeHomeDir(errs)
    Call HomeDir(errs)
  Case "hosthead"
    Call HostHead(errs)
  Case "change_hosthead"
    Call ChangeHostHead(errs)
    Call HostHead(errs)
  Case "logdir"
    Call LogDir(errs)
  Case "change_logdir"
    Call ChangeLogDir(errs)
    Call LogDir(errs)
  Case "messages"
    Call Messages(errs)
  Case "change_messages"
    Call ChangeMessages(errs)
    Call Messages(errs)
  Case "change_conto"
    Call Change_ConnectionTimeout(errs)
    Call ConnectionTimeout(errs)
  Case "conto"
    Call ConnectionTimeout(errs)
  Case "ipdomrest"
    Call IPDomRestrictions(errs)
  Case "change_ipdomrest"
    Call Change_IPDomRestrictions(errs)
    Call IPDomRestrictions(errs)
  Case "change_logging"
    Call Change_Logging(errs)
    Call Logging(errs)
  Case "logging"
    Call Logging(errs)
  Case "newvdir"
    Call Show_VDir_Install()
  Case "manvdir"
    Call Show_Man_VDirs(errs,vd)
  Case "modvdir"
    Call Mod_VDir(errs,vd)
    Call Show_Man_VDirs(errs,vd)
  Case "delvdir"
    Call Del_VDir(errs)
    Call Show_VDirs(errs)
  Case "delete"
    Call Show_Delete()
  Case "change_maxcon"
    If Len(Request.Form("MCS")) Then
      Call MaxConnections(errs)
    Else 'it must have been the Update button
      Call Change_MaxConnections(errs)
      Call MaxConnections(errs)
    End If
  Case "maxcon"
    Call MaxConnections(errs)

End Select


Sub HomeDir(errs)

  Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "/root")
%>
<form method="post" action="ftpsvc_site_config.asp?action=change_homedir">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
<TABLE width="75%">
  <TR><TH colspan="2">Manage <%=objSite.ServerComment%>Root File Directory</TH></TR>
  <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
  <TR><TH>Current</TH><TD><%= objSiteRoot.path%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="newhd" id="GiveMeFocus" value="<%=objSiteRoot.path%>"size="75"></TD></TR>
  <TR><TH>&nbsp;</TH><TD>There is no need for a trailing slash.	If the physical path does not exist the site will not start.</TD></TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
</table>
</form>
<%
End Sub

Sub HostHead(errs)

  Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
  hhip = objSite.ServerBindings
  CurHH = Split(hhip(0),":")
  SelectedValue = CurHH(0)
%>
<form method="post" action="ftpsvc_site_config.asp?action=change_hosthead">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE width="75%">
    <TR><TH colspan="2">Manage Site's IP address and Port</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR>
      <TD><%= ReturnNextFreeIPAddress(SelectedValue) %>&nbsp;:&nbsp;<input type="text" name="Port" size="2" value="<%=CurHH(1)%>"></TD>
      <TD>
        <input type="submit" name="update" value="Update">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site"></TD></TR>
  </table>
</form>
<%
End Sub

Sub LogDir(errs)
  If Request("Site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
    addext = ""
    ServerComment = "Master FTP"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
    addext = "\MSFTPSVC" & Request("site")
    ServerComment = objsite.ServerComment
  End If

	If objSite.LogFileDirectory = "" Then
	  curld = objSite.LogFileDirectory & "\MSFTPSVC" & Request("site")
	Else
	  curld = objSite.LogFileDirectory
	End If
%>
<form method="post" action="ftpsvc_site_config.asp?action=change_logdir">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
<TABLE width="75%">
  <TR><TH colspan=2>Manage <%=ServerComment%> Log File Directory</TH></TR>
  <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
  <TR><TH>Current</TH><TD><%=curld%><%=addext%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="newld" id="GiveMeFocus" value="<%=curld%>"size="75"><%=addext%></TD></TR>
  <TR>
    <TH>&nbsp;</TH>
  	<TD class="config_note">
	    <ul>
		    <li>There is no need for a trailing slash.</li>
		    <li>%WinDir% is system Enviornment Variable that points to your System Root which is normally "C:\winnt\"</li>
		    <% If Request("Site") > 0 Then %>
			  <li>A directory of "MSFTPSVC" with the Metabase ID number will be created automatically, please do not include it. It is a limitation of IIS not this script.</li>
			<% End If %>
	    </ul>
	  </TD>
  </TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
</table>
</form>
<%
End Sub

Sub Messages(errs)
On Error Resume Next

  If Request("Site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
    ServerComment = "Master FTP"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
    ServerComment = objsite.ServerComment
  End If

  greets = objSite.GreetingMessage
  For i = 0 to Ubound(greets)
    gmess = gmess & greets(i)
  Next

  If Application("IISVer") > 5 Then
  banner = objSite.BannerMessage
  For i = 0 to Ubound(banner)
    banner_message = banner_message & banner(i)
  Next
  End If
%>
<form method="post" action="ftpsvc_site_config.asp?action=change_messages">
	<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan=2>Manage <%=ServerComment%> Messages</TH></TR>
    <TR>
      <TH>&nbsp;</TH>
      <TD>&nbsp;<%=errs%></TD>
    </TR>

    <%   If Application("IISVer") > 5 Then %>
    <TR>
	    <TH>Banner Message:</TH>
	    <TD><TEXTAREA Name="banmess" rows="8" cols="30"><%= banner_message%></TEXTAREA></TD>
    </TR>
    <TR><TH>&nbsp;</TH><TD>&nbsp;</TD></TR>
    <% End If %>


    <TR>
	    <TH>Greeting Message:</TH>
	    <TD><TEXTAREA Name="greetmess" rows="8" cols="30"><%= gmess%></TEXTAREA></TD>
    </TR>
    <TR>
      <TH>&nbsp;</TH>
      <TD>&nbsp;</TD>
    </TR>
    <TR>
	    <TH>Exit Message:</TH><TD><input type="text" name="exitmess" value="<%=objSite.ExitMessage%>" size="40"></TD>
    </TR>
    <TR>
      <TH>&nbsp;</TH>
      <TD>&nbsp;</TD>
    </TR>
    <TR>
      	    <TH>Max Clients Message:</TH><TD><input type="text" name="maxmess" value="<%=objSite.MaxClientsMessage%>" size="40"></TD>
    </TR>
    <TR>
      <TH>&nbsp;</TH>
      <TD>&nbsp;</TD>
    </TR>
    <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub

Sub Show_VDirs(errs)
Server.ScriptTimeout = 180
%>
  <form method="post" action="ftpsvc_site_config.asp">
	<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE width="100%">
    <TR><TH colspan="4">Virtual Directories</TH></TR>
<%
  response.flush
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "/root")

	For each vdir in objSiteRoot
	  If InStr(vdir.Path, ":") Then path = Split(vdir.Path, ":")
		npath = path(0) & "$" & path(1)
		hd = "<a target=""_blank"" href=""\\" & Application("Server") & "\" & npath & """>" & vdir.path & "</a>"
		fsize = ""
		Call DirSize(vdir.Path,fsize)
		response.write "<TR><TH>" & vdir.name & "</TH><TD>" & hd & "&nbsp;&nbsp;(" & fsize & ")</TD>"
		response.write "<TD><a class=""man_link"" href=""ftpsvc_site_config.asp?action=manvdir&site="&Request("site")&"&vdir=" & vdir.Name & """>Manage</a></TD>"
		response.write "<TD><a href=""ftpsvc_site_config.asp?action=delvdir&site="&Request("site")&"&vdir=" & vdir.Name & """>Delete</a></TD></TR>"
		response.flush
	Next
%>
  <TR><TD colspan="4">&nbsp;<%=errs%></TD></TR>
  <TR>
    <TH>&nbsp;</TH>
	  <TD>
      <input type="submit" name="createvd" value="Create New Virtual Directory">
      &nbsp;&nbsp;
      <input type="submit" name="return" value="Manage Site">
    </TD>
    <TD colspan="2">&nbsp;</TD>
  </TR>
</table>
</form>

<%
End Sub

Sub Show_Man_VDirs(errs,vd)
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "/root")
	For each vdir in objSiteRoot
	  If vdir.name = vd Then
%>
  <form method="post" action="ftpsvc_site_config.asp?site=<%=Request("site")%>&vdir=<%=vdir.name%>">
	<Input type="Hidden" name="action" value="modvdir">
<TABLE width="100%">
  <TR><TH colspan="2">Manage Virtual Directory</TH></TR>
  <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
  <TR><TH>Name:</TH><TD><input type="text" name="vname" id="GiveMeFocus" value="<%=vdir.name%>" size="25"></TD></TR>
  <TR><TH>Path:</TH><TD><input type="text" name="vpath" value="<%=vdir.path%>" size="25"></TD></TR>
  <TR><TH>Access Permissions</TH>
	  <TD>
		  <input type="checkbox" name="Read" value="yes" <% If vdir.AccessFlags = 3 or vdir.AccessFlags = 1 Then Response.write "Checked" %>>Read
		  <input type="checkbox" name="Write" value="yes" <% If vdir.AccessFlags = 3 or vdir.AccessFlags = 2 Then Response.write "Checked" %>>Write
		  <input type="checkbox" name="Log" value="yes" <% If vdir.DontLog = 0 Then Response.write "Checked" %>>Log
	  </TD>
  </TR>
  <TR>
	  <TD colspan="2">
	    <input type="submit" name="commit" Value="Commit Modifications">
	    &nbsp;&nbsp;
	    <input type="submit" name="return" value="Manage Site">
	    &nbsp;&nbsp;
	    <input type="submit" name="returnvd" value="List Virtual Directories">
	  </TD>
  </TR>

</table>
</form>
<%
	  End If
	Next
End Sub

Sub Show_VDir_Install()
Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "/ROOT")
%>
<form method="POST" action="ftpsvc_site_config.asp">
	<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan="2">FTP Virtual Directory Creation for:&nbsp;<%=objSite.ServerComment%></TH></TR>
    <TR><TH>Name:</TH><TD><input type="text" name="vdirname" id="GiveMeFo0cus"></TD></TR>
    <TR><TH>File Path:</TH>
	    <TD>
	      <input type="text" name="vdir_homedir" value="<%=ObjSiteRoot.Path%>">
	      <br>
	      <input type="checkbox" name="fpathyn" value="yes" Checked>Use Name for File Path?
	    </TD>
    </TR>
    <TR>
	    <TH>Permissions</TH>
	    <TD>
	      <input type="checkbox" name="Read" value="yes" Checked>Read
	      <input type="checkbox" name="Write" value="yes" Checked>Write
	      <input type="checkbox" name="Log" value="yes" Checked>Log
	    </TD>
    </TR>
    <TR><TH>&nbsp;</TH><TD><input type="submit" name="cvdir" value="Create">&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </table>
</form>
<%
End Sub

Sub IPDomRestrictions(errs)
On Error Resume Next
' Set up variables.
  If Request("Site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
    ServerComment = "Master FTP"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "/ROOT")
    ServerComment = objsite.ServerComment
  End If

  Set IIsIPSecurityObj = objSiteRoot.IPSecurity

If True = IIsIPSecurityObj.GrantByDefault Then
  output = "By Default All IP's and Domains are Granted access"
  SwitchButton = "<input type=""submit"" name=""switch"" value=""Deny by Default"">"

  IPList = IIsIPSecurityObj.IPDeny

  If UBound(IPList) >= 0 Then
    IPListOut = "<SELECT MULTIPLE Name=""IPList"" size=""" & Ubound(IPList) + 1 & """>"
    For x = 0 to Ubound(IPList)
	    IPListOut = IPListOut & "<option value=""" & IPList(x) & """>" & IPList(x) & "</option>"
    Next
    IPListOut = IPListOut & "</SELECT>"
    IPRemButton = "<input type=""submit"" name=""remIP"" value=""Remove"">"
  Else
    IPListOut = "Nothing is being denied"
    IPRemButton = "&nbsp;"
  End If

Else

  output = "By Default All IP's and Domains are Denied access"
  SwitchButton = "<input type=""submit"" name=""switch"" value=""Grant by Default"">"

  IPList = IIsIPSecurityObj.IPGrant

  If UBound(IPList) >= 0 Then
    IPListOut = "<SELECT MULTIPLE Name=""IPList"" size=""" & Ubound(IPList) + 1 & """>"
    For x = 0 to Ubound(IPList)
	    IPListOut = IPListOut & "<option value=""" & IPList(x) & """>" & IPList(x) & "</option>"
    Next
    IPListOut = IPListOut & "</SELECT>"
    IPRemButton = "<input type=""submit"" name=""remIP"" value=""Remove"">"
  Else
    IPListOut = "Nothing is being granted access"
    IPRemButton = "&nbsp;"
  End If

End if
%>
  <form method="post" action="ftpsvc_site_config.asp?action=change_ipdomrest">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan="3">IP Address and Domain Restrictions for <%=ServerComment%></TH></TR>
    <TR><TD colspan="3">&nbsp;<%=errs%></TD></TR>
    <TR><TH colspan="3"><%=output%></TH></TR>
    <TR><TD colspan="3">Switch to: <%=SwitchButton%></TD></TR>
    <TR><TD colspan="3">&nbsp;</TD></TR>
    <TR>
      <TH colspan="3">Current Entries</TH>
    </TR>
    <TR>
      <TD colspan="2"><%=IPListOut%></TD>
      <TD><%=IPRemButton%></TD>
    </TR>
    <TR><TD colspan="3">&nbsp;</TD></TR>
    <TR>
      <TH colspan="3">Add an Entry</TH>
    </TR>
    <TR>
      <TH>Single IP</TH>
      <TD>IP Address: <input type="text" name="ipadd" size="15"></TD>
      <TD Rowspan="2">
        <input type="submit" name="add" value="Add">
      </TD>
    </TR>
    <TR>
      <TH>IP Range</TH>
      <TD>Network ID: <input type="text" name="netid" size="15">&nbsp;&nbsp;Subnet: <input type="text" name="subnet" size="15"></TD>
    </TR>
    <TR><TD colspan="3">&nbsp;</TD></TR>
    <TR><TD colspan="3"><input type="submit" name="return" value="Manage Site"></TD></TR>
  </table>
</form>

<%
End Sub

Sub ConnectionTimeOut(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
    ServerComment = "Master FTP"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
    ServerComment = objSite.ServerComment
  End If

%>
<form name="theform" method="post" action="ftpsvc_site_config.asp?action=change_conto">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH>Manage <%=ServerComment%> Connection Timeout</TH></TR>
    <TR><TD>&nbsp;<%=errs%></TD></TR>
    <TR><TH>Current</TH></TR>
    <TD><%= objSite.ConnectionTimeout%> seconds</TD></TR>
    <TR><TD>&nbsp;</TD></TR>
    <TR><TH>New</TH></TR>
    <TD><input type="text" name="conntime" id="GiveMeFocus" value="<%=objSite.connectiontimeout%>" size="5"></TD></TR>
    <TR><TD>&nbsp;</TD></TR>
    <TR><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub

Sub Show_Delete()
  Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & site)
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & site & "/ROOT")
  homed = Split(objSiteRoot.Path, "\")
  user = homed(Ubound(homed))
  z = 0
  Set objGroup = GetObject("WinNT://" & Application("domain") & "/" & Application("Server"))
	objGroup.Filter = Array("user")
  For Each xuser in objGroup
	  If LCase(xuser.name) = LCase(user) Then z = 1
  Next

  If z = 0 Then
	  uselect = "<TD>User: <select name=""user"">"
	  For each xuser in objGroup
		uselect = uselect & "<option value=""" & xuser.name & """>" & xuser.name & "</option>"
	Next
	  uselect = uselect & "</select></TD>"
  Else
	  uselect = "<Input Type=Hidden Name=user Value=""" & user & """>"
	  uselect = uselect & "<TD>User: " & user & "</TD>"
  End If
%>
<TABLE>
  <TR><TH colspan="2">Delete&nbsp;<%=objSITE.ServerComment%></TH></TR>
  <TR>
	<form method="POST" action="ftpsvc_site_config.asp">
	  <Input Type=Hidden Name="site" Value="<%=site%>">
	  <Input Type=Hidden Name="action" Value="do_delete">
	  <%=uselect%>
	  <TD>
		<select name="useryn">
		  <option <% If z = 1 Then response.write "SELECTED" %> value="delete">Delete</option>
		  <option value="disable">Disable</option>
			<option <% If z = 0 Then response.write "SELECTED" %> value="nothing">Nothing</option>
		</select>
	  </TD>
  </TR>
  <TR>
	  <Input Type=Hidden Name=homedir Value="<%=objSiteRoot.Path%>">
	  <TD>Files: <%=objSiteRoot.Path%></TD>
	  <TD>
		<select name="fileyn">
			<option value="delete">Delete</option>
			<option value="move" SELECTED>Trash</option>
			<option value="nothing">Nothing</option>
		</select>
	  </TD>
  </TR>
  <TR><TD colspan="2"><input type="submit" value="Delete" Name="JakeIsDaMan">&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  <%=errmsg%>
</TABLE>

</form>
<%
End Sub

Sub Logging(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
    ServerComment = "Master FTP"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
    ServerComment = objSite.ServerComment
  End If
  Session("svc") = "MSFTPSVC"

  curLogType = objSite.LogPluginClsid
  If curLogType = "{FF160663-DE82-11CF-BC0A-00AA006111E0}" Then Session("rollover") = objSite.LogFileLocaltimeRollover
  If curLogType <> "{FF16065B-DE82-11CF-BC0A-00AA006111E0}" Then 
    Session("fileperiod") = objSite.LogFilePeriod
    Session("filesize") = objSite.LogFileTruncateSize
  Else
    Session("LogODBCDataSource") = objSite.LogODBCDataSource
    Session("LogODBCTableName") = objSite.LogODBCTableName
    Session("LogODBCUserName") = objSite.LogODBCUserName
    Session("LogODBCPassword") = objSite.LogODBCPassword
  End If

  logen = "enabled"
  logen_button = "<input type=""submit"" name=""logen"" value=""Disable"">"
  If objSite.LogType = 0 Then
    logen = "disabled"
    logen_button = "<input type=""submit"" name=""logen"" value=""Enable"">"
  End If

%>
<form name="theform" method="post" action="ftpsvc_site_config.asp?action=change_logging">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan="2">Manage <%=ServerComment%> Logging Options</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TD>Logging is <%=logen%></TD><TD><%=logen_button%></TD></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD><%=GetLogTypes(curLogType)%></TD><TD><input type="submit" name="switchlogtype" value="Switch"></TD></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <%= LogOptionsDisplay(curLogType) %>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="commit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub

Sub MaxConnections(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
    ServerComment = "Master FTP"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
    ServerComment = objSite.ServerComment
  End If

  maxcons = objSite.MaxConnections
  MaxConsUlimit = 2000000000


  If maxcons = -1 or maxcons >= MaxConsUlimit Then
    If Len(Request("MCS")) Then 'Turn ON/OFF value entry textbox
      If Request("MCSFlag") = 0 Then showhide = 0 Else showhide = 1
    Else
      showhide = 1
    End If
  Else 'not unlimited
    If Len(Request("MCS")) Then 'Turn ON/OFF value entry textbox
      If Request("MCSFlag") = 0 Then
        showhide = 0
        MaxConsUlimit = MaxCons
      Else
        showhide = 1
'         MaxConsUlimit = MaxCons
      End If
    Else
      showhide = 0
      MaxConsUlimit = MaxCons
    End If
  End If

  Select Case ShowHide
    Case 0 'Show
      maxconDisplay = "<TD>" & MaxConsUlimit & "</TD>"
      maxconButton = "<TD><input type=""submit"" name=""MCS"" value=""Switch to Unlimited""></TD></TR>"
      maxconValue = "<TR><TH>Enter a value</TH><TD>&nbsp;</TD></TR>"
      maxconValue = maxconValue & "<TR><TD><input type=""text"" name=""MCValue"" value=""" & MaxConsUlimit & """></TD>"
      maxconValue = maxconValue & "<TD><input type=""submit"" name""MCUpdate"" value=""Update""></TD></TR>"
      maxconValue = maxconValue & "<Input type=""Hidden"" name=""MCSFlag"" value=""1"">"

    Case 1 'Hide
      maxconDisplay = "<TR><TD>Unlimited</TD>"
      maxconButton = "<TD><input type=""submit"" name=""MCS"" value=""Enter a Value""></TD></TR>"
      maxconButton = maxconButton & "<TR><TD colspan=""2"">&nbsp;</TD></TR><TR><TD>&nbsp;</TD>"
      maxconButton = maxconButton & "<TD><input type=""submit"" name""MCUpdate"" value=""Update""></TD></TR>"
      maxconValue = "<Input type=""Hidden"" name=""MCValue"" value=""" & MaxConsUlimit & """><Input type=""Hidden"" name=""MCSFlag"" value=""0"">"

  End Select



%>
<form name="theform" method="post" action="ftpsvc_site_config.asp?action=change_maxcon">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan="2">Manage <%=ServerComment%> Max Connections</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TH>Current Connections</TH><TD>&nbsp;</TD></TR>
    <%= MaxConDisplay%><%=MaxConButton%>
    <%=MaxConValue%>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub


%>

</DIV>
</Body>
</HTML>

<%
'##########
'Below is where the action takes place. All subs will redirect back to the site's display page.

Sub ChangeHomeDir(errs)
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "/root")
    objSiteRoot.Path = Trim(Request("newhd"))
    objSiteRoot.SetInfo
  Set objSiteRoot = nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub ChangeHostHead(errs)
On Error Resume Next
  Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
    Dim hhiparr()
    ReDim hhiparr(0)
    hhiparr(0) = Request("IPAdd") & ":" & Request("port") & ":"
    objSite.ServerBindings = hhiparr
    objSite.SetInfo
  Set objSite = nothing
  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"
End Sub

Sub ChangeMessages(errs)
On Error Resume Next
  If Request("Site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
  End If
  If Len(Request("exitmess")) Then objSite.ExitMessage = Request("exitmess")
  If Len(Request("maxmess")) Then objSite.MaxClientsMessage = Request("maxmess")
  If Len(Request("banmess")) Then objSite.BannerMessage = Request("banmess")
  If Len(Request("greetmess")) Then objSite.GreetingMessage = Request("greetmess")

  objSite.SetInfo
  Set objSite = nothing
  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"
End Sub

Sub ChangeLogDir(errs)
  If Request("site") = 0 Then 
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
  End If
    objSite.LogFileDirectory = Trim(Request("newld"))
    objSite.SetInfo
  Set objSite = nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub Do_Delete()

  Set CompObj = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
  CompObj.Delete "IIsFtpServer", Request("site")

  If LCase(Request("useryn")) <> "nothing" Then
	Select Case LCase(Request("useryn"))
	  Case "delete"
		Set objServer = GetObject("WinNT://" & Application("domain") & "/" & Application("Server"))
		objServer.Delete "user", Request("user")
	  Case "disable"
		set ObjUser = GetObject("WinNT://" & Application("domain") & "/" & Application("Server") & "/" & Request("user"))
			ObjUser.AccountDisabled = True
		  ObjUser.SetInfo
	End Select
  End If

  If LCase(Request("fileyn")) <> "nothing" Then
	Set fso = CreateObject("Scripting.FileSystemObject")
	Select Case LCase(Request("fileyn"))
	  Case "move"
		fso.movefolder Request("homedir"), Application("DELETE_SITE_ROOT") & "\"
	  Case "delete"
		fso.DeleteFolder Request("homedir"), True
	End Select
  End If

response.redirect "display_services.asp?svc=MSFTPSVC"

End Sub

Sub Create_VDir(errs)
Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "/ROOT")
filepath = Request("vdir_homedir")
If Request("fpathyn") = "yes" Then filepath = objSiteRoot.Path & "\" & Request("vdirname")

Set fso = CreateObject("Scripting.FileSystemObject")
If fso.FolderExists(filepath) = False Then Set fldr = fso.CreateFolder(filepath)

  Set vDir = objSiteRoot.Create("IIsFtpVirtualDir",Request("vdirname"))
  vDir.Path = filepath
  If LCase(Request("Read")) = "yes" Then vDir.AccessRead = True
  If LCase(Request("Write")) = "yes" Then vDir.AccessWrite = True
  If LCase(Request("Log")) <> "yes" Then vDir.DontLog = True
  vDir.SetInfo

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub Del_VDir(errs)

  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "/ROOT")
    objSiteRoot.Delete "IIsFtpVirtualDir",Request("vdir")

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Deleted!"

End Sub

Sub Mod_VDir(errs,vd)

  Set objSiteVDir = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "/ROOT/"& vd)
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "/ROOT")
  Set fso = CreateObject("Scripting.FileSystemObject")
  
  If fso.FolderExists(Request("vpath")) = False Then Set fldr = fso.CreateFolder(Request("vpath"))

  objSiteVDir.Path = Request("vpath")
  If LCase(Request("Read")) = "yes" Then objSiteVDir.AccessRead = True Else objSiteVDir.AccessRead = False
  If LCase(Request("Write")) = "yes" Then objSiteVDir.AccessWrite = True Else objSiteVDir.AccessWrite = False
  If LCase(Request("Log")) <> "yes" Then objSiteVDir.DontLog = True Else objSiteVDir.DontLog = False
  objSiteVDir.SetInfo

  If LCase(Request("vname")) <> LCase(Request("vdir")) Then 
    Set MoveObj = ObjSiteRoot.MoveHere(Request("vdir"), Request("vname"))
    vd = Request("vname")
  End If
  
  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub Change_IPDomRestrictions(errs)
On Error Resume Next
  If Request("Site") = 0 Then 
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
  Else
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "/ROOT")
  End If

  Set IIsIPSecurityObj = objSiteRoot.IPSecurity
  'Switch?
  If Len(Request("switch")) Then
   If IIsIPSecurityObj.GrantByDefault = True Then IIsIPSecurityObj.GrantByDefault = False Else IIsIPSecurityObj.GrantByDefault = True
   objSiteRoot.IPSecurity = IIsIPSecurityObj
   objSiteRoot.SetInfo

  Else
    Dim NewIPList()

    If IIsIPSecurityObj.GrantByDefault = True Then

      If Len(Request("remIP")) Then
        IPList = IIsIPSecurityObj.IPDeny
        If UBound(IPList) >= 0 Then
          i = UBound(IPList) - Request("IPList").Count
          ReDim NewIPList(i)
          cnt = 0
          For x = 0 To UBound(IPList)
            bFound = False
            For i = 1 to Request("IPList").Count
              If IPList(x) = Request("IPList").Item(i) Then bFound = True
            Next
            If bFound = False Then
              NewIPList(cnt) = IPList(x)
              cnt = cnt + 1
            End If
          Next
        End If
        IIsIPSecurityObj.IPDeny = NewIPList
        objSiteRoot.IPSecurity = IIsIPSecurityObj
        objSiteRoot.SetInfo
      End If

      If Len(Request("add")) Then

        If Len(Request("ipadd")) Then
          IPList = IIsIPSecurityObj.IPDeny
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("ipadd")) & ", 255.255.255.255"
          IIsIPSecurityObj.IPDeny = IPList
          objSiteRoot.IPSecurity = IIsIPSecurityObj
          objSiteRoot.SetInfo
        End If

        If Len(Request("netid")) Then
          IPList = IIsIPSecurityObj.IPDeny
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("netid")) & ", " & Trim(Request("subnet"))
          IIsIPSecurityObj.IPDeny = IPList
          objSiteRoot.IPSecurity = IIsIPSecurityObj
          objSiteRoot.SetInfo
        End If

      End If

    Else

      If Len(Request("remIP")) Then
        IPList = IIsIPSecurityObj.IPGrant
        If UBound(IPList) >= 0 Then
          i = UBound(IPList) - Request("IPList").Count
          ReDim NewIPList(i)
          cnt = 0
          For x = 0 To UBound(IPList)
            bFound = False
            For i = 1 to Request("IPList").Count
              If IPList(x) = Request("IPList").Item(i) Then bFound = True
            Next
            If bFound = False Then
              NewIPList(cnt) = IPList(x)
              cnt = cnt + 1
            End If
          Next
        End If
        IIsIPSecurityObj.IPGrant = NewIPList
        objSiteRoot.IPSecurity = IIsIPSecurityObj
        objSiteRoot.SetInfo
      End If

      If Len(Request("add")) Then

        If Len(Request("ipadd")) Then
          IPList = IIsIPSecurityObj.IPGrant
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("ipadd")) & ", 255.255.255.255"
          IIsIPSecurityObj.IPGrant = IPList
          objSiteRoot.IPSecurity = IIsIPSecurityObj
          objSiteRoot.SetInfo
        End If

        If Len(Request("netid")) Then
          IPList = IIsIPSecurityObj.IPGrant
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("netid")) & ", " & Trim(Request("subnet"))
          IIsIPSecurityObj.IPGrant = IPList
          objSiteRoot.IPSecurity = IIsIPSecurityObj
          objSiteRoot.SetInfo
        End If

      End If

    End If
  End If

  If err = False Then Errs = "Updated" Else errs = "There was an error!<br>Err: " & err.description

End Sub

Sub Change_Logging(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
  End If

  If Len(Request("logen")) Then
    'Switch the flag, 1 = Logging enabled, 0 = no logging
    If objSite.LogType = 1 Then objSite.LogType = 0 Else objSite.LogType = 1
  End If

  If Len(Request("switchlogtype")) Then 
    objSite.LogPluginClsid = Request("logtype")
  End If

  If Len(Request("commit")) Then
    If Len(Request("rollover")) Then objSite.LogFileLocaltimeRollover = True Else objSite.LogFileLocaltimeRollover = False
    If Len(Request("LogExtFileBytesRecv")) Then objSite.LogExtFileBytesRecv = True Else objSite.LogExtFileBytesRecv = False
    If Len(Request("LogExtFileBytesSent")) Then objSite.LogExtFileBytesSent = True Else objSite.LogExtFileBytesSent = False
    If Len(Request("LogExtFileClientIp")) Then objSite.LogExtFileClientIp = True Else objSite.LogExtFileClientIp = False
    If Len(Request("LogExtFileComputerName")) Then objSite.LogExtFileComputerName = True Else objSite.LogExtFileComputerName = False
    If Len(Request("LogExtFileCookie")) Then objSite.LogExtFileCookie = True Else objSite.LogExtFileCookie = False
    If Len(Request("LogExtFileDate")) Then objSite.LogExtFileDate = True Else objSite.LogExtFileDate = False
    If Len(Request("LogExtFileHost")) Then objSite.LogExtFileHost = True Else objSite.LogExtFileHost = False
    If Len(Request("LogExtFileHttpStatus")) Then objSite.LogExtFileHttpStatus = True Else objSite.LogExtFileHttpStatus = False
    If Application("IISVer") = 6 Then
      If Len(Request("LogExtFileHttpSubStatus")) Then objSite.LogExtFileHttpSubStatus = True Else objSite.LogExtFileHttpSubStatus = False
    End If
    If Len(Request("LogExtFileMethod")) Then objSite.LogExtFileMethod = True Else objSite.LogExtFileMethod = False
    If Len(Request("LogExtFileProtocolVersion")) Then objSite.LogExtFileProtocolVersion = True Else objSite.LogExtFileProtocolVersion = False
    If Len(Request("LogExtFileReferer")) Then objSite.LogExtFileReferer = True Else objSite.LogExtFileReferer = False
    If Len(Request("LogExtFileServerIp")) Then objSite.LogExtFileServerIp = True Else objSite.LogExtFileServerIp = False
    If Len(Request("LogExtFileServerPort")) Then objSite.LogExtFileServerPort = True Else objSite.LogExtFileServerPort = False
    If Len(Request("LogExtFileSiteName")) Then objSite.LogExtFileSiteName = True Else objSite.LogExtFileSiteName = False
    If Len(Request("LogExtFileTime")) Then objSite.LogExtFileTime = True Else objSite.LogExtFileTime = False
    If Len(Request("LogExtFileTimeTaken")) Then objSite.LogExtFileTimeTaken = True Else objSite.LogExtFileTimeTaken = False
    If Len(Request("LogExtFileUriQuery")) Then objSite.LogExtFileUriQuery = True Else objSite.LogExtFileUriQuery = False
    If Len(Request("LogExtFileUriStem")) Then objSite.LogExtFileUriStem = True Else objSite.LogExtFileUriStem = False
    If Len(Request("LogExtFileUserAgent")) Then objSite.LogExtFileUserAgent = True Else objSite.LogExtFileUserAgent = False
    If Len(Request("LogExtFileUserName")) Then objSite.LogExtFileUserName = True Else objSite.LogExtFileUserName = False
    If Len(Request("LogExtFileWin32Status")) Then objSite.LogExtFileWin32Status = True Else objSite.LogExtFileWin32Status = False

    If Len(Request("fileperiod")) Then
      fileperiod = Request("fileperiod")
      If fileperiod = "5" Then fileperiod = "0"
        objSite.LogFilePeriod = fileperiod
        If Request("fileperiod") = "0" Then
          If Request("filesize") < 4096 Then objSite.LogFileTruncateSize = Request("filesize") * 1048576 Else objSite.LogFileTruncateSize = "4294967295"
        End If
        If Request("fileperiod") = "5" Then objSite.LogFileTruncateSize = "4294967295"
    End If

    If Len(Request("LogODBCDataSource")) Then
      objSite.LogODBCDataSource = Request("LogODBCDataSource")
      objSite.LogODBCTableName = Request("LogODBCTableName")
      objSite.LogODBCUserName = Request("LogODBCUserName")
      objSite.LogODBCPassword = Request("LogODBCPassword")
    End If

  End If

  objSite.SetInfo
  Set objSite = Nothing
  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub Change_ConnectionTimeout(errs)
On Error Resume Next
  If Request("Site") = 0 Then Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC") Else Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site") & "")
	objSite.ConnectionTimeout = Request("conntime")
	objSite.SetInfo
  Set objSite = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub Change_MaxConnections(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC")
    ServerComment = "Master FTP"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/" & Request("site"))
    ServerComment = objSite.ServerComment
  End If

  MCValue = Request("MCValue") 'From the form

  Select Case Application("IISVer")
    Case 5
      MCUpperLimit = "2000000000"
    Case 6
      MCUpperLimit = "4294967295"
  End Select

  If MCValue >= 2000000000 Then MCValue = MCUpperLimit

  objSite.MaxConnections = MCValue
  objSite.SetInfo
  Set objSite = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub
%>

