<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################


On Error Resume Next
If Request.queryString("action") = "go" Then Response.Redirect "manage_" & Request.queryString("svc")& ".asp?site=" & Request.queryString("site")

If Len(Request("svc")) Then svc = Request("svc")

cs = "4"
Select Case UCase(svc)
  Case "W3SVC"
  	svc_disp = "WWW"
  Case "MSFTPSVC"
	  svc_disp = "FTP"
  Case "SMTPSVC"
	  svc_disp = "SMTP"
End Select

errmsg = ""
If Len(Request("state")) Then Call change_state(svc,Request("site"),errmsg,Request("state"))
If Len(Request("appstate")) Then Call change_app_state(Request("app"),errmsg,Request("appstate"))
If Len(Request("wsestate")) Then Call change_wse_state(Request("wse"),errmsg,Request("wsestate"))

%>

<!-- #INCLUDE FILE="common\head.inc" -->
<div id="maincontent">
<TABLE width="100%">
  <TR><TH colspan="<%=cs%>"><%=svc_disp%> Services</TH></TR>
  <TR>
	  <TD><a class="man_link" href="display_services.asp?action=show&svc=<%=svc%>">Show All Sites</a></TD>
	  <TD><a class="man_link" href="display_services.asp?action=search&svc=<%=svc%>">Search for a Site</a></TD>
  	<TD><a class="man_link" href="install_<%=svc%>.asp?svc=<%=svc%>">Install a Site</a></TD>
  	<TD><a class="man_link" href="manage_<%=svc%>_master.asp">Master Site Properties</a></TD>
  </TR>
<% If Lcase(svc) = "w3svc" Then %>
  <TR>
    <% If Application("IISVer") = "6" Then %>
    <TD><a class="man_link" href="display_services.asp?action=wse&svc=<%=svc%>">Web Service Extensions</a></TD>
    <TD><a class="man_link" href="display_services.asp?action=apools&svc=<%=svc%>">Application Pools</a></TD>
    <TD colspan="2"><a class="man_link" href="display_services.asp?action=fpse&svc=<%=svc%>">FP 2002 Server Extensions</a></TD>
    <% Else %>
    <TD colspan="4"><a class="man_link" href="display_services.asp?action=fpse&svc=<%=svc%>">FP 2002 Server Extensions</a></TD>
    <% End If %>
  </TR>
<% End If %>

</TABLE>

<%
If Len(Request("tc")) OR Len(Request("e")) OR errmsg <> "" Then
  Response.write "<TABLE width=""100%"">"
  If Request("tc") = "1" Then
    response.write "<tr><th colspan=""" & cs & """>Task Completed!</TH></TR>"
  Else
    If errmsg = "" Then errmsg = Request("e")
    response.write "<tr><th colspan=""" & cs & """>There were errors! " & errmsg & "</TH></TR>"
  End If
  Response.write "</TABLE>"
End If
%>

<%
If Len(Request("searchfor")) Then Call Search(Request("searchfor"), Request("svc"))

If Len(Request.queryString("action")) Then
  Select Case LCase(Request.QueryString("action"))
	Case "show"
	  Call Display_All(svc)
	Case "search"
	  Call Show_Search(svc)
	Case "fpse"
	  Call Show_FP_Sites
	Case "apools"
	  Call Show_App_Pools
	Case "wse"
	  Call Show_Web_SE
  End Select
End If

Sub Show_Search(svc)
%>
<TABLE>
<form action="display_services.asp" method="POST" tabindex="1">
<input type="hidden" name="svc" value="<%=svc%>">
<TR><TH>Site:</TH><TD><input type="text" name="searchfor" id="GiveMeFocus"></TD><TD><input type="submit" value="Search"></TD></TR>
</form>
</TABLE>
<%
End Sub

Sub Search(searchfor, svc)
On Error Resume Next
Dim objComp, strItem, flag, cnt
Dim ArrBinding, strBinding, ipadd, serverstate
flag = 0
cnt = 0

searchlink = "&searchfor=" & LCase(searchfor)

%>
Searching for: "<%=LCase(searchfor)%>" ...<br>
<TABLE width="100%" name="rsTable" id="rsTable" cols=6>
	<TR>
		<TH><Acronym title="Sort by Instance Number" onClick="table_sort(0)" onMouseOver="this.style.cursor='hand';">Instance</acronym></TH>
		<TH><Acronym title="Sort by Description" onClick="table_sort(1)" onMouseOver="this.style.cursor='hand';">Description</acronym></TH>
		<TH><Acronym title="Sort by IP Address" onClick="table_sort(2)" onMouseOver="this.style.cursor='hand';">IP address</acronym></TH>
		<TH><Acronym title="Sort by Status" onClick="table_sort(3)" onMouseOver="this.style.cursor='hand';">Status</acronym></TH>
		<TH>&nbsp;</TH>
		<TH>&nbsp;</TH>
	</TR>
	<%
response.flush

Set objComp = GetObject("IIS://" & Application("Server") & "/" & svc)
	For Each strItem in objComp
	  If isNumeric(strItem.name) Then
	  ArrBindings = strItem.ServerBindings

	  bMatch = False
	  For i = 0 to UBound(ArrBindings)
      If InStr(LCase(ArrBindings(i)), LCase(searchfor)) Then bFound = True
	    i = i + 1
	  Next

    If InStr(LCase(strItem.ServerComment), LCase(searchfor)) or bMatch Then
			flag = 1
		  If err then
		    ipadd = "Err Retrieving Bindings"
		  Else
		    strBinding = Split(ArrBindings(0), ":")
		    ipadd = strBinding(0)
      End If
      err.clear
			If ipadd = "" Then ipadd = "* All Unassinged *"

			Select Case strItem.ServerState
  		  Case 1
	    		serverstate = "<font color='#00FF00'>( Starting )"
			    statlink = "<a href=""display_services.asp?action=search" & searchlink & "&svc="& svc &"&site=" & strItem.Name & "&state=Stop"">Stop</a>&nbsp;&nbsp;<a href=""display_services.asp?action=search" & searchlink & "&svc="& svc &"&site=" & strItem.Name & "&state=Pause"">Pause</a>"
		    Case 2
			    serverstate = "<font color='#00FF00'>( Running )"
			    statlink = "<a href=""display_services.asp?action=search" & searchlink & "&svc="& svc &"&site=" & strItem.Name & "&state=Stop"">Stop</a>&nbsp;&nbsp;<a href=""display_services.asp?action=search" & searchlink & "&svc="& svc &"&site=" & strItem.Name & "&state=Pause"">Pause</a>"
		    Case 3
		      serverstate = "<font color='#FF0000'>( Stopping )"
		      statlink = "<a href=""display_services.asp?action=search" & searchlink & "&svc="& svc &"&site=" & strItem.Name & "&state=Start"">Start</a>"
		    Case 4
			    serverstate = "<font color='#FF0000'>( Stopped )"
			    statlink = "<a href=""display_services.asp?action=search" & searchlink & "&svc="& svc &"&site=" & strItem.Name & "&state=Start"">Start</a>"
		    Case 5
			    serverstate = "<font color='#00FFFF'>( Pausing )"
			    statlink = "<a href=""display_services.asp?action=search" & searchlink & "&svc="& svc &"&site=" & strItem.Name & "&state=Continue"">Continue</a>"
		    Case 6
			    serverstate = "<font color='#00FFFF'>( Paused )"
			    statlink = "<a href=""display_services.asp?action=search" & searchlink & "&svc="& svc &"&site=" & strItem.Name & "&state=Continue"">Continue</a>"
		    Case 7
			    serverstate = "<font color='#00FFFF'>( Continuing )"
			    statlink = "<a href=""display_services.asp?action=search" & searchlink & "&svc="& svc &"&site=" & strItem.Name & "&state=Stop"">Stop</a>&nbsp;&nbsp;<a href=""display_services.asp?action=search" & searchlink & "&svc="& svc &"&site=" & strItem.Name & "&state=Pause"">Pause</a>"
		    Case Else
			    serverstate = "unknown"
			    statlink = ""
		  End Select

			response.write "<tr>"
			response.write "<td>" & strItem.Name & "</td>"
			response.write "<td>" & strItem.ServerComment & "</td>"
			response.write "<td>" & ipadd & "</td>"
			response.write "<td>" & serverstate & "</td>"
			response.write "<TD>" & statlink & "</TD>"
			Response.write "<td><a class=""man_link"" href=display_services.asp?action=go&svc=" & svc & "&site="& strItem.Name & ">Manage</a></td></tr>"
			cnt = cnt + 1
		End If
	  End If
	Next
Set objComp = Nothing

If flag = 0 Then
  Response.write "No sites not found."
  Call Show_Search(svc)
Else
  Response.write "Completed. Found " & cnt & " sites."
  Response.write "</table>"
End If
Response.write "</div></body></html>"
Response.END
End Sub

Sub Display_All(svc)
On Error Resume Next
Dim objComp, strItem
Set objComp = GetObject("IIS://" & Application("Server") & "/" & svc)
%>
Retrieving list of sites...
<TABLE width="100%" name="rsTable" id="rsTable" cols=6>
	<TR>
		<TH><Acronym title="Sort by Instance Number" onClick="table_sort(0)" onMouseOver="this.style.cursor='hand';">< Instance ></acronym></TH>
		<TH><Acronym title="Sort by Description" onClick="table_sort(1)" onMouseOver="this.style.cursor='hand';">< Description ></acronym></TH>
		<TH><Acronym title="Sort by IP Address" onClick="table_sort(2)" onMouseOver="this.style.cursor='hand';">< IP address ></acronym></TH>
		<TH><Acronym title="Sort by Status" onClick="table_sort(3)" onMouseOver="this.style.cursor='hand';">< Status ></acronym></TH>
		<TH>&nbsp;</TH>
		<TH>&nbsp;</TH>
	</TR>
	<%
	For Each strItem in objComp
	  If isNumeric(strItem.name) Then
		Dim ArrBinding, strBinding, ipadd
		  ArrBindings = strItem.ServerBindings
		  If err then
		    ipadd = "Err Retrieving Bindings"
		  Else
		    strBinding = Split(ArrBindings(0), ":")
		    ipadd = strBinding(0)
      End If
      err.clear
		  If ipadd = "" Then ipadd = "* All Unassinged *"
	%>
	<tr>
	  <td><%=strItem.Name%></td>
	  <td><%=strItem.ServerComment%></td>
	  <td>
		<%=ipadd%>
	  </td>
	  <td>
		<%
		Select Case strItem.ServerState
		  Case 1
			Response.write "<font color='#00FF00'>( Starting )"
			statlink = "<a href=""display_services.asp?action=show&site=" & strItem.Name & "&state=Stop&svc="& svc &""">Stop</a>&nbsp;&nbsp;<a href=""display_services.asp?action=show&site=" & strItem.Name & "&state=Pause&svc="& svc &""">Pause</a>"
		  Case 2
			Response.write "<font color='#00FF00'>( Running )"
			statlink = "<a href=""display_services.asp?action=show&site=" & strItem.Name & "&state=Stop&svc="& svc &""">Stop</a>&nbsp;&nbsp;<a href=""display_services.asp?action=show&site=" & strItem.Name & "&state=Pause&svc="& svc &""">Pause</a>"
		  Case 3
		  Response.write "<font color='#FF0000'>( Stopping )"
		  statlink = "<a href=""display_services.asp?action=show&site=" & strItem.Name & "&state=Start&svc="& svc &""">Start</a>"
		  Case 4
			Response.write "<font color='#FF0000'>( Stopped )"
			statlink = "<a href=""display_services.asp?action=show&site=" & strItem.Name & "&state=Start&svc="& svc &""">Start</a>"
		  Case 5
			Response.write "<font color='#00FFFF'>( Pausing )"
			statlink = "<a href=""display_services.asp?action=show&site=" & strItem.Name & "&state=Continue&svc="& svc &""">Continue</a>"
		  Case 6
			Response.write "<font color='#00FFFF'>( Paused )"
			statlink = "<a href=""display_services.asp?action=show&site=" & strItem.Name & "&state=Continue&svc="& svc &""">Continue</a>"
		  Case 7
			Response.write "<font color='#00FFFF'>( Continuing )"
			statlink = "<a href=""display_services.asp?action=show&site=" & strItem.Name & "&state=Stop&svc="& svc &""">Stop</a>&nbsp;&nbsp;<a href=""display_services.asp?action=show&site=" & strItem.Name & "&state=Pause&svc="& svc &""">Pause</a>"
		  Case Else
			Response.Write "unknown"
			statlink = ""
		End Select
		%>
	  </td>
	  <TD><%= statlink %></TD>
	  <td><a class="man_link" href=display_services.asp?action=go&svc=<%=svc%>&site=<%=strItem.Name%>>Manage</a></td>
	</tr>
		<%
		  End If
	Next
%>
</table>
</div>
</body>
</html>
<%
Response.End
End Sub

Sub Show_FP_Sites

%>
<br>
Retrieving list FP 2002 enabled websites...

<TABLE width="100%" name="rsTable" id="rsTable" cols=4>
  <TR>
	<TH><Acronym title="Sort by Domain Name" onClick="table_sort(0)" onMouseOver="this.style.cursor='hand';">Domain Name</acronym></TH>
	<TH><Acronym title="Sort by IP Address" onClick="table_sort(1)" onMouseOver="this.style.cursor='hand';">IP address</acronym></TH>
	<TH>&nbsp;</TH>
	<TH>&nbsp;</TH>
  </TR>

<%
On Error Resume Next
Server.ScriptTimeout = 300

'errs = ""
Set objComp = GetObject("IIS://" & Application("Server") & "/" & svc)
  For Each strItem in objComp
	err.clear
	If IsNumeric(strItem.name) Then

	  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & stritem.Name & "/ROOT")
	  FPWeb = False
	  If Application("IISVer") = 5 Then
      If strItem.FrontPageWeb = "True" Then FPWeb = True
    ElseIf Application("IISVer") = 6 Then
      If objSiteRoot.FrontPageWeb = "True" Then FPWeb = True
    End If

	  If FPWeb = True Then
		If err Then
		  err.clear
		Else
		  Set objSiteFP = GetObject("IIS://" & Application("Server") & "/W3SVC/" & stritem.Name & "/ROOT/_vti_bin")
			If err Then
			  err.clear
			Else
			  If InStr(objSiteFP.path, "50") Then
				flag = 1
		    If err then
		      ipadd = "Err Retrieving Bindings"
		    Else
		      strBinding = Split(ArrBindings(0), ":")
		      ipadd = strBinding(0)
        End If
      err.clear
				If ipadd = "" Then ipadd = "127.0.0.1"
  				admlink = "<a class=""man_link"" href=http://" & strItem.ServerComment & "/_vti_bin/_vti_adm/fpadmdll.dll?page=webadmin.htm>Manage</a>"
	  			iplnk = "<a class=""man_link"" href=http://" & ipadd & "/>" & ipadd & "</a>"
		  		dnrlnk = "<a class=""man_link"" target=""_blank"" href=http://" & strItem.ServerComment & "/_vti_bin/_vti_adm/fpadmdll.dll?page=health.htm>Detect & Repair</a>"
			  	Response.write "<tr>"
				  Response.write "<td>" & strItem.ServerComment & "</td>"
				  Response.write "<td>" & iplnk & "</td>"
				  Response.write "<td>" & dnrlnk & "</td>"
				  Response.write "<td>" & admlink & "</td>"
				  Response.Write "</tr>"
				  Response.Flush
				Set objSiteFP = Nothing
				Set objSiteRoot = Nothing
			  End If
			End If
		End If
	  End If
	End If
  Next

Set objComp = Nothing
Set objSiteRoot = Nothing
Set objSiteFP = Nothing

If flag = 0 Then Response.write "<TR><TD colspan=""4"">No sites found.</TD></TR>"
'If errs <> "" Then Response.write "<TR><TD colspan=""4"">Errors " & errs & "</TD></TR>"
Response.write "</TABLE>"

End Sub

Sub Show_App_Pools

%>
<br>
Retrieving list Application Pools...

<TABLE width="100%" name="rsTable" id="rsTable" cols=4>
  <TR>
  	<TH><Acronym title="Sort by Application Pool Name" onClick="table_sort(0)" onMouseOver="this.style.cursor='hand';">< Application Pool ></acronym></TH>
	  <TH><Acronym title="Sort by Status" onClick="table_sort(1)" onMouseOver="this.style.cursor='hand';">< Status ></acronym></TH>
	  <TH>&nbsp;</TH>
	  <TH>&nbsp;</TH>
  </TR>

<%
Flag = 0
On Error Resume Next
Server.ScriptTimeout = 300
Dim statlink, statshow

Set AppPools = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools")
  For Each AppPool in AppPools
    If err = False Then flag = 1

 		Select Case AppPool.AppPoolState
		  Case 2
			statshow = "<font color='#00FF00'>( Running )"
			statlink = "<a href=""display_services.asp?action=apools&app=" & Server.URLEncode(AppPool.Name) & "&appstate=Stop&svc="& svc &""">Stop</a>&nbsp;&nbsp;<a href=""display_services.asp?action=apools&app=" & AppPool.Name & "&appstate=Recycle&svc="& svc &""">Recycle</a>"
		  Case 4
			statshow = "<font color='#FF0000'>( Stopped )"
			statlink = "<a href=""display_services.asp?action=apools&app=" & Server.URLEncode(AppPool.Name) & "&appstate=Start&svc="& svc &""">Start</a>"
		  Case Else
			statshow = "unknown"
			statlink = ""
		End Select

    Response.write "<TR><TD>" & AppPool.Name & "</TD><TD>" & statshow & "</TD>"
    Response.write "<TD>" & statlink & "</TD>"
    Response.write "<TD><a class=""man_link"" href=""manage_app_pools.asp?appname=" & Server.URLEncode(AppPool.Name) & """>Manage</a></TD></TR>"
  Next

Set AppPools = Nothing

If flag = 0 Then Response.write "<TR><TD colspan=""4"">No Application Pools found.</TD></TR>"

Response.write "</TABLE><br>"

If Application("IISVer") = "6" AND LCase(Request.QueryString("action")) = "apools" Then %>
      <TABLE width="100%">
        <TR>
          <TD><a class="man_link" href="install_app_pools.asp">Create Application Pool</a></TD>
          <TD><a class="man_link" href="manage_app_pools.asp?appname=main">Application Pool Defaults</a></TD>
        </TR>
      </TABLE>
<% End If

End Sub


Sub Show_Web_SE
On Error Resume Next
%>
<br>
Retrieving list of Web Service Extensions...

<TABLE width="100%" name="rsTable" id="rsTable" cols=4>
  <TR>
  	<TH><Acronym title="Sort by Web Service Extension Name" onClick="table_sort(0)" onMouseOver="this.style.cursor='hand';">< Web Service Extension ></acronym></TH>
	  <TH><Acronym title="Sort by Status" onClick="table_sort(1)" onMouseOver="this.style.cursor='hand';">< Status ></acronym></TH>
	  <TH>&nbsp;</TH>
	  <TH>&nbsp;</TH>
  </TR>
<%

Dim bFound
WSEList = Array()
Dim FoundList()

ReDim Preserve FoundList(0)

Set providerObj = GetObject("winmgmts://" & Application("SERVER") & "/root/MicrosoftIISv2")
Set IIsSettingObj = providerObj.Get("IIsWebServiceSetting='W3SVC'")

WSEList = IIsSettingObj.WebSvcExtRestrictionList
flag = 0

For Each i in WSEList

  If err = False Then flag = 1
'   i.Access
'   i.Deletable
'   i.Description
    wse_name = i.ServerExtension
    nostat = False
    If i.FilePath = "*.exe" Then
      wse_name = "All Unknown CGI Extensions"
      nostat = True
    End If
    If i.FilePath = "*.dll" Then
      wse_name = "All Unknown ISAPI Extensions"
      nostat = True
    End If
    'Check to see if we already have it, add it if we don't, skip if we do
    bFound = False
    For x = 0 to UBound(FoundList)
      If wse_name = FoundList(x) Then
        bFound = True
        Exit For
      End If
    Next
    If bFound = False Then
      FoundList(UBound(FoundList)) = wse_name
      ReDim Preserve FoundList((UBound(FoundList)+1))

 		  Select Case i.Access
		    Case 0
			    statshow = "<font color='#FF0000'>( Disabled )"
			    If nostat = False Then statlink = "<a href=""display_services.asp?action=wse&wse=" & Server.URLEncode(wse_name) & "&wsestate=enable&svc="& svc &""">Enable</a>"
		    Case 1
			    statshow = "<font color='#00FF00'>( Enabled )"
			    If nostat = False Then statlink = "<a href=""display_services.asp?action=wse&wse=" & Server.URLEncode(wse_name) & "&wsestate=disable&svc="& svc &""">Disable</a>"
		    Case Else
			    statshow = "unknown"
			    statlink = ""
		  End Select
      Response.write "<TR><TD>" & wse_name & "</TD><TD>" & statshow & "</TD>"
      Response.write "<TD>" & statlink & "</TD>"
      If nostat = False Then 
        Response.write "<TD><a class=""man_link"" href=""manage_wse.asp?appname=" & Server.URLEncode(wse_name) & """>Manage</a></TD></TR>"
      Else
        Response.write "<TD>&nbsp;</TD></TR>"
      End If
    End If

Next

If flag = 0 Then Response.write "<TR><TD colspan=""4"">No Web Service Extensions found.</TD></TR>"

Response.write "</TABLE><br>"

If Application("IISVer") = "6" AND LCase(Request.QueryString("action")) = "wse" Then %>
      <TABLE width="100%">
        <TR>
          <TD><a class="man_link" href="install_wse.asp">Add Web Service Extension</a></TD>
        </TR>
      </TABLE>
<% End If

End Sub

%>

</div>
</body>
</html>

<%
Sub change_state(svc,site,errmsg,state)

Select Case LCase(svc)
  Case "w3svc"
    set oServer = GetObject("IIS://" & Application("Server") & "/" & svc & "/" & site )
    Select Case LCase(state)
	    Case "start"
	      oServer.Start
	    Case "stop"
	      oServer.Stop
	    Case "pause"
	      oServer.Pause
	    Case "continue"
	      oServer.Continue
    End Select
  Case "msftpsvc"
    flag = 0
    set objSite = GetObject("IIS://" & Application("Server") & "/" & svc & "/" & site )
  	  siteBindings = objSite.ServerBindings
  	  siteBinds = Split(siteBindings(0),":")
    Set objServer = GetObject("IIS://" & Application("Server") & "/" & svc )
  	For each item in objServer
  	  If IsNumeric(item.name) AND item.name <> objSite.name Then
  		If item.ServerState < 3 Then
  		  obind = item.ServerBindings
  		  obinds = Split(obind(0), ":")
  		  If obinds(0) = siteBinds(0) AND obinds(1) = siteBinds(1) Then flag = 1
  		End If
  	  End If
  	Next
    Set objServer = Nothing

    If flag = 0 Then
      Select Case LCase(state)
  	    Case "start"
  		    objSite.Start
  	    Case "stop"
  		    objSite.Stop
  	    Case "pause"
  		    objSite.Pause
  	    Case "continue"
  		    objSite.Continue
      End Select
  Else
    errmsg = "Action not completed.  FTP sites need a UNIQUE IP Address and/or port"
  End If
  Set objSite = Nothing
  Case "smtpsvc"
    flag = 0
    set objSite = GetObject("IIS://" & Application("Server") & "/" & svc & "/" & site )
	    siteBindings = objSite.ServerBindings
	    siteBinds = Split(siteBindings(0),":")
    Set objServer = GetObject("IIS://" & Application("Server") & "/" & svc )
	  For each item in objServer
	    If IsNumeric(item.name) AND item.name <> objSite.name Then
		    If item.ServerState < 3 Then
		      obind = item.ServerBindings
		      obinds = Split(obind(0), ":")
		      If obinds(0) = siteBinds(0) AND obinds(1) = siteBinds(1) Then flag = 1
		    End If
	    End If
	  Next
    Set objServer = Nothing
    If flag = 0 Then
      Select Case LCase(state)
	      Case "start"
		      objSite.Start
	      Case "stop"
		      objSite.Stop
	      Case "pause"
		      objSite.Pause
	      Case "continue"
		      objSite.Continue
      End Select
Else
  errmsg = "Action not completed.  SMTP sites need a UNIQUE IP Address and/or port"
End If

Set objSite = Nothing

End Select

End sub

Sub change_app_state(app,errmsg,state)
On Error Resume Next

  Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & app)
    Select Case LCase(state)
	    Case "start"
	      AppPool.Start
	    Case "stop"
	      AppPool.stop
	    Case "recycle"
	      AppPool.recycle
    End Select
  If err then errmsg = "Error Changing State!"
End sub

Sub change_wse_state(wse,errmsg,state)
On Error Resume Next
Set providerObj = GetObject("winmgmts://" & Application("SERVER") & "/root/MicrosoftIISv2")
Set IIsObj = providerObj.Get("IIsWebService='W3SVC'")
  wse = CStr(wse)
'   If InStr(wse,"CGI") Then wse = "*.exe"
'   If InStr(wse,"ISAPI") Then wse = "*.dll"
  Select Case state
    Case "enable"
      IIsObj.EnableWebServiceExtension wse
    Case "disable"
      IIsObj.DisableWebServiceExtension wse
  End Select
If err then errmsg = "Error Changing State!<BR>" & err.description & "<BR>wse: " & wse & "<br>state: " & state

End sub

%>
