<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################


dim IPS, MachineName, Obj, IISObject, IISObjectPath, IPAddressFile
dim Index, ArrayOfIP, IPAddress, BindingPath, IISObjectIP
dim ValueList, ValueIndex, ValueString, value, tcpport, pos, NextfreeIP

' This subroutine will remove any currently assigned IPs from the dictionary
Sub RemoveIPFromDictionary(IPAddress)
 Dim ArrayofIP

 ArrayofIP = IPS.keys
 for pos = lbound(ArrayofIP) to UBound(ArrayOfIP)
  if (ArrayOfIP(Pos) = IPAddress) then
   IPS.Remove(IPAddress)
   exit Sub
  end if
 next
end Sub

' Read the IP Address file into the dictionary
Sub ReadIPAddressFile
On Error Resume Next
Set ObjShell=CreateObject("WScript.SHELL")
  TcpIPInfo = ObjShell.RegRead("HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Linkage\Route")
  For i = 0 to (Ubound(TcpIPInfo)-1)
	  ServiceName = Replace(TcpIPInfo(i),"""","")
    StrIP = ObjShell.RegRead("HKLM\System\CurrentcontrolSet\Services\" & Servicename & "\Parameters\TCPIP\IPAddress")
    For pos = lbound(strIP) to UBound(StrIP)
      If InStr(StrIP(pos),"0.0.0.0") = False Then IPS.Add	StrIP(Pos), StrIP(Pos)
    Next
  Next
End Sub

Sub FindFreeIPS()
'Determine svc based on page in URL
' ***
Set IIsObject = GetObject("IIS://" & Application("Server") & "/" & svc)
  For each obj in IISObject
  If (Obj.Class = "IIsWebServer")  or (Obj.Class = "IIsFTPServer") then
	BindingPath = "IIS://" & Application("Server") & "/" & svc & "/" & Obj.Name
	Set IIsObjectIP = GetObject(BindingPath)
	ValueList = IISObjectIP.Get("ServerBindings")
	ValueString = ""
	For ValueIndex = 0 To UBound(ValueList)
	  If (left(ValueList(ValueIndex), 1) = ":") Then
	  Else
		value = ValueList(ValueIndex)
		value = left(Value, len(Value)-1) ' Remove the last :
		IPAddress = left(Value, instr(value, ":")-1)
		TCPport   = mid(Value, instr(value, ":")+1)
		RemoveIPFromDictionary IPAddress
	  End if
	Next
	RemoveIPFromDictionary session("Pri_Srv_IP")
  Set IISObjectIP = Nothing
  End if
Next
Set IISObject = Nothing
End sub

Function ReturnNextFreeIPAddress(SelectedValue)
  Set IPS = CreateObject("Scripting.Dictionary")
  ReadIPAddressFile
'###########
'###  If you do not want to be able to select an
'###   already used IP uncomment the next 2 lines.
'  FindFreeIPS
'###########
  If (IPS.Count = 0) Then
    ReturnnextFreeIPAddress = ""
    Exit Function
  End If
  ArrayofIP = IPS.keys
  Dim theOutput
  theOutput = "<select name=IPAdd><option value="""">All Unassigned</option>"
  For pos = lbound(ArrayofIP) to UBound(ArrayOfIP)
    If SelectedValue = ArrayOfIP(Pos) Then
      theOutput = theOutput & "<option value=""" & ArrayOfIP(Pos) & """ SELECTED>" & ArrayOfIP(Pos) & "</option>"
    Else
	    theOutput = theOutput & "<option value=""" & ArrayOfIP(Pos) & """>" & ArrayOfIP(Pos) & "</option>"
    End If
  Next
  theOutput = theOutput & "</select>"
  ReturnNextFreeIPAddress = theOutput
End function



Sub Register_DLL(dllname,opt,errs)
On Error Resume Next

  Set WshShell = Server.CreateObject("WScript.Shell")
    path = Request.ServerVariables("APPL_PHYSICAL_PATH") & "dlls\" & dllname
    If opt = "i" Then un_in = "" else un_in = " /u"
    strCmdLine = "regsvr32 " & path & " /s" & un_in
    ' /s is for silent

    oRun = WshShell.Run( strCmdLine, 0, True )
    If err then errs = "Error: " & err.description & "<BR>"
    If dllname = "iacp_dns.dll" Then Application("iacp_dns") = WshShell.RegRead("HKEY_CLASSES_ROOT\iacp_dns.dns0\")
    If err then errs = "Error: " & err.description & "<BR>"


End Sub

%>
