<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################



Function CheckLogFlag(FlagName)

CheckLogFlag = ""
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/" & Session("svc"))
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/" & Session("svc") & "/" & Request("site"))
  End If

Select Case FlagName
  Case "LogExtFileBytesRecv"
    If objSite.LogExtFileBytesRecv = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileBytesSent"
    If objSite.LogExtFileBytesSent = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileClientIp"
    If objSite.LogExtFileClientIp = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileComputerName"
    If objSite.LogExtFileComputerName = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileCookie"
    If objSite.LogExtFileCookie = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileDate"
    If objSite.LogExtFileDate = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileHost"
    If Application("IISVer") = 6 Then
      If objSite.LogExtFileHost = True Then CheckLogFlag = "CHECKED"
    End If
  Case "LogExtFileHttpStatus"
    If objSite.LogExtFileHttpStatus = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileMethod"
    If objSite.LogExtFileMethod = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileProtocolVersion"
    If objSite.LogExtFileProtocolVersion = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileReferer"
    If objSite.LogExtFileReferer = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileServerIp"
    If objSite.LogExtFileServerIp = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileServerPort"
    If objSite.LogExtFileServerPort = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileSiteName"
    If objSite.LogExtFileSiteName = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileTime"
    If objSite.LogExtFileTime = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileTimeTaken"
    If objSite.LogExtFileTimeTaken = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileUriQuery"
    If objSite.LogExtFileUriQuery = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileUriStem"
    If objSite.LogExtFileUriStem = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileUserAgent"
    If objSite.LogExtFileUserAgent = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileUserName"
    If objSite.LogExtFileUserName = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileWin32Status"
    If objSite.LogExtFileWin32Status = True Then CheckLogFlag = "CHECKED"
  Case "LogExtFileHttpSubStatus"
    If Application("IISVer") = 6 Then
      If objSite.LogExtFileHttpSubStatus = True Then CheckLogFlag = "CHECKED"
    End If
End Select


End Function



Function GetLogTypes(curLogType)

  selectStr = "<SELECT Name=""logtype"">"
  Set objIISLogTypes = GetObject("IIS://" & Application("Server") & "/Logging")
    For each Logtype in objIISLogTypes
      If LogType.Name <> "Custom Logging" Then
        Set objLogType = GetObject("IIS://" & Application("Server") & "/Logging/" & Logtype.Name)
        If Session("svc") = "MSFTPSVC" and objLogType.LogModuleid = "{FF16065F-DE82-11CF-BC0A-00AA006111E0}" Then
          'The FTP svc does not use NCSA type logging.
          'Just skip it.
        Else
          selectStr = selectStr & "<option value=""" & objLogType.LogModuleid & """ "
          If objLogType.LogModuleid = curLogType Then selectStr = selectStr & "SELECTED"
          selectStr = selectStr & ">" & Logtype.Name & "</option>"
        End If
      End If
    Next
  selectStr = selectStr & "</SELECT>"
  GetLogTypes = selectStr

End Function



Function LogOptionsDisplay(LogType)
  tmpDisplayStr = ""
  tmpBlank = "<TR><TD colspan=""2"">&nbsp;</TD></TR>" & vbCrLf

  tmpFilePeriod = "<TR><TD class=""left"" colspan=""2""><b>New Log File Schedule</b><BR><BR>"

  tmpFilePeriod = tmpFilePeriod & "<input type=""radio"" name=""fileperiod"" value=""4"""
  If Session("fileperiod") = "4" Then tmpFilePeriod = tmpFilePeriod & " CHECKED"
  tmpFilePeriod = tmpFilePeriod & "> Hourly<BR>"

  tmpFilePeriod = tmpFilePeriod & "<input type=""radio"" name=""fileperiod"" value=""1"""
  If Session("fileperiod") = "1" Then tmpFilePeriod = tmpFilePeriod & " CHECKED"
  tmpFilePeriod = tmpFilePeriod & "> Daily<BR>"

  tmpFilePeriod = tmpFilePeriod & "<input type=""radio"" name=""fileperiod"" value=""2"""
  If Session("fileperiod") = "2" Then tmpFilePeriod = tmpFilePeriod & " CHECKED"
  tmpFilePeriod = tmpFilePeriod & "> Weekly<BR>"

  tmpFilePeriod = tmpFilePeriod & "<input type=""radio"" name=""fileperiod"" value=""3"""
  If Session("fileperiod") = "3" Then tmpFilePeriod = tmpFilePeriod & " CHECKED"
  tmpFilePeriod = tmpFilePeriod & "> Monthly<BR>"

  tmpFilePeriod = tmpFilePeriod & "<input type=""radio"" name=""fileperiod"" value=""5"""
  If Session("fileperiod") = 0 AND Session("filesize") = -1 Then tmpFilePeriod = tmpFilePeriod & " CHECKED"
  tmpFilePeriod = tmpFilePeriod & "> Unlimited File Size<BR>"

  tmpFilePeriod = tmpFilePeriod & "<input type=""radio"" name=""fileperiod"" value=""0"""
  If Session("fileperiod") = 0 AND Session("filesize") <> -1 Then tmpFilePeriod = tmpFilePeriod & " CHECKED"
  If Session("filesize") = -1 Then filesize = "" Else filesize = Session("filesize") / 1048576
  tmpFilePeriod = tmpFilePeriod & "> When File Size Reaches: "
  tmpFilePeriod = tmpFilePeriod & "<input type=""textbox"" name=""filesize"" value=""" & filesize & """ size=""5"">megs<BR>"

  tmpFilePeriod = tmpFilePeriod & "<BR></TD></TR>"


  Select Case LogType
    Case "{FF160657-DE82-11CF-BC0A-00AA006111E0}" 'MS-IIS
      tmpDisplayStr = tmpDisplayStr & tmpFilePeriod & tmpBlank

    Case "{FF16065F-DE82-11CF-BC0A-00AA006111E0}" 'NCSA Common
      tmpDisplayStr = tmpDisplayStr & tmpFilePeriod & tmpBlank

    Case "{FF16065B-DE82-11CF-BC0A-00AA006111E0}" 'ODBC
      tmpDisplayStr = tmpDisplayStr & "<TR><TD class=""right"">Data Source Name</TD><TD><input type=""textbox"" name=""LogODBCDataSource"" value=""" & Session("LogODBCDataSource") & """></TD></TR>"
      tmpDisplayStr = tmpDisplayStr & "<TR><TD class=""right"">Table Name</TD><TD><input type=""textbox"" name=""LogODBCTableName"" value=""" & Session("LogODBCTableName") & """></TD></TR>"
      tmpDisplayStr = tmpDisplayStr & "<TR><TD class=""right"">User Name</TD><TD><input type=""textbox"" name=""LogODBCUserName"" value=""" & Session("LogODBCUserName") & """></TD></TR>"
      tmpDisplayStr = tmpDisplayStr & "<TR><TD class=""right"">Password</TD><TD><input type=""textbox"" name=""LogODBCPassword"" value=""" & Session("LogODBCPassword") & """></TD></TR>"

    Case "{FF160663-DE82-11CF-BC0A-00AA006111E0}" 'W3C Extended

      tmpROD = "<TR><TD>Use local time for file naming and roll over</TD><TD><input type=""checkbox"" name=""rollover"""
      If Session("rollover") = True Then tmpROD = tmpROD & " CHECKED"
      tmpROD = tmpROD & "></TD></TR>" & vbCrLf

      tmpDisplayStr = tmpDisplayStr & tmpFilePeriod & tmpBlank
      tmpDisplayStr = tmpDisplayStr & tmpROD & tmpBlank

      tmpDisplayStr = tmpDisplayStr & "<TR><TD class=""left"" colspan=""2""><b>Extended Logging Options</b><BR><BR>"
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileDate"" " & CheckLogFlag("LogExtFileDate") & ">Date<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileTime"" " & CheckLogFlag("LogExtFileTime") & ">Time<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileClientIp"" " & CheckLogFlag("LogExtFileClientIp") & ">Client IP<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileUserName"" " & CheckLogFlag("LogExtFileUserName") & ">Client Username<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileSiteName"" " & CheckLogFlag("LogExtFileSiteName") & ">Service Name<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileComputerName"" " & CheckLogFlag("LogExtFileComputerName") & ">Server Name<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileServerIp"" " & CheckLogFlag("LogExtFileServerIp") & ">Server IP Address<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileServerPort"" " & CheckLogFlag("LogExtFileServerPort") & ">Server Port<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileMethod"" " & CheckLogFlag("LogExtFileMethod") & ">Method<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileUriStem"" " & CheckLogFlag("LogExtFileUriStem") & ">URI Stem<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileUriQuery"" " & CheckLogFlag("LogExtFileUriQuery") & ">URI Query<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileHttpStatus"" " & CheckLogFlag("LogExtFileHttpStatus") & ">Protocol Status<BR>" & vbCrLf
      If Application("IISVer") >= 6 Then tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileHttpSubStatus"" " & CheckLogFlag("LogExtFileHttpSubStatus") & ">Protocol Sub Status<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileWin32Status"" " & CheckLogFlag("LogExtFileWin32Status") & ">Win32 Status<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileBytesSent"" " & CheckLogFlag("LogExtFileBytesSent") & ">Bytes Sent<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileBytesRecv"" " & CheckLogFlag("LogExtFileBytesRecv") & ">Bytes Recieved<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileTimeTaken"" " & CheckLogFlag("LogExtFileTimeTaken") & ">Time Taken<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileProtocolVersion"" " & CheckLogFlag("LogExtFileProtocolVersion") & ">Protocol Version<BR>" & vbCrLf
      If Application("IISVer") >= 6 Then tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileHost"" " & CheckLogFlag("LogExtFileHost") & ">Host<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileUserAgent"" " & CheckLogFlag("LogExtFileUserAgent") & ">User Agent<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileCookie"" " & CheckLogFlag("LogExtFileCookie") & ">Cookie<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<input type=""checkbox"" name=""LogExtFileReferer"" " & CheckLogFlag("LogExtFileReferer") & ">Referer<BR>" & vbCrLf
      tmpDisplayStr = tmpDisplayStr & "<BR></TD></TR>"
  End Select

  LogOptionsDisplay = tmpDisplayStr

End Function


%>
