<%
' countdown.asp: Countdown to Event
' Version 1.0
' Copyright (C) 1998 John Watson
'
' E-mail: john@watson-net.com
'
' Get the latest version and full documentation
' at http://www.watson-net.com/
'
' PURPOSE
'
' Contains functions for displaying a text countdown to a certain
' date (e.g. It is only 5 days 3 minutes until x).  It will countdown
' years, months, days, and minutes.
'
' INPUTS
'
' dTargetDate: the date to countdown to (mm/dd/yy string)
' dTargetTime: the time to countdown to (hh:mm:ss string)
' sEventName: the name of the event to countdown to
'
' RETURNS
'
' None
'
' LICENSE
'
' This library is free software; you can redistribute it and/or
' modify it under the terms of the GNU Library General Public
' License as published by the Free Software Foundation; either
' version 2 of the License, or (at your option) any later version.
' 
' This library is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
' Library General Public License for more details.
' 
' You should have received a copy of the GNU Library General Public
' License along with this library; if not, write to the
' Free Software Foundation, Inc., 59 Temple Place - Suite 330,
' Boston, MA  02111-1307, USA.

Function CountDown(dTargetDate, dTargetTime, sEventName)
	DIM D1, D2, T1, T2, Years, Months, Days, Hours, Minutes, Temp, since
	
    D2 = DateValue(dTargetDate)
    T2 = TimeValue(dTargetTime)

    If (D2 < Date) Then
        since = TRUE
        D1 = DateValue(dTargetDate)
        D2 = Date
        T1 = TimeValue(dTargetTime)
        T2 = Time
    Else
        since = FALSE
        D1 = Date
        T1 = Time
    End If

    Years = Year(D2) - Year(D1)
    Months = Month(D2) - Month(D1)
    Days = Day(D2) - Day(D1)

    Hours = Hour(T2) - Hour(T1)
    Minutes = Minute(T2) - Minute(T1)

    If (Months < 0) Then
        Months = Months + 12
        Years = Years - 1
    End If

    If (Days < 0) Then
        Days = Days + DaysIn(Month(D1))
        Months = Months - 1
    End If

    If (Hours < 0) Then
        Hours = Hours + 24
        Days = Days - 1
    End If

    If (Minutes < 0) Then
        Minutes = Minutes + 60
        Hours = Hours - 1
    End If

    Temp = ""

    If (Years <> 0) Then
        Temp = Temp & Years
        If (Years = 1) Then
            Temp = Temp & " year "
        Else
            Temp = Temp & " years "
        End If
    End If
    If (Months <> 0) Then
        Temp = Temp & Months
        If (Months = 1) Then
            Temp = Temp & " month "
        Else
            Temp = Temp & " months "
        End If
    End If
    If (Days <> 0) Then
        Temp = Temp & Days
        If (Days = 1) Then
            Temp = Temp & " day "
        Else
            Temp = Temp & " days "
        End If
    End If
    If (Hours <> 0) Then
        Temp = Temp & Hours
        If (Hours = 1) Then
            Temp = Temp & " hour "
        Else
            Temp = Temp & " hours "
        End If
    End If
    If (Minutes <> 0) Then
        If (Temp <> "") Then Temp = Temp & " and "
        Temp = Temp & Minutes
        If (Minutes = 1) Then
            Temp = Temp & " minute "
        Else
            Temp = Temp & " minutes "
        End If
    End If
    If (Since) Then
        Temp = "It has been " & temp & " since " & sEventName
    Else
        Temp = "Only " & temp & " until " & sEventName
    End If

    Countdown = Temp
End Function

' Returns the number of days in a given month
Function DaysIn(MonthNum)
    Select Case MonthNum
        Case 1  DaysIn = 31 'jan
        Case 2  DaysIn = 28 'feb
        Case 3  DaysIn = 31 'mar
        Case 4  DaysIn = 30 'apr
        Case 5  DaysIn = 31 'may
        Case 6  DaysIn = 30 'jun
        Case 7  DaysIn = 31 'jul
        Case 8  DaysIn = 31 'aug
        Case 9  DaysIn = 30 'sep
        Case 10 DaysIn = 31 'oct
        Case 11 DaysIn = 30 'nov
        Case 12 DaysIn = 31 'dec
    End Select
End Function
%>
