<%
' Comersus 5.0x Sophisticated Cart 
' Developed by Rodrigo S. Alhadeff for Comersus Open Technologies
' United States 
' Open Source License can be found at License.txt
' http://www.comersus.com  
' Details: takes credit card data for off-line payments, verify exp and number 
%>

<!--#include virtual="/comersus/includes/settings.asp"--> 
<!--#include virtual="/comersus/includes/getSettingKey.asp"--> 
<!--#include virtual="/comersus/includes/sessionFunctions.asp"--> 
<!--#include virtual="/comersus/includes/databaseFunctions.asp"--> 
<!--#include virtual="/comersus/includes/languages.asp"--> 
<!--#include virtual="/comersus/includes/currencyFormat.asp"--> 
<!--#include virtual="/comersus/includes/encryption.asp" -->
<!--#include virtual="/comersus/includes/stringFunctions.asp"-->
<!--#include virtual="/comersus/includes/sendMail.asp"--> 
<!--#include virtual="/comersus/includes/miscFunctions.asp"--> 

<% 

on error resume next

dim mySQL, conntemp, rsTemp

' get settings 
pDefaultLanguage 	= getSettingKey("pDefaultLanguage")
pStoreFrontDemoMode 	= getSettingKey("pStoreFrontDemoMode")
pCurrencySign	 	= getSettingKey("pCurrencySign")
pDecimalSign	 	= getSettingKey("pDecimalSign")
pCompany	 	= getSettingKey("pCompany")
pCompanyLogo	 	= getSettingKey("pCompanyLogo")
pOrderPrefix	 	= getSettingKey("pOrderPrefix")
pEncryptionPassword	= getSettingKey("pEncryptionPassword")
pEncryptionMethod 	= getSettingKey("pEncryptionMethod")
pSendPlainText		= getSettingKey("pSendPlainText")

pOrderTotal 		= getUserInput(request.querystring("orderTotal"),20)
pIdOrder		= getUserInput(request.querystring("idOrder"),20)

' extract real idOrder (without prefix)
pRealIdOrder		= removePrefix(pIdOrder,pOrderPrefix)

pCardType		= request.querystring("cardType")
pCardNumber		= request.querystring("cardNumber")
pExpiration		= request.querystring("expMonth") & "/" & request.querystring("expYear")
pSeqCode		= request.querystring("seqCode")
pNameOnCard		= request.querystring("nameOnCard")
pStatementAddress	= request.querystring("statementAddress")

pObs=dictLanguage.Item(Session("language")&"_offlinepaymentexec_2")  & pStatementAddress & " " & dictLanguage.Item(Session("language")&"_offlinepaymentexec_3")  & pNameOnCard

' validates missing fields
if trim(pOrderTotal)="" or trim(pRealIdOrder)="" then
   response.redirect "comersus_message.asp?message="&Server.Urlencode(dictLanguage.Item(Session("language")&"_offlinepaymentexec_1") ) 
end if

' validates expiration
if DateDiff("d", Month(Now)&"/"&Year(now), request.querystring("expMonth")&"/"&request.querystring("expYear"))<0 then
   response.redirect "comersus_message.asp?message="&Server.UrlEncode(dictLanguage.Item(Session("language")&"_offlinepaymentexec_6") )
end if

if not ValidateCreditCard(pCardNumber, pCardType) then
 response.redirect "comersus_message.asp?message="&Server.UrlEncode(dictLanguage.Item(Session("language")&"_offlinepaymentexec_5"))
end if

' encrypt CC data
pECardNumber=EnCrypt(pCardNumber, pEncryptionPassword)

' save credit card info
mySQL="INSERT INTO creditCards (idOrder, cardType, cardNumber, expiration, seqcode, obs) VALUES (" &pRealIdOrder& ",'" &pCardType& "','" &pECardNumber& "','" &pExpiration& "','" &pSeqCode& "','" &pObs& "')"

call updateDatabase(mySQL, rstemp, "optOffLinePaymentExec")


if pSendPlainText="-1" then
 ' send plain text email with CC data (try not to use this option for security reasons)
 call sendmail (pCompany, pEmailSender, pEmailAdmin, "New CC data in your store!, order: #"&pOrderPrefix&pIdorder, "Card Type:"&VBCrlf&pCardType&VBCrlf&"Name: " &pNameOnCard&Vbcrlf& "Adress:" &pStatementAddress&Vbcrlf& "Card Type: " &pCardType&Vbcrlf& "Card Number: " &pCardNumber&VBcrlf& "Expiration:"&pExpiration&VBcrlf&VBcrlf& "Off Line Payment powered by Comersus Sophisticated Cart"&VBcrlf&"http://www.comersus.com")
else
 ' send encrypted email
 call sendmail (pCompany, pEmailSender, pEmailAdmin, "New CC data in your store!, order: #"&pOrderPrefix&pIdorder, "Card Type: "&VBCrlf&pCardType&VBCrlf&"Card Number: "&pECardNumber&VBcrlf&VBcrlf&"Expiration:"&pExpiration&VBcrlf&VBcrlf& "Off Line Payment powered by Comersus Sophisticated Cart"&VBcrlf&"http://www.comersus.com")
end if

call closeDb()

' go to confirmation page
response.redirect "comersus_offLinePaymentConfirmation.asp?idOrder="&pIdOrder

Function ValidateCreditCard(ByRef pStrNumber, ByRef pStrType)

' THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT
' WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
' INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
' OF MERCHANTABILITY AND/OR FITNESS FOR A  PARTICULAR
' PURPOSE.

' Copyright 2000 - 2001. All rights reserved.
' Lewis Moten
' http://www.lewismoten.com
' email: lewis@moten.com

	
	ValidateCreditCard = False ' Initialize negative results
	
	' Clean Credit Card Number (Removes dashes and spaces)
	pStrNumber = ParseDigits(pStrNumber)		
	
	' Validate number with LUHN Formula
	If Not LUHN(pStrNumber) Then Exit Function
	
	' Apply rules based on type of card
	Select Case pStrType
		Case "A"
			Select Case Left(pStrNumber, 2)
				Case "34", "37"
					' Do Nothing
				Case Else
					Exit Function
			End Select
			If Not Len(pStrNumber) = 15 Then Exit Function
		Case "D"
			Select Case Left(pStrNumber, 2)
				Case "36" , "38"
					' Do Nothing
				Case "30"
					Select Case Left(pStrNumber, 3)
						Case "300", "301", "302", "303", "304", "305"
							' Do Nothing
						Case Else
							Exit Function
					End Select
				Case Else
					Exit Function
			End Select
			If Not Len(pStrNumber) = 14 Then Exit Function
		Case "Discover"
			If Not Left(pStrNumber, 4) = "6011" Then Exit Function
			If Not Len(pStrNumber) = 16 Then Exit Function
		Case "JCB"
			If Left(pStrNumber, 1) = "3" And Len(pStrNumber) = 16 Then
				' Do Nothing
			ElseIf Left(pStrNumber, 14) = "2131" And Len(pStrNumber) = 15 Then
				' Do Nothing
			ElseIf Left(pStrNumber, 14) = "1800" And Len(pStrNumber) = 15 Then
				' Do Nothing
			Else
				Exit Function
			End If
		Case "M"
			Select Case Left(pStrNumber, 2)
				Case "51", "52", "53", "54", "55"
					' Do Nothing
				Case Else
					Exit Function
			End Select
			If Not Len(pStrNumber) = 16 Then Exit Function
		Case "V"
			If Not Left(pStrNumber, 1) = "4" Then Exit Function
			If Not (Len(pStrNumber) = 13 Or Len(pStrNumber) = 16) Then Exit Function
		Case Else
			' Unknown Card Type
			Exit Function
	End Select
	
	' We got this far so the number passed all the rules!
	ValidateCreditCard = True
	
End Function
' ------------------------------------------------------------------------------
Function LUHN(ByRef pStrDigits)
	
	Dim lLngMaxPosition
	Dim lLngPosition
	Dim lLngSum				' Sum of all positions
	Dim lLngDigit			' Current digit in specified position
	
	' Initialize
	lLngMaxPosition = Len(pStrDigits)
	lLngSum = 0
	
	' Read from right to left
	For lLngPosition = lLngMaxPosition To 1 Step -1
		
		' If we are working with an even digit (from the right)
		If (lLngMaxPosition - lLngPosition) Mod 2 = 0 Then
		
			lLngSum = lLngSum + CInt(Mid(pStrDigits, lLngPosition, 1))
		
		Else
		
			' Double the digit
			lLngDigit = CInt(Mid(pStrDigits, lLngPosition, 1)) * 2
			
			' shortcut adding sum of digits
			If lLngDigit > 9 Then lLngDigit = lLngDigit - 9
			
			lLngSum = lLngSum + lLngDigit
			
		End If
	Next

	' A mod 10 check must not return any remainders
	LUHN = lLngSum Mod 10 = 0

End Function
' ------------------------------------------------------------------------------
Function ParseDigits(ByRef pStrData)
	
	' Strip all the numbers from a string
	' (cleans up dashes and spaces)
	
	Dim lLngMaxPosition
	Dim lLngPosition
	
	lLngMaxPosition = Len(pStrData)
	
	For lLngPosition = 1 To lLngMaxPosition
		If IsNumeric(Mid(pStrData, lLngPosition, 1)) Then
			ParseDigits = ParseDigits & Mid(pStrData, lLngPosition, 1)
		End If
	Next

End Function
    	
%>
