<%
' Comersus 5.0x Sophisticated Cart 
' Developed by Rodrigo S. Alhadeff for Comersus Open Technologies
' USA - 2003
' Open Source License can be found at documentation/readme.txt
' http://www.comersus.com 
' Details: miscellaneous functions
%>
<%

' discount code Generator (65^n)
function DiscountCodeGenerator(n) 
 dim s
 randomize()
 s="1234567890AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz"
 
 do
  a=""
  for i = 1 to n
   a = a + mid(s,cint(rnd()*len(s))+1,1)
  next
  
  ' search if the code is being used  
  mySQL = "SELECT discountCode FROM discounts WHERE discountCode='" &a& "'"	
  call getFromDatabase (mySql, rsTemp3, "miscFunctions")
 
 ' eof implies that the code is available		
 loop until rstemp3.eof 
 
 
 DiscountCodeGenerator = cstr(a)
end function

' randomNumber function, generates a number between 1 and limit
function randomNumber(limit)
 randomize
 randomNumber=int(rnd*limit)+1
end function

' min value
function min(byval value1, byval value2)
 if value1>value2 then
    min = value2
 else
    min = value1
 end if
end function

function getMax(arrProducts)
 dim tempMax, k
 tempMax=0
 for k=0 to uBound(arrProducts)
  if arrProducts(k,7)>tempMax then tempMax=arrProducts(k,7)
 next 
 getMax=tempMax
end function

function getPopularity(currentPopularity, maxPopularity)
 ' to avoid errors 
 if maxPopularity=0 then maxPopularity=1 
 getPopularity=int(currentPopularity*4/maxPopularity)
end function

function removePrefix(input,prefix)
 removePrefix=""
 if input<>"" and prefix<>"" then
     dim longPrefix
     longPrefix		=len(prefix)+1
     removePrefix	=mid(input,longPrefix)      
 end if
end function

function saveCookie()
 response.cookies("test")="-1"
end function

function readCookie() 
 if request.cookies("test")<>"-1" then 
  readCookie=0
 else
  readCookie=-1  
 end if
end function

function writeLog(line, file)
 set FSO 	= Server.CreateObject("scripting.FileSystemObject") 
 set myFile    = fso.OpenTextFile(file, 8, true) 
 myFile.WriteLine(line) 
 myFile.Close 
end function


sub parseShipmentMethod(pPlainString, pShipmentDesc, pShipmentPrice)
 dim cutPoint, longpRealTimeShipment
 cutPoint			= instr(pPlainString, "|")
 longpRealTimeShipment		= len(pPlainString)
 pShipmentPrice			= left(pPlainString,cutPoint-1)
 pShipmentDesc			= right(pPlainString,longpRealTimeShipment-cutPoint)    
 if pChangeDecimalPoint="-1" then pShipmentPrice=replace(pShipmentPrice,".",",") 
end sub

sub checkRentalAvailability(pIdProduct, pFrom, pUntil, pIsAvailable, pReason, pQuantity)
 
 pQuantity	=datediff("d",pFrom,pUntil) 

 if pQuantity<1 then
  pReason="Rental interval is not correct. Please check date format."
  pIsAvailable=0
 end if
 
 ' get availability

 mySQL="SELECT * FROM rentals WHERE idProduct="&pIdProduct
 call getFromDatabase(mySQL, rstemp, "comersus_rentalListAvailability.asp") 

 do while not rstemp.eof

 pLimitFF=datediff("d",pFrom,rstemp("fromDate"))
 pLimitFU=datediff("d",pFrom,rstemp("untilDate"))

 pLimitUF=datediff("d",pUntil,rstemp("fromDate"))
 pLimitUU=datediff("d",pUntil,rstemp("untilDate"))

 if pLimitFF<=0 and pLimitFU>=0 then 
   pReason="From date reserved"
   pIsAvailable=0
 end if
 
 if pLimitUF<=0 and pLimitUU>=0 then 
   if pReason<>"" then pReason=pReason&" and "
   pReason="End date reserved"
   pIsAvailable=0
 end if
 
 rstemp.movenext
loop
 
end sub
%>