<%
' Comersus 5.0x Sophisticated Cart 
' Developed by Rodrigo S. Alhadeff for Comersus Open Technologies
' USA - 2003
' Open Source License can be found at documentation/readme.txt
' http://www.comersus.com 
' Details: cart functions
%>
<%
' findProduct
function findProduct(pIdDbSessionCart, pIdProduct)  
 
 ' check if the product is inside the cart
 mySQL="SELECT idProduct FROM cartRows WHERE idProduct=" &pIdProduct& " AND idDbSessionCart="&pIdDbSessionCart
 
 call getFromDatabase(mySQL, rstemp, "cartFunctions")  

 if not rstemp.eof then
  findProduct=-1
 else
  findProduct=0
 end if  
 
end function

function findProductPrice(pIdDbSessionCart, pIdCustomerType, pIdProduct)  
 
 ' check price of the product in the cart
 
 mySQL="SELECT quantity, unitPrice, unitBtoBPrice FROM cartRows WHERE idProduct=" &pIdProduct& " AND idDbSessionCart="&pIdDbSessionCart
 call getFromDatabase(mySQL, rsTemp10, "cartFunctions")  

 if pIdCustomerType=1 then
  findProductPrice = Cdbl(rsTemp10("quantity") * rsTemp10("unitPrice"))         
 else
  findProductPrice = Cdbl(rsTemp10("quantity") * rsTemp10("unitBtoBPrice"))                  
 end if          

end function

function findProductQuantity(pIdDbSessionCart, pIdProduct)  
 
 ' retrieve quantity of the product in the cart
 
 mySQL="SELECT quantity FROM cartRows WHERE idProduct=" &pIdProduct& " AND idDbSessionCart="&pIdDbSessionCart
 call getFromDatabase(mySQL, rsTemp10, "cartFunctions")  

 findProductQuantity = rsTemp10("quantity")

end function

' count cart Rows
function countCartRows(pIdDbSessionCart)
 
 dim mySQL, rsTemp2
 
 ' check if the product is inside the cart
 mySQL="SELECT COUNT(idCartRow) AS howMany FROM cartRows WHERE idDbSessionCart="&pIdDbSessionCart

 call getFromDatabase(mySQL, rsTemp2, "cartFunctions")  

 if rsTemp2.eof then
  countCartRows=0
 else
  countCartRows=rsTemp2("howMany")
 end if  
 
end function

' Cart total
function calculateCartTotal(pIdDbSessionCart)       
 
 dim mySql, rsTempCartTotal, rsTempCartTotal2, pTotal, pOptionsTotal  
 
 pTotal=Cdbl(0)
 
 ' iterate through cart rows
 
 mySQL="SELECT idCartRow, quantity, unitPrice, unitBtoBPrice FROM cartRows WHERE idDbSessionCart="&pIdDbSessionCart  
 
 call getFromDatabase(mySQL, rsTempCartTotal, "cartFunctions")  
  
 do while not rsTempCartTotal.eof
 
  pUnitPrice		= Cdbl(rsTempCartTotal("unitPrice"))
  pUnitBtoBPrice	= Cdbl(rsTempCartTotal("unitBtoBPrice"))
  pQuantity		= rsTempCartTotal("quantity")
  pIdCartRow		= rsTempCartTotal("idCartRow")    
     
  ' get Optionals value for that row    
  
  pOptionsTotal=Cdbl(0)
  
  mySQL="SELECT SUM(cartRowsOptions.priceToAdd) AS optionsTotal FROM options, cartRowsOptions WHERE options.idOption=cartRowsOptions.idOption AND cartRowsOptions.idCartRow="&pIdCartRow     
  
  call getFromDatabase(mySQL, rsTempCartTotal2, "cartFunctions")  
    
  if rsTempCartTotal2.eof then
   pOptionsTotal=Cdbl(0)   
  else
   if isNull(rsTempCartTotal2("optionsTotal")) then
    pOptionsTotal=Cdbl(0)   
   else
    pOptionsTotal=Cdbl(rsTempCartTotal2("optionsTotal"))
   end if
  end if                
  
  pIdCustomerType     	= getSessionVariable("idCustomerType",1)
  
  if pIdCustomerType=2 and pUnitBtoBPrice>0 then 
   pTotal=pTotal+pQuantity*(pUnitBtoBPrice+pOptionsTotal)
  else
   pTotal=pTotal+pQuantity*(pUnitPrice+pOptionsTotal)   
  end if       
  
  rsTempCartTotal.movenext
 loop   
   
 calculateCartTotal=pTotal
 
end function

' Cart Weight
function calculateCartWeight(pIdDbSessionCart)   
 
 ' sum the total weight of the cart
 mySQL="SELECT SUM(quantity*unitWeight) AS total FROM cartRows WHERE idDbSessionCart="&pIdDbSessionCart

 call getFromDatabase(mySQL, rsTemp, "cartFunctions")    

 if rstemp.eof then
  calculateCartWeight=0
 else
 
  if not isNull(rstemp("total")) then
    calculateCartWeight=Cdbl(rstemp("total"))
  else
    calculateCartWeight=0
  end if
 
 end if
   
 ' sum the weight of the optionals, if any
 
 mySQL="SELECT SUM(cartRows.quantity*options.weight) AS total FROM cartRows, cartRowsOptions, options WHERE cartRows.idCartRow=cartRowsOptions.idCartRow AND cartRowsOptions.idOption=options.idOption AND idDbSessionCart="&pIdDbSessionCart

 call getFromDatabase(mySQL, rsTemp, "cartFunctions")    
 
 pTotalCartWeight=rstemp("total") 
 
 if not rstemp.eof and not isNull(pTotalCartWeight) then
    calculateCartWeight=calculateCartWeight+Cdbl(pTotalCartWeight)
  
 end if  
   
end function

' Cart Product Quantity
function calculateCartQuantity(pIdDbSessionCart)
 
 dim mySQL, rstemp2  
     
 ' sum
 mySQL="SELECT SUM(quantity) AS qTotal FROM cartRows WHERE idDbSessionCart="&pIdDbSessionCart 
 
 call getFromDatabase(mySQL, rsTemp2, "cartFunctions")        

 if rstemp2.eof then
  calculateCartQuantity=0
 else    
  if isNull(rstemp2("qTotal")) then
   calculateCartQuantity=0
  else
   calculateCartQuantity=Cdbl(rstemp2("qTotal"))
  end if
 end if     
end function

' Check session lost
function checkSessionLost() 
 if pIdDbSession="" or isNull(pIdDbSession) then
  checkSessionLost = 1
 else
  checkSessionLost = 0
 end if
end function


' Cart Weight
function calculateCartFreeShippingWeight(pIdDbSessionCart)   
 
 ' sum the total weight of the FS products 
 mySQL="SELECT SUM(quantity*unitWeight) AS total FROM cartRows, products WHERE idDbSessionCart="&pIdDbSessionCart& " AND cartRows.idProduct=products.idProduct AND freeShipping=-1"

 call getFromDatabase(mySQL, rsTemp, "cartFunctions")    

 if rstemp.eof then
  calculateCartFreeShippingWeight=0
 else
 
  if not isNull(rstemp("total")) then
    calculateCartFreeShippingWeight=Cdbl(rstemp("total"))
  else
    calculateCartFreeShippingWeight=0
  end if
 
 end if
   
 ' sum the weight of the optionals, if any
 
 mySQL="SELECT SUM(cartRows.quantity*options.weight) AS total FROM cartRows, cartRowsOptions, options, products WHERE cartRows.idCartRow=cartRowsOptions.idCartRow AND cartRowsOptions.idOption=options.idOption AND idDbSessionCart="&pIdDbSessionCart& " AND cartRows.idProduct=products.idProduct AND freeShipping=-1"

 call getFromDatabase(mySQL, rsTemp, "cartFunctions")    
 
 pTotalCartWeight=rstemp("total") 
 
 if not rstemp.eof and not isNull(pTotalCartWeight) then
    calculateCartFreeShippingWeight=calculateCartFreeShippingWeight+Cdbl(pTotalCartWeight)  
 end if  
   
end function

' Cart Free Shipping Quantity
function calculateCartFreeShippingQuantity(pIdDbSessionCart)
 
 dim mySQL, rstemp2  
     
 ' sum
 mySQL="SELECT SUM(quantity) AS qTotal FROM cartRows, products WHERE idDbSessionCart="&pIdDbSessionCart& " AND cartRows.idProduct=products.idProduct AND freeShipping=-1" 
 
 call getFromDatabase(mySQL, rsTemp2, "cartFunctions")        

 if rstemp2.eof then
  calculateCartFreeShippingQuantity=0
 else    
  if isNull(rstemp2("qTotal")) then
   calculateCartFreeShippingQuantity=0
  else
   calculateCartFreeShippingQuantity=Cdbl(rstemp2("qTotal"))
  end if
 end if     
end function

' Cart total
function calculateFreeShippingTotal(pIdDbSessionCart)       
 
 dim mySql, rsTempCartTotal, rsTempCartTotal2, pTotal, pOptionsTotal  
 
 pTotal=Cdbl(0)
 
 ' iterate through FS cart rows
 
 mySQL="SELECT idCartRow, quantity, unitPrice, unitBtoBPrice FROM cartRows, products WHERE idDbSessionCart="&pIdDbSessionCart& " AND cartRows.idProduct=products.idProduct AND freeShipping=-1"   
 
 call getFromDatabase(mySQL, rsTempCartTotal, "cartFunctions")  
  
 do while not rsTempCartTotal.eof
 
  pUnitPrice		= Cdbl(rsTempCartTotal("unitPrice"))
  pUnitBtoBPrice	= Cdbl(rsTempCartTotal("unitBtoBPrice"))
  pQuantity		= rsTempCartTotal("quantity")
  pIdCartRow		= rsTempCartTotal("idCartRow")    
     
  ' get Optionals value for that row    
  
  pOptionsTotal=Cdbl(0)
  
  mySQL="SELECT SUM(cartRowsOptions.priceToAdd) AS optionsTotal FROM options, cartRowsOptions WHERE options.idOption=cartRowsOptions.idOption AND cartRowsOptions.idCartRow="&pIdCartRow     
  
  call getFromDatabase(mySQL, rsTempCartTotal2, "cartFunctions")  
    
  if rsTempCartTotal2.eof then
   pOptionsTotal=Cdbl(0)   
  else
   if isNull(rsTempCartTotal2("optionsTotal")) then
    pOptionsTotal=Cdbl(0)   
   else
    pOptionsTotal=Cdbl(rsTempCartTotal2("optionsTotal"))
   end if
  end if                
  
  pIdCustomerType     	= getSessionVariable("idCustomerType",1)
  
  if pIdCustomerType=2 and pUnitBtoBPrice>0 then 
   pTotal=pTotal+pQuantity*(pUnitBtoBPrice+pOptionsTotal)
  else
   pTotal=pTotal+pQuantity*(pUnitPrice+pOptionsTotal)   
  end if       
  
  rsTempCartTotal.movenext
 loop   
   
 calculateFreeShippingTotal=pTotal
 
end function

sub calculateCartVolume(pIdDbSessionCart, pMaxLength, pMaxHeight, pSumWidth)
 
 pInterWidth		= getSettingKey("pInterWidth")
 
 dim mySQL, rstemp2  
     
 ' get max length
 mySQL="SELECT MAX(length) AS maxLength FROM cartRows, products WHERE idDbSessionCart="&pIdDbSessionCart& " AND cartRows.idProduct=products.idProduct" 
 
 call getFromDatabase(mySQL, rsTemp2, "cartFunctions")        

 if rstemp2.eof then
  pMaxLength=0
 else    
  if isNull(rstemp2("maxLength")) then
   pMaxLength=0
  else
   pMaxLength=Cdbl(rstemp2("maxLength"))
  end if
 end if     
 
 ' get max height
 mySQL="SELECT MAX(height) AS maxHeight FROM cartRows, products WHERE idDbSessionCart="&pIdDbSessionCart& " AND cartRows.idProduct=products.idProduct" 
 
 call getFromDatabase(mySQL, rsTemp2, "cartFunctions")        

 if rstemp2.eof then
  pMaxHeight=0
 else    
  if isNull(rstemp2("maxHeight")) then
   pMaxHeight=0
  else
   pMaxHeight=Cdbl(rstemp2("maxHeight"))
  end if
 end if     
 
 ' get sum width
 mySQL="SELECT width, quantity FROM cartRows, products WHERE idDbSessionCart="&pIdDbSessionCart& " AND cartRows.idProduct=products.idProduct" 
 
 call getFromDatabase(mySQL, rsTemp2, "cartFunctions")        
 
 pSumWidth=0
    
 ' sum width and sum inter space from settings    
 do while not rstemp2.eof   
   pSumWidth=pSumWidth+(rstemp2("quantity")*rstemp2("width")) + (rstemp2("quantity")*Cdbl(pInterWidth))
   rstemp2.movenext
 loop
 
 'response.write "<br>Max Lenght:"&pMaxLength 
 'response.write "<br>Max Height:"&pMaxHeight
 'response.write "<br>Sum Width:"&pSumWidth
end sub

%>
