<!--#include file='_config.inc'-->
<%
'  submit.asp
'
'  Site submit page
'  hySite version 2006.01.01
'  Copyright (c) 2006 by Dr. Herong Yang, http://www.herongyang.com/

   Dim bgShowForm
   Dim sgError, sgNotice
   Dim sgName, sgURL, sgDesc
   bgShowForm = True

   sgNotice = "Fill in the form to submit a new site. Or go to the <a href=default.asp><b>search page</b></a>."  
%>
<!--#include file='_template.inc'-->
<%
Sub opening
   dbConnect

'  Checking query string and form data

   If Request.Form("submit") = "Submit" Then
      sgName = myTrim(Request.Form("Name"),64)
      sgURL = myTrim(Request.Form("URL"),128)
      sgDesc = myTrim(Request.Form("Desc"),255)

      sgName = removeHTML(sgName)
      sgDesc = removeHTML(sgDesc)

      bOK = True

'     Checking required values
      If bOK Then
         bOK = validateRequiredValue
      End If

'     Checking submit limit
      If bOK Then
         bOK = validateSubmitLimit
      End If

'     Checking to stop re-post
      If bOK Then
         bOK = validateRepost
      End If

'     Submit data
      If bOK Then

'        Inserting the new site      
         sName = Replace(sgName, "'", "''")
         sURL = Replace(sgURL, "'", "''")
         sDesc = Replace(sgDesc, "'", "''")
         sSQL = "INSERT INTO [hyLink] ([Name]," _
            & " [URL]," _
            & " [Desc]," _
            & " [Status]," _ 
            & " [Rank])" _
            & " VALUES ('" & sName & "'" _
            & ", '" & sURL & "'" _ 
            & ", '" & sDesc & "'" _ 
            & ", 0" _
            & ", 100)"
         If bgDebug Then
            ogDebug.WriteLine("sSQL = " & sSQL)
         End If
         ogConn.Execute(sSQL)

'        Inserting the new transaction      
         Set rSelect = Server.CreateObject("ADODB.Recordset")
         sSQL = "SELECT [ID] FROM [hyLink]" _
         & " WHERE [URL] = '" & sURL & "'"
         rSelect.Open sSQL, ogConn
         sID = rSelect.Fields(0)

         sHost = Request.ServerVariables("REMOTE_ADDR")
         sSQL = "INSERT INTO [hyTrans] ([LinkID]," _
            & " [Type]," _
            & " [Date]," _
            & " [Host])" _
            & " VALUES (" & sID _
            & ", 1" _ 
            & ", #" & date() & "#" _
            & ", '" & sHost & "')"
         If bgDebug Then
            ogDebug.WriteLine("sSQL = " & sSQL)
         End If
         ogConn.Execute(sSQL)
         sgNotice = "Your site has been added. Thank you!<br/><br/>" _ 
            & "Use the form below to submit another site.<br/>" _
            & "Go to the <a href=new.asp><b>new site list page</b></a> to see your site.<br/>" _
            & "Go to the <a href=default.asp><b>search page</b></a> to search for other sites."  
         sgName = ""
         sgURL = ""
         sgDesc = ""
      Else
         sgName = Server.HTMLEncode(sgName)
         sgURL = Server.HTMLEncode(sgURL)
         sgDesc = Server.HTMLEncode(sgDesc)
      End If
   End If

End Sub

Function myTrim(sText,nLen)
   myTrim = sText
   If myTrim <> "" Then
      myTrim = Trim(sText)
      If Len(myTrim) > nLen Then
         myTrim = Mid(myTrim, 1, nLen)
      End If
   End If
End Function

Function validateSubmitLimit
   sHost = Request.ServerVariables("REMOTE_ADDR")
   dYesterday = DateAdd("D", -1, DATE())
   Set rSelect = Server.CreateObject("ADODB.Recordset")
   sSQL = "SELECT count(*) FROM [hyTrans]" _
      & " WHERE [Host] = '" & sHost & "'" _ 
      & " AND [Date] > #" & dYesterday & "#"
   rSelect.Open sSQL, ogConn
   If bgDebug Then
      ogDebug.WriteLine(sSQL)
      ogDebug.WriteLine("Count = " & rSelect.Fields(0))
   End If
   If rSelect.Fields(0) < ngSubmitLimit Then
      validateSubmitLimit = True
   Else
      sgError = "You have reached your submission limit." _
         & " Please submit your comment later."
      validateSubmitLimit = False
   End If
   set rSelect = Nothing
End Function

Function validateRequiredValue
   If bgDebug Then
      ogDebug.WriteLine("sgURL = " & sgName)
      ogDebug.WriteLine("sgURL = " & sgURL)
      ogDebug.WriteLine("sgDesc = " & sgDesc)
   End If
   If sgName <> "" AND sgURL <> "" AND sgDesc <> "" Then
      validateRequiredValue = True
   Else
      sgError = "Missing required values." _
         & " Please update the form and submit it again."
      validateRequiredValue = False
   End If
End Function

Function validateRepost
   sURL = Replace(sgURL, "'", "''")
   Set rSelect = Server.CreateObject("ADODB.Recordset")
   sSQL = "SELECT * FROM [hyLink]" _
      & " WHERE [URL] = '" & sURL & "'"
   If bgDebug Then
      ogDebug.WriteLine(sSQL)
   End If

   rSelect.Open sSQL, ogConn
   If rSelect.EOF Then
      validateRepost = True
   Else
      sgError = "Site already exist." _ 
         & " Replease review your submission."
      validateRepost = False
   End If
   set rSelect = Nothing
End Function

Sub outputHeader
   Response.Write("<p class=hy_title>")
   Response.Write(sgPageTitle) 
   Response.Write("</p>")
End Sub

Sub outputBody
   If sgError <> "" Then 
      htmlError(sgError)
      sgError = ""
   End If

   If sgNotice <> "" Then 
      htmlNotice(sgNotice)
      sgNotice = ""
   End If

   If bgShowForm Then 
      htmlForm()
   End If   
End Sub

Sub outputFooter
   ' Do nothing
End Sub

Sub closing
   dbClose
End Sub

Function htmlForm()
   Response.Write("<table class=hysite_submit cellspacing=0" _ 
      & " cellpadding=5>")
   Response.Write("<form action=" _ 
      & Request.ServerVariables("SCRIPT_NAME") & " method=post>")
   Response.Write("<tr><td class=hysite_submit>Site Name:</td>" _ 
      & "<td><input type=text size=40 maxlength=64 name=Name" _
      & " value=""" & sgName & """></td></tr>")
   Response.Write("<tr><td class=hysite_submit>Site URL:</td>" _
      & "<td><input type=text size=60 maxlength=128 name=URL" _
      & " value=""" & sgURL & """></td></tr>")
   Response.Write("<tr><td class=hysite_submit>Site Description:<br/><sup>(< 256 char.)</sup></td>" _
      & "<td><textarea name=Desc cols=45 rows=4 wrap=virtual>" _
      & sgDesc & "</textarea></td></tr>")
   Response.Write("<tr><td></td>" _
      & "<td><input name=submit value=Submit type=submit> (All fields are required.)</td></tr>")
   Response.Write("</form>")
   Response.Write("</table>")
End Function

Function removeHTML(strText)
   Dim RegEx
   Set RegEx = New RegExp
   RegEx.Pattern = "<[^>]*>"
   RegEx.Global = True
   RemoveHTML = RegEx.Replace(strText, "")
End Function

Function htmlNotice(sText)
   Response.Write("<table class=hy_notice cellspacing=0" _
      & " cellpadding=5>")
   Response.Write("<tr><td>" & sText & "</td></tr>")
   Response.Write("</table>")
End Function

Function htmlError(sText)
   Response.Write("<table class=hy_error cellspacing=0" _ 
      & " cellpadding=5>")
   Response.Write("<tr><td>" & sText & "</td></tr>")
   Response.Write("</table>")
End Function
%>