<%	
function StripDegrees(asString)

	'This function removes the degree character from the string found at geocoder.us

	if asString <> "" then

		DegreeReplace = chr(32) &  chr(38) &  chr(100) &  chr(101) &  chr(103) &  chr(59)				
		asString  = replace(asString,DegreeReplace,"")
	
	end if 
	
	StripDegrees = asString

end function

function StripHTML(asHTML)

	'This function removes all HTML from the string found at geocoder.us
	
	if asHTML <> "" then
	
		Set loRegExp = New RegExp
		loRegExp.Global = True
		loRegExp.Pattern = "<[^>]*>"
		asHTML = loRegExp.Replace(asHTML, "")
		
	end if
	
	StripHTML = asHTML
	
End function
	
Function GetBetween(strPage, strPrePat, strPostPat)

	'This is a crude function but it basically returns any string found between a starting
	'and ending point within a string.  Regular Expressions work better...but this works in a bind.
  
  GetBetween = ""
  iStart = InStr(1, strPage, strPrePat)
  If iStart <> 0 Then
    iStart = iStart + Len(strPrePat)
    iEnd = InStr(iStart, strPage, strPostPat)
    If iEnd <> 0 Then
      strIn = Mid(strPage, iStart, iEnd - iStart)
      strOut = ""
      For iStart = 1 To Len(strIn)
        If Mid(strIn, iStart, 1) < " " Then
          strOut = strOut & " " 
        Else
          strOut = strOut & Mid(strIn, iStart, 1)
        End If
      Next
    GetBetween = Trim(strOut)
    End If
  End If
  
End Function

'Primary Google Map Sub

Sub DisplayGoogleMap(GeoAddress,GeoCity,GeoState,GeoZip,MapWidth,MapHeight,ShowInfoWindow,ShowInfoMessage,ShowControls)

	Dim objXmlHttp
	Dim strHTML
	Dim Longitude, Latitude
	
	'String to pass to geocoder.us
	strGetURL = "http://rpc.geocoder.us/demo.cgi?address="&GeoAddress&"+"&GeoCity&"+"&GeoState&"+"&GeoZip
	
	'Using MSXML we are going to get the full HTML page generated by geocoder.us
	Set objXmlHttp = Server.CreateObject("Msxml2.ServerXMLHTTP")
	objXmlHttp.open "GET", strGetURL, False
	objXmlHttp.send
	strHTML = objXmlHttp.responseText
	Set objXmlHttp = Nothing
	
	'Extract the longitude from the page using the GetBetween Function
	Longitude = GetBetween(strHTML, "Longitude</h3></td>", "</td>")
	'Remove any remaining HTML
	Longitude = StripHTML(Longitude)
	'Remove the degrees character
	Longitude = StripDegrees(Longitude)
	
	'Extract the latitude from the page using the GetBetween Function
	Latitude = GetBetween(strHTML, "Latitude</h3></td>", "</td>")
	'Remove any remaining HTML
	Latitude = StripHTML(Latitude)
	'Remove the degrees character
	Latitude = StripDegrees(Latitude)
	
	'Build the Google Map Javascript
	%>
    <div id="map" style="width: <%=MapWidth%>px; height: <%=MapHeight%>px"></div>
    <script type="text/javascript">
    //<![CDATA[
    
    var map = new GMap(document.getElementById("map"));
    map.addControl(new GSmallMapControl());
	map.addControl(new GMapTypeControl());
    map.centerAndZoom(new GPoint(<%=Longitude%>,<%=Latitude%>), 4);
	
	<%if ShowInfoWindow = true then%>
	map.openInfoWindow(map.getCenterLatLng(),document.createTextNode("<%=ShowInfoMessage%>"));	
	<%end if%>
	
	<%if ShowControls = true then%>
	GEvent.addListener(map, 'click', function(overlay, point) {
	  if (overlay) {
		map.removeOverlay(overlay);
	  } else if (point) {
		map.addOverlay(new GMarker(point));
	  }
	});			
    <%end if%>
	
    //]]>
    </script>
	<%
end sub
%>