<%
' tree.asp: Expandable Menu Tree
' Version 1.0
' Copyright (C) 1998 John Watson
'
' E-mail: john@watson-net.com
'
' Get the latest version and full documentation
' at http://www.watson-net.com/
'
' PURPOSE
'
' Contains functions for displaying an expandable menu tree.
'
' INPUTS
'
' See individual function definitions
'
' RETURNS
'
' See individual function definitions
'
' LICENSE
'
' This library is free software; you can redistribute it and/or
' modify it under the terms of the GNU Library General Public
' License as published by the Free Software Foundation; either
' version 2 of the License, or (at your option) any later version.
' 
' This library is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
' Library General Public License for more details.
' 
' You should have received a copy of the GNU Library General Public
' License along with this library; if not, write to the
' Free Software Foundation, Inc., 59 Temple Place - Suite 330,
' Boston, MA  02111-1307, USA.
%>

<%
' Clear the aTree array
sub clearTree()
	redim aTree(0)
	aTree(0) = ""
end sub
%>

<%
' Add an item to the table of contents
'
' sSection is the full section identifier.  This is only
' used internally and is never displayed.  It is used to
' compute the level and indention for each item.
'
' sSection is always in the following format:
'
' a.b. ... .n
'
' e.g.	1		Section 1
'		1.2		Section 1, subsection 2
'		3.4.2	Section 3, subsection 4, sub-subsection 2
'
' Top level sections should not contain a dot.
'
' sSectionTitle is the displayed section.  These can be numbers,
' roman numerals, letters, etc.  They are for display only and
' do not affect the ordering or indention of the items.  This
' can be any valid HTML (e.g. an <IMG> tag).
'
' sTitle is the title of the section.  It is the description for
' the anchor.  This can be any valid HTML (e.g. an <IMG> tag).
'
' sAnchor is the url for the section.  Clicking the title will
' bring you to this url. If the value is blank ("") then the title
' will not be linked. If the value is "DEFAULT" then the title
' will be linked to a page called "<sPrefix><sSection>.<sExtension>".
' Where section is the internal section number and extension
' is the extension appended to the filename (see the showTree()
' function).
'
' e.g.	add_item("1", "A)", "Section A", "a.html", NULL)
'		add_item("1", "A)", "Section A", "a.html", "_top")
'		add_item("1", "A)", "Section A", "", NULL)
'
' sTarget is the target parameter for the anchor.  Set this
' to blank ("") to default to the current window.
sub addItem(sSection, sSectionTitle, sTitle, sAnchor, sTarget)
	dim BRK
	BRK = "||"
	
	aTree(UBOUND(aTree)) = sSection & BRK & sSectionTitle & BRK & sTitle & BRK & sAnchor & BRK & sTarget

	redim preserve aTree(UBOUND(aTree) + 1)
end sub
%>

<%
' sSection is the section to expand.  If sSection = "ALL" then
' all sections are expanded.
'
' sExtension is the extension to append to the default filename
' for each link.  If the default filename is not used then this
' parameter is ignored.
'
' sOpenImage is the image to display next to branches that can be opened.
' sCloseImage is the image to display next to branches that can be closed.
' sBlankImage is an image the same size as sOpenImage and sCloseImage that
'   is used to indent items that have no sub-items.  This is so all items
'   in a tree are left-aligned.
'
' iBaseSize is the size of the largest menu item text.  Valid sizes are 1-7.
'
' bIndent specifies whether you want to indent sub-sections. Sub-sections
' are indented if bIndent is TRUE.
sub showTree(sSection, sPrefix, sExtension, sOpenImage, sCloseImage, sBlankImage, iBaseSize, bIndent)
	dim sThisaItem, iThisLevel, aItem, sNextItem, iNextLevel, aNextItem, sOutput, sLink
	dim sThisSection, aThisSection, aSection
	dim bExpandSection, bExpanded
	dim i, j, k, tmp, tmp2, sIndent, BRK
	dim bIndented
	BRK = "||"

	const ITEM_SECTION = 0
	const ITEM_SECTIONTITLE = 1
	const ITEM_TITLE = 2
	const ITEM_ANCHOR = 3
	const ITEM_TARGET = 4

	' Init variables
	bIndented = FALSE
	
	' Default file name prefix
	if (sPrefix = "" or isnull(sPrefix)) then sPrefix = "body"

	' Default file link extension
	if (sExtension = "" or isnull(sExtension)) then sExtension = "html"

	' Default base font size
	if (iBaseSize = "" or isnull(iBaseSize)) then iBaseSize = 3
	
	' Default indent
	if (bIndent = "" or isnull(bIndent)) then bIndent = TRUE
	
	' Image defaults
	If (sOpenImage = "") then
		sOpenImage = "+"
	else
		sOpenImage = "<IMG SRC=""" & sOpenImage & """ BORDER=0>"
	end if

	If (sCloseImage = "") then
		sCloseImage = "-"
	else
		sCloseImage = "<IMG SRC=""" & sCloseImage & """ BORDER=0>"
	end if
	
	If (sBlankImage = "") then
		sBlankImage = "&nbsp;&nbsp;"
	else
		sBlankImage = "<IMG SRC=""" & sBlankImage & """ BORDER=0>"
	end if
	
	' Loop through each item in the aTree array
	for i = 0 to (ubound(aTree) - 1)
		' Clear output variable
		SOutput = ""
		
		' Get this and next items
		sThisItem = aTree(i)
		if (i < ubound(aTree) - 1) then
			sNextItem = aTree(i+1)
		else
			sNextItem = "NONE"
		end if
		aItem = split(sThisItem, BRK)
		aNextItem = split(sNextItem, BRK)
		
		' Compute levels
		iThisLevel = ubound(split(aItem(ITEM_SECTION), ".")) + 1
		iNextLevel = ubound(split(aNextItem(ITEM_SECTION), ".")) + 1
		
		' Build anchor
		if (aItem(ITEM_ANCHOR) = "DEFAULT") then
			sLink = sPrefix & aItem(ITEM_SECTION) & "." & sExtension
		else
			sLink = aItem(ITEM_ANCHOR)
		end if
		
		' Set section we are currently inside of
		sThisSection = aItem(ITEM_SECTION)
		
		' Check if this section is expanded
		if (ucase(sSection) = "ALL") then
			' Expand all sections
			bExpandSection = TRUE
			bExpanded = TRUE
		else
			' Only expand this section
			bExpandSection = FALSE
			bExpanded = FALSE

			aThisSection = split(sThisSection, ".")
			aSection = split(sSection, ".")
		
			for j = 0 to ubound(aSection)
				tmp = ""
				tmp2 = ""
				if (ubound(aSection) >= j and ubound(aThisSection) = j+1) then
					for k = 0 to j
						tmp = tmp & aSection(k)
						tmp2 = tmp2 & aThisSection(k)
					next
					if (tmp = tmp2) then
						bExpandSection = TRUE
					end if
				end if
			next
		
			' Check if this section needs a + or - sign
			tmp = ""
			for j = 0 to ubound(aSection)
				tmp = tmp & "." & aSection(j)
				if (mid(tmp, 2) = sThisSection) then bExpanded = TRUE
				' mid(tmp, 2) since the above algorithm adds a . as the
				' first character of tmp
			next

			' Add expansion boxes
			if (iNextLevel > iThisLevel) then
				if (not bExpanded) then
					' Link to this section
					sOutput = sOutput & _
						"<A HREF=""" & TREESCRIPT & "?section=" & aItem(ITEM_SECTION) & """>" & _
						sOpenImage & _
						"</A> "
				else
				' Link sCloseImage to parent section
				tmp = ""
				for j = 0 to (ubound(aSection) - ubound(aSection) + iThisLevel - 2)
					tmp = tmp & "." & aSection(j)
					next
					tmp = mid(tmp, 2) ' watch out for the leading dot the above adds
					sOutput = sOutput & _
						"<A HREF=""" & TREESCRIPT & "?section=" & tmp & """>" & _
						sCloseImage & _
						"</A> "
				end if
			else
				sOutput = sOutput & _
					sBlankImage & " "
			end if
		end if
		
		' Add anchor
		if (sLink <> "") then
			tmp = aItem(ITEM_TARGET)
			if (tmp = "") then
				sOutput = sOutput & _
					aItem(ITEM_SECTIONTITLE) & " " & _
					"<A HREF=""" & sLink & """>" & _
					aItem(ITEM_TITLE) & _
					"</A>"
			else
				sOutput = sOutput & _
					aItem(ITEM_SECTIONTITLE) & " " & _
					"<A HREF=""" & sLink & """ TARGET=""" & tmp & """>" & _
					aItem(ITEM_TITLE) & _
					"</A>"
			end if
		else
			sOutput = sOutput & _
				aItem(ITEM_SECTIONTITLE) & " " & aItem(ITEM_TITLE)
		end if
		
		' Add formatting
		select case iThisLevel
			case 1:
				tmp = iBaseSize
				if (tmp <= 0) then tmp = 1
				sOutput = "<FONT SIZE=" & tmp & "><B>" & sOutput & "</B></FONT>"
				
			case 2:
				tmp = iBaseSize
				if (tmp <= 0) then tmp = 1
				sOutput = sOutput
				sOutput = "<FONT SIZE=" & tmp & ">" & sOutput & "</FONT>"
				
			case 3:
				tmp = iBaseSize - 1
				if (tmp <= 0) then tmp = 1
				sOutput = "<FONT SIZE=" & tmp & "><B>" & sOutput & "</B></FONT>"
				
			case 4:
				tmp = iBaseSize - 1
				if (tmp <= 0) then tmp = 1
				sOutput = "<FONT SIZE=" & tmp & ">" & sOutput & "</FONT>"
				
			case 5:
				tmp = iBaseSize - 2
				if (tmp <= 0) then tmp = 1
				sOutput = "<FONT SIZE=" & tmp & "><B>" & sOutput & "</B></FONT>"
				
			case 6:
				tmp = iBaseSize - 2
				if (tmp <= 0) then tmp = 1
				sOutput = "<FONT SIZE=" & tmp & ">" & sOutput & "</FONT>"

			case 7:
				tmp = iBaseSize - 3
				if (tmp <= 0) then tmp = 1
				sOutput = "<FONT SIZE=" & tmp & "><B>" & sOutput & "</B></FONT>"
				
			case 8:
				tmp = iBaseSize - 3
				if (tmp <= 0) then tmp = 1
				sOutput = "<FONT SIZE=" & tmp & ">" & sOutput & "</FONT>"
		end select

		' Draw item
		if (bExpandSection or iThisLevel = 1) then
			response.write sOutput & "<BR>" & vbcrlf
		end if
		
		' Do indent
		if (bIndent) then
			if (iNextLevel > iThisLevel) then
				response.write "<UL>" & vbcrlf
			end if
		
			if (iNextLevel < iThisLevel) then
				if (sNextItem = "NONE") then iNextLevel = iNextLevel + 1
				for j = 1 to (iThisLevel - iNextLevel)
					response.write "</UL>" & vbcrlf
				next
			end if
		end if
		
	next
	
	' Write out last unindent if last item is indented
	if (bIndent and iThisLevel > 1) then response.write "</UL>" & vbcrlf
end sub
%>
