<%@ Page Language="VB" Debug="true" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>
<script language="VB" runat="server">	
	Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)         
        Dim oTree = new obout_ASPTreeView_2_NET.Tree()
        Dim html As String

        ' Populate Treeview.
        oTree.Add("root", "a0", "obout.com", true, Nothing, Nothing)
        oTree.Add("a0", "a0_0", "ASP TreeView", true, Nothing, Nothing)
        oTree.Add("a0", "a0_1", "Fast", true, Nothing, Nothing)
        oTree.Add("a0", "a0_2", "Easy", true, "page.gif", Nothing)

        html = "<span onclick='ob_t23(this)' style='cursor: pointer;' title='my tooltip'>Links & Notes since 1998</span>"

        oTree.Add("root", "a1", html, true, "book.gif", Nothing)
        oTree.Add("a1", "a1_0", "First child", true, Nothing, Nothing)
        oTree.Add("a1_0", "a1_0_0", "This is nr.1", true, Nothing, Nothing)
        oTree.Add("a1_0", "a1_0_1", "This is nr.2", true, Nothing, Nothing)
        oTree.Add("a1_0", "a1_0_2", "This is nr.3", true, Nothing, Nothing)
        oTree.Add("a1_0_2", "a1_0_2_0", "Move me down", true, Nothing, Nothing)
        oTree.Add("a1_0_2", "a1_0_2_1", "Move me up", true, Nothing, Nothing)
        oTree.Add("a1", "a1_1", "Second child", true, Nothing, Nothing)
        oTree.Add("a1", "a1_2", "Third child", true, Nothing, Nothing)

		oTree.FolderStyle = "../TreeIcons/Styles/xpBlue"
		oTree.FolderIcons = "../TreeIcons/Icons"
        ' use the modified ob_mdn_2022.js file - that allows you to reorder nodes using drag and drop
        ' see http://www.obout.com/t2/eMoveNodes.aspx for more details
        oTree.FolderScript = "Script"

        oTree.Width = "200px"        
        oTree.SelectedEnable = true
        oTree.DragAndDropEnable = true

        ' Write treeview to your page.
        TreeView.Text = oTree.HTML()
	End Sub
</script>

<html>
<head>		    
    <span style="color:#666666; font:11px verdana;">
	    <b>Move child nodes under<br />the same parent</b>	    
	    <br /><br />
		<ASP:Literal id="TreeView" runat="server" />
		<br />
		<input type="button" ID="btnMoveUp" value="Move Up" onclick="ob_t2_UpDown('up')" />
		<input type="button" ID="btnMoveDown" value="Move Down" onclick="ob_t2_UpDown('down')" />	    

        <br /><br />
        &nbsp;To move a node up, use : <span style="color:#0033cc;">onclick="ob_t2_UpDown('up')"</span>
	    <br /><br />	    
	    &nbsp;And to move it down: <span style="color:#0033cc;">onclick="ob_t2_UpDown('down')"</span>
	    <br /><br /><br />
	    &nbsp;To re-order the nodes using drag and drop, simply drag and drop a child node<br />
	    &nbsp;over its parent.The dragged child will become the first child of the parent.<br />
	    &nbsp;In order to make this work, the <span style="color:#0033cc;">ob_mdn_xxxx.js</span> located in the <span style="color:#0033cc;">TreeIcons/Script/</span><br />
	    &nbsp;folder must be edited.<br /><br />
	    &nbsp;Open the <span style="color:#0033cc;">ob_mdn_xxxx.js</span> file, and locate the following piece of code:<br />
	    &nbsp;<span style="color:#0033cc;">/*ob_t2_MoveDraggableNode(o_A);*/</span><br /><br />	    
	    &nbsp;1.Uncomment that code fragment<br />
	    &nbsp;2.Comment the next line:<br />
	    &nbsp;<span style="color:#0033cc;">alert("Can not move. The destination is the same as the source.");</span><br />
	    (this is located after the ob_t2_MoveDraggableNode function)    	    
    </span>
</body>
</html>    
    

