<%@ Page Language="C#" ASPCOMPAT="TRUE" Debug="true" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>
<%@ Register TagPrefix="oem" Namespace="OboutInc.EasyMenu_Pro" Assembly="obout_EasyMenu_Pro" %>
<%@ Import Namespace="System.Data.OleDb" %>

<script language="C#" runat="server">         
    void Page_Load(object sender, EventArgs e) {

		obout_ASPTreeView_2_NET.Tree oTree = new obout_ASPTreeView_2_NET.Tree();
		oTree.id = "tree_0";
		string ParentID;
		string attachTo = "";
		string nodeId;

		oTree.FolderIcons = "../TreeIcons/Icons";
		oTree.FolderStyle = "../TreeIcons/Styles/Classic";
		oTree.FolderScript = "../TreeIcons/Script";
		oTree.AddRootNode("Hello, I am Root node!", true, null);

		OleDbConnection myConn = new OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + Server.MapPath("../Database/Demo.mdb"));

		// executing a sql query that will return the records from the database
		OleDbCommand myComm = new OleDbCommand("SELECT id, parent, html, expanded, icon FROM tree ORDER BY parent, id", myConn);
		myConn.Open();
		OleDbDataReader myReader = myComm.ExecuteReader();
		
		// make a loop through all the records and adding the nodes to the treeview
		while (myReader.Read())
		{
			if (myReader.IsDBNull(1))
			{
				ParentID = "root";
			}
			else
			{
				ParentID = "id" + myReader.GetInt32(1);
			}
			oTree.Add(ParentID, nodeId = "id" + myReader.GetInt32(0), myReader.GetString(2), myReader.GetBoolean(3), myReader.GetString(4) + "\" onclick=\"ob_t25(document.getElementById('" + nodeId + "'))", null);
			
			// create a string with all the ids to which we want to attach the easy menu
			attachTo += "id" + myReader.GetInt32(0) + ",";
		}
		oTree.DragAndDropEnable = true;
		TreeView.Text = oTree.HTML();		
		myReader.Close();
		myConn.Close();
		// attaching the easy menu to the ids of the treeview
		EasyMenu1.AttachTo = attachTo;


		obout_ASPTreeView_2_NET.Tree oTree1 = new obout_ASPTreeView_2_NET.Tree();
		attachTo = "";
		oTree1.id = "tree_1";

		oTree1.FolderIcons = "../TreeIcons/Icons";
		oTree1.FolderStyle = "../TreeIcons/Styles/Classic";
		oTree.FolderScript = "../TreeIcons/Script";
		oTree1.AddRootNode("Hello, I am Root node!", null);

		// adding all the nodes manually
		string Html = "<span style='color:#666666; font:bold; cursor:pointer;' onclick='ob_t25(this)'>obout.com<b style='color:crimson; text-decoration:none;'> Home</b></span>";
		oTree1.Add("root", "r1", Html, true, "xpPanel.gif\" onclick=\"ob_t25(document.getElementById('r1'))", null);

		// creating a string with all the ids to which we want to attach the easy menu
		attachTo += "r1,";

		Html = "ASPTreeView";
		oTree1.Add("r1", "a0", Html, true, "Folder.gif\" onclick=\"ob_t25(document.getElementById('a0'))", null);
		attachTo += "a0,";

		oTree1.Add("a0", "a0_0", "Small", null, "ball_glass_redS.gif\" onclick=\"ob_t25(document.getElementById('a0_0'))", null);
		attachTo += "a0_0,";
		oTree1.Add("a0", "a0_1", "Fast", null, "ball_glass_redS.gif\" onclick=\"ob_t25(document.getElementById('a0_1'))", null);
		attachTo += "a0_1,";
		oTree1.Add("a0", "a0_2", "Easy", null, "ball_glass_redS.gif\" onclick=\"ob_t25(document.getElementById('a0_2'))", null);
		attachTo += "a0_2,";

		Html = "More nodes";
		oTree1.Add("r1", "a1", Html, true, "Folder.gif\" onclick=\"ob_t25(document.getElementById('a1'))", null);
		attachTo += "a1,";

		Html = "Different color";
		oTree1.Add("a1", "a1_0", Html, null, "ball_glass_blueS.gif\" onclick=\"ob_t25(document.getElementById('a1_0'))", null);
		attachTo += "a1_0,";

		Html = "Any HTML";
		oTree1.Add("a1", "a1_1", Html, null, "ball_glass_blueS.gif\" onclick=\"ob_t25(document.getElementById('a1_1'))", null);
		attachTo += "a1_1,";

		oTree1.Add("a1", "a1_2", "Select Icons", null, "ball_glass_blueS.gif\" onclick=\"ob_t25(document.getElementById('a1_2'))", null);
		attachTo += "a1_2,";

		Html = "Memobook";
		oTree1.Add("a1", "a1_3", Html, null, "ball_glass_blueS.gif\" onclick=\"ob_t25(document.getElementById('a1_3'))", null);
		attachTo += "a1_3,";

		Html = "Recycle :)";
		oTree1.Add("root", "a2", Html, true, "xpRecycle.gif\" onclick=\"ob_t25(document.getElementById('a2'))", null);
		attachTo += "a2";

		oTree1.DragAndDropEnable = true;
		TreeView2.Text = oTree1.HTML();

		// attaching the easy menu to the ids of the treeview
		EasyMenu2.AttachTo = attachTo;
    }
</script>

<html>
    <head>
<style>
	td {font: 10pt Tahoma; margin: 20px;}
	.title {font-size: X-Large; padding: 20px; border-bottom: 2px solid gray; width: 100%; }
</style>
</head>

<body>
<br />
<br />
<form name="oForm" runat="server">
<table border="0" width="800px">	
	<tr>
		<td valign="top" width="50%">
			The nodes of this ASPTreeView are loaded from a database
			<br /><br />	            			            
            <ASP:Literal id="TreeView" EnableViewState="false" runat="server" />            
		</td>				
		<td valign="top" width="50%">
			The nodes of this ASPTreeView are created by code
			<br /><br />	
		   <asp:Label id="TreeView2" runat="server"></asp:Label>
		</td>			
	</tr>
	<tr>
		<td colspan="2">
			<br /><br />
			Right click on the nodes of the ASPTreeView. An EasyMenu with different options will pop-up.
			<br /><br />
			We need to create a string that contains all the ids of all nodes to which<br />
			we want to attach the EasyMenu ASP.NET control, then set the AttachTo property<br />
			 of the EasyMenu to this string:
		</td>
	</tr>
</table>
<!--
Here are the EasyMenu ASP.NET controls. 
Please note that there is not AttachTo 
property added since this is done from the code above
-->
<oem:EasyMenu id="EasyMenu1" ScriptPath="../emstyles/script" StyleFolder="../emstyles/styles/" runat="server" Width="150">
    <COMPONENTS>
        <oem:MenuItem id="menuItem3" OnClientClick="try {alert(targetEl.innerHTML);} catch (e) {}" InnerHtml="Show Node's HTML"></oem:MenuItem>
        <oem:MenuItem id="menuItem2" OnClientClick="try {targetEl.parentNode.firstChild.firstChild.onclick();} catch (e) {}"
            InnerHtml="Expand/Collapse Node"></oem:MenuItem>
    </COMPONENTS>
</oem:EasyMenu>
<oem:EasyMenu id="EasyMenu2" ScriptPath="../emstyles/script" StyleFolder="../emstyles/styles/" runat="server" Width="150">
    <COMPONENTS>
        <oem:MenuItem id="menuItem5" OnClientClick="try {alert(targetEl.innerHTML);} catch (e) {}" InnerHtml="Show Node's HTML"></oem:MenuItem>
        <oem:MenuItem id="menuItem6" OnClientClick="try {targetEl.parentNode.firstChild.firstChild.onclick();} catch (e) {}"
            InnerHtml="Expand/Collapse Node"></oem:MenuItem>
    </COMPONENTS>
</oem:EasyMenu>
<br>
</form>
</body>
</html>