<%@ Page Language="C#" ASPCOMPAT="TRUE" Debug="true"%>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>

<script language="C#" runat="server">
	obout_ASPTreeView_2_NET.Tree oTree = new obout_ASPTreeView_2_NET.Tree();

	void Page_Load(object sender, EventArgs e) {
		string relativePath;
		
		oTree.FolderIcons = "TreeIcons/Icons";
		oTree.FolderStyle = "TreeIcons/Styles/Win2003";
		oTree.FolderScript = "TreeIcons/Script";
		oTree.ShowIcons = true;
		oTree.AddRootNode("Folder name here. Root is optional.", true, "book.gif");
		
		relativePath = "";                // Show current Folder

		CreateNodes (relativePath, "root");
			
		TreeView.Text = oTree.HTML();
	}
	
	void CreateNodes (string relativePath, string sID){
		string hddPath = MapPath(relativePath);
		string[] listFiles =  Directory.GetFiles(hddPath);
		string[] listDirectories = Directory.GetDirectories(hddPath);
		string sPath;
		string SubTreeUrl;
		
		// Display Subfolders.
		for (int i=0; i<listDirectories.Length; i++){
			sPath = Path.GetFullPath(listDirectories[i]);
            SubTreeUrl = "FileSystemSub.aspx?path=" + Server.UrlEncode(sPath).Replace("'", "\\'") + "&length=" + hddPath.Length;

			// Last parameter SubTreeUrl added to load dynamically from FileSystemSub.asp.
			oTree.Add (sID, sID+(i+1), "<span onclick='ob_t23(this)'>" + Path.GetFileName(listDirectories[i]) + "</span>", false, null, SubTreeUrl);
			sPath = relativePath + Path.GetFileName(listDirectories[i]) + "/";
			//CreateNodes (sPath, sID + (i+1));
		}
		// Display Files.
		for (int i=0; i<listFiles.Length; i++){
			sPath = HttpUtility.UrlPathEncode(relativePath + Path.GetFileName(listFiles[i]));
			sPath = "<a href='"+ sPath +"'>"+ Path.GetFileName(listFiles[i]) +"</a>";
			oTree.Add (sID, sID+(i+1), sPath, null, "page.gif", null);
		}
	}

</script>

<html>
<body>
<p style="color:#666666; font:11px verdana;">
	Put 2 files <b>FileSystemBIG.aspx</b> (main page)<br>
	and <b>FileSystemSub.aspx</b> (sub folders) to any web folder.<br>
	They will show content of the folder. Feel free to modify the example code.<br>
	<br>
	Folders are populated dynamically using <b>FileSystemSub.aspx</b><br>
	Use these examples for large number of files/folders.
</P>
		<ASP:Literal id="TreeView" EnableViewState="false" runat="server" />
</body>
</html>