<%@ Page Language="C#" ASPCOMPAT="TRUE" Debug="true"%>
<%@ Import Namespace="System" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Web" %>
<%@ Import Namespace="System.Web.UI" %>
<%@ Import Namespace="System.Web.UI.WebControls" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>

<script language="C#" runat="server">
	obout_ASPTreeView_2_NET.Tree oTree = new obout_ASPTreeView_2_NET.Tree();

	void Page_Load(object sender, EventArgs e) {
		string relativePath;
		
		oTree.FolderIcons = "TreeIcons/Icons";
		oTree.FolderScript = "TreeIcons/Script";
		oTree.FolderStyle = "TreeIcons/Styles/Win2003";
		oTree.ShowIcons = true;
		oTree.AddRootNode("Folder name here. Root is optional.", true, "book.gif");
		
		relativePath = "";                // Show current Folder
		//relativePath = "codebehind/";   // Show Folder one level below
		//relativePath = "../";           // Show Folder one level up

		CreateNodes (relativePath, "root");
			
		TreeView.Text = oTree.HTML();
	}
	
	void CreateNodes (string relativePath, string sID){
		string hddPath = MapPath(relativePath);
		string[] listFiles =  Directory.GetFiles(hddPath);
		string[] listDirectories = Directory.GetDirectories(hddPath);
		string sPath;
		
		// Display Subfolders.
		for (int i=0; i<listDirectories.Length; i++){
			oTree.Add (sID, sID+"_"+(i+1), Path.GetFileName(listDirectories[i]), false, null, null);
			sPath = relativePath + Path.GetFileName(listDirectories[i]) + "/";
			CreateNodes (sPath, sID+"_"+(i+1));
		}
		// Display Files.
		for (int i=0; i<listFiles.Length; i++){
			sPath = HttpUtility.UrlPathEncode(relativePath + Path.GetFileName(listFiles[i]));
			oTree.Add (sID, sID+"_"+(i+1), "<a href='"+ sPath +"'>"+ Path.GetFileName(listFiles[i]) +"</a>", null, "page.gif", null);
		}
	}

</script>

<html>
<body>
<p style="color:#666666; font:11px verdana;">
	Put this file <b>FileSystem.aspx</b> to any web folder.<br>
	It will show content of the folder. Feel free to modify the example code.
</P>
		<ASP:Literal id="TreeView" EnableViewState="false" runat="server" />
</body>
</html>