<%@ Page Language="C#" ASPCOMPAT="TRUE" Debug="true" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>
<%@ Import Namespace="System.Data.OleDb" %>

<script language="C#" runat="server">         
    void Page_Load(object sender, EventArgs e) {        
        
        obout_ASPTreeView_2_NET.Tree oTree = new obout_ASPTreeView_2_NET.Tree();

        OleDbConnection oConn = new OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + Server.MapPath("../Database/categories.mdb"));
        oConn.Open();

        // get all the categories from the database
        string sQuery = "SELECT CategoryID, ParentID, CategoryText, Description, DateAdded, PriceRange, [Level], Icon FROM Categories ORDER BY [Level] ASC";
        OleDbCommand oCommand = new OleDbCommand(sQuery);
        oCommand.Connection = oConn;
        OleDbDataReader oReader = oCommand.ExecuteReader();

        string sHtml, sCategoryId, sParentId, sCategoryText, sDescription, sPriceRange, sIcon;
        int iLevel, iAddWidth;
        DateTime sDateAdded;

		oTree.AddRootNode("Categories", true, "Folder.gif");

        // add the categories in the tree
        while (oReader.Read())
        {
            sCategoryId = oReader.GetInt32(0).ToString();
            sParentId = oReader.GetInt32(1).ToString();
            sCategoryText = oReader.GetString(2);
            sDescription = oReader.GetString(3);
            sDateAdded = oReader.GetDateTime(4);
            sPriceRange = oReader.GetString(5);
            iLevel = oReader.GetInt32(6);
            sIcon = oReader.GetString(7);

            oTree.Add(sParentId != "0" ? "oCateg_" + sParentId : "root", "oCateg_" + sCategoryId, "oCateg_" + sCategoryId, 1, sIcon, null);
        }        
        oConn.Close();

        oTree.FolderStyle = "../TreeIcons/Styles/Classic";
        oTree.FolderIcons = "../TreeIcons/Icons";
        oTree.FolderScript = "../TreeIcons/Script";
        
                
        oTree.SelectedEnable = true;
        oTree.DragAndDropEnable = true;        
        oTree.SelectedId = "oCateg_13";
        oTree.Width = "250px";
        
        TreeView.Text = oTree.HTML();
    }
</script>

<html>
    <head>
<script type="text/javascript">
var arr_ob_t2_IndexedNodes = null, arr_ob_t2_NodesParents = null, arr_ob_t2_NodesLevels = null;
function ob_t2_ExpandCollapseLevel(iLevel, bType)
{
    // the first time the function is executed
    // the levels of the nodes must be calculated
    if(arr_ob_t2_NodesLevels == null)
    {
        arr_ob_t2_IndexedNodes = new Array();    
        arr_ob_t2_NodesParents = new Array();
        arr_ob_t2_NodesLevels = new Array();
          
        var oTempNode = ob_getFirstNodeOfTree();    
        var oTempParent = null;
        var i=0;
        while(oTempNode != null)
        {                  
            arr_ob_t2_IndexedNodes[i] = oTempNode.id;
        
            oTempParent = ob_getParentOfNode(oTempNode);        
            if(oTempParent)
            {
                arr_ob_t2_NodesParents[oTempNode.id] = oTempParent.id;
            }                 	    
 	        oTempNode = ob_getNodeDown(oTempNode, true); 	
 	        i++;      	           
        }
        
        for(i=0; i<arr_ob_t2_IndexedNodes.length; i++)
        {
            var iTempLevel = 0;
            var sTempParent = arr_ob_t2_NodesParents[arr_ob_t2_IndexedNodes[i]];
            while(sTempParent != null)
            {
                iTempLevel++;
                sTempParent = arr_ob_t2_NodesParents[sTempParent];
            }
            arr_ob_t2_NodesLevels[arr_ob_t2_IndexedNodes[i]] = iTempLevel;            
        }    
    }
    
    for(var i=0; i<arr_ob_t2_IndexedNodes.length; i++)
    {
        if(arr_ob_t2_NodesLevels[arr_ob_t2_IndexedNodes[i]] == iLevel)
        {
            oImg = document.getElementById(arr_ob_t2_IndexedNodes[i]).parentNode.firstChild.firstChild;
            var lensrc = (oImg.src.length - 8);
		    var s = oImg.src.substr(lensrc, 8);
            if (bType == true) 
            {
			    if ((s == "usik.gif") || (s == "ik_l.gif")) 
			    {
				    oImg.onclick();
				    //ob_t21(oImg, null);
			    }		       
		    }
		    else if ((s == "inus.gif") || (s == "us_l.gif")) 
			{
				oImg.onclick();
				//ob_t21(oImg, null);
			}
        }
    }
    
}
</script>
<style>
	td {font: 10pt Tahoma; margin: 20px;}
	.title {font-size: X-Large; padding: 20px; border-bottom: 2px solid gray; width: 100%; }
</style>
</head>

<body>
<br />
<br />
<table border="0">
	<tr><td valign="top" width="230px">
		Click on the buttons to expand/collapse the levels of the ASPTreeView
	</td><td class="tdText" style="color:#0033cc;">	 		    
	</td></td>
</table>
<br />
<form name="oForm" runat="server">
<table border="0">	
	<tr>
		<td valign="top">	            			            
            <ASP:Literal id="TreeView" EnableViewState="false" runat="server" />            
		</td>				
		<td valign="top">	
		    <table border="0">
		        <tr>
		            <td align="center"><input type="button" value="Collapse level 1" onclick="ob_t2_ExpandCollapseLevel(1, false)" id="btnCollapseLevel1" /></td>
		            <td align="center"><input type="button" value="Collapse level 2" onclick="ob_t2_ExpandCollapseLevel(2, false)" id="btnCollapseLevel2" /></td>
		            <td align="center"><input type="button" value="Collapse level 3" onclick="ob_t2_ExpandCollapseLevel(3, false)" id="btnCollapseLevel3" /></td>
		        </tr>		    
                <tr>
                    <td align="center"><input type="button" value="Expand level 1" onclick="ob_t2_ExpandCollapseLevel(1, true)" id="btnExpandLevel1" /></td>
                    <td align="center"><input type="button" value="Expand level 2" onclick="ob_t2_ExpandCollapseLevel(2, true)" id="btnExpandLevel2" /></td>
                    <td align="center"><input type="button" value="Expand level 3" onclick="ob_t2_ExpandCollapseLevel(3, true)" id="btnExpandLevel3" /></td>
                </tr>
                <tr>
                    <td colspan="3">
                        <br /><br />
                        The expand/collapse feature will work even if you change <br />
                        the level of the nodes (using drag and drop).   
                    </td>
                </tr>               
            </table>
		</td>			
	</tr>
</table>
<br>
</form>

<script type="text/javascript">
function ob_getFirstNodeOfTree ()
{
	try
	{	    
		tree_div = document.getElementById(ob_tree_id);
		if (tree_div != null)
		{		    
			rootNode = tree_div.childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[2];
			if(rootNode == null)			
			{
			    
			    rootNode = tree_div.childNodes[0].childNodes[1].childNodes[0].childNodes[0].childNodes[0].childNodes[2];
			}			
			if (rootNode != null) return rootNode;
		}
	}
	catch (e)
	{
	}
}

function ob_OnNodeDrop(src, dst)
{
    // if drag and drop takes place, the levels of the nodes must be recalculated
    arr_ob_t2_NodesLevels = null;
}
</script>
</body>
</html>