<%@ Page Language="VB" ASPCOMPAT="TRUE" Debug="true"%>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>

<!-- For sub tree do NOT put any HTML tags above and below code -->

<script language="VB" runat="server">
	Dim oTree As New obout_ASPTreeView_2_NET.Tree()
	Dim iLength As Integer
	
	Public Sub Page_Load(sender As object, e As EventArgs)
		Dim relativePath As String
		
		' These 3 lines prevent from browser caching. They are optional.
		' Useful when your data changes frequently. 
		Response.AddHeader("pragma","no-cache")
		Response.AddHeader("cache-control","private")
		Response.CacheControl = "no-cache"

		oTree.FolderIcons = "/TreeIcons/Icons"
		oTree.FolderStyle = "/TreeIcons/Styles/Win2003"
		oTree.FolderScript = "/TreeIcons/Script"
		
		oTree.ShowIcons = true
		oTree.AddRootNode("Folder name here. Root is optional.", True, "book.gif")
		
		' For non-English characters. See MSDN for your language settings. 
		'Response.CodePage = 1252
		Response.CharSet = "windows-1252"

		' IMPORTANT:  For loaded SubTree set to TRUE.
		oTree.SubTree = true
		
		iLength = Request.QueryString("length")
		If iLength = 0 Then
			Response.Write("This file works with <b>FileSystemBig.aspx</b>")
			Response.End
		End If
		relativePath = Replace(Mid(Request.QueryString("path"), iLength + 2), "\", "/") & "/"

		CreateNodes(relativePath, "root")
			
		Response.Write(oTree.HTML())
	End Sub
	
	Sub CreateNodes (relativePath As String, sID As String)
		Dim sPath As String
		Dim s As String
		Dim i As Integer
		Dim hddPath As String = Server.MapPath(relativePath)
		Dim SubTreeUrl As String
		
		' Display Subfolders.
		For Each s In Directory.GetDirectories(hddPath)
			i = i + 1
			sPath = Path.GetFullPath(s)
			
			' Populate folders dynamically on expand.
            SubTreeUrl = "FileSystemSub.aspx?path=" & Server.UrlEncode(Path.GetFullPath(s)).Replace("'", "\'") & "&length=" & iLength
			oTree.Add(sID, sID & i, "<span onclick='ob_t23(this)'>" & Path.GetFileName(s) & "</span>", false, , SubTreeUrl)
		Next

		' Display Files.
		For Each s In Directory.GetFiles(hddPath)
			i = i + 1
			sPath = HttpUtility.UrlPathEncode(relativePath & Path.GetFileName(s))
			sPath = "<a href='" & sPath & "'>" & Path.GetFileName(s) & "</a>"
			oTree.Add(sID, sID & i, sPath, , "page.gif")
		Next
	End Sub

</script>

<!-- For sub tree do NOT put any HTML tags above and below code -->
