<%@ Page Language="VB" ASPCOMPAT="TRUE" Debug="true"%>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>

<script language="VB" runat="server">
	Dim oTree As New obout_ASPTreeView_2_NET.Tree()
	
	Public Sub Page_Load(sender As object, e As EventArgs)
		Dim relativePath As String
		
		oTree.FolderIcons = "/TreeIcons/Icons"
		oTree.FolderStyle = "/TreeIcons/Styles/Win2003"
		oTree.FolderScript = "/TreeIcons/Script"

		oTree.ShowIcons = true
		oTree.AddRootNode("Folder name here. Root is optional.", True, "book.gif")
		
		relativePath = ""               ' Show current Folder
		CreateNodes(relativePath, "root")
			
		TreeView.Text = oTree.HTML()
	End Sub
	
	Sub CreateNodes (relativePath As String, sID As String)
		Dim sPath As String
		Dim s As String
		Dim i As Integer
		Dim hddPath As String = Server.MapPath(relativePath)
		Dim SubTreeUrl As String
		
		' Display Subfolders.
		For Each s In Directory.GetDirectories(hddPath)
			i = i + 1
			sPath = Path.GetFullPath(s)
            SubTreeUrl = "FileSystemSub.aspx?path=" & Server.UrlEncode(sPath).Replace("'", "\'") & "&length=" & Len(hddPath)

			' Last parameter SubTreeUrl added to load dynamically from FileSystemSub.asp.
			oTree.Add(sID, sID & i, "<span onclick='ob_t23(this)'>" & Path.GetFileName(s) & "</span>", false, , SubTreeUrl)
		Next

		' Display Files.
		For Each s In Directory.GetFiles(hddPath)
			i = i + 1
			sPath = HttpUtility.UrlPathEncode(relativePath & Path.GetFileName(s))
			sPath = "<a href='" & sPath & "'>" & Path.GetFileName(s) & "</a>"
			oTree.Add(sID, sID & i, sPath, , "page.gif")
		Next
	End Sub

</script>

<html>
<body>
<p style="color:#666666; font:11px verdana;">
	Put 2 files <b>FileSystemBIG.aspx</b> (main page)<br>
	and <b>FileSystemSub.aspx</b> (sub folders) to any web folder.<br>
	They will show content of the folder. Feel free to modify the example code.<br>
	<br>
	Folders are populated dynamically using <b>FileSystemSub.aspx</b><br>
	Use these examples for large number of files/folders.
</P>
		<ASP:Literal id="TreeView" EnableViewState="false" runat="server" />
</body>
</html>