﻿<%@ Page Language="VB" Debug="true" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>
<%@ Import Namespace="System.Data.OleDb" %>

<script type="text/VB" runat="server">
    Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)    
		Dim oTree = new obout_ASPTreeView_2_NET.Tree()
        
		Dim oConn = New OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + Server.MapPath("../Database/categories.mdb"))
        oConn.Open()       

        ' get all the categories from the database
        Dim sQuery As String 
        sQuery = "SELECT CategoryID, ParentID, CategoryText, Description, DateAdded, PriceRange, [Level], Icon FROM Categories ORDER BY [Level] ASC"
        Dim oCommand As OleDbCommand 
        oCommand = new OleDbCommand(sQuery)
        oCommand.Connection = oConn
        Dim oReader As OleDbDataReader 
        oReader = oCommand.ExecuteReader()

        Dim sHtml, sCategoryId, sParentId, sCategoryText, sDescription, sPriceRange, sIcon As String
        Dim iLevel, iAddWidth As Integer
        Dim sDateAdded As DateTime
        Dim sNewParentId As String

        ' adding the root node
        sHtml = "<table cellspacing='0' cellpadding='0' border='0'><tr><td class='ob_header' style='width: 203px'>Category Name</td><td class='ob_header' style='width:200px;'>Description</td><td class='ob_header' style='width:100px;' align='left'>Date Created</td><td class='ob_header' align='left'>Price Range</td></tr></table>"
		oTree.AddRootNode(sHtml, True, "Folder.gif")

        ' add the categories in the tree
        While (oReader.Read())        
            sCategoryId = oReader.GetInt32(0).ToString()
            sParentId = oReader.GetInt32(1).ToString()
            sCategoryText = oReader.GetString(2)
            sDescription = oReader.GetString(3)
            sDateAdded = oReader.GetDateTime(4)
            sPriceRange = oReader.GetString(5)
            iLevel = oReader.GetInt32(6)
            sIcon = oReader.GetString(7)

            ' calculate the width of the first column from the table
            iAddWidth = 200 - (iLevel * 15)

            ' create the html of the nodes - this will be a table, 
            ' having the width of the first column calculated according to the level of the nodes
            sHtml = "<table cellspacing='0' cellpadding='0' border='0'><tr><td class='ob_column' style='width: " + iAddWidth.ToString() + "px'>" + sCategoryText + "</td><td class='ob_column' style='width:200px;'>" + sDescription + "</td><td class='ob_column' style='width:100px;' align='left'>" + sDateAdded.ToShortDateString() + "</td><td class='ob_column' align='left'>" + sPriceRange + "</td></tr></table>"
            
            If sParentId <> "0" Then
                sNewParentId = "oCateg_" + sParentId
            Else
                sNewParentId = "root"
            End If

            oTree.Add(sNewParentId, "oCateg_" + sCategoryId, sHtml, 1, sIcon, Nothing)          
        End While
        oConn.Close()        
		
		oTree.FolderStyle = "/TreeIcons/Styles/win2003"
        oTree.FolderIcons = "/TreeIcons/Icons"
        oTree.FolderScript = "/TreeIcons/Script"

		oTree.Width = "700px"
		oTree.SelectedEnable = true
        oTree.DragAndDropEnable = true
        oTree.SelectedId = "oCateg_2"

		' Write treeview to your page.
		TreeView.Text = oTree.HTML()
    End Sub
</script>

<html>
<head>
    <title>obout.com - ASPTreeview 2</title>     
    <style type="text/css">
        /*the css styles needed for the columns from the nodes*/
        td.ob_column {	        
	        color:navy;
	        FONT: 8pt Tahoma; 
	        vertical-align:middle; 
	        border-bottom: 1px solid #cccccc
        }
        td.ob_header {	        
	        color:navy;
	        FONT: 9pt Tahoma; 
	        font-weight: bold;
	        vertical-align:middle; 
	        border-bottom: 1px solid #cccccc
        }
    </style>   
</head>
<body>
    <form name="myform" runat="server">
         <span style="color:#666666; font:11px verdana;">
		<b>ASPTreeView with aligned columns in the nodes</b>
	    </span>
	    <br /><br />
		<ASP:Literal id="TreeView" EnableViewState="false" runat="server" />			
		<br />  	
		<span style="color:#666666; font:11px verdana;">
            The html for each node is a table, that has the width of the first column<br />
            calculated according to the level of the node:<br /><br />
            <span style="background:#eeeeee;">
            iAddWidth = 200 - (iLevel * 15);<br /><br />
            sHtml = "&lt;table cellspacing='0' cellpadding='0' border='0'&gt;&lt;tr&gt;<br />
            &lt;td class='ob_column' style='width: " + iAddWidth.ToString() + "px'&gt;" + sCategoryText + "&lt;/td&gt;<br />
            &lt;td class='ob_column' style='width:200px;'&gt;" + sDescription + "&lt;/td&gt;<br />
            &lt;td class='ob_column' style='width:100px;' align='left'&gt;" + sDateAdded.ToShortDateString() + "&lt;/td&gt;<br />
            &lt;td class='ob_column' align='left'&gt;" + sPriceRange + "&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;";
            </span>
        </span>
		<br />
		<br />
		<span style="color:#666666; font:11px verdana;">
		Also, you have to declare 2 CSS classes, that are used for the columns:
		<pre style="background:#eeeeee; width:400px;">		        
        td.ob_column {	        
	        color:navy;
	        FONT: 8pt Tahoma; 
	        vertical-align:middle; 
	        border-bottom: 1px solid #cccccc
        }
        td.ob_header {	        
	        color:navy;
	        FONT: 9pt Tahoma; 
	        font-weight: bold;
	        vertical-align:middle; 
	        border-bottom: 1px solid #cccccc
        }   
		</pre>
		</span>	
	</form>
</body>
</html>