<%@ Page Language="C#" ASPCOMPAT="TRUE" Debug="true"%>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>

<!-- For sub tree do NOT put any HTML tags above and below code -->

<script language="C#" runat="server">
	obout_ASPTreeView_2_NET.Tree oTree = new obout_ASPTreeView_2_NET.Tree();
	int iLength;

	void Page_Load(object sender, EventArgs e) {
		string relativePath;
		
		// These 3 lines prevent from browser caching. They are optional.
		// Useful when your data changes frequently. 
		Response.AddHeader("pragma","no-cache");
		Response.AddHeader("cache-control","private");
		Response.CacheControl = "no-cache";
		
		// For non-English characters. See MSDN for your language settings. 
		//Response.CodePage = 1252;
		//Response.CharSet = "windows-1252";

		// IMPORTANT:  For loaded SubTree set to TRUE.
		oTree.SubTree = true;
		oTree.FolderIcons = "/TreeIcons/Icons";
		oTree.FolderStyle = "/TreeIcons/Styles/Win2003";
		oTree.FolderScript = "/TreeIcons/Script";
		oTree.ShowIcons = true;
		oTree.AddRootNode("Folder name here. Root is optional.", true, "book.gif");
		
		if (Request.QueryString["length"]==null) {
			Response.Write("This file works with <b>FileSystemBig.aspx</b>");
			Response.End();
		}
		else {
			iLength = Convert.ToInt32(Request.QueryString["length"]);			
		}
		relativePath = Request.QueryString["path"];
		relativePath = relativePath.Remove(0, iLength + 1);
		relativePath = relativePath.Replace("\\", "/") + "/";

		CreateNodes (relativePath, "root");
		Response.Write(oTree.HTML());
	}
	
	void CreateNodes (string relativePath, string sID){
		string hddPath = MapPath(relativePath);
		string[] listFiles =  Directory.GetFiles(hddPath);
		string[] listDirectories = Directory.GetDirectories(hddPath);
		string sPath;
		string SubTreeUrl;
		
		// Display Subfolders.
		for (int i=0; i<listDirectories.Length; i++){
			sPath = Path.GetFullPath(listDirectories[i]);
			
			// Populate folders dynamically on expand.
            SubTreeUrl = "FileSystemSub.aspx?path=" + Server.UrlEncode(Path.GetFullPath(listDirectories[i])).Replace("'", "\\'") + "&length=" + iLength;
			oTree.Add (sID, sID+(i+1), "<span onclick='ob_t23(this)'>" + Path.GetFileName(listDirectories[i]) + "</span>", false, null, SubTreeUrl);
		}
		// Display Files.
		for (int i=0; i<listFiles.Length; i++){
			sPath = HttpUtility.UrlPathEncode(relativePath + Path.GetFileName(listFiles[i]));
			oTree.Add (sID, sID+(i+1), "<a href='"+ sPath +"'>"+ Path.GetFileName(listFiles[i]) +"</a>", null, "page.gif", null);
		}
	}

</script>

<!-- For sub tree do NOT put any HTML tags above and below code -->
