<%@ Page Language="C#" ASPCOMPAT="TRUE" Debug="true" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>
<%@ Register TagPrefix="obout" Namespace="OboutInc.Postback4" Assembly="obout_Postback4" %> 
<script type="text/C#" runat="server">
void Page_Load(object sender, EventArgs e)
{	
	obout_ASPTreeView_2_NET.Tree oTree = new obout_ASPTreeView_2_NET.Tree();	
    
    string html;

	oTree.AddRootNode("I'm the root node", true, "Folder.gif");
    oTree.Add("root", "a0", "obout.com", true, "Folder.gif", null);
    oTree.Add("a0", "a0_0", "ASP TreeView", false, "Folder.gif", null);
    oTree.Add("a0", "a0_1", "Fast", false, "Folder.gif", null);
    oTree.Add("a0", "a0_2", "Easy", false, "Folder.gif", null);

    html = "<span onclick='ob_t23(this)' style='cursor: pointer;' title='my tooltip'>Links & Notes since 1998</span>";

    oTree.Add("root", "a1", html, true, "Folder.gif", null);
    oTree.Add("a1", "a1_0", "First child", false, "Folder.gif", null);
    oTree.Add("a1_0", "a1_0_0", "This is nr1", false, "Folder.gif", null);
    oTree.Add("a1_0", "a1_0_1", "This is nr2", false, "Folder.gif", null);
    oTree.Add("a1_0", "a1_0_2", "This is nr3", false, "Folder.gif", null);
    oTree.Add("a1_0_2", "a1_0_2_0", "Last one", false, "Folder.gif", null);
    oTree.Add("a1_0_2", "a1_0_2_1", "Final one", false, "Folder.gif", null);
    oTree.Add("a1", "a1_1", "Second child", false, "Folder.gif", null);
    oTree.Add("a1", "a1_2", "Third child", false, "Folder.gif", null); 
	
	oTree.FolderIcons = "/TreeIcons/Icons";
	oTree.FolderScript = "/TreeIcons/Script";
	oTree.FolderStyle = "/TreeIcons/Styles/Classic";
    
    // Enabling the events
    oTree.EventList = "OnNodeExpand,OnNodeCollapse";	    
	
	TreeView.Text = oTree.HTML();
}
</script>
<html>
<head>
<title>obout.com - ASPTreeview 2</title>
</head>
<body>
<ASP:Literal id="TreeView" EnableViewState="false" runat="server" />
<obout:Postback4 ID="Postback4_1" runat="server" />
<br />
<p style="color:#666666; font:11px verdana;">
<b>This example demonstrate how to use the OnNodeExpand and OnNodeCollapse events.</b>
<br /><br />
The OnNodeExpand event is triggered when a node is expanded,<br />
and the OnNodeCollapse event is executed when a node is collapsed.
<br /><br />
The events are available:<br />
- on client side - you can execute a javascript action when a node is expanded/collapsed<br />
- on the server side - you can make a server-side processing (for example to update a database)
<br /><br /><br />
You can read more about the events of the ASPTreeView <a href="http://www.obout.com/t2/eServerSideEvents.aspx">here</a>
<br /><br />
<a href="http://www.obout.com/t_db/tutorial_1.aspx">Here</a> you'll find a nice tutorial about how to use the server-side events to update<br />
a database (using 3 of obout's components: ASPTreeView, Postback4 and TreeDB)
</p>
</body>
</html>
<script type="text/javascript">
// implement the OnNodeExpand event
function ob_OnNodeExpand(id)
{
    // add client side code here
	//alert("OnNodeExpand on " + id);			
	
    if(ob_ev("OnNodeExpand"))
	{
	    if(typeof ob_post == "object")
	    {
	        // add the parameter needed on server-side
	        ob_post.AddParam("id", id);	        
	        // send the data to the server and display the message returned from the server
	        alert(ob_post.post("process_expand_collapse.aspx", "OnNodeExpand"));
	    }
	    else
	    {
	        alert("Please add obout_Postback control to your page to use the server-side events");
	    }
	}		
}


// implement the OnNodeCollapse event
function ob_OnNodeCollapse(id)
{
    // add client side code here
	//alert("OnNodeCollapse on " + id);			
	
    if(ob_ev("OnNodeCollapse"))
	{
	    if(typeof ob_post == "object")
	    {
	        // add the parameter needed on server-side
	        ob_post.AddParam("id", id);	        
	        // send the data to the server and display the message returned from the server
	        alert(ob_post.post("process_expand_collapse.aspx", "OnNodeCollapse"));
	    }
	    else
	    {
	        alert("Please add obout_Postback control to your page to use the server-side events");
	    }
	}		
}
</script>
