<%@ Page Language="C#" ASPCOMPAT="TRUE" Debug="true" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>
<%@ Register TagPrefix="obout" Namespace="OboutInc.Postback4" Assembly="obout_Postback4" %> 
<script type="text/C#" runat="server">
void Page_Load(object sender, EventArgs e)
{	
	obout_ASPTreeView_2_NET.Tree oTree = new obout_ASPTreeView_2_NET.Tree();	
    
    string html;

	oTree.AddRootNode("I'm the root node", true, "Folder.gif");
    oTree.Add("root", "a0", "obout.com", true, "Folder.gif", null);
    oTree.Add("a0", "a0_0", "ASP TreeView", false, "Folder.gif", null);
    oTree.Add("a0", "a0_1", "Fast", false, "Folder.gif", null);
    oTree.Add("a0", "a0_2", "Easy", false, "Folder.gif", null);

    html = "<span onclick='ob_t23(this)' style='cursor: pointer;' title='my tooltip'>Links & Notes since 1998</span>";

    oTree.Add("root", "a1", html, true, "Folder.gif", null);
    oTree.Add("a1", "a1_0", "First child", false, "Folder.gif", null);
    oTree.Add("a1_0", "a1_0_0", "This is nr1", false, "Folder.gif", null);
    oTree.Add("a1_0", "a1_0_1", "This is nr2", false, "Folder.gif", null);
    oTree.Add("a1_0", "a1_0_2", "This is nr3", false, "Folder.gif", null);
    oTree.Add("a1_0_2", "a1_0_2_0", "Last one", false, "Folder.gif", null);
    oTree.Add("a1_0_2", "a1_0_2_1", "Final one", false, "Folder.gif", null);
    oTree.Add("a1", "a1_1", "Second child", false, "Folder.gif", null);
    oTree.Add("a1", "a1_2", "Third child", false, "Folder.gif", null); 
	
	oTree.FolderIcons = "/TreeIcons/Icons";
	oTree.FolderScript = "/TreeIcons/Script";
	oTree.FolderStyle = "/TreeIcons/Styles/Classic";
    
    // Enabling the events
    oTree.EventList = "OnAddNode,OnRemoveNode";
    oTree.SelectedId = "a0";      
	
	TreeView.Text = oTree.HTML();
}
</script>
<html>
<head>
<title>obout.com - ASPTreeview 2</title>
<script type="text/javascript">
// function for removing nodes
function deleteNode()
{    
    if(typeof tree_selected_id != "undefined")
    {
        ob_t2_Remove(tree_selected_id);
    }
    else
    {
        alert("Please select a node to delete!");
    }
}
// function for adding nodes
function addNode()
{       
    var sParentId = (typeof tree_selected_id != "undefined") ? tree_selected_id : "root";
    ob_t2_Add(sParentId, document.getElementById("sNodeId").value, document.getElementById("sNodeHtml").value, 1, "Folder.gif", null);
}
</script>
</head>
<body>
<ASP:Literal id="TreeView" EnableViewState="false" runat="server" />
<obout:Postback4 ID="Postback4_1" runat="server" />
<br />
<input type="button" value="Add" id="btnAdd" onclick="addNode()" />&nbsp;
Id:<input type="text" id="sNodeId" value="" />&nbsp;
Text:<input type="text" id="sNodeHtml" value="" />
<br />
<input type="button" value="Remove" id="btnRemove" onclick="deleteNode()" />
<br />
<p style="color:#666666; font:11px verdana;">
<b>This example demonstrate how to use the OnAddNode and OnRemoveNode events.</b>
<br /><br />
The OnAddNode event is triggered when a node is added from client-side,<br />
and the OnRemoveNode event is executed when a node is removed.
<br /><br />
The events are available:<br />
- on client side - you can execute a javascript action when a node is added/removed<br />
- on the server side - you can make a server-side processing (for example to update a database)
<br /><br /><br />
You can read more about the events of the ASPTreeView <a href="http://www.obout.com/t2/eServerSideEvents.aspx">here</a>
<br /><br />
<a href="http://www.obout.com/t_db/tutorial_1.aspx">Here</a> you'll find a nice tutorial about how to use the server-side events to update<br />
a database (using 3 of obout's components: ASPTreeView, Postback4 and TreeDB)
</p>
</body>
</html>
<script type="text/javascript">
// implement the OnAddNode event
function ob_OnAddNode(parentId, childId, textOrHTML, expanded, image, subTreeURL)
{    
	// add client side code here
	/*alert("OnAddNode:\n  parentId: " + (parentId || "none")
			+ "\n  childId: " + (childId || "none")
			+ "\n  textOrHTML: " + (textOrHTML || "none")
			+ "\n  expanded: " + (expanded || "false")
			+ "\n  image: " + (image || "none")
			+ "\n  subTreeURL: " + (subTreeURL || "none"));*/
   
	if(ob_ev("OnAddNode"))
	{
	    if(typeof ob_post == "object")
	    {
	        // add the parameters needed on server-side
	        ob_post.AddParam("parentId", parentId);
	        ob_post.AddParam("childId", childId);
	        ob_post.AddParam("textOrHTML", textOrHTML);
	        ob_post.AddParam("expanded", expanded ? expanded : 0);
	        ob_post.AddParam("image", image ? image : "");
	        ob_post.AddParam("subTreeURL", subTreeURL ? subTreeURL : "");
	        // send the data to the server and display the message returned from the server
	        alert(ob_post.post("process_add_remove.aspx", "OnAddNode"));
	    } 		
	    else
	    {
	        alert("Please add obout_Postback control to your page to use the server-side events");
	    } 
	}
}

// implement the OnRemoveNode event
function ob_OnRemoveNode(id)
{    
     // add client side code here
	 //alert("OnRemoveNode on " + id);
	 if(ob_ev("OnRemoveNode"))
	 {
	    if(typeof ob_post == "object")
	    {
	        // add the parameters needed on server-side
	        ob_post.AddParam("id", id);
	        // send the data to the server and display the message returned from the server
	        alert(ob_post.post("process_add_remove.aspx", "OnRemoveNode"));
	    }
	    else
	    {
	        alert("Please add obout_Postback control to your page to use the server-side events");
	    } 
	 }
}
</script>
