﻿<%@ Page Language="C#" Debug="true" %>
<%@ Import Namespace="obout_ASPTreeView_2_NET" %>
<%@ Import Namespace="System.Data.OleDb" %>

<script type="text/C#" runat="server">
    void Page_Load(object sender, EventArgs e)
    {
		obout_ASPTreeView_2_NET.Tree oTree = new obout_ASPTreeView_2_NET.Tree();

		OleDbConnection oConn = new OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + Server.MapPath("../Database/categories.mdb"));
        oConn.Open();        

        // get all the categories from the database
        string sQuery = "SELECT CategoryID, ParentID, CategoryText, Description, DateAdded, PriceRange, [Level], Icon FROM Categories ORDER BY [Level] ASC";
        OleDbCommand oCommand = new OleDbCommand(sQuery);
        oCommand.Connection = oConn;
        OleDbDataReader oReader = oCommand.ExecuteReader();

        string sHtml, sCategoryId, sParentId, sCategoryText, sDescription, sPriceRange, sIcon;
        int iLevel, iAddWidth;
        DateTime sDateAdded;

        // adding the root node
        sHtml = "<table cellspacing='0' cellpadding='0' border='0'><tr><td class='ob_header' style='width: 203px'>Category Name</td><td class='ob_header' style='width:200px;'>Description</td><td class='ob_header' style='width:100px;' align='left'>Date Created</td><td class='ob_header' align='left'>Price Range</td></tr></table>";
		oTree.AddRootNode(sHtml, true, "Folder.gif");

        // add the categories in the tree
        while (oReader.Read())
        {
            sCategoryId = oReader.GetInt32(0).ToString();
            sParentId = oReader.GetInt32(1).ToString();
            sCategoryText = oReader.GetString(2);
            sDescription = oReader.GetString(3);
            sDateAdded = oReader.GetDateTime(4);
            sPriceRange = oReader.GetString(5);
            iLevel = oReader.GetInt32(6);
            sIcon = oReader.GetString(7);

            // calculate the width of the first column from the table
            iAddWidth = 200 - (iLevel * 15);

            // create the html of the nodes - this will be a table, 
            // having the width of the first column calculated according to the level of the nodes
            sHtml = "<table cellspacing='0' cellpadding='0' border='0'><tr><td class='ob_column' style='width: " + iAddWidth.ToString() + "px'>" + sCategoryText + "</td><td class='ob_column' style='width:200px;'>" + sDescription + "</td><td class='ob_column' style='width:100px;' align='left'>" + sDateAdded.ToShortDateString() + "</td><td class='ob_column' align='left'>" + sPriceRange + "</td></tr></table>";

            oTree.Add(sParentId != "0" ? "oCateg_" + sParentId : "root", "oCateg_" + sCategoryId, sHtml, 1, sIcon, null);            
        }
        oConn.Close();        
		
		oTree.FolderStyle = "/TreeIcons/Styles/win2003";
        oTree.FolderIcons = "/TreeIcons/Icons";
        oTree.FolderScript = "/TreeIcons/Script";

		oTree.Width = "700px";
		oTree.SelectedEnable = true;
        oTree.DragAndDropEnable = true;
        oTree.SelectedId = "oCateg_2";

		// Write treeview to your page.
		TreeView.Text = oTree.HTML();
    }
</script>

<html>
<head>
    <title>obout.com - ASPTreeview 2</title>     
    <style type="text/css">
        /*the css styles needed for the columns from the nodes*/
        td.ob_column {	        
	        color:navy;
	        FONT: 8pt Tahoma; 
	        vertical-align:middle; 
	        border-bottom: 1px solid #cccccc
        }
        td.ob_header {	        
	        color:navy;
	        FONT: 9pt Tahoma; 
	        font-weight: bold;
	        vertical-align:middle; 
	        border-bottom: 1px solid #cccccc
        }
    </style>   
</head>
<body>
    <form name="myform" runat="server">
         <span style="color:#666666; font:11px verdana;">
		<b>ASPTreeView with aligned columns in the nodes</b>
	    </span>
	    <br /><br />
		<ASP:Literal id="TreeView" EnableViewState="false" runat="server" />			
		<br />  	
		<span style="color:#666666; font:11px verdana;">
            The html for each node is a table, that has the width of the first column<br />
            calculated according to the level of the node:<br /><br />
            <span style="background:#eeeeee;">
            iAddWidth = 200 - (iLevel * 15);<br /><br />
            sHtml = "&lt;table cellspacing='0' cellpadding='0' border='0'&gt;&lt;tr&gt;<br />
            &lt;td class='ob_column' style='width: " + iAddWidth.ToString() + "px'&gt;" + sCategoryText + "&lt;/td&gt;<br />
            &lt;td class='ob_column' style='width:200px;'&gt;" + sDescription + "&lt;/td&gt;<br />
            &lt;td class='ob_column' style='width:100px;' align='left'&gt;" + sDateAdded.ToShortDateString() + "&lt;/td&gt;<br />
            &lt;td class='ob_column' align='left'&gt;" + sPriceRange + "&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;";
            </span>
        </span>
		<br />
		<br />
		<span style="color:#666666; font:11px verdana;">
		Also, you have to declare 2 CSS classes, that are used for the columns:
		<pre style="background:#eeeeee; width:400px;">		        
        td.ob_column {	        
	        color:navy;
	        FONT: 8pt Tahoma; 
	        vertical-align:middle; 
	        border-bottom: 1px solid #cccccc
        }
        td.ob_header {	        
	        color:navy;
	        FONT: 9pt Tahoma; 
	        font-weight: bold;
	        vertical-align:middle; 
	        border-bottom: 1px solid #cccccc
        }   
		</pre>
		</span>	
	</form>
</body>
</html>