<%
' ------ For sub tree do NOT put any HTML tags above ASP code -------------------------

	'This file FileSystemSub.asp works with file FileSystemBig.asp

	' These 3 lines prevent from browser caching. They are optional.
	Response.AddHeader "pragma","no-cache" 
	Response.AddHeader "cache-control","private" 
	Response.CacheControl = "no-cache" 
	
	' These 2 lines for non-English characters. See MSDN for your language settings. 
	Response.CodePage = 1252
	Response.CharSet = "windows-1252"
	
	Dim sPath, ot, oFSO, sFolderName, i, iNode, SubTreeUrl, sBaseUrl, iLength
	
	sPath = Request.QueryString("path") & "\"
	If sPath = "\" Then
		Response.Write "This file works with <b>FileSystemBig.asp</b>"
		Response.End
	End If
	
	iLength = Request.QueryString("length")
	sBaseUrl = Mid(sPath, iLength + 1)
	sBaseUrl = Replace(sBaseUrl, "\", "/")

	' Find current folder name.
	i = Len(sPath) - 1
	Do Until Mid(sPath, i, 1) = "\"
		sFolderName = Mid(sPath, i, Len(sPath) - i)
		i = i - 1
	Loop
	
	' Create objects.
	Set oFSO = CreateObject("Scripting.FileSystemObject")
	Set ot = Server.CreateObject("obout_asptreeview_2.tree")
	ot.FolderIcons = "/TreeIcons/Icons"
	ot.FolderScript = "/TreeIcons/Script"
	ot.FolderStyle = "/TreeIcons/Styles/Classic"
	ot.SubTree = true
	
	' Show folders and files.
	Call AddFolder(sPath, "../" & Server.URLEncode(sFolderName), "root")
	
	' Write treeview to page.
	Response.Write ot.HTML
	Set ot = Nothing 
	Set oFSO = Nothing


	
Function AddFolder(pth, dpt, parentID)
	Dim oF, oFolder, oFile, oSubFolder, oItem

	Set oFolder = oFSO.GetFolder(pth)
	Set oSubFolder = oFolder.SubFolders
	Set oFile = oFolder.Files
	
	' Display Subfolders.
	For Each oItem In oSubFolder 
		iNode = iNode + 1
		' Populate folders dynamically again.
		SubTreeUrl = "FileSystemSub.asp?path=" & Replace(Server.URLEncode(oItem.Path), "'", "\'") & "&length=" & iLength
		ot.Add parentID, "z" & iNode, "<span onclick='ob_t23(this)'>" & oItem.Name & "</span>", , , SubTreeUrl
	Next
	
	' Display Files.
	For Each oF In oFile
		iNode = iNode + 1
		ot.Add parentID, "z" & iNode, "<a href=""" & sBaseUrl & Server.URLPathEncode(oF.Name) & """>" & oF.Name & "</a>", , "page.gif" 
	Next
End Function

' ------ For sub tree do NOT put any HTML tags below ASP code -------------------------
%>
