<%
        Dim oTree
        Set oTree = Server.CreateObject("obout_ASPTreeview_2.Tree")
        Dim html

		oTree.AddRootNode "I am Root node!", true, "xpMyComp.gif"
		oTree.DragAndDropEnable = true
        ' Populate Treeview.
        oTree.Add "root", "a0", "obout.com", true
        oTree.Add "a0", "a0_0", "ASP TreeView", true
        oTree.Add "a0", "a0_1", "Fast", true
        oTree.Add "a0_1", "a0_2", "Very Fast", true
        oTree.Add "a0", "a0_3", "Easy", true
        oTree.Add "root", "a1", "Links & Notes since 1998", false, "book.gif"

        html = "MemoBook.com"
        oTree.Add "a1", "a1_0", html, true
        html = "bzook.com"
        oTree.Add "a1", "a1_1", html, true
        html = "obout.com"
        oTree.Add"a1", "a1_2", html, true
        
        oTree.FolderIcons = "/TreeIcons/Icons"
        oTree.FolderStyle = "/TreeIcons/Styles/Classic"
        oTree.FolderScript = "/TreeIcons/Script"
                        
        oTree.SelectedId = "a0_1"
            
        oTree.Width = "200px"	            
%>
<html>
<head>
<title>obout.com - ASPTreeview 2</title>
<style type="text/css">
    td {font: 10pt Tahoma; margin: 20px;}
/* this style is used for node numbers */
span.ob_number
{
	font: bold 9px Verdana;
}
</style>
</head>
<body>
<br />
<table border="0">
	<tr>
	    <td valign="top">
		    <b>Renumber the nodes of the ASPTreeView</b>
	    </td>
	</tr>
</table>
<br />
<table border="0">	
	<tr>
		<td valign="top">	            			            
            <%
                Response.Write(oTree.HTML())
                oTree = null
            %>
		</td>		
    </tr>
    <tr>		
		<td valign="top">	
		    <br />
		    You can renumber the nodes using drag and drop.
        </td>
    </tr>
</body>
</html>
<script language="javascript">

function ob_OnNodeDrop(src, dst)
{
	ob_Renumber();
}

function ob_Renumber(parentNum, nodeNum, node)
{
    if (!node)
    {
        var topLevel = ob_getTopLevelList();
         for(var i = 0; i < topLevel.length; i++)
        	ob_Renumber(null, i + 1, topLevel[i]);
        return;
    }
	var curNum = parentNum ?  parentNum + "." + nodeNum : nodeNum;
	node.setAttribute("number", curNum);
    var text = curNum + " ";
    if (node.firstChild.className == "ob_number")
    {
    	node.firstChild.firstChild.nodeValue = text;    	
	}
    else
    {
    	var numberSpan = document.createElement("SPAN");
    	numberSpan.appendChild(document.createTextNode(text));
    	numberSpan.className = "ob_number";
    	node.insertBefore(numberSpan, node.firstChild);
	}
    var children = ob_getChildrenList(node);
    if (children)
    {
        for (var i = 0; i < children.length; i++)
        	ob_Renumber(curNum, i + 1, children[i]);
    }
}

window.onload = function()
{
    ob_Renumber();
}
</script>