<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<% 
	'8***********************************************8
	' Jason Withrow - For ASP101 July 2001
	' Page Builds List of Files in Specific Folder
	' With Links to Download files
	'
	' jwithrow@mediaone.net
	'8***********************************************8

	Dim strThisPage
	strThisPage = Request.ServerVariables("SCRIPT_NAME")
	strThisPage = Right(strThisPage, Len(strThisPage) - 1)
	
	'Path To Folder That holds Files To Download Here
	'Default is the current Folder
	FILE_FOLDER = StripFileName(Request.ServerVariables("PATH_TRANSLATED"))
	
	'Constants
	Const adVarChar = 200
	Const adInteger = 3
	Const adDate = 7
	Const adFileTime = 64
	Const adNumeric = 131
	
%>
<HTML>
<HEAD>
	<TITLE>File Download List For <%= Date() %></TITLE>
	<STYLE TYPE="TEXT/CSS">
	.TabHeader { Font-Family: Arial; Font-Weight: Bold; Font-Size: 12px; Background: Silver }
	.DataCol { Font-Family: Verdana; Font-Size: 12px }
	</STYLE>
	<SCRIPT>
		function msg() {
			self.status = 'File Downloads For <%= Date() %>';
			return true
		}
	</SCRIPT>
</HEAD>

<BODY onLoad="msg()">
<TABLE BORDER=1 ID=tblFileData BACKGROUND="">
	<TR>
		<TD CLASS=TabHeader><A HREF="sSort.asp?sort=Name">File Name</A></TD>
		<TD CLASS=TabHeader><A HREF="sSort.asp?sort=Type">File Type</A></TD>
		<TD CLASS=TabHeader><A HREF="sSort.asp?sort=Size">File Size</A></TD>
		<TD CLASS=TabHeader><A HREF="sSort.asp?sort=Path">File Path</A></TD>
		<TD CLASS=TabHeader><A HREF="sSort.asp?sort=Date">Last Modified</A></TD>
	</TR>
<%  
	strSortHeader = Request.QueryString("sort")
	
	IF strSortHeader = "" Then
		Call GetAllFiles("")
	Else
		Call GetAllFiles(strSortHeader)
	End IF
%>


</TABLE>
</BODY>
</HTML>
<%  
'8*****************************************8
' The next release will have sort routines 
' That is why the column headers are links
' They are hooks to add the sorts into.
'8****************************************8


Sub GetAllFiles(strSortBy)
	Dim oFS, oFolder, oFile
	Set oFS = Server.CreateObject("Scripting.FileSystemObject")
		
	'Set Folder Object To Proper File Directory
	Set oFolder = oFS.getFolder(FILE_FOLDER)
	
	Dim intCounter
	
	intCounter = 0
	
	IF strSortBy = "" Then 'UnSorted (default)
		Dim FileArray()
		ReDim Preserve FileArray(oFolder.Files.Count, 5)
	
		For Each oFile in oFolder.Files
			strFileName = oFile.Name
			strFileType = oFile.Type
			strFileSize = oFile.Size
			strFilePath = oFile.Path
			strFileDtMod = oFile.DateLastModified
				
			FileArray(intCounter, 0) = strFileName
			FileArray(intCounter, 1) = "<A HREF=" & Chr(34) & "startDownload.asp?File=" _
				& Server.urlEncode(strFilePath) & "&Name=" & Server.urlEncode(strFileName) & "&Size=" & strFileSize & Chr(34) _
				& " onMouseOver=" & Chr(34) & "self.status='" & strFileName & "'; return true;" & Chr(34) _
				& " onMouseOut=" & Chr(34) & "self.status=''; return true;" & Chr(34) & ">" & strFileName & "</A>"
			FileArray(intCounter, 2) = strFileType
			FileArray(intCounter, 3) = strFileSize
			FileArray(intCounter, 4) = strFilePath
			FileArray(intCounter, 5) = strFileDtMod
		
			intCounter = (intCounter + 1)
		Next
		
		intRows = uBound(FileArray, 1)
		intCols = uBound(FileArray, 2)
	
		For x = 0 To intRows -1
			Echo("<TR>")
			For z = 0 To intCols
				If z > 0  Then
					BuildTableCol(FileArray(x, z))
				End IF
			Next
			Echo("</TR>")
		Next
		
	Else
	'Sorted List
	
		Set oRS = Server.CreateObject("ADODB.Recordset")
		oRS.Fields.Append "Name", adVarChar, 500
		oRS.Fields.Append "Type", adVarChar, 500
		oRS.Fields.Append "Size", adInteger
		oRS.Fields.Append "Path", adVarChar, 500
		oRS.Fields.Append "Date", adFileTime
		oRS.Open
		
		For Each oFile in oFolder.Files
			strFileName = oFile.Name
			strFileType = oFile.Type
			strFileSize = oFile.Size
			strFilePath = oFile.Path
			strFileDtMod = oFile.DateLastModified
			
			oRS.AddNew
			oRS.Fields("Name").Value = "<A HREF=" & Chr(34) & "startDownload.asp?File=" _
				& Server.urlEncode(strFilePath) & "&Name=" & Server.urlEncode(strFileName) & "&Size=" & strFileSize & Chr(34) _
				& " onMouseOver=" & Chr(34) & "self.status='" & strFileName & "'; return true;" & Chr(34) _
				& " onMouseOut=" & Chr(34) & "self.status=''; return true;" & Chr(34) & ">" & strFileName & "</A>"
			oRS.Fields("Type").Value = strFileType
			oRS.Fields("Size").Value = strFileSize
			oRS.Fields("Path").Value = strFilePath
			oRS.Fields("Date").Value = strFileDtMod
		Next
		
		oRS.Sort = strSortBy & " ASC"
		
		Do While Not oRS.EOF
			Echo("<TR>")
				BuildTableCol(oRS("Name"))
				BuildTableCol(oRS("Type"))
				BuildTableCol(oRS("Size"))
				BuildTableCol(oRS("Path"))
				BuildTableCol(oRS("Date"))
			Echo("</TR>")
		oRS.MoveNext
		Loop			
		
		oRS.Close
		Set oRS = Nothing
	End IF
	
	EchoB("<B>" & oFolder.Files.Count & " Files Available</B>")
		
	Cleanup oFile
	Cleanup oFolder
	Cleanup oFS
End Sub

Function Echo(str)
	Echo = Response.Write(str & vbCrLf)
End Function

Function EchoB(str)
	EchoB = Response.Write(str & "<BR>" & vbCrLf)
End Function

Sub Cleanup(obj)
	IF isObject(obj) Then
		Set obj = Nothing
	End IF
End Sub

Function StripFileName(strFile)
	StripFileName = Left(strFile, inStrRev(strFile, "\"))
End Function

Sub BuildTableCol(strData)
	Echo("<TD CLASS=DataCol>" & strData & "</TD>")
End Sub

'Not implemented
Sub BuildTableRow(arrData)
	Dim intCols
	intCols = uBound(arrData)
	For y = 0 To intCols
		Echo("<TD CLASS=DataCol>" & arrData(y) & "</TD>")
	Next
End Sub

%>
