<%
    '***********************************************************************************************
    '// Class: clsDataGrid (see ReadMe.txt)
    '// Author: Nick DelMedico (www.pixel420.com)
    '// Properties:
    '//    .Connection - The connection object to use if one exists (default is none)
    '//    .Command - The SQL query to build the grid from (Required)
    '//    .AutoGenerateCols - Boolean specifying if the grid creates the columns (default is "True")
    '//    .GridClassName - Name of a CSS Class to apply to the grid (default is none)
    '//    .GridStyle - CSS inline style to apply to the grid (default is none)
    '//    .GridAlign - Alignment of grid ("center", "left", "right" - default is none)
    '//    .HeaderClassName - Name of a CSS Class to apply to the grid header (default is none)
    '//    .HeaderStyle - CSS inline style to apply to the grid header (default is none)
    '//    .ItemClassName - Name of a CSS Class to apply to the records/rows (default is none)
    '//    .ItemStyle - CSS inline style to apply to the records/rows (default is none)
    '//    .AltItemClassName - Name of a CSS Class to apply to every other record/row (default is none)
    '//    .AltItemStyle - CSS inline style to apply to the every other record/row (default is none)
    '//    .LinkClassName - Name of a CSS Class to apply to links added by .LinkColumn() (default is none)
    '//    .LinkStyle - CSS inline style to apply to links added by .LinkColumn() (default is none)
    '//    .FooterClassName - Name of a CSS Class to apply to the grid paging footer (default is none)
    '//    .FooterStyle - CSS inline style to apply to the grid paging footer (default is none)
    '//    .PagingLinkClass - Name of a CSS Class to apply to Next X/Previous X links (default is none)
    '//    .PageResults - Boolean whether to page the results (default is "False")
    '//    .CurrentRecord - Int that represents which record to start from when paging (default is "0")
    '//    .PageSize - Int that represents how many records shown per page when paging (default is "10")
    '// Methods:
    '//    .CreateConnection - Creates a connection. (Args: Connection string)
    '//    .SetTableOptions - Overrides default grid settings. (Args: Width, Padding, Spacing, Border)
    '//    .BoundColumn - Replaces the db column name w/ one you specify and creates "sort by" headers
    '//     -->(Args: DB Field, Header Text, Boolean is sort by header, CSS class name for sort by links)
    '//    .LinkColumn - Renders a field as link. (Args: DB Field, URL, Link Text, Target)
    '//    .Bind - Outputs DataGrid to browser. (Args: None)
    '***********************************************************************************************

    Class clsDataGrid
        '//My privates -- variables of course
        Private p_strHeader, p_strOutput, p_strCommand
        Private p_strBoundCols, p_strGridStyle, p_strGridClass
        Private p_strGridWidth, p_strHeadStyle, p_strHeadClass
        Private p_strItemStyle, p_strItemClass, p_strAltItemStyle
        Private p_strAltItemClass, p_strThisStyle, p_strThisClass
        Private p_strPagingClass, p_strFootStyle, p_strFootClass
        Private p_strGridAlign, p_strLinks, p_strLinkStyle
        Private p_strLinkClass, p_strScriptName
        Private p_intCurRow, p_intPadding, p_intSpacing
        Private p_intGridBorder, p_intBegRec, p_intRecOffset
        Private p_intEndRec, p_i, p_x
        Private p_arrBoundCols, p_arrRecords, p_arrLinks, p_arrTemp
        Private p_blnAutoCols, p_blnPrivConn, p_blnAllowPaging
        Private p_blnLinkCol, p_blnSortCol
        Private p_objConn, p_objRS

        '//This fires when an instance of the class is created
        Private Sub Class_Initialize()
            p_strScriptName = Request.ServerVariables("SCRIPT_NAME")
            p_strGridWidth = "100%" : p_strGridAlign = ""
            p_strGridClass = "" : p_strGridStyle = ""
            p_strHeadClass = "" : p_strHeadStyle = ""
            p_strItemClass = "" : p_strItemStyle = ""
            p_strFootClass = "" : p_strFootStyle = ""
            p_strLinkClass = "" : p_strLinkStyle = ""
            p_strAltItemClass = "" : p_strAltItemStyle = ""
            p_strPagingClass = "" : p_strLinks = ""
            p_intGridBorder = 1 : p_intCurRow = 1
            p_intPadding = 2 : p_intSpacing = 2
            p_intRecOffset = 10 : p_intBegRec = 0
            p_blnAutoCols = True : p_blnPrivConn = False
            p_blnAllowPaging = False : p_blnLinkCol = False
            p_blnSortCol = False
        End Sub

        '//Properties
        Public Property Set Connection(oConn)
            Set p_objConn = oConn
        End Property

        Public Property Let Command(sSql)
            p_strCommand = sSql
        End Property

        Public Property Let AutoGenerateCols(bAutoCols)
            If bAutoCols = True Or bAutoCols = False Then
                p_blnAutoCols = bAutoCols
            End If
        End Property

        Public Property Let GridClassName(sClass)
            p_strGridClass = " class=""" & sClass & """"
        End Property

        Public Property Let GridStyle(sStyle)
            p_strGridStyle = " style=""" & sStyle & """"
        End Property

        Public Property Let GridAlign(sAlign)
            Select Case LCase(sAlign)
                Case "center", "left", "right"
                    p_strGridAlign = " align=""" & sAlign & """"
            End Select
        End Property

        Public Property Let HeaderClassName(sClass)
            p_strHeadClass = " class=""" & sClass & """"
        End Property

        Public Property Let HeaderStyle(sStyle)
            p_strHeadStyle = " style=""" & sStyle & """"
        End Property

        Public Property Let ItemClassName(sClass)
            p_strItemClass = " class=""" & sClass & """"
        End Property

        Public Property Let ItemStyle(sStyle)
            p_strItemStyle = " style=""" & sStyle & """"
        End Property

        Public Property Let AltItemClassName(sClass)
            p_strAltItemClass = " class=""" & sClass & """"
        End Property

        Public Property Let AltItemStyle(sStyle)
            p_strAltItemStyle = " style=""" & sStyle & """"
        End Property

        Public Property Let LinkClassName(sClass)
            p_strLinkClass = " class=""" & sClass & """"
        End Property

        Public Property Let LinkStyle(sStyle)
            p_strLinkStyle = " style=""" & sStyle & """"
        End Property

        Public Property Let FooterClassName(sClass)
            p_strFootClass = " class=""" & sClass & """"
        End Property

        Public Property Let FooterStyle(sStyle)
            p_strFootStyle = " style=""" & sStyle & """"
        End Property

        Public Property Let PagingLinkClass(sClass)
            p_strPagingClass = " class=""" & sClass & """"
        End Property

        Public Property Let PageResults(bPaging)
            If bPaging = True Or bPaging = False Then
                p_blnAllowPaging = bPaging
            End If
        End Property

        Public Property Let CurrentRecord(iRec)
            If IsNumeric(iRec) Then p_intBegRec = CInt(iRec)
        End Property

        Public Property Let PageSize(iPageSize)
            If IsNumeric(iPageSize) Then p_intRecOffset = CInt(iPageSize)
        End Property

        '//Private Functions -- available to class only
        Private Function CreateFooter()
            Dim p_sTemp, p_sQS
            If p_blnAllowPaging Then
                If Len(Trim(Request.Querystring("sort"))) > 0 Then p_sQS = "&sort=" & Request.Querystring("sort")
                p_sTemp = "<tr><td align=""right"" colspan=""" & UBound(p_arrRecords, 1) + 1 & """" & p_strFootClass & p_strFootStyle & ">"
                If p_intBegRec > 0 Then p_sTemp = p_sTemp & "<a href=""" & p_strScriptName & "?nxtrec=" & p_intBegRec - p_intRecOffset & "&recos=" & p_intRecOffset & p_sQS & """" & p_strPagingClass & ">&#171; Previous " & p_intRecOffset & "</a>"
                If p_intEndRec < UBound(p_arrRecords, 2) Then p_sTemp = p_sTemp & " &nbsp; &nbsp; <a href=""" & p_strScriptName & "?nxtrec=" & p_intBegRec + p_intRecOffset & "&recos=" & p_intRecOffset & p_sQS & """" & p_strPagingClass & ">Next " & p_intRecOffset & " &#187;</a>"
                p_sTemp = p_sTemp & "</td></tr>" & vbCrLf
            End If
            CreateFooter = p_sTemp
        End Function

        Private Function GetIndex(sFldName, iIdx)
            Dim p_aTemp, p_y
            If p_blnLinkCol Then
                p_aTemp = Split(p_strLinks, "|||")
                For p_y = 0 To UBound(p_aTemp) - 1
                    If Split(p_aTemp(p_y), "|=|")(0) = sFldName Then p_strLinks = Replace(p_strLinks, sFldName, iIdx)
                Next
            End If
            GetIndex = sFldName
        End Function

        Private Function CreateLink(sFldValue, iIdx)
            Dim p_aTemp, p_y, p_sUrl, p_sText
            Dim p_sTarget, p_sLink, p_iTemp
            If p_blnLinkCol Then
                For p_y = 0 To UBound(p_arrLinks) - 1
                    p_aTemp = Split(p_arrLinks(p_y), "|=|")
                    If CStr(p_aTemp(0)) = CStr(iIdx) Then
                        p_sUrl = p_aTemp(1) : p_sText = p_aTemp(2) : p_sTarget = Trim(p_aTemp(3))
                        p_sLink = "<a href=""" & Replace(p_sUrl, "#TEMP#", Server.URLEncode(sFldValue)) & """"
                        If Len(p_sTarget) > 0 Then p_sLink = p_sLink & " target=""" & p_sTarget & """"
                        p_sLink = p_sLink & p_strLinkStyle & p_strLinkClass & ">" & Replace(p_sText, "#TEMP#", sFldValue) & "</a>"
                        CreateLink = p_sLink
                        Exit Function
                    Else
                        p_sLink = sFldValue
                    End If
                Next
            Else
                p_sLink = sFldValue
            End If
            CreateLink = p_sLink
        End Function

        Private Function ReturnNextStyle(iCurRow)
            If iCurRow Mod 2 = 0 Then
                If p_strAltItemStyle = "" Then
                    ReturnNextStyle = p_strItemStyle
                Else
                    ReturnNextStyle = p_strAltItemStyle
                End If
            Else
                ReturnNextStyle = p_strItemStyle
            End If
        End Function

        Private Function ReturnNextClass(iCurRow)
            If iCurRow Mod 2 = 0 Then
                If p_strAltItemClass = "" Then
                    ReturnNextClass = p_strItemClass
                Else
                    ReturnNextClass = p_strAltItemClass
                End If
            Else
                ReturnNextClass = p_strItemClass
            End If
        End Function

        Private Sub CreateSortParam(sParam)
            Dim p_sTemp : p_sTemp = Trim(Replace(Replace(Replace(sParam, "'", ""), "--", ""), ";", ""))
            If Not Instr(p_strBoundCols, sParam & "|=|") > 0 Or Len(p_sTemp) < 1 Then Exit Sub
            p_strCommand = p_strCommand & " Order By " & p_sTemp
        End Sub

        '//Methods for the class
        Public Sub CreateConnection(sConn)
            Set p_objConn = Server.CreateObject("ADODB.Connection")
            p_objConn.Open sConn
            p_blnPrivConn = True
        End Sub

        Public Sub SetTableOptions(sWidth, iSpace, iPad, iBorder)
            If IsNumeric(sWidth) Or Right(sWidth, 1) = "%" Then p_strGridWidth = sWidth
            If IsNumeric(iSpace) Then p_intPadding = iSpace
            If IsNumeric(iPad) Then p_intSpacing = iPad
            If IsNumeric(iBorder) Then p_intGridBorder = iBorder
        End Sub

        Public Sub BoundColumn(sColumn, sHeader, bSort, sClass)
            Dim p_sSort : p_sSort = sHeader
            Dim p_sClass : p_sClass = ""
            If bSort Then
                If Len(Trim(sClass)) > 0 Then p_sClass = " class=""" & sClass & """"
                p_sSort = "<a href=""" & p_strScriptName & "?sort=" & sColumn & """ title=""Sort By " & sHeader & """" & p_sClass & ">" & sHeader & "</a>"


                p_blnSortCol = True
            End If
            p_strBoundCols = p_strBoundCols & sColumn & "|=|" & p_sSort & "|||"
            p_blnAutoCols = False
        End Sub

        Public Sub LinkColumn(sColumn, sUrl, sText, sTarget)
            p_strLinks = p_strLinks & sColumn & "|=|" & sUrl & "|=|" & sText & "|=| " & sTarget & "|||"
            p_blnLinkCol = True
        End Sub

        Public Sub Bind()
            If IsObject(p_objConn) And Not IsEmpty(p_strCommand) Then
                If p_blnSortCol Then CreateSortParam(Request.Querystring("sort"))
                Set p_objRS = Server.CreateObject("ADODB.Recordset")
                Set p_objRS = p_objConn.Execute(p_strCommand)
                p_strOutput = "<table width=""" & p_strGridWidth & """ border=""" & p_intGridBorder & """ cellpadding=""" & p_intPadding & """ cellspacing=""" & p_intSpacing & """" & p_strGridAlign & p_strGridClass & p_strGridStyle & ">" & vbCrLf & "<tr>"
                For p_i = 0 To p_objRS.Fields.Count - 1
                    p_strHeader = p_strHeader & "<td align=""center""" & p_strHeadClass & p_strHeadStyle & ">" & GetIndex(p_objRS.Fields(p_i).Name, p_i) & "</td>"
                Next
                If Not p_blnAutoCols Then
                    p_arrBoundCols = Split(p_strBoundCols, "|||")
                    For p_i = 0 To UBound(p_arrBoundCols) - 1
                        p_arrTemp = Split(p_arrBoundCols(p_i), "|=|")
                        p_strHeader = Replace(p_strHeader, p_arrTemp(0), p_arrTemp(1))
                    Next
                End If
                p_strOutput = p_strOutput & p_strHeader & "</tr>" & vbCrLf
                p_arrRecords = p_objRS.GetRows()
                p_objRS.Close
                Set p_objRS = Nothing
                If p_blnLinkCol Then p_arrLinks = Split(p_strLinks, "|||")
                If p_blnAllowPaging Then
                    If UBound(p_arrRecords, 2) > p_intBegRec + p_intRecOffset Then
                        p_intEndRec = p_intRecOffset + p_intBegRec - 1
                    Else
                        p_intEndRec = UBound(p_arrRecords, 2)
                    End If
                Else
                    p_intEndRec = UBound(p_arrRecords, 2)
                End If
                For p_i = p_intBegRec To p_intEndRec
                    p_strThisClass = ReturnNextClass(p_intCurRow)
                    p_strThisStyle = ReturnNextStyle(p_intCurRow)
                    p_strOutput = p_strOutput & "<tr>"
                    For p_x = 0 To UBound(p_arrRecords, 1)
                        p_strOutput = p_strOutput & "<td" & p_strThisClass & p_strThisStyle & ">" & CreateLink(p_arrRecords(p_x, p_i), p_x) & "</td>"
                    Next
                    p_strOutput = p_strOutput & "</tr>" & vbCrLf
                    p_intCurRow = p_intCurRow + 1
                Next
                p_strOutput = p_strOutput & CreateFooter() & "</table>" & vbCrLf
                Response.Write(p_strOutput)
            Else
                Response.Write("ERROR! Database Connection and SQL Command must be set before calling .Bind() method.<br />")
            End If
        End Sub

        '//This fires when the instance of the class is destroyed
        Private Sub Class_Terminate()
            p_strHeader = Empty
            p_strOutput = Empty
            If p_blnPrivConn Then p_objConn.Close
            Set p_objConn = Nothing
        End Sub
    End Class
%>