/*
** topslidebox jQuery Plugin
** http://github.com/pierre-lecocq/topslidebox
*/
(function($)
{
  	this.topslideboxClose = function () {$('#topslidebox_wrap').slideUp('normal', function () {$('#topslidebox_overlay').fadeOut('normal', function () {$(this).remove();});});return false;};	
  	$.fn.topslidebox = function(settings)
	{
    	var defaults = {
			title: null,
			titleMarkup: 'h1',
			width: 600,
			height: null,
			fixed: false,
			closable: true,
			closeButtonContent: 'close',
			ajaxOtions: {},
			errorMessage: 'An error occured ...',
			overlayClass: '',
			wrapClass: '',
			contentClass: '',
			closeClass: ''
		};
    	var settings = $.extend({}, defaults, settings); 
    	return this.each(function()
		{
			$(this).click(function ()
			{
				var opts = $.meta ?  $.extend({}, settings, $this.data()) : settings;
				var href = $(this).attr('href');   
				var content = '<div id="topslidebox_error">' + opts.errorMessage + '</div>';
				/* Build HTML */
				$(document.createElement('div')).attr({'id':'topslidebox_overlay', 'class': opts.overlayClass}).css({'display':'none','width':$(document).width(),'height':$(document).height()}).appendTo('body');
				$(document.createElement('div')).attr({'id':'topslidebox_wrap', 'class': opts.wrapClass}).css({'display':'none','width': opts.width+'px','top': $(window).scrollTop()+'px','left': (($(document).width()/2)-(opts.width/2))}).appendTo('#topslidebox_overlay');
				$(document.createElement('div')).attr({'id':'topslidebox_content', 'class': opts.contentClass}).appendTo('#topslidebox_wrap');
				/* Re-init events */
	        	$(document).unbind('keyup'); 
	        	$(document).unbind('scroll'); 
				/* ContentType */
				if (href.indexOf('http') < 0){$.ajax({ type: "GET", url: href, dataType: 'html', data: opts.ajaxOtions, success: function(html){ content = '<div>' + html + '</div>'; } });}
				else{content = '<iframe src="' + href + '" />';}
				/* Height */
				if (opts.height != null){$('#topslidebox_wrap').css('height', opts.height + 'px');}
				/* Title */
				if (opts.title != null && opts.title.length > 0){$(document.createElement('div')).attr({id:'topslidebox_title'}).html('<' + opts.titleMarkup + '>' + opts.title + '</' + opts.titleMarkup + '>').insertBefore('#topslidebox_content');}
				/* Scroll */
				if (opts.fixed == false){$(document).scroll(function(e) { $('#topslidebox_wrap').css( { top: $(window).scrollTop() + 'px' } );});}
				/* Close */
				if (opts.closable == true)
				{
					$(document.createElement('div')).attr({'id':'topslidebox_close', 'class': opts.closeClass}).html('<a href="#" onclick="topslideboxClose(); return false;">' + opts.closeButtonContent + '</a>').insertAfter('#topslidebox_content');
					$(document).keyup(function(e) { if (e.keyCode == 27 && opts.closable == true){topslideboxClose();}return false;});					
				}
				/* Process */
				$('#topslidebox_content').html('<div id="topslidebox_loader">&nbsp;</div>');
				$('#topslidebox_overlay').fadeIn('normal', function () {$('#topslidebox_wrap').slideDown('normal', function () {$('#topslidebox_content').html(content);});}); 
	  			return false;
			});
    	});
  	};	
})(jQuery);
