/**
 * Rotator - Generic class to rotate different kind of collections.
 * Copyright (c) 2008 Ariel Flesler - aflesler(at)gmail(dot)com | http://flesler.blogspot.com
 * Dual licensed under MIT and GPL.
 * Date: 2/20/2008
 * @version 1.0.0
 * http://flesler.blogspot.com/2007/10/jqueryscrollto.html
 */
;function Rotator( coll, setter, getter ){
	this.collection( coll );
	switch( typeof setter ){
		case 'string': this.setter = function(v){ this[setter] = v;	}; break;
		case 'undefined': setter = Rotator.defaultSetter;
		case 'function': this.setter = setter;
	}
	switch( typeof getter ){
		case 'string': this.getter = function(){ return this[getter]; }; break;
		case 'undefined': getter = Rotator.defaultGetter;
		case 'function': this.getter = getter;
	}
};

Rotator.toArray = function( obj ){
	if( obj.split )
		return obj.split('');
	var arr = [], l = obj.length;
	while(l--)
		arr[l] = obj[l];
	return arr;
};

Rotator.defaultGetter = function(){
	return this;
};
Rotator.defaultSetter = function( value ){
	return value;
};

Rotator.prototype = {
	constructor:Rotator,
	collection:function( c ){
		if( c === undefined ) return this._c_;
		this._c_ = Rotator.toArray(c);
	},
	_getValues:function(){
		var values = [ ];
		for( var i=0, l=this._c_.length; i < l; i++ )
			values[i] = this.getter.call( this._c_[i], i );
		return values;
	},
	_setValues:function( values ){
		for( var i=0, l=values.length; i < l; i++ ){
			var ret = this.setter.call( this._c_[i], values[i], i );
			if( ret !== undefined )
				this._c_[i] = ret;
		}
	},
	left:function(){
		var values = this._getValues();
		values.push( values.shift() );
		this._setValues( values );
	},
	right:function(){
		var values = this._getValues();
		values.unshift( values.pop() );
		this._setValues( values );
	}
};