/*
Copyright 2007 Bruce Kroeze <brucek@solidsitesolutions.com>
This work is licensed under a Creative Commons Attribution 2.5  License,
Please see the license text at: http://creativecommons.org/licenses/by/2.5/
*/
SSS = {
	// prefix for all "over" images
	imagebase : 'media/images/btn_',
	
	// flag for IE
	IE6 : false,
			
	// Initialize all menus for rollover
	menuinit : function() {
		if (SSS.IE6) {
			selector = 'span';
		} else {
			selector = 'img';
		}

		$('.nav li ' + selector).hover(function() {
			SSS.over(this);
		}, function() {
			SSS.out(this);
		});
	},
	
	// Swap image to non-rolled-over state
	out : function(elt) {
		SSS.setpng(elt, SSS.imagebase + $(elt).attr('id') + '.png');
	},
	
	// Swap image to rolled-over state
	over : function(elt) {
		SSS.setpng(elt, SSS.imagebase + $(elt).attr('id') + '_on.png');
	},

	// Preload rollover images and set the image name prefix.
	preloadimages : function() {
		base = arguments[0];
		SSS.imagebase = base;
		
		for(var i = 1; i<arguments.length; i++) {
			jQuery("<img>").attr("src", base + arguments[i]);
		}
	},
	
	// Set the source png for an element.
	setpng : function(elt, src) {
		if (SSS.IE6) {
			// this is the magic which loads a png, preserving transparency.
			$(elt).css('filter', "progid:DXImageTransform.Microsoft.AlphaImageLoader(src=\'" + src + "\', sizingMethod='scale');");
		} else {
			$(elt).attr('src', src);
		}
	}
}

// put this part in your site.js file.  Call preload with the "base" of your image file first, then list the files.
// in the example below, I am preloading: media/images/btn_home_on.png, media/images/btn_store_on.png, etc.
/*
$(function() {
	SSS.preloadimages("media/images/btn_", "home_on.png", "store_on.png", 
		"stories_on.png", "lessons_on.png", "boomer_on.png", 
		"company_on.png", "careers_on.png", "contact_on.png");
	SSS.menuinit();
});
*/