///////////////////////////////////////////////////////////////////////////////////////// 
// SUPER TABLES - VERSION 0.23
// SCRIPT BY MATT MURPHY --- visit www.matts411.com
///////////////////////////////////////////////////////////////////////////////////////// 
// NOTES: 
//  function call: setupSuperTable(A, B, C ,D) arguments:
//      A - table id [string]
//		B - css skin [string]
//      C - fix first column - t/f [boolean]
//      D - columns resizable - t/f [boolean]
///////////////////////////////////////////////////////////////////////////////////////// 
// KNOWN ISSUES / BUGS:
// 1. moving outside of table while resizing in safari causing occassional issues
// 2. only copying first node from source table
///////////////////////////////////////////////////////////////////////////////////////// 

var sT = new Array();

function setupSuperTable(A, B, C, D) {
	if(!A) return;
    document.getElementById(A).className = 'sTempTable';
    
	var i = sT.length;
	sT[i] = new superTable(A, B, C, D);
	sT[i].initiateDomEvents(i);
}

/////////////////////////////////////////////////////////////////////////////////////////
//  INITIALIZE
/////////////////////////////////////////////////////////////////////////////////////////
function superTable(A, B, C, D) {
	var table = document.getElementById(A); 
	this.skin = (B == "") ? '_Default' : '_' + B;
    this.fixedCol = (C == "") ? false : C;
    this.resizable = (D == "") ? false : D;
    this.isIE = (navigator.userAgent.toLowerCase().indexOf("msie") != -1) ? true : false;
    this.isFirefox = (navigator.userAgent.toLowerCase().indexOf("firefox") != -1) ? true : false;
    this.isSafari = (navigator.userAgent.toLowerCase().indexOf("safari") != -1) ? true : false;
    this.isOpera = (navigator.userAgent.toLowerCase().indexOf("opera") != -1) ? true : false;
    
    // GET THE COLUMN WIDTHS FIRST
	//////////////////////////////////////////////////////////////
    this.columnWidths = new Array();
  	for(i=0; i<table.tBodies[0].rows[0].cells.length; i++) {
    	this.columnWidths[i] = table.tBodies[0].rows[0].cells[i].offsetWidth;
		if(this.isSafari) {
			this.columnWidths[i] += 10; // safari's text is wider/bolder
		}
        if(this.resizable) {
            this.columnWidths[i] += 5; // for the DIV resize elements
        }
    }

	// CREATE THE FRAMEWORK DOM
	//////////////////////////////////////////////////////////////
    this.sParent = table.parentNode;
    this.sParentHeight = this.sParent.clientHeight - (this.sParent.offsetHeight - this.sParent.clientHeight);
    this.sParentWidth = this.sParent.clientWidth - (this.sParent.offsetWidth - this.sParent.clientWidth);
    this.sParent.removeChild(table);
	
	var cloneDiv = document.createElement('DIV');
	this.sBase = cloneDiv.cloneNode(false);
	this.sFHeader = cloneDiv.cloneNode(false);
	this.sHeader = cloneDiv.cloneNode(false);
	this.sFData = cloneDiv.cloneNode(false);
	this.sData = cloneDiv.cloneNode(false);
	
	if(this.fixedCol) { this.sBase.appendChild(this.sFHeader); }
	this.sBase.appendChild(this.sHeader);
	if(this.fixedCol) { this.sBase.appendChild(this.sFData); }
	this.sBase.appendChild(this.sData);
	this.sParent.appendChild(this.sBase);
	
	// CREATE THE ROW 'MOLD'
	//////////////////////////////////////////////////////////////
    this.colCount = table.tBodies[0].rows[0].cells.length;
	var cloneRow = document.createElement('TR');
    if(this.fixedCol) {
        var fCloneRow = cloneRow.cloneNode(false);
        fCloneRow.appendChild(document.createElement('TD'));
        fCloneRow.childNodes[0].appendChild(document.createElement('DIV'));
    	for(i=0; i<this.colCount-1; i++) {
            cloneRow.appendChild(document.createElement('TD'));
    		cloneRow.childNodes[i].appendChild(document.createElement('DIV'));
    	}
    } else {
    	for(i=0; i<this.colCount; i++) {
            cloneRow.appendChild(document.createElement('TD'));
    		cloneRow.childNodes[i].appendChild(document.createElement('DIV'));
    	}
    }
	
    // CREATE THE HEADER DOM AND COPY THE HEADER DATA
	//////////////////////////////////////////////////////////////
    var n = 0;
	this.sHeaderTable = document.createElement('TABLE');
	this.sHeaderTable.appendChild(document.createElement('TBODY'));
    if(this.fixedCol) {
        this.sFHeaderTable = this.sHeaderTable.cloneNode(true);
        this.sFHeaderTable.tBodies[0].appendChild(fCloneRow.cloneNode(true));
        this.sHeaderTable.tBodies[0].appendChild(cloneRow.cloneNode(true));
        if(table.tHead) {
			if(table.tHead.rows[0].cells[0].childNodes.length > 0) {
				this.sFHeaderTable.tBodies[0].rows[0].cells[0].firstChild.appendChild(table.tHead.rows[0].cells[0].firstChild);
			} else {
				this.sFHeaderTable.tBodies[0].rows[0].cells[0].firstChild.innerHTML = '&nbsp;';
			}
			this.sFHeaderTable.tBodies[0].rows[0].cells[0].style.width = this.columnWidths[0] + 'px';
    		for(i=1; i<this.colCount; i++) {
                if(table.tHead.rows[0].cells[i].childNodes.length > 0) {
    				this.sHeaderTable.tBodies[0].rows[0].cells[i-1].firstChild.appendChild(table.tHead.rows[0].cells[i].firstChild);
    			} else {
    				this.sHeaderTable.tBodies[0].rows[0].cells[i-1].firstChild.innerHTML = '&nbsp;';
    			}
    			this.sHeaderTable.tBodies[0].rows[0].cells[i-1].style.width = this.columnWidths[i] + 'px';
    		}
        } else {
			if(table.tBodies[0].rows[0].cells[0].childNodes.length > 0) {
                this.sFHeaderTable.tBodies[0].rows[0].cells[0].firstChild.appendChild(table.tBodies[0].rows[0].cells[0].firstChild);
			} else {
				this.sFHeaderTable.tBodies[0].rows[0].cells[0].firstChild.innerHTML = '&nbsp;';
			}
			this.sFHeaderTable.tBodies[0].rows[0].cells[0].style.width = this.columnWidths[0] + 'px';
    		for(i=1; i<this.colCount; i++) {
                if(table.tBodies[0].rows[0].cells[i].childNodes.length > 0) {
                    this.sHeaderTable.tBodies[0].rows[0].cells[i-1].firstChild.appendChild(table.tBodies[0].rows[0].cells[i].firstChild);
    			} else {
    				this.sHeaderTable.tBodies[0].rows[0].cells[i-1].firstChild.innerHTML = '&nbsp;';
    			}
    			this.sHeaderTable.tBodies[0].rows[0].cells[i-1].style.width = this.columnWidths[i] + 'px';
    		}
            table.tBodies[0].removeChild(table.tBodies[0].rows[0]);
        }
    } else {
        this.sHeaderTable.tBodies[0].appendChild(cloneRow.cloneNode(true));
        if(table.tHead) {
    		for(i=0; i<this.colCount; i++) {
                if(table.tHead.rows[0].cells[i].childNodes.length > 0) {
    				this.sHeaderTable.tBodies[0].rows[0].cells[i].firstChild.appendChild(table.tHead.rows[0].cells[i].firstChild);
    			} else {
    				this.sHeaderTable.tBodies[0].rows[0].cells[i].firstChild.innerHTML = '&nbsp;';
    			}
    			this.sHeaderTable.tBodies[0].rows[0].cells[i].style.width = this.columnWidths[i] + 'px';
    		}
        } else {
    		for(i=0; i<this.colCount; i++) {
    			if(table.tBodies[0].rows[0].cells[i].childNodes.length > 0) {
    				this.sHeaderTable.tBodies[0].rows[0].cells[i].firstChild.appendChild(table.tBodies[0].rows[0].cells[i].firstChild);
    			} else {
    				this.sHeaderTable.tBodies[0].rows[0].cells[i].firstChild.innerHTML = '&nbsp;';
    			}
    			this.sHeaderTable.tBodies[0].rows[0].cells[i].style.width = this.columnWidths[i] + 'px';
    		}
            table.tBodies[0].removeChild(table.tBodies[0].rows[0]);
        }
    }
	
	// CREATE THE TABLE DOM
	//////////////////////////////////////////////////////////////
	this.sDataTable = document.createElement('TABLE');
	this.sDataTable.appendChild(document.createElement('TBODY'));
	this.sDataRows = new Array();
    if(this.fixedCol) {
        this.sFDataTable = this.sDataTable.cloneNode(true);
        this.sFDataRows = new Array();
        for(i=0; i<table.tBodies[0].rows.length; i++) {
            this.sFDataRows[i] = fCloneRow.cloneNode(true);
            this.sFDataRows[i].className = (i % 2 == 0) ? 'alt' : '';
            this.sDataRows[i] = cloneRow.cloneNode(true);
            this.sDataRows[i].className = (i % 2 == 0) ? 'alt' : '';
            if(i == 0) {
                this.sFDataRows[i].childNodes[i].style.width = this.columnWidths[0] + 'px';
    			for(j=1; j<this.colCount; j++) {
    				this.sDataRows[i].childNodes[j-1].style.width = this.columnWidths[j] + 'px';
    			}
            }
        }
    } else {
        for(i=0; i<table.tBodies[0].rows.length; i++) {
    		this.sDataRows[i] = cloneRow.cloneNode(true);
    		this.sDataRows[i].className = (i % 2 == 0) ? 'alt' : '';
            if(i == 0) {
    			for(j=0; j<this.colCount; j++) {
    				this.sDataRows[i].childNodes[j].style.width = this.columnWidths[j] + 'px';
    			}
    		}
        }
    }
	
	// FILL IN THE DATA
	//////////////////////////////////////////////////////////////
	this.sHeader.appendChild(this.sHeaderTable);
    if(this.fixedCol) {
        this.sFHeader.appendChild(this.sFHeaderTable);
        for(i=0; i<this.sDataRows.length; i++) {
            this.sDataTable.tBodies[0].appendChild(this.sDataRows[i]);
            this.sFDataTable.tBodies[0].appendChild(this.sFDataRows[i]);
			if(table.tBodies[0].rows[i].cells[0].childNodes.length > 0) {
				this.sFDataRows[i].childNodes[0].firstChild.appendChild(table.tBodies[0].rows[i].cells[0].firstChild);
        	} else {
				this.sFDataRows[i].childNodes[0].firstChild.innerHTML = '&nbsp;';
			}
            for(j=1; j<this.colCount; j++) {
    			if(table.tBodies[0].rows[i].cells[j].childNodes.length > 0) {
    				this.sDataRows[i].childNodes[j-1].firstChild.appendChild(table.tBodies[0].rows[i].cells[j].firstChild);
            	} else {
    				this.sDataRows[i].childNodes[j-1].firstChild.innerHTML = '&nbsp;';
    			}
    		}
        }
        this.sData.appendChild(this.sDataTable);
        this.sFData.appendChild(this.sFDataTable);
    } else {
    	for(i=0; i<this.sDataRows.length; i++) {
            this.sDataTable.tBodies[0].appendChild(this.sDataRows[i]);
            for(j=0; j<this.colCount; j++) {
    			if(table.tBodies[0].rows[i].cells[j].childNodes.length > 0) {
    				this.sDataRows[i].childNodes[j].firstChild.appendChild(table.tBodies[0].rows[i].cells[j].firstChild);
            	} else {
    				this.sDataRows[i].childNodes[j].firstChild.innerHTML = '&nbsp;';
    			}
    		}
    	}
    	this.sData.appendChild(this.sDataTable);
    }
	
	// STYLE/SKIN THE CONTAINERS
	//////////////////////////////////////////////////////////////
	this.sBase.className = 'sBase' + this.skin;
	this.sFHeader.className = 'sFHeader' + this.skin;
	this.sFHeader.style.width = this.columnWidths[0] + 'px';
	this.sHeader.className = 'sHeader' + this.skin;
	this.sFData.className = 'sFData' + this.skin;
	this.sFData.style.width = this.columnWidths[0] + 'px';
	this.sData.className = 'sData' + this.skin;
}


/////////////////////////////////////////////////////////////////////////////////////////
//  INITIATE DOM EVENTS
/////////////////////////////////////////////////////////////////////////////////////////
superTable.prototype.initiateDomEvents = function(x) {
	// SIZE THE CONTAINERS - using setTimeout because offsetWidth/offsetHeight is slowww
	//////////////////////////////////////////////////////////////
	if(this.fixedCol) {
        setTimeout("sT["+x+"].sHeader.style.right = (sT["+x+"].sFHeaderTable.offsetWidth * -1) + 'px'; sT["+x+"].sData.style.marginLeft = sT["+x+"].sFDataTable.offsetWidth + 'px'; sT["+x+"].sData.style.width = (sT["+x+"].sParentWidth - sT["+x+"].sFHeaderTable.offsetWidth) + 'px'; sT["+x+"].sData.style.height = (sT["+x+"].sParentHeight - sT["+x+"].sHeaderTable.offsetHeight) + 'px'; sT["+x+"].sData.style.overflow='auto'; sT["+x+"].drawOverflowBorders("+x+");", 1);
    } else {
        setTimeout("sT["+x+"].sData.style.height = (sT["+x+"].sParentHeight - sT["+x+"].sHeaderTable.offsetHeight) + 'px'; sT["+x+"].sData.style.overflow='auto'; sT["+x+"].drawOverflowBorders("+x+");", 1);
    }
    
	// INITIATE SCROLL EVENTS
	//////////////////////////////////////////////////////////////
    if(this.fixedCol) {
        this.sData.onscroll = function() {
            sT[x].sHeader.style.right = (sT[x].sData.scrollLeft - sT[x].sFHeaderTable.offsetWidth) + 'px';
            sT[x].sFData.style.top = ((sT[x].sData.scrollTop * -1) + sT[x].sFHeaderTable.offsetHeight) + 'px';
            return true;
        }
    } else {
        this.sData.onscroll = function() {
        	sT[x].sHeader.style.right = sT[x].sData.scrollLeft + 'px';
    		return true;
        }
    }
    
	// SETUP THE RESIZE DOM AND INITIATE EVENTS
	//////////////////////////////////////////////////////////////
    if(this.resizable) {
        setTimeout("sT["+x+"].setupColResizing("+x+");", 1);
    }
}


/////////////////////////////////////////////////////////////////////////////////////////
//  DRAW OVERFLOW BORDERS (adjacent to the overflow scrollbars)
/////////////////////////////////////////////////////////////////////////////////////////
superTable.prototype.drawOverflowBorders = function(x) {
    if(this.fixedCol) {
		if(this.sData.clientWidth < this.sDataTable.clientWidth) {
			if(document.getElementById('sHorOverflow' + x)) {
				this.sHorOverflow.style.width = this.sFDataTable.offsetWidth + 'px';
			} else {
				this.sHorOverflow = document.createElement('DIV');
				this.sHorOverflow.id = 'sHorOverflow' + x;
				this.sHorOverflow.className = 'sHorOverflow';
				this.sHorOverflow.style.width = this.sFDataTable.offsetWidth + 'px';
				this.sBase.appendChild(this.sHorOverflow);
			}
		} else if(document.getElementById('sHorOverflow' + x)) {
			this.sBase.removeChild(this.sHorOverflow);
		}
    }
	if(this.sData.clientHeight < this.sDataTable.clientHeight) {
        if(document.getElementById('sVertOverflow' + x) == null) {
    		this.sVertOverflow = document.createElement('DIV');
    		this.sVertOverflow.id = 'sVertOverflow' + x;
    		this.sVertOverflow.className = 'sVertOverflow';
    		this.sVertOverflow.style.height = this.sHeaderTable.offsetHeight + 'px';
    		this.sBase.appendChild(this.sVertOverflow);
        }
	} else if(document.getElementById('sVertOverflow' + x)) {
		this.sBase.removeChild(this.sVertOverflow);
    }
}


/////////////////////////////////////////////////////////////////////////////////////////
//  SETUP COLUMN RESIZING
/////////////////////////////////////////////////////////////////////////////////////////
superTable.prototype.setupColResizing = function(x) {
    this.minColumnWidthAllowed = 10; // in pixels
	this.maxColumnWidthAllowed = parseInt(this.sParentWidth*0.5); // in pixels
    
    var resizeA = document.createElement('A');
    resizeA.className = 'sResizeA';
    resizeA.style.height = this.sHeaderTable.tBodies[0].rows[0].cells[0].firstChild.clientHeight + 'px';
    resizeA.innerHTML = '&nbsp;'
    
    for(i=0; i<this.colCount; i++) {
        var resizer = resizeA.cloneNode(true);
        if(this.fixedCol) { 
            if(i == 0) {
                this.sFHeaderTable.tBodies[0].rows[0].cells[i].insertBefore(resizer, this.sFHeaderTable.tBodies[0].rows[0].cells[i].firstChild);
                resizer.style.marginLeft = this.sFHeaderTable.tBodies[0].rows[0].cells[i].childNodes[1].clientWidth + 'px';
             } else {
                this.sHeaderTable.tBodies[0].rows[0].cells[i-1].insertBefore(resizer, this.sHeaderTable.tBodies[0].rows[0].cells[i-1].firstChild);
                resizer.style.marginLeft = this.sHeaderTable.tBodies[0].rows[0].cells[i-1].childNodes[1].clientWidth + 'px';
             }
        } else {
            this.sHeaderTable.tBodies[0].rows[0].cells[i].insertBefore(resizer,  this.sHeaderTable.tBodies[0].rows[0].cells[i].firstChild);
            resizer.style.marginLeft = this.sHeaderTable.tBodies[0].rows[0].cells[i].childNodes[1].clientWidth + 'px';
        }
        resizer.onmousedown = function(e) {
            sT[x].startResizeColumn(x, e);
        }
    }
}


/////////////////////////////////////////////////////////////////////////////////////////
//  START RESIZE COLUMN
/////////////////////////////////////////////////////////////////////////////////////////
superTable.prototype.startResizeColumn = function(x, e) {
    if (window.event) { e = window.event; var resizeA = e.srcElement; e.cancelBubble = true; } else { var resizeA = e.target; e.stopPropagation(); }
    resizeA.className = 'sResizeA sResizeAActive';
    resizeA.style.height = (this.sData.clientHeight < this.sDataTable.clientHeight) ? (this.sParentHeight - 15) + 'px' : this.sParentHeight + 'px';

    this.xStart = e.clientX;
    var hCol = getTargetedParentObject(resizeA, 'TD'); // TD since TD determines the width
    var colIndex = '';
    for(i=0; i<this.sHeaderTable.tBodies[0].rows[0].cells.length; i++) {
        if(this.sHeaderTable.tBodies[0].rows[0].cells[i] == hCol) { colIndex = i; }
    }
    if(this.fixedCol) {
        if(this.sFHeaderTable.tBodies[0].rows[0].cells[0] == hCol) {
            colIndex = 0;
            var dCol = this.sFDataTable.tBodies[0].rows[0].cells[colIndex];
        } else {
            colIndex += 1;
            var dCol = this.sDataTable.tBodies[0].rows[0].cells[colIndex-1];
        }
    } else {
        var dCol = this.sDataTable.tBodies[0].rows[0].cells[colIndex];
	}
    this.resizeColumnRefFunction = function(e) { sT[x].resizeColumn(resizeA, colIndex, e); }; // set as an object variable so it can be referenced later for removal
	this.endResizeColumnRefFunction = function(e) { sT[x].endResizeColumn(resizeA, x, hCol, dCol, colIndex, e); };
	if(window.addEventListener) {
		document.addEventListener('mousemove', this.resizeColumnRefFunction, true);
		document.addEventListener('mouseup', this.endResizeColumnRefFunction, true);
	} else {
		document.attachEvent('onmousemove', this.resizeColumnRefFunction);
		document.attachEvent('onmouseup', this.endResizeColumnRefFunction);
	}
	return false;
}


/////////////////////////////////////////////////////////////////////////////////////////
//  RESIZE COLUMN
/////////////////////////////////////////////////////////////////////////////////////////
superTable.prototype.resizeColumn = function(resizeDiv, colIndex, e) {
    if (window.event) { e = window.event; e.cancelBubble = true; } else { e.stopPropagation(); }
    if(window.getSelection) { window.getSelection().removeAllRanges(); } else { document.selection.empty(); }
    
    var testWidth = this.columnWidths[colIndex] + (e.clientX - this.xStart);
    if(testWidth < this.minColumnWidthAllowed) {
        this.columnWidths[colIndex] = this.minColumnWidthAllowed;
    } else if(testWidth > this.maxColumnWidthAllowed) {
        this.columnWidths[colIndex] = this.maxColumnWidthAllowed;
    } else {
        this.columnWidths[colIndex] = testWidth;
        this.xStart = e.clientX;
    }
    
    if(this.fixedCol) {
        if(colIndex == 0) {
            this.sFHeaderTable.tBodies[0].rows[0].cells[colIndex].firstChild.style.marginLeft = (this.isSafari) ? (this.columnWidths[colIndex] - 8) + 'px' : this.columnWidths[colIndex] + 'px';
        } else {
            this.sHeaderTable.tBodies[0].rows[0].cells[colIndex-1].firstChild.style.marginLeft = (this.isSafari) ? (this.columnWidths[colIndex] - 8) + 'px' : this.columnWidths[colIndex] + 'px';
        }
    } else {
        this.sHeaderTable.tBodies[0].rows[0].cells[colIndex].firstChild.style.marginLeft = (this.isSafari) ? (this.columnWidths[colIndex] - 8) + 'px' : this.columnWidths[colIndex] + 'px';
    }
    
    return false;
}


/////////////////////////////////////////////////////////////////////////////////////////
//  END RESIZE COLUMN
/////////////////////////////////////////////////////////////////////////////////////////
superTable.prototype.endResizeColumn = function(resizeA, x, hCol, dCol, colIndex, e) {
    if (window.event) { e = window.event; e.cancelBubble = true; } else { e.stopPropagation(); }
    if(window.getSelection) { window.getSelection().removeAllRanges(); } else { document.selection.empty(); }
    resizeA.className = 'sResizeA';
    resizeA.style.height = this.sHeaderTable.tBodies[0].rows[0].cells[0].childNodes[1].clientHeight + 'px';
    
    hCol.style.width = this.columnWidths[colIndex] + 'px';
    dCol.style.width = this.columnWidths[colIndex] + 'px';
    if(this.isOpera) { // Opera does not redraw the tables with the new widths... not sure why -- assigning a new class will force redraw
        if(this.fixedCol) {
            this.sFHeaderTable.className = 'sRand' + parseInt(Math.random()*10000);
            this.sFDataTable.className = 'sRand' + parseInt(Math.random()*10000);
        } else {
            this.sHeaderTable.className = 'sRand' + parseInt(Math.random()*10000);
            this.sDataTable.className = 'sRand' + parseInt(Math.random()*10000);
        }
    }
    
    this.sHeader.style.right = (this.fixedCol) ? (this.sData.scrollLeft - this.sFHeaderTable.offsetWidth) + 'px' : this.sData.scrollLeft + 'px';
    if(this.fixedCol) {
        this.sData.style.marginLeft = this.sFDataTable.offsetWidth + 'px'; 
        this.sData.style.width = (this.sParentWidth - this.sFHeaderTable.offsetWidth) + 'px';
        sT[x].drawOverflowBorders(x);
    }
    
    if(this.isSafari) { // Safari fix where the resize anchors sometimes cannot be grabbed after resizing a column
        if(this.fixedCol) {
            this.sFHeaderTable.tBodies[0].rows[0].cells[0].removeChild(this.sFHeaderTable.tBodies[0].rows[0].cells[0].firstChild);
        }
        for(i=0; i<this.sHeaderTable.tBodies[0].rows[0].cells.length; i++) {
            this.sHeaderTable.tBodies[0].rows[0].cells[i].removeChild(this.sHeaderTable.tBodies[0].rows[0].cells[i].firstChild);
        }
        sT[x].setupColResizing(x);
    }
    
	if(window.addEventListener) {
		document.removeEventListener('mousemove', this.resizeColumnRefFunction, true);
		document.removeEventListener('mouseup', this.endResizeColumnRefFunction, true);
	} else {
		document.detachEvent('onmousemove', this.resizeColumnRefFunction);
		document.detachEvent('onmouseup', this.endResizeColumnRefFunction);
	}
    
    return false;
}


/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
function getTargetedParentObject(childEl, tagName) {
    while(childEl.tagName != tagName && childEl.tagName != 'BODY') {
        childEl = childEl.parentNode;
    }
    return childEl;
}


