/* This script and many more are available free online at
   The JavaScript Source!! http://javascript.internet.com
   Created by: JTricks.com | http://www.jtricks.com/Licensed under: U.S. Copyright
   Version: 20060105
   Latest version:
   www.jtricks.com/javascript/navigation/annotations.html */


// Adds DIV tags containing the ANCHORs' titles

function add_titles(cls) {
  var as = document.getElementsByTagName('a');
  var i = 0;

  // Traverse all the ANCHOR tags
  while (i < as.length) {
    var a = as.item(i);
    i++;

    // Check if the tag's class is what we have to alter.
    if (a.className != cls) {
      continue;
    }

    // Check if the next DIV already contains the title
    if (a.nextSibling &&
        a.nextSibling.nodeName == 'DIV' &&
        a.nextSibling.firstChild &&
        a.nextSibling.firstChild.nodeName == '#text' &&
        a.nextSibling.firstChild.nodeValue == a.title) {
      continue;
    }

    var title = document.createElement("div");
    title.appendChild(document.createTextNode(a.title));
    a.parentNode.insertBefore(title, a.nextSibling);
  }
}

// Removes DIV tags containing the ANCHORs' titles

function remove_titles(cls) {
  var as = document.getElementsByTagName('a');
  var i = 0;

  // Traverse all the ANCHOR tags
  while (i < as.length) {
    var a = as.item(i);
    i++;

    // Check if the tag's class is what we have to alter.
    if (a.className != cls) {
      continue;
    }

    // Remove the next DIV containing the anchor title
    if (a.nextSibling &&
        a.nextSibling.nodeName == 'DIV' &&
        a.nextSibling.firstChild &&
        a.nextSibling.firstChild.nodeName == '#text' &&
        a.nextSibling.firstChild.nodeValue == a.title)
    {
    a.parentNode.removeChild(a.nextSibling);
    }
  }
}

function toggle_titles() {
  // ####  Change this to actual ANCHOR tag class  ####
  var anchorsClassName = 'linkDemo';
  var box = document.getElementById('toggle_titles_checkbox');

  if (box.checked)
    add_titles(anchorsClassName);
  else
    remove_titles(anchorsClassName);
}

// Handle the old user agents - no checkbox
// will appear if the user agent doesn't support DOM2.
function createTitles() {
  if (document.getElementsByTagName) {
    document.write('<input id="toggle_titles_checkbox" type="checkbox" ' + 'onclick="toggle_titles()">Mosta le descizioni dei link');
    if (window.addEventListener)
      window.addEventListener("load", toggle_titles, false);
    else if (window.addEvent)
      window.addEvent("load", toggle_titles);
  }
}
