// Created and set free in July of 2007 by Jenna ‘Blueberry’ Fox <blueberry@creativepony.com>
// Released as public domain, with the request that credit is given for my contribution
// Also, I'd love to here where you've used or changed this code to do other interesting things!
// Requires MooTools 1.0 or newer with Accordion and Event

var AutoAccordion = Accordion.extend({
	initialize: function(handles, drawers, options) {
		this.addEvent('onActive', function(handle, i) {
			handle.addClass('selected');
		});
		this.addEvent('onBackground', function(handle, i) {
			handle.removeClass('selected');
		});
		
		// run parent initializer
		this.parent.apply(this, arguments);
		
		// this next part adds the automatic opening magic to each “Handle”
		this.togglers.each(function(handle, index, array) {
			// and the magic hover opening dealie!
			handle.hoverOpenTimer = null
			handle.getElement('a').addEvents({
				mouseover: function(thisHandle) {
					thisHandle.hoverOpenTimer = $clear(thisHandle.hoverOpenTimer);
					thisHandle.hoverOpenTimer = this.display.delay(300, this, index);
				}.bind(this, handle),
				mouseout: function(thisHandle) {
					thisHandle.hoverOpenTimer = $clear(thisHandle.hoverOpenTimer);
				}.bind(this, handle),
				focus: this.display.pass(index, this) // supports tab based keyboard navigation
			});
		}.bind(this));
	}
});