/* This script and many more are available free online at
The JavaScript Source!! http://javascript.internet.com
Created by: Steve Chipman | http://slayerofficeLicensed under: Creative Commons License
 */

var links = new Array();
var categories = new Array();
var searchFilter = "Any";

function init() {
  initLinks();
  buildCategoryArray();
  selectHeight = categories.length + 1;
  links.sort();
  drawSelect();
  buildCategoryList();
}

function initLinks() {
  // name, links, category
  links[0] = new Array("Fark","http://www.fark.com","News");
  links[1] = new Array("Centricle","http://centricle.com","Friends");
  links[2] = new Array("Slayeroffice","http://slayeroffice.com","Friends");
  links[3] = new Array("BBspot","http://www.bbspot.com","Satire");
  links[4] = new Array("GameSpot","http://www.gamespot.com","Gaming");
  links[5] = new Array("The Onion","http://www.theonion.com","Satire");
  links[6] = new Array("Javascript-games.org","http://www.javascript-games.org","Gaming");
  links[7] = new Array("TheWebMachine","http://www.thewebmachine.com","Web Design and Development");
  links[8] = new Array("KVIII","http://www.kviii.com","Friends");
  links[9] = new Array("A List Apart","http://www.alistapart.com","Web Design and Development");
  links[10] = new Array("Red vs. Blue","http://www.redvsblue.com","Entertainment");
  links[11] = new Array("Satirewire","http://www.satirewire.com","Satire");
  links[12] = new Array("Caster's Realm","http://eq.castersrealm.com","Gaming");
  links[13] = new Array("Linux Online","http://www.linux.org/","Computers");
  links[14] = new Array("Dev Edge","http://devedge.netscape.com/","Web Design and Development");
  links[15] = new Array("Tech TV","http://www.techtv.com","Entertainment");
  links[16] = new Array("Brain Jar","http://www.brainjar.com","Web Design and Development");
  links[17] = new Array("Webmonkey","http://www.webmonkey.com","Web Design and Development");
  links[18] = new Array("W3C.org","http://www.w3c.org","Web Design and Development");
  links[19] = new Array("Builder.com","http://builder.cnet.com/","Web Design and Development");
  links[20] = new Array("Bioware","http://www.bioware.com","Gaming");
  links[21] = new Array("Adobe","http://www.adobe.com","Web Design and Development");
  links[22] = new Array("AO Basher","http://www.ao-basher.com","Gaming");
  links[23] = new Array("SWG","http://starwarsgalaxies.station.sony.com/","Gaming");
  links[24] = new Array("Brutal News","http://www.brutalnews.com","News");
  links[25] = new Array("AOLserver","http://www.aolserver.com/","Web Design and Development");
  links[26] = new Array("Apache.org","http://www.apache.org","Web Design and Development");
  links[27] = new Array("PHP.net","http://www.php.net","Web Design and Development");
  links[28] = new Array("MSDN","http://msdn.microsoft.com","Web Design and Development");
  links[29] = new Array("Java Boutique","http://javaboutique.internet.com/","Web Design and Development");
  links[30] = new Array("EQ Vault","http://eqvault.ign.com/","Gaming");
  links[31] = new Array("Google","http://www.google.com","Search Engines");
  links[32] = new Array("Alta Vista","http://www.altavista.com","Search Engines");
  links[33] = new Array("Hotbot","http://www.hotbot.com","Search Engines");
  links[34] = new Array("Ask Jeeves","http://www.ask.com","Search Engines");
  links[35] = new Array("CNN","http://www.cnn.com","News");
  links[36] = new Array("MSNBC","http://www.msnbc.com","News");
  links[37] = new Array("Washington Post","http://www.washingtonpost.com","News");
  links[38] = new Array("New York Times","http://www.nytimes.com","News");
  links[39] = new Array("AOL","http://www.aol.com","Online Services");
  links[40] = new Array("MSN","http://www.msn.com","Online Services");
  links[41] = new Array("Earthlink","http://www.earthlink.net","Online Services");
  links[42] = new Array("Compuserve","http://www.compuserve.com","Online Services");
  links[43] = new Array("MSIE","http://www.microsoft.com/windows/ie/default.asp","Browsers");
  links[44] = new Array("Mozilla","http://www.mozilla.org","Browsers");
  links[45] = new Array("Opera","http://www.opera.com","Browsers");
  links[46] = new Array("Netscape","http://www.netscape.com","Browsers");
  links[47] = new Array("Safari","http://www.apple.com/safari/download/","Browsers");
  links[48] = new Array("Konquerer","http://www.konqueror.org/","Browsers");
  links[49] = new Array("Lynx","http://lynx.browser.org/","Browsers");
}

function drawSelect() {
  mHTML = "<select name=\"lists\" class=\"sel\" size=" + selectHeight + ">";
  for(i=0;i<links.length;i++) {
    if(searchFilter == "Any") {
      mHTML+="<option title=\"test\" value=\"" + links[i][1] + "\">" + links[i][0] + "</option>";
    } else {
      if(links[i][2] == searchFilter)mHTML+="<option value=\"" + links[i][1] + "\">" + links[i][0] + "</option>";
    }
  }
  mHTML+="</select>";
  document.getElementById("mContainer").innerHTML = mHTML;
}

function narrowList(searchString) {
  resultsFound = 0;
  searchString = searchString.toLowerCase();
  mHTML = "<select size=" + selectHeight + " class=\"sel\" name=\"lists\">";
  found=false;
  partialStringMatching = document.forms[0].psm.checked;
  for(i=0;i<links.length;i++) {
    zLink = links[i][0].toLowerCase();
    if((partialStringMatching && zLink.indexOf(searchString)>-1) || (zLink.indexOf(searchString) == 0 && (links[i][2] == searchFilter || searchFilter == "Any"))) {
      found=true;
      resultsFound++;
      mHTML+="<option value=\"" + links[i][1] + "\">" + links[i][0] + "</option>";
    }
  }
  mHTML+="</select>";
  if(found)document.getElementById("mContainer").innerHTML = mHTML
  showResults(resultsFound,searchString);
}

function showResults(zResultsFound,zSearchString) {
  zHTML = "";
  zHTML += "<b>" + zResultsFound + "</b> results found";
  if(zSearchString != "") zHTML += " for search term <b>" + zSearchString + "</b>";
  zHTML += " in category <b>" + searchFilter + "</b>";
  if(zResultsFound==0) zHTML+=" so listing what was found.";
  document.getElementById("mResults").innerHTML = zHTML;
}

function buildCategoryArray() {
  for(i=0;i<links.length;i++)if(!existsInArray(categories,links[i][2])) categories[categories.length] = links[i][2];
  categories.sort();
}

function buildCategoryList() {
  zHTML = "<select size=" + selectHeight + " name=\"cats\" class=\"sel\" onClick=\"handleCategoryClick(this.value);\">";
  zHTML += "<option value=\"Any\">Any</option>";
  for(i=0;i<categories.length;i++)  zHTML+="<option value=\"" +categories[i] + "\">" + categories[i] + "</option>";
  zHTML+= "</select>";
  document.getElementById("nContainer").innerHTML = zHTML;
}

function existsInArray(arrayToCheck,valueToCheck) {
  for(z=0;z<arrayToCheck.length;z++)if(arrayToCheck[z] == valueToCheck) { return true; break; }
  return false;
}

function handleCategoryClick(sValue) {
  searchFilter = sValue;
  drawSelect();
  narrowList(document.forms[0].searchText.value);
}

function handleClear() {
  document.forms[0].searchText.value="";
  narrowList("");
}

function handleGoClick() {
  if(document.forms[0].lists.value)location.href = document.forms[0].lists.value;
}

// Multiple onload function created by: Simon Willison
function addLoadEvent(func) {
  var oldonload = window.onload;
  if (typeof window.onload != 'function') {
    window.onload = func;
  } else {
    window.onload = function() {
      if (oldonload) {
        oldonload();
      }
      func();
    }
  }
}

addLoadEvent(function() {
  init();
});
