/* FavoriteIcon v1.1 - 5 May 09 (http://blog.liviuholhos.com/javascript/add-a-favicon-near-external-links-with-jquery)
 * Author : Liviu Holhos (http://www.liviuholhos.com/) */
(function($){
	$.fn.favoriteIcon = function(options) {
		var defaults = {
			iconClass    : 'favoriteIcon',
			insertMethod : 'appendTo',
			iconSearched : 'favicon.ico'
		};
		var options = $.extend(defaults, options);
	
		$(this).filter(function(){
			return this.hostname && this.hostname !== location.hostname;
		}).each(function() {
			var link = jQuery(this);
			var faviconURL = link.attr('href').replace(/^(http:\/\/[^\/]+).*$/, '$1')+'/'+options.iconSearched;
			var faviconIMG = jQuery('<img class="'+options.iconClass+'" src="" alt="" />')[options.insertMethod](link);
			var extImg = new Image();
			extImg.src = faviconURL;
			if (extImg.complete)
				faviconIMG.attr('src', faviconURL);
			else
				extImg.onload = function() { faviconIMG.attr('src', faviconURL); };
		});
	}
})(jQuery);