(function($){  
 $.toaster = function(options) {  
    
    var defaults = {  
	   showTime:1000, //Time visible in milliseconds
	   center:false
	};  
	
	var options = $.extend(defaults, options);  
	
	var isQue = false; //is there a que?
	
	//create container
	var container = $('<div class="toast-container"></div>').appendTo('body');
	container.hide();
	var que = new Array();
	
	this.toast = function(text)
	{
		que.push(text);
		if(!isQue)
			NextToast();
	}
	
	function ShowToast(text)//show a toast
	{
		container.hide().text(text);
		CenterContainer();
		container.fadeIn(function(){
			setTimeout(HideToast, options.showTime);
		});
	}
	
	function CenterContainer() //center the container
	{
		container.css("margin-left","50%");
		container.css("left","-"+container.outerWidth()/2+"px");
	}
	
	function HideToast()//hide current toast
	{
		container.fadeOut(function(){
			que.shift();
			NextToast();
		});
	}
	
	function NextToast() //show next toast in que
	{
		isQue = que.length > 0;
		if(isQue)
			ShowToast(que[0]);
	}
	
	return this;
 };  
})(jQuery);  