/*
 * DragScroller - jQuery Plugin
 * version: 1.00 (2011/04/15)
 * Created by: digitalillusion
 *
 * Dual licensed under the MIT (http://github.com/jquery/jquery/blob/master/MIT-LICENSE.txt)
 * and GPL (http://github.com/jquery/jquery/blob/master/GPL-LICENSE.txt) licenses.
 * 
 */

(function($) {
  var dragScroller;
  var methods = {
    init : function (objectsQuery) {
      dragScroller = new DragScroller(this.selector, objectsQuery);
      return this;
    },
    jumpTo : function(xdrag, ydrag) { 
      dragScroller.jumpTo(xdrag, ydrag);
    },
    setObjectsQuery : function(objectsQuery) {
      dragScroller.setObjectsQuery(objectsQuery);
    },
    setAttrition : function(attrition) {
      dragScroller.setAttrition(attrition);
    }
  };

  $.fn.dragScroller = function( method ) {
    
    // Method calling logic
    if ( methods[method] ) {
      return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
    } else if ( typeof method === 'object' || ! method ) {
      return methods.init.apply( this, arguments );
    } else {
      $.error( 'Method ' +  method + ' does not exist on jQuery.dragScroller' );
    }    
  
  };

  function DragScroller(canvasQuery, objectsQuery) {
    var self = this;
    this.canvas         = "";
    this.objects        = "";
    this.dragging       = false;
    this.xstart         = 0;
    this.ystart         = 0;
    this.attrition      = 0.2;
    this.smoothScrollIntv = null;
    this.jumpTo = function (xdrag, ydrag) {
      // Get bg position prior to set it
      var bgx = self._getBgPosition()[0];
      var bgy = self._getBgPosition()[1];
      
      if($.browser.msie) {
        $(self.canvas).css("background-position-x", xdrag + "px ");
        $(self.canvas).css("background-position-y", ydrag + "px ");
      } else {
        $(self.canvas).css("background-position", xdrag + "px " + ydrag + "px");
      }
   
      // Calculate delta with the old background position
      var xdelta = xdrag - bgx;
      var ydelta = ydrag - bgy;
      $(self.objects).each(function(){
        $(this).css('left', (self._cssToNum($(this).css('left')) + xdelta) + "px");
        $(this).css('top', (self._cssToNum($(this).css('top')) + ydelta) + "px");
      });
    };
    this.setObjectsQuery = function(objectsQuery) {
      self.objects = objectsQuery;
    };
    this.setAttrition = function(attrition) {
      self.attrition = attrition;
    };
    this._getBgPosition = function () {
      if($.browser.msie) {
        var bgx = $(self.canvas).css("background-position-x");
        var bgy = $(self.canvas).css("background-position-y");
        return Array(
            self._cssToNum(bgx, 10),
            self._cssToNum(bgy, 10)
        );
      } else {
        var bg = $(self.canvas).css("background-position").split(" ");
        return Array(
            self._cssToNum(bg[0], 10),
            self._cssToNum(bg[1], 10)
        );
      }
    };
    this._cssToNum = function (css) {
      css = css.replace("auto", "0");
      css = css.replace("px", "");
      return parseFloat(css);
    };
    this._dragStart = function (e) {
      self.dragging = true;
      clearInterval(self.smoothScrollIntv);
      
      self.xstart = e.pageX;
      self.ystart = e.pageY;
      var xhold = self.xstart - self._getBgPosition()[0];
      var yhold = self.ystart - self._getBgPosition()[1];
      
      $(self.canvas).mousemove(function(e){
        if (self.dragging){
          var xdrag = e.pageX - xhold;
          var ydrag = e.pageY - yhold;
          self.jumpTo(xdrag, ydrag);
        }
        // Periodically move start drag position to current cursor position
        var dirVec = Array(
            e.pageX - self.xstart, 
            e.pageY - self.ystart
          );
        if(!(dirVec[0] == 0 && dirVec[1] == 0)) {
          var norm = Math.sqrt(dirVec[0]*dirVec[0] + dirVec[1]*dirVec[1]);
          dirVec = Array(dirVec[0]/norm, dirVec[1]/norm);
          self.xstart += dirVec[0]*norm*0.5;
          self.ystart += dirVec[1]*norm*0.5;
        }
      });
    };
    this._dragEnd = function (e) {
      if(self.dragging) {
        self.dragging = false; 

        var speedVec = Array(
          e.pageX - self.xstart, 
          e.pageY - self.ystart
        );

        if(!(speedVec[0] == 0 && speedVec[1] == 0)) {
          var norm = Math.sqrt(speedVec[0]*speedVec[0] + speedVec[1]*speedVec[1]);
          speedVec = Array(speedVec[0]/norm, speedVec[1]/norm);
          clearInterval(self.smoothScrollIntv);
          self.smoothScrollIntv = setInterval(function() {
            norm *= 1 - self.attrition;
            if(norm < 1) {
              clearInterval(self.smoothScrollIntv);
            } else {
              self.jumpTo(
                  self._getBgPosition()[0] + speedVec[0]*norm,
                  self._getBgPosition()[1] + speedVec[1]*norm
              );
            }
          }, 50);
        }
      }
    };
    $(canvasQuery+", "+objectsQuery).mousedown(function(e){
      self._dragStart(e);
    });

    $(":not(."+objectsQuery+")").mouseup(function(e){
      self._dragEnd(e);
    });
    
    $(canvasQuery).bind("dragstart", function() {
      return false;
    });
    this.canvas = canvasQuery;
    this.objects = objectsQuery;

    this.jumpTo(
      this._cssToNum($(canvasQuery).css('width'))*0.5,
      this._cssToNum($(canvasQuery).css('height'))*0.5
    );
  }
}) (jQuery);
