/*
 * jQuery scratchDiv plugin
 * Version 1.0.0 (22/12/2010)
 * @requires jQuery v1.3+
 * Ferjani Sadok : "My first plugin jQuery"
 * @ website : http://jquery.kolchay.com
 */
(function( $ ){    
    $.fn.scratchDiv  = function(options, _init) {
        //Default Settings : 
        var settings = {
            nbXDivs    : '6',    // Number of Vertical mini-divs that be showed in selected element,
            loopValue     : '5',    // Number of time that each mini-div will change color,
            delayTime     :  '0',   // Timer delay beetween each mini-div to change color,
            opacityDivs    :  "0.97", // Opacity for each mini-divs,
            colorsDivs    : [       // Array contain the colors of mini-divs,
                                "#8C0000",
                                "#383838",
                                "#6B6350",
                                "#171717",
                                "#8C8282",
                                "#161616",
                                "#C2C1A3",
                                "#50789C"
                                ],
            miniDivsCss    :{       // CSS attributs for each mini-divs,
                                "float"     :   "left",
                                "overflow"  :   "auto",
                                "position"  :   "absolute"
                             } ,
            onStart        : function(e){   // function to run just before start animation,
                $.noop()
            },
            onFinish       : function(e){   // function to run just after start animation,
                $.noop()
            }
        };
        
        if ( options ) {
            $.extend( settings, options );
        }
        var roundNumber = function (num, dec) {
            dec = dec || 0;            
            var result = Math.round(num*Math.pow(10,dec))/Math.pow(10,dec);
            return result;
        }
        // init function to create all mini-divs,
        var initFunction =function (){
            var _height = $(this).height() ;
            var _width = $(this).innerWidth() ;
            
            var DivsWidth = roundNumber(_width/settings.nbXDivs,2);
            var DivsHeight = roundNumber(_height/settings.nbXDivs,2);
            var nbDivsHeight = roundNumber(_height/DivsHeight);
            
            var leftPosition = 0 ;
            var topPosition = 0 ;           
            
            nbDivsHeight = nbDivsHeight ? nbDivsHeight : 1 ;
            settings.miniDivsCss.height = DivsHeight ;
            settings.miniDivsCss.width  =  DivsWidth;
            //  $("#divdebug").append("<br> - "+DivsHeight);
            var nbDivsTotal  = settings.nbXDivs*nbDivsHeight ;
            $(this).data({
                "nbDivs": nbDivsTotal
            }).css({
                "position" :   "relative"
            });

            _width -= DivsWidth - 1;
           
            for(var i = 0 ; i< nbDivsTotal; i++){
                var miniDivs = $("<div class='miniDivsScratch'/>").css(settings.miniDivsCss);
                miniDivs.css({
                    "left" : leftPosition,
                    "opacity"  : settings.opacityDivs,
                    "top" : topPosition
                });
                             
                if((leftPosition+DivsWidth) < _width){
                    leftPosition = roundNumber(leftPosition + DivsWidth,2);
                }else{                    
                    topPosition  =  roundNumber(topPosition + DivsHeight,2);
                    leftPosition = 0 ;
                }
                $(this).append(miniDivs);
            }
        };
        // function to run animation effect to each mini-divs
        var animateThis =  function (_this,settings){            
            var tabSpeed    = new Array("slow", "fast");
            var speedRand   = Math.floor(Math.random()* 2);
            var speed       = tabSpeed[speedRand];
            var colorRand   = Math.floor(Math.random() * settings.colorsDivs.length)
            var colored     = {
                "background" : settings.colorsDivs[colorRand]
            };                                    
            $(_this).css(settings.miniDivsCss).css(colored);
            $(_this).fadeTo(speed,settings.opacityDivs,function(){
                if(settings.loopValue > 0 ){                     
                    $(_this).delay(settings.delayTime).scratchDiv.call(_this,settings,_init);                    
                }else{                                        
                    $(_this).fadeOut("slow");
                    var nbDivsTotal = $(_this).parent().data("nbDivs");
                    --nbDivsTotal;
                    $(_this).parent().data({
                        "nbDivs": nbDivsTotal
                    });                    
                    var _currentDiv = $(_this).parent();                    
                    if(nbDivsTotal  ==  0){
                        settings.onFinish.call(this,_currentDiv);
                        _currentDiv.removeData("nbDivs");
                        _currentDiv.find("div.miniDivsScratch").remove();
                    }                    
                }
            });
        }
        if( ! _init ){
            settings.onStart.call(this,this);
            initFunction.call(this);
            _init = 1 ;
            var listDivs    = $(this).find("div") ;
            for(var cp = 0; cp < listDivs.length; cp++){
                animateThis(listDivs[cp],settings);
            }
        }else{
            settings.loopValue = settings.loopValue - 1;                        
            animateThis(this,settings);          
        }

    }
})( jQuery );