/* This script and many more are available free online at
The JavaScript Source :: http://javascript.internet.com
Created by: Tom Hermansson Snickars :: http://carpe.ambiprospect.com/ */

//------------------------------------------+
//  CARPE  S l i d e r  v. 1.5  2006-01-03  |
//  By Tom Hermansson Snickars              |
//  Copyright CARPE Design                  |
//  http://carpe.ambiprospect.com/          |
//------------------------------------------+

var carpeDefaultSliderLength      = 100
var carpeSliderDefaultOrientation = 'horizontal'
var carpeSliderClassName          = 'carpe_slider'
var carpeSliderDisplayClassName   = 'carpe_slider_display'

function carpeGetElementsByClass(className) {
  var classElements = new Array()
  var els = document.getElementsByTagName("*")
  var elsLen = els.length
  var pattern = new RegExp("\\b" + className + "\\b")
  for (i = 0, j = 0; i < elsLen; i++) {
    if ( pattern.test(els[i].className) ) {
      classElements[j] = els[i]
      j++
    }
  }
  return classElements;
}

function carpeLeft(elmnt, pos) {
  if (!(elmnt = document.getElementById(elmnt))) return 0;
  if (elmnt.style && (typeof(elmnt.style.left) == 'string')) {
    if (typeof(pos) == 'number') elmnt.style.left = pos + 'px';
    else {
      pos = parseInt(elmnt.style.left);
      if (isNaN(pos)) pos = 0;
    }
  } else if (elmnt.style && elmnt.style.pixelLeft) {
    if (typeof(pos) == 'number') elmnt.style.pixelLeft = pos;
    else pos = elmnt.style.pixelLeft;
  }
  return pos;
}

function carpeTop(elmnt, pos) {
  if (!(elmnt = document.getElementById(elmnt))) return 0;
  if (elmnt.style && (typeof(elmnt.style.top) == 'string')) {
    if (typeof(pos) == 'number') elmnt.style.top = pos + 'px';
    else {
      pos = parseInt(elmnt.style.top);
      if (isNaN(pos)) pos = 0;
    }
  } else if (elmnt.style && elmnt.style.pixelTop) {
    if (typeof(pos) == 'number') elmnt.style.pixelTop = pos;
    else pos = elmnt.style.pixelTop;
  }
  return pos;
}

function moveSlider(evnt) {
  var evnt = (!evnt) ? window.event : evnt;
  if (mouseover) {
    x = slider.startOffsetX + evnt.screenX
    y = slider.startOffsetY + evnt.screenY
    if (x > slider.xMax) x = slider.xMax
    if (x < 0) x = 0
    if (y > slider.yMax) y = slider.yMax
    if (y < 0) y = 0
    carpeLeft(slider.id, x)
    carpeTop(slider.id, y)
    sliderVal = x + y
    sliderPos = (slider.distance / display.valuecount) * 
      Math.round(display.valuecount * sliderVal / slider.distance)
    v = Math.round((sliderPos * slider.scale + slider.from) *
      Math.pow(10, display.decimals)) / Math.pow(10, display.decimals)
    display.value = v
    return false
  }
  return
}

function slide(evnt) {
  if (!evnt) evnt = window.event;
  slider = (evnt.target) ? evnt.target : evnt.srcElement;
  dist = parseInt(slider.getAttribute('distance'))
  slider.distance = dist ? dist : carpeDefaultSliderLength
  ori = slider.getAttribute('orientation')
  orientation = ((ori == 'horizontal') || (ori == 'vertical')) ? ori : carpeSliderDefaultOrientation
  displayId = slider.getAttribute('display')
  display = document.getElementById(displayId)
  display.sliderId = slider.id
  dec = parseInt(display.getAttribute('decimals'))
  display.decimals = dec ? dec : 0
  val = parseInt(display.getAttribute('valuecount'))
  display.valuecount = val ? val : slider.distance + 1
  from = parseFloat(display.getAttribute('from'))
  from = from ? from : 0
  to = parseFloat(display.getAttribute('to'))
  to = to ? to : slider.distance
  slider.scale = (to - from) / slider.distance
  if (orientation == 'vertical') {
    slider.from = to
    slider.xMax = 0
    slider.yMax = slider.distance
    slider.scale = -slider.scale
  } else {
    slider.from = from
    slider.xMax = slider.distance
    slider.yMax = 0
  }
  slider.startOffsetX = carpeLeft(slider.id) - evnt.screenX
  slider.startOffsetY = carpeTop(slider.id) - evnt.screenY
  mouseover = true
  document.onmousemove = moveSlider
  document.onmouseup = sliderMouseUp
  return false
}

function sliderMouseUp() {
  if (mouseover) {
    v = (display.value) ? display.value : 0
    pos = (v - slider.from)/(slider.scale)
    if (slider.yMax == 0) {
      pos = (pos > slider.xMax) ? slider.xMax : pos
      pos = (pos < 0) ? 0 : pos
      carpeLeft(slider.id, pos)
    }
    if (slider.xMax == 0) {
      pos = (pos > slider.yMax) ? slider.yMax : pos
      pos = (pos < 0) ? 0 : pos
      carpeTop(slider.id, pos)
    }
    if (document.removeEventListener) {
      document.removeEventListener('mousemove', moveSlider, false)
      document.removeEventListener('mouseup', sliderMouseUp, false)
    }
    else if (document.detachEvent) {
      document.detachEvent('onmousemove', moveSlider)
      document.detachEvent('onmouseup', sliderMouseUp)
    }
  }
  mouseover = false
}

function focusDisplay(evnt) {
  if (!evnt) evnt = window.event;
  display = (evnt.target) ? evnt.target : evnt.srcElement;
  lock = display.getAttribute('typelock')
  if (lock == 'on') {
    display.blur()
  }
  return
}

window.onload = function() {
  sliders = carpeGetElementsByClass(carpeSliderClassName)
  for (i = 0; i < sliders.length; i++) {
    sliders[i].onmousedown = slide
  }
  displays = carpeGetElementsByClass(carpeSliderDisplayClassName)
  for (i = 0; i < displays.length; i++) {
    displays[i].onfocus = focusDisplay
  }
}

