// Copyright 1995-2011 (C) Otto de Voogd - http://www.7is7.com/
// 
// See: http://www.7is7.com/otto/countdcopy.html for details.
// 

//
// Javascript library for countdown clock pages.
//

var lt=unescape('%3C');
var gt=unescape('%3E');
var nbsp=unescape('%A0');
var smallWindow=false;

// Variables

// var al=0;

var now;
var target;
var next_target;
var targetminusmonths;
var targetminusyears;
// var month_correction=0;
var timezoneoffset=0;
var msDiff=0;
var sDiff=0;
var mDiff=0;
var hDiff=0;
var dDiff=0;
var WDiff=0;
var MDiff=0;
var YDiff=0;
var timeoutID=0;

var title=-1;

var tz;
var ts=24;
var year = 0;
var mon = 0;
var dat = 0;
var hrs = 0;
var min = 0;
var sec = 0;
var ryr = 0;
var rmo = 0;
var rwe = 0;
var rda = 0;
var rhr = 0;
var rmi = 0;
var rse = 0;

msPerSecond = 1000;
msPerMinute = 60*1000;
msPerHour = 60*msPerMinute;
msPerDay = 24*msPerHour;
msPerWeek = 7*msPerDay;

var cdir="down";

// Defaults (-1 = no replacement yet)
var lang=-1;
var numerals=-1;
var yrslabel=-1;
var yrslabels=-1;
var yrslabel_smpl=-1;
var yrslabel_sing=-1;
var yrslabel_ones=-1;
var monlabel=-1;
var monlabels=-1;
var monlabel_smpl=-1;
var monlabel_sing=-1;
var monlabel_ones=-1;
var weeklabel=-1;
var weeklabels=-1;
var weeklabel_smpl=-1;
var weeklabel_sing=-1;
var weeklabel_ones=-1;
var dayslabel=-1;
var dayslabels=-1;
var dayslabel_smpl=-1;
var dayslabel_sing=-1;
var dayslabel_ones=-1;
var hrslabel=-1;
var hrslabels=-1;
var hrslabel_smpl=-1;
var hrslabel_sing=-1;
var hrslabel_ones=-1;
var minlabel=-1;
var minlabels=-1;
var minlabel_smpl=-1;
var minlabel_sing=-1;
var minlabel_ones=-1;
var seclabel=-1;
var seclabels=-1;
var seclabel_smpl=-1;
var seclabel_sing=-1;
var seclabel_ones=-1;
var installlinktext=-1;
var installlinktext2=-1;
var installlinktitle=-1;
var loaded_lang_js=0;

// Next Event
var next=-1;

// var datestyle="us";
var datestyle="#WD, #MO #DA, #YR";
var dayNames=new Array('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');	
var monNames = new Array('January','February','March','April','May','June','July','August','September','October','November','December');	

// Determine Language
lang = getQsVal("lang");
if (-1==lang) lang=getCookieVal("lang");

// Load language file if not English.
if ((-1!=lang) && ("en"!=lang) && (lang.length>1) && (lang.length<4)) {
	var langfile = document.createElement("script");
	langfile.src = 'countdown/lang-'+lang+'.js';
	langfile.type="text/javascript";
	document.getElementsByTagName("head")[0].appendChild(langfile);
} else {
	yrslabel='years';
	yrslabel_sing='year';
	monlabel='months';
	monlabel_sing='month';
	weeklabel='weeks';
	weeklabel_sing='week';
	dayslabel='days';
	dayslabel_sing='day';
	hrslabel='hours';
	hrslabel_sing='hour';
	minlabel='minutes';
	minlabel_sing='minute';
	seclabel='seconds';
	seclabel_sing='second';
	loaded_lang_js = 1;
}

// Next Event requested?
next=getQsVal("next");
if (-1==next) next=getCookieVal("next");

// Load Next Event file
if ((-1!=next) && (""!=next)) {
	document.write(lt+'script type="text/javascript" src="countdown/next-'+next+'.js"'+gt+lt+'/script'+gt);
}

// Verify page - check for mandatory elements
function verifyPage() {
	if (document.getElementById('InstallLink')) {
		return 1;
	} else {
		return 0;
	}
}

// Setup content
function setupContent() {
	// Set background (more than just color)
	var bgcolor=getBgcolorVal();
	document.getElementById('bodyID').style.background=bgcolor;
	// Set foreground color
	var fgcolor=getFgcolorVal();
	document.getElementById('bodyID').style.color=fgcolor;
	setFontSize();
}

// Set font size
function setFontSize() {
	// Set font-size
	var dWidth=250;
	var dHeight=280;
	if (self.innerWidth) { // W3C compliant browsers
		dWidth=self.innerWidth;
		dHeight=self.innerHeight;
	} else if (document.documentElement && document.documentElement.clientWidth) { // The other crap, IE.
		dWidth=document.documentElement.clientWidth;
		dHeight=document.documentElement.clientHeight;
	} else if (document.body) { // Older versions of the other crap.
		dWidth=document.body.clientWidth;
		dHeight=document.body.clientHeight;
	}
	var show=getShowVal();
	var fsw=Math.floor(100*dWidth/240);
	var fsh=Math.floor(100*dHeight/(180+show.length*20));
	var fs=(fsw<fsh)?fsw:fsh;
	document.getElementById('bodyID').style.fontSize=fs+'%';
	// Are we inside a small window?
	if (dWidth<640 || dHeight<480) {
		smallWindow=true;
	}
}

// Open link in new window
function openLink(src) {
	if (smallWindow && self==top) {
		newwin=window.open(src.getAttribute('href'),'_blank','width=800,height=600,toolbar=yes,status=yes,location=yes,menubar=yes,directories=yes,resizable=yes,scrollbars=yes');
		if(window.focus){newwin.focus()};
		return(false);
	} else {
		src.target='_top';
		return(true);
	}
}

// Get Background
function getBgcolorVal() {
	var bgcolor=getQsVal("bgcolor");
	if (-1==bgcolor || bgcolor.length < 2) bgcolor=getCookieVal("bgcolor");
	if (-1==bgcolor || bgcolor.length < 2) bgcolor='#CFF';
	return bgcolor;
}

// Get fgcolor value
function getFgcolorVal() {
	var fgcolor=getQsVal("fgcolor");
	if (-1==fgcolor || fgcolor.length<2) fgcolor=getCookieVal("fgcolor");
	if (-1==fgcolor || fgcolor.length<2) fgcolor='#000';
	return fgcolor;
}

// Get show value - time units to show
function getShowVal() {
	var show=getQsVal("show");
	if (-1==show) { show=getCookieVal("show"); }
	if (-1==show || show.length<1) { show='dhms'; } // Default setting
	return show;
}

// Make Date object
// Enter Month as real month number not number -1.
// Deals with year<100 interpretation
function mkDate(yr,mo,dt,hr,mi,se) {
	Dobj = new Date(yr,mo-1,dt,hr,mi,se);
	Dobj.setFullYear(yr);
	return Dobj;
}


// getFull year returns the proper year
// old browsers use getYear implemented here to work until 2070.
function retYear(datetime) {
	var year = 2000;
	if (datetime.getFullYear) {
		year = datetime.getFullYear();
	} else if (datetime.getYear) { 
		year = datetime.getYear() % 100;
		year += (year<70) ? 2000 : 1900;
	}
	return year;
}

// We *try* to check if number is a number
function isNumber(number) {
	if (isFinite) {
		if (!isFinite(number)) return 0;
	} else if (isNaN) {
		if (!isNaN(number)) return 0;
	}
	return 1;
}

// Prefix a number to use another number range
// Such as %u0660 for Arabic
function prefixNumber(num) {
	var out='';
	num=num+''; // Force a string
	if (-1!=numerals) {
		for (i=0;i<num.length;i++) {
			j=num.charAt(i)*1;
			out+=numerals[j];
		}
	} else {
		out=num;
	}
	return out;
}

// Function to replace text
function replaceTextById(id,str) {
	if (
		document.getElementById(id) &&
		document.getElementById(id).firstChild
	) {
		document.getElementById(id).firstChild.nodeValue=unescape(str);
	}
}

// Replace attribute
function replaceAttrById(id,attr,val) {
	if (
		document.getElementById(id) &&
		document.getElementById(id).getAttribute(attr)
	) {
		document.getElementById(id).setAttribute(attr,val);
	}
}

// Function to change display of certain elements
function setDisplay(id,setting) {
	if (
		document.getElementById(id) &&
		document.getElementById(id).style
	) document.getElementById(id).style.display=setting;
}

function dispTimeUnits(units) {
		setDisplay(units,'block');
		setDisplay(units+'Lbl','block');
}

// Trim leading and trailing whitespace
function trimWhitespace(str) {
	return str.replace(/^\s+|\s+$/,'');
}

// We are trying to match the entire name.
// Which means preceded by the start of the string or a seperator (pre)
// and followed by "=".
function getObjVal(obj,pre,sep,name) {
	name = name + "=";
	var start = obj.indexOf (name,0);
	if (start == -1) return start;
	if (start != 0) {
		name = pre + name;
		var start = obj.indexOf (name,0)
		if (start == -1) return start;
	}
	start += name.length;
	var end = obj.indexOf (sep,start);
	if (end == -1) end = obj.length;
	return trimWhitespace(unescape(obj.substring (start,end)));
}

// Use getObjVal to extract a value from the Query String.
function getQsVal(name) {
	return getObjVal(location.search.substring(1),"&","&",name);
}

// Use getObjVal to extract a cookie value.
// If cookie is found set it again to lengthen expiration date
function getCookieVal(name) {
	var value=getObjVal(document.cookie,"; ",";",name);
	if (-1!=value) { setCookie(name,value); }
	return value;
}

// Set cookie (expires in 2 years)
function setCookie(name,value) {
	var expdate = new Date ();
	expdate.setTime (expdate.getTime() + (msPerDay * 366 * 2));
	document.cookie = name + "=" + escape (value) + "; expires=" + expdate.toGMTString();
}

// Set Values
function setYear(value) {
	if (value != "next" && !isNumber(value)) {
		value = retYear(now)+1;
		if (document.clock.year) document.clock.year.value=value;
	}
	year=value
	setCookie('year',value)
	set_target(now);
}

function setMonth(value) {
	if (value<1 || value>12 || !isNumber(value)) {
		value=1;
		if (document.clock.month) document.clock.month.value=value;
	}
	mon=value
	setCookie('month',value)
	set_target(now);
}

function setDate(value) {
	if (value < 1 || value > 31 || !isNumber(value)) {
		value = 1;
		if (document.clock.date) document.clock.date.value=value;
	}
	dat=value
	setCookie('date',value)
	set_target(now);
}

function setHrs(value) {
	if (value < 0 || value > 23 || !isNumber(value)) {
		value = 1;
		if (document.clock.hrs) document.clock.hrs.value=value;
	}
	hrs=value
	setCookie('hrs',value)
	set_target(now);
}

function setMin(value) {
	if (value < 0 || value > 59 || !isNumber(value)) {
		value = 1;
		if (document.clock.min) document.clock.min.value=value;
	}
	min=value
	setCookie('min',value)
	set_target(now);
}

function setSec(value) {
	if (value < 0 || value > 59 || !isNumber(value)) {
		value = 1;
		if (document.clock.sec) document.clock.sec.value=value;
	}
	sec=value
	setCookie('sec',value)
	set_target(now);
}

// Calculate the timezoneoffset
// Correct the time for UTC setting or given tz value
// else we leave it at the local value (if -1 nothing was entered).
function calc_timezoneoffset() {
	if ( "UTC" == tz ) {
		timezoneoffset = target.getTimezoneOffset() * 60000;
	} else if ( -1 != tz && isNumber(tz) ) {
        // Force tz to be a number by substracting 0.
		timezoneoffset = (target.getTimezoneOffset() + (tz-0)) * 60000;
	} else {
		timezoneoffset = 0;
	}
}

// Return month difference between now and target
function ret_monDiff(cdir,tgt_year,tgt_mon,tgt_dat,tgt_hrs,tgt_min,tgt_sec,now_year,now_mon,now_dat,now_hrs,now_min,now_sec) {
	var res=0;
	var tgt_dattim=((tgt_dat*24+tgt_hrs*1)*60+tgt_min*1)*60+tgt_sec*1;
	var now_dattim=((now_dat*24+now_hrs*1)*60+now_min*1)*60+now_sec*1;
	if (cdir=='up') {
		res=(now_year-tgt_year)*12+now_mon*1-tgt_mon-((tgt_dattim>now_dattim)?1:0);
	} else {
		res=(tgt_year-now_year)*12+tgt_mon*1-now_mon-((now_dattim>tgt_dattim)?1:0);
	}
	return (res>0)?res:0;
}

// Correct date for targetminusmonths value calculation
function monDatCorr(year,mon,dat) {
	mon++;
	var dat_new=dat;
	if ((4==mon||6==mon||9==mon||11==mon) && dat>30) {
		dat_new=30;
	} else if (2==mon && dat>29 && year%4==0 && (year%100!=0||year%400==0)) {
		dat_new=29;
	} else if (2==mon && dat>28) {
		dat_new=28;
	}
	return dat_new;
}

// Set the target date (can vary if year is "next")
// If year is next, it means the next occurence of given date
// hence we determine if it is this year or next year.
// Also set targetminusmonths and targetminusyears
function set_target(now) {

	var now_year=retYear(now);
	var now_mon=now.getMonth();
	var now_dat=now.getDate();
	var now_hrs=now.getHours();
	var now_min=now.getMinutes();
	var now_sec=now.getSeconds();

	if ("undefined"!=typeof(next_event)) {
		target=next_event(now);
	} else if (year == "next") {
		target = mkDate(now_year,mon,dat,hrs,min,sec);
		calc_timezoneoffset();
		if (target.getTime()-timezoneoffset-now.getTime() < 0) {
			target = mkDate(now_year+1,mon,dat,hrs,min,sec)
			calc_timezoneoffset();
		}
	} else if (rwe>0 || rda>0 || rhr>0 || rmi>0 || rse>0) {
		target = new Date();
		ref_target = mkDate(year,mon,dat,hrs,min,sec);
		rcycle = (((((rwe*7)+rda*1)*24+rhr*1)*60+rmi*1)*60+rse*1)*1000;
		if (cdir=="up") {
			cur_cycle = Math.floor((now.getTime()-ref_target.getTime())/rcycle);
			next_target = new Date();
			next_target.setTime(ref_target.getTime()+((cur_cycle+1)*rcycle));
		} else {
			cur_cycle = Math.ceil((now.getTime()-ref_target.getTime())/rcycle);
		}
		target.setTime(ref_target.getTime()+(cur_cycle*rcycle));
		calc_timezoneoffset();
	} else {
		target = mkDate(year,mon,dat,hrs,min,sec)
		calc_timezoneoffset();
	}

	// Calculate the number of whole months between now and target
	var monDiff=ret_monDiff(cdir,year,mon,dat,hrs,min,sec,now_year,now_mon+1,now_dat,now_hrs,now_min,now_sec);

	// Calculate the number of whole years and corrected year
	var yearDiff=Math.floor(monDiff/12);
	var yearCorr=(cdir=='up')?year*1+yearDiff:year-yearDiff;

	// Determine the target minus all the years.
	targetminusyears=mkDate(yearCorr,mon,dat,hrs,min,sec);

	// Calculate remainder months and corrected month
	var remMon=monDiff%12;
	var monCorr=(cdir=='up')?mon-1+remMon:mon-1-remMon;
	if (monCorr<0) {yearCorr--;monCorr+=12;}
	if (monCorr>11) {yearCorr++;monCorr-=12;}

	var datCorr=monDatCorr(yearCorr,monCorr,dat);

	// Determine target minus all the months
	targetminusmonths=mkDate(yearCorr,monCorr+1,datCorr,hrs,min,sec);

// if (al==0) { alert(yearCorr+"-"+monCorr+"-"+datCorr+" "+hrs+":"+min+" "+timezoneoffset+" now "+now_year+"-"+now_mon+"-"+now_dat+" "+now_hrs+":"+now_min);al=1;}
}

// Update a time unit label
function update_timeunit_label(oLabel,units,plur,smpl,ones,sing,labels) {
	if (-1!=plur) {
		if ("function"==typeof(label_units)) { units=label_units(units); }
		if (1==units && -1!=sing)
			replaceTextById(oLabel,sing);
		// The next two cases will go eventually
		else if (-1!=ones && 1==units%10 && 11!=units%100)
			replaceTextById(oLabel,ones);
		else if (-1!=smpl && 2<=units%10 && 4>=units%10 && (12>units%100 || 14<units%100)) 
			replaceTextById(oLabel,smpl);
		else if (-1!=labels && units<labels.length && "undefined"!=typeof(labels[units]))
			replaceTextById(oLabel,labels[units]);
		else
			replaceTextById(oLabel,plur);
	}
}

// Calculate msDiff
function calcDiffs(now) {
	// Ignore months in remainder mode if we are showing months or years.
	// calc msDiff using targetminusmonths
	if (-1!=mode && 0<mode.length && 0<=mode.indexOf('r')) {
		if (0<=show.indexOf('M')) {
			msDiff=targetminusmonths.getTime()-timezoneoffset-now.getTime();
		} else if (0<=show.indexOf('Y')) {
			msDiff=targetminusyears.getTime()-timezoneoffset-now.getTime();
		} else {
			msDiff=target.getTime()-timezoneoffset-now.getTime();
		}
	} else {
		msDiff=target.getTime()-timezoneoffset-now.getTime();
	}
	if (0<=show.indexOf('M')||0<=show.indexOf('Y')) {
		MDiff=target.getMonth()-targetminusmonths.getMonth()+12*(retYear(target)-retYear(targetminusmonths));
	}
}

// Update the clock every 1000 milliseconds
function updateDom() {
	now = new Date();
	calcDiffs(now);
	if ("up"==cdir) {
		msDiff=-msDiff;
		MDiff=-MDiff;
		if (
			(rwe>0 || rda>0 || rhr>0 || rmi>0 || rse>0) &&
			(next_target.getTime()-timezoneoffset-now.getTime()<0)
		) {
			set_target(now);
			calcDiffs(now);
			modify_clock(now);
		}
		
	} else {
		// Add one to the lowest unit to compensate for Math.floor
		// in countdown mode
		if (0<=show.indexOf('s')) {
			msDiff+=1000;
		} else if (0<=show.indexOf('m')) {
			msDiff+=60000;
		} else if (0<=show.indexOf('h')) {
			msDiff+=3600000;
		} else if (0<=show.indexOf('d')) {
			msDiff+=86400000;
		} else if (0<=show.indexOf('W')) {
			msDiff+=604800000;
		}
		if (msDiff<0) {
			set_target(now);
			calcDiffs(now);
			modify_clock(now);
		}
	}
	// If less than zero? Set to zero.
	if (msDiff<0) { msDiff=0; }

	if (document.getElementById('oSec')) {
		if (-1!=mode && 0<mode.length && 0<=mode.indexOf('r')) {
			msRem=msDiff;
			MRem=MDiff;
			if (0<=show.indexOf('Y')) {
				YDiff=Math.floor(MRem/12);
				MRem=MRem%12;
			}
			if (0<=show.indexOf('M')) {
				MDiff=MRem;
			}
			if (0<=show.indexOf('W')) {
				WDiff=Math.floor(msRem/msPerWeek);
				msRem=msRem%msPerWeek;
			}
			if (0<=show.indexOf('d')) {
				dDiff=Math.floor(msRem/msPerDay);
				msRem=msRem%msPerDay;
			}
			if (0<=show.indexOf('h')) {
				hDiff=Math.floor(msRem/msPerHour);
				msRem=msRem%msPerHour;
			}
			if (0<=show.indexOf('m')) {
				mDiff=Math.floor(msRem/msPerMinute);
				msRem=msRem%msPerMinute;
			}
			if (0<=show.indexOf('s')) {
				sDiff=Math.floor(msRem/msPerSecond);
				// msRem=msRem%msPerSecond;
			}

		} else {
			sDiff=Math.floor(msDiff/msPerSecond);
			mDiff=Math.floor(msDiff/msPerMinute);
			hDiff=Math.floor(msDiff/msPerHour);
			dDiff=Math.floor(msDiff/msPerDay);
			WDiff=Math.floor(msDiff/msPerWeek);
			MDiff=MDiff;
			YDiff=Math.floor(MDiff/12);
		}
		replaceTextById('oSec',prefixNumber(sDiff));
		replaceTextById('oMin',prefixNumber(mDiff));
		replaceTextById('oHrs',prefixNumber(hDiff));
		replaceTextById('oDays',prefixNumber(dDiff));
		replaceTextById('oWeek',prefixNumber(WDiff));
		replaceTextById('oMon',prefixNumber(MDiff));
		replaceTextById('oYrs',prefixNumber(YDiff));

		// Singular/Plural check, and automatic language modification.
		update_timeunit_label('oYrsLbl',YDiff,yrslabel,yrslabel_smpl,yrslabel_ones,yrslabel_sing,yrslabels);
		update_timeunit_label('oMonLbl',MDiff,monlabel,monlabel_smpl,monlabel_ones,monlabel_sing,monlabels);
		update_timeunit_label('oWeekLbl',WDiff,weeklabel,weeklabel_smpl,weeklabel_ones,weeklabel_sing,weeklabels);
		update_timeunit_label('oDaysLbl',dDiff,dayslabel,dayslabel_smpl,dayslabel_ones,dayslabel_sing,dayslabels);
		update_timeunit_label('oHrsLbl',hDiff,hrslabel,hrslabel_smpl,hrslabel_ones,hrslabel_sing,hrslabels);
		update_timeunit_label('oMinLbl',mDiff,minlabel,minlabel_smpl,minlabel_ones,minlabel_sing,minlabels);
		update_timeunit_label('oSecLbl',sDiff,seclabel,seclabel_smpl,seclabel_ones,seclabel_sing,seclabels);

		timeoutID=setTimeout('updateDom()',1010 - now%1000)
	}
}

// For backward compatibility (still used in language definition files)
function modify_language() { modifyLanguage(); }

// Language setting
// Let's change all the little texts
function modifyLanguage() {
	if (-1!=yrslabel) replaceTextById('oYrsLbl',yrslabel);
	if (-1!=monlabel) replaceTextById('oMonLbl',monlabel);
	if (-1!=weeklabel) replaceTextById('oWeekLbl',weeklabel);
	if (-1!=dayslabel) replaceTextById('oDaysLbl',dayslabel);
	if (-1!=hrslabel) replaceTextById('oHrsLbl',hrslabel);
	if (-1!=minlabel) replaceTextById('oMinLbl',minlabel);
	if (-1!=seclabel) replaceTextById('oSecLbl',seclabel);
	if (-1!=installlinktext) {
		replaceTextById('IL_Text',installlinktext);
		if (-1!=installlinktext2) {
			replaceTextById('IL_Text2',installlinktext2);
		} else {
			replaceTextById('IL_Text2','%u200B');
		}
	}
	if (-1!=installlinktitle) replaceAttrById('InstallLink','title',unescape(installlinktitle));
}

// We modify the clock

function modify_clock(now) {

	// if the user has set the title replace our original title.
	if (-1!=title) {
		replaceTextById('oTitle',title);
		if (document.title) { document.title=title; }
	}

	// if the user has fixed the date through the querystring show it
	if (location.search && (
			(-1 != getQsVal("year")) ||
			(-1 != getQsVal("datestr")) ||
			(-1 != getQsVal("next"))
		) && document.getElementById('oToDate')
	) {
		// dispyear is different from var year as year can contain "next"
		//dispyear=target.getFullYear();
		dispyear=retYear(target);
		mon=target.getMonth()+1;
		dat=target.getDate();
		hrs=target.getHours();
		min=target.getMinutes();
		sec=target.getSeconds();

		var dayName = "";
		if (target.getDay) dayName = dayNames[target.getDay()];

		var monName = monNames[mon-1];

		// Set the date according to style
		var txtDate;
		// if ("eu"==datestyle) { datestyle="#WD #DA #MO #YR"; }
		// else if (4>datestyle.length) { datestyle="#WD, #MO #DA, #YR"; }
		txtDate=datestyle;
		txtDate=txtDate.replace(/#WD/,unescape(dayName));
		txtDate=txtDate.replace(/#DA/,prefixNumber(dat));
		txtDate=txtDate.replace(/#MO/,unescape(monName));
		txtDate=txtDate.replace(/#MN/,prefixNumber(mon));
		txtDate=txtDate.replace(/#YR/,prefixNumber(dispyear));
		txtDate=unescape(txtDate);

		var txtTime=" ";
		var dhrs=hrs;
		if (12==ts) {
			dhrs=hrs%12;
			if (dhrs==0) { dhrs=12; }
		}
		if (0!=hrs || 0!=min || 0!=sec) {
			txtTime+=((ts!=12&&dhrs<10)?"0":"")+dhrs+":"+((min<10)?"0":"")+min;
			if (0!=sec) { txtTime+=":"+((sec<10)?"0":"")+sec; }
			if (12==ts) { txtTime+=nbsp+((hrs>11)?"pm":"am"); }
		}

		var txtTZ=nbsp;
		if ( "UTC" == tz ) {
			txtTZ += "UTC";
		} else if ( -1!=tz && isNumber(tz) ) {
			var off_sign = ((tz<0)?"-":"+");
			tz = ((tz<0)?-tz:tz);
			var off_hrs = Math.floor(tz/60);
			var off_min = tz-Math.floor(tz/60)*60;
			txtTZ += "[" + off_sign + ((off_hrs<10)?"0":"") + off_hrs + ":" + ((off_min<10)?"0":"") + off_min + "]";
		} else {
			txtTZ = "";
		}

		if (document.getElementById('oToDate').firstChild) {
			document.getElementById('oToDate').removeChild(document.getElementById('oToDate').firstChild);
		}
		var txtNode = document.createTextNode(txtDate + txtTime + txtTZ);
		if (document.getElementById('oToDate')) {
			document.getElementById('oToDate').appendChild(txtNode);
		}
		// Turn off date form 
		setDisplay('oUntilTxt','none');
		setDisplay('oUntilForm','none');
	} else {
		// Turn on date form to allow visitor to enter a date.
		setDisplay('oUntilTxt','block');
		setDisplay('oUntilForm','block');
	}

	// Modify the labels according to language
	modify_language();

	// Show time units that are wanted
	if (0<=show.indexOf('Y')) { dispTimeUnits('oYrs'); }
	if (0<=show.indexOf('M')) { dispTimeUnits('oMon'); }
	if (0<=show.indexOf('W')) { dispTimeUnits('oWeek'); }
	if (0<=show.indexOf('d')) { dispTimeUnits('oDays'); }
	if (0<=show.indexOf('h')) { dispTimeUnits('oHrs'); }
	if (0<=show.indexOf('m')) { dispTimeUnits('oMin'); }
	if (0<=show.indexOf('s')) { dispTimeUnits('oSec'); }

	// If the clock was the result of a search plugin search pass the
	// query string on so that user can generate the appropriate code
	// for his settings quickly.
	if (location.search && -1 != getQsVal('sourceid') && document.getElementById('InstallLink')) {
		document.getElementById('InstallLink').setAttribute('href','http://www.7is7.com/otto/countdclock.html' + location.search);
	}

}

// If location.search exists and the year is set we assume that the date
// needs to be set from the querystring. Otherwise we check the cookies.
function helloGo() {
	now=new Date();

	// In IE the link doesn't inherit changed color value of parent div.
	// So we need to set it again. Thanks Bill!
	var fgcolor=getFgcolorVal();
	if (document.getElementById('InstallLink') &&
		document.getElementById('InstallLink').style
	) document.getElementById('InstallLink').style.color=fgcolor;

	// Determine the date to countdown to
	if (location.search && (-1!=getQsVal("datestr"))) {
		var datestr=getQsVal("datestr");
		datestr=datestr.replace(/\+/g," ");
		target=new Date(Date.parse(datestr));
		//year=target.getFullYear();
		year=retYear(target);
		mon=target.getMonth()+1;
		dat=target.getDate();
		hrs=target.getHours();
		min=target.getMinutes();
		sec=target.getSeconds();
		tz=getQsVal("tz");
		ts=getQsVal("ts");
		if (!isNumber(target.getTime())) alert (datestr+" is not a valid date!");
	} else if (location.search &&
		((-1!=getQsVal("year"))||(-1!=getQsVal("next")))
	) {
		year=getQsVal("year");
		mon=getQsVal("month");
		dat=getQsVal("date");
		hrs=getQsVal("hrs");
		min=getQsVal("min");
		sec=getQsVal("sec");
		tz=getQsVal("tz");
		ts=getQsVal("ts");
		ryr=getQsVal("ryr");
		rmo=getQsVal("rmo");
		rwe=getQsVal("rwe");
		rda=getQsVal("rda");
		rhr=getQsVal("rhr");
		rmi=getQsVal("rmi");
		rse=getQsVal("rse");
	} else {
		year=getCookieVal("year");
		mon=getCookieVal("month");
		dat=getCookieVal("date");
		hrs=getCookieVal("hrs");
		min=getCookieVal("min");
		sec=getCookieVal("sec");
		// Theoretical - no way to set these cookies
		tz=getCookieVal("tz");
		ts=getCookieVal("ts");
		ryr=getCookieVal("ryr");
		rmo=getCookieVal("rmo");
		rwe=getCookieVal("rwe");
		rda=getCookieVal("rda");
		rhr=getCookieVal("rhr");
		rmi=getCookieVal("rmi");
		rse=getCookieVal("rse");
	}

	// title - title to display
	title=getQsVal("title");
	if (-1==title ) title=getCookieVal("title");

	// show - time units to show
	show=getShowVal();

	// cdir - count direction (up or down)
	cdir=getQsVal("cdir");
	if (-1==cdir) cdir=getCookieVal("cdir");

	// mode - countdown mode: total (t) or remainder (r).
	mode=getQsVal("mode");
	if (-1==mode) mode=getCookieVal("mode");

	// Default values
	if (year==-1 || year.length<1 || (year != "next" && !isNumber(year))) year=retYear(now)+1;
	if (mon==-1 || mon.length<1 || !isNumber(mon)) mon=1;
	if (dat==-1 || dat.length<1 || !isNumber(dat)) dat=1;
	if (hrs==-1 || hrs.length<1 || !isNumber(hrs)) hrs=0;
	if (min==-1 || min.length<1 || !isNumber(min)) min=0;
	if (sec==-1 || sec.length<1 || !isNumber(sec)) sec=0;

	if (-1==ryr || ryr.length<1 || !isNumber(ryr)) ryr=0;
	if (-1==rmo || rmo.length<1 || !isNumber(rmo)) rmo=0;
	if (-1==rwe || rwe.length<1 || !isNumber(rwe)) rwe=0;
	if (-1==rda || rda.length<1 || !isNumber(rda)) rda=0;
	if (-1==rhr || rhr.length<1 || !isNumber(rhr)) rhr=0;
	if (-1==rmi || rmi.length<1 || !isNumber(rmi)) rmi=0;
	if (-1==rse || rse.length<1 || !isNumber(rse)) rse=0;

	if (document.clock) {
		if (document.clock.year) document.clock.year.value=year;
		if (document.clock.month) document.clock.month.value=mon;
		if (document.clock.date) document.clock.date.value=dat;
		if (document.clock.hrs) document.clock.hrs.value=hrs;
		if (document.clock.min) document.clock.min.value=min;
		if (document.clock.sec) document.clock.sec.value=sec;
		if (-1!=title && document.clock.title)
			document.clock.title.value=title;
	}

	// Set the target time to countdown to.
	set_target(now);
	modify_clock(now);
	updateDom();
}

// If browser is not DOM compliant ask to send user to Firefox download page.
function helloDom() {
	if (
        !document.getElementById ||
        !document.getElementById('oTitle') ||
        !document.getElementById('oTitle').firstChild
    ) {
        if (
			window.confirm("Your browser is not DOM compliant.\n" +
            "Try using Firefox (getfirefox.com)...")
        ) {
            location.href="http://www.spreadfirefox.com/?q=affiliates&amp;id=89185&amp;t=197";
        }
    } else {
		if (verifyPage()) {
			setupContent();
			helloGo();
		}
	}
}

// Bye - clear timeout
function bye () {
	clearTimeout(timeoutID);
}

// Onload & onunload

window.onload=helloDom;
window.onresize=setFontSize;
window.onunload=bye;

// Set status vars

var loaded_countdown_js = 1;
var version="2.0.2.2-0";

// That's All Folks!
