//jCalendar version 1.0.0
//Author: Martin McCool
//Date: 10/03/2011

//A calendar jQuery plugin

(function( $ ){

	$.fn.jCalendar = function( options ) {  
		//initialise default options
		var settings = {
		  'fadeout'         : 10000,
		  'titleColor' : '#000',
		  'textColor' : '#000',
		  'calendarBg' : '#ddd',
		  'monthBarBg' : '#aaa',
		  'monthBarText' : '#000',
		  'currentDay' : '#aaa',
		  'eventHighlight' : '#fff',
		  'width' : 266,
		  'textSize' : 1,
		  'titleAlign' : 'center',
		  'wrapperColor' : '#ddd'
		};
		
		//main variables
		var globalMonth = new Date(),
		globalYear = 2009,
		newcontent = "",
		timeout, 
		date = new Date(),
		month = date.getMonth(),
		calString = '<table id="cal2"  border="0" cellspacing="3">' + 
			
				'<tr><td colspan="7">&nbsp;&nbsp;<input type="button" value="" id="monBack" /><input type="button" value="" id="monFor" /></td></tr>' + 
			'</table>' + 
			'<table border="0">' +
				'<tr><td id="months" colspan="7"><div id="month"></div></td></tr>' +
			'</table>' +
			
			  '<div id="eventsLayer">'+
			  		'<div id="events">An Event</div>'+
		'	  </div>'+
			'<table id="calendar" border="0">'+
				'<tr id="days">'+
				  '<td class="dayLetter">S</td>'+
				'  <td class="dayLetter">M</td><td class="dayLetter">T</td><td class="dayLetter">W</td><td class="dayLetter">T</td><td class="dayLetter">F</td>'+
				'  <td class="dayLetter">S</td>'+
				'</tr>'+
				'<tr id="row1"><td><input class="days" id="a2" type="button" value="" /></td><td><input class="days"  id="a3" type="button" value="" /></td><td><input class="days"  id="a4" type="button" value="" /></td><td><input class="days"  id="a5" type="button" value="" /></td><td><input class="days"  id="a6" type="button" value="" /></td><td><input class="days"  id="a7" type="button" value="" /></td><td><input class="days"  id="a8" type="button" value="" /></td></tr>'+
				'<tr id="row2"><td><input class="days" id="a9" type="button" value="" /></td><td><input class="days"  id="a10" type="button" value="" /></td><td><input class="days"  id="a11" type="button" value="" /></td><td><input class="days"  id="a12" type="button" value="" /></td><td><input class="days"  id="a13" type="button" value="" /></td><td><input class="days" id="a14" type="button" value="" /></td><td><input class="days" id="a15" type="button" value="" /></td></tr>'+
				'<tr id="row3"><td><input class="days" id="a16" type="button" value="" /></td><td><input class="days" id="a17" type="button" value="" /></td><td><input class="days" id="a18" type="button" value="" /></td><td><input class="days" id="a19" type="button" value="" /></td><td><input class="days" id="a20" type="button" value="" /></td><td><input class="days" id="a21" type="button" value="" /></td><td><input class="days" id="a22" type="button" value="" /></td></tr>'+
				'<tr id="row4"><td><input class="days" id="a23" type="button" value="" /></td><td><input class="days"  id="a24" type="button" value="" /></td><td><input class="days" id="a25" type="button" value="" /></td><td><input  class="days" id="a26" type="button" value="" /></td><td><input class="days" id="a27" type="button" value="" /></td><td><input class="days" id="a28" type="button" value="" /></td><td><input class="days" id="a29" type="button" value="" /></td></tr>'+
			'	<tr id="row5"><td><input class="days" id="a30" type="button" value="" /></td><td><input class="days" id="a31" type="button" value="" /></td><td><input class="days" id="a32" type="button" value="" /></td><td><input class="days" id="a33" type="button" value="" /></td><td><input class="days" id="a34" type="button" value="" /></td><td><input  class="days" id="a35" type="button" value="" /></td><td><input class="days" id="a36" type="button" value="" /></td></tr>'+
				'<tr id="row6"><td><input class="days" id="a37" type="button" value="" /></td><td><input class="days" id="a38" type="button" value="" /></td><td><input class="days" id="a39" type="button" value="" /></td><td><input class="days" id="a40" type="button" value="" /></td><td><input class="days" id="a41" type="button" value="" /></td><td><input class="days" id="a42" type="button" value="" /></td><td><input class="days" id="a43" type="button" value="" /></td></tr>'+
			'</table>';
			
		//add the calendar to the div calendar layer
		$('#calendarLayer').html(calString);
		
		//set the global months and year vars
		globalMonth = month;
		globalYear = date.getFullYear();
		
			
		 return this.each(function(){
			 if ( options ) { 
				$.extend( settings, options );
			 }
			 
			 //modify the css of the calendar either with the default or options values
			$('#calendarLayer').css("background-color", settings.calendarBg);
			$('#calendarLayer').css("color", settings.textColor);
			$('#calendarLayer').css("width", settings.width + "px");
			$('#calendarLayer').css("font-size", settings.textSize + "em");
			$('#month').css("background-color", settings.monthBarBg);
			$('#month').css("color", settings.monthBarText);
			$('#month').css("font-size", settings.textSize + "em");
			$('.days').css("color" , settings.textColor);
			$('.days').css("background-color", settings.calendarBg);
			$('.days').css("border", "1px solid " + settings.calendarBg);
			$('.days').css("font-size", settings.textSize + "em");
			$('#monBack').css("background-color", settings.calendarBg);
			$('#monBack').css("border", "1px solid " + settings.calendarBg);
			$('#monBack').css("color", settings.textColor);
			$('#monBack').css("font-size", settings.textSize + "em");
			$('#monFor').css("background-color", settings.calendarBg);
			$('#monFor').css("border", "1px solid " + settings.calendarBg);
			$('#monFor').css("color", settings.textColor);
			$('#monFor').css("font-size", settings.textSize + "em");
			$('#eventsLayer').css("background-color", settings.calendarBg);
			$('#eventsLayer').css("color", settings.textColor);
			$('#eventsLayer').css("border", "1px solid " + settings.textColor);
			$('#evetnsLayer').css("font-size", "1em");
			$('#event h3').css("color", settings.titleColor);
			$('#cal2').css("width", settings.width + "px");
			$('#month').css("width", (settings.width -16) + "px");
			$('#monFor').css("width", (settings.width *.3) + "px");
			$('.days').css("width", (settings.width * .125) + "px");
			$('.days').css("height", (settings.width * .09) + "px");
			$('.dayLetter').css("font-size", settings.textSize + "em");
			$('#event').css("width", settings.width + "px");
			$('#event h3').css("text-align", settings.titleAlign);
			$('#event h3').css("font-size", (settings.textSize + 0.5) + "em");
			$('#event').css("background-color", settings.wrapperColor);
			
			//get this month
			getTodaysDate(month);
			//check for events
			checkMyEvents();
			
			//on hover over a day check for event and display the event text
			$('.days').hover(function(e){
				
				$('#eventsLayer').html("The is no event on this day.");
				checkDate($(this).val());
				
				//var offset = $(this).offset();
				var relativeX = e.pageX;
				var relativeY = e.pageY;
	
				$('#eventsLayer').css("top", relativeY);
				$('#eventsLayer').css("left", relativeX);
				$('#eventsLayer').css("visibility", "visible");
				
				
				
				setTimeout(function(){ hideEvent(); }, settings.fadeout);
			});
			
			
			//change month to the previous month
			$('#monBack').click(function(){
				backMonth();
				checkMyEvents();
			});
			
			//change month to the next month
			$('#monFor').click(function(){
				forMonth();
				checkMyEvents();
			});
			
		});
		
		//this function calls the event checking code and modifies the background
		//of the current day
		function checkMyEvents(){
			var nodes = $('.days'), d = new Date(), dateStr, day, nodeMonth, nodeId;
			day = d.getDate();
			month = d.getMonth() + 1;
			if(day < 10){
				day = "0" + day;
			}
			if(month < 10){
				month = "0" + month;
			}
			dateStr = (globalYear + "-" + month + "-" + day);
			nodeMonth = globalMonth+1;
			if(nodeMonth < 10){
				nodeMonth = "0" + nodeMonth;
			}
			for(var i = 0; i < nodes.length; i++){
				checkEvents(nodes[i].value, nodes[i]);
				if(globalYear + "-" + nodeMonth + "-" + nodes[i].value === dateStr){
					$('#' + nodes[i].id).css("background-color" , settings.currentDay);	
				}else{
					$('#' + nodes[i].id).css("background-color" , settings.calendarBg);	
				}
			}	
		}
		
		
		//hides the events text
		function hideEvent(){
			clearTimeout(timeout);
			$("#eventsLayer").css("visibility", "hidden");
		}
		
		//this function calculates the calendar values
		function getTodaysDate(monthIn){
			//pass in the month
			var month = monthIn,
			d_names = new Array("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"),
			m_names = new Array("Jan", "Feb", "Mar", " April ", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"),
			d = new Date(globalYear, month, 1),
			curr_day = d.getDay(),
			curr_date = d.getDate(),			
			curr_month = d.getMonth(),
			curr_year = d.getFullYear(),
			monthYear = m_names[curr_month] + "  " + curr_year,
			prevMonth,
			nextMonth,
			arr,
			i,
			days,
			year,
			k;
			//clear months
			for(g = 2; g < 44; g++){
				if($("#a"+g) !== null)
					$("#a"+g).val("");
			}
			
			if(curr_month === 0)
				prevMonth = m_names[11];
			else
				prevMonth = m_names[curr_month-1];
			if(curr_month === 11)
			 	nextMonth = m_names[0];
			else
				nextMonth = m_names[curr_month+1];
			//setting the months
			if($('#month') !== null){
				$('#month').html(monthYear);
				$('#monBack').val(prevMonth);
				$('#monFor').val(nextMonth);
			}
			
			
			//array of ids
			arr = new Array("2","3","4","5","6","7","8");
			
			
			//if the cuurent day is whatever set i to correspond to the array of ids
			// i = index of days
			i = 0;
			//get day
			if(d_names[curr_day] === "Sun")
				i = 2;
			else if(d_names[curr_day] === "Mon")
				i = 3;
			else if(d_names[curr_day] === "Tue")
				i = 4;
			else if(d_names[curr_day] === "Wed")
				i = 5;
			else if(d_names[curr_day] === "Thu")
				i = 6;
			else if(d_names[curr_day] === "Fri")
				i = 7;
			else 
				i = 8;
				
			//set the number of days in the month
			days = 0;
			year = d.getFullYear();
			if(month === 0 || month === 2 || month === 4 || month === 6 || month === 7 || month === 9 || month === 11){
				days = 31;
			}
			else if(month === 3 || month === 5 || month === 8 || month === 10){
				days = 30;
			}
			else if (month === 1 && year%4 === 0 && year%100 === 0 && year%400 === 0){
				days = 29;
			}
			else{
				days = 28;
			}
			//set what day the month starts at
			for(j = curr_date; j >=1; j--)
			{	
				if(i === 1){
					i = 8;
				}
				else
					i--;
			}
			
			//set calendar
			k = 1;
			if(i === 1){
				i = 8;
			}
			for(m = i; m < days + i; m++){
				if($("#a"+m) != null){
					$("#a"+m).val(k);
				}
				
				
				k++;
			}
			
			
		}
		
		
		function backMonth(){
			for(var i = 2; i < 37; i++){
				$("#a"+i).css("border","medium none");
			}
			globalMonth -= 1;		
			if(globalMonth === -1){
				globalMonth = 11;
				globalYear--;
			}
			getTodaysDate(globalMonth);
		}
		
		function forMonth(){
			for(var i = 2; i < 37; i++){
				$("#a"+i).css("border","medium none");
			}
			globalMonth += 1;	
			if(globalMonth === 12){
				globalMonth = 0;
				globalYear++;
			}
			getTodaysDate(globalMonth);
			
		}
		
		
		//checks for eventa and adds its text to the event
		function checkDate(date) {
			var day = date,gMonth,theDate,date,nodeId;
			if(day < 10)
				day = "0" + day;
			if(globalMonth + 1 < 10)
				gMonth = "0" + (globalMonth+1);
			else
				gMonth = globalMonth + 1;
			theDate = globalYear + "-" + gMonth + "-" + day;
			date = escape(theDate);
			//get the list of nodes for events
			var nodes = $('#myEvents').contents();
			//search through all the nodes for the current hovered over day
			$.each(nodes,function(i, v){
				if(nodes[i].id === date && nodes[i].id !== undefined){
					$('#eventsLayer').html(nodes[i].innerHTML);	
				}
			});
			
		  
		}
		
		
		//checks through the days of the month for events
		//and adds a border around the days with events
		function checkEvents(date, elem) {
		  var day = date,gMonth,theDate,date, nodeId;
			if(day < 10)
				day = "0" + day;
			if(globalMonth + 1 < 10)
				gMonth = "0" + (globalMonth+1);
			else
				gMonth = globalMonth + 1;
			theDate = globalYear + "-" + gMonth + "-" + day;
			date = escape(theDate);
			var nodes = $('#myEvents').contents();
			$.each(nodes,function(i, v){
				if(nodes[i].id === date && nodes[i].id!== undefined){
					elem.style.border = "1px solid " + settings.eventHighlight;
				}
			});
		  
		}

	};
})( jQuery );
