/* This script and many more are available free online at
The JavaScript Source!! http://javascript.internet.com
Created by: Steve Chipman | http://slayeroffice.com/Licensed under: Creative Commons License
 */

function so_createDateDropDown(numDays,direction) {
	var current = Date.parse(new Date());
	var dayLength = 86400000;
	var maxDate = direction?current - (dayLength*numDays):current + (dayLength*numDays);
	maxDate = new Date(maxDate);
	months = new Array("January","February","March","April","May","June","July","August","September","October","November","December");
	days = new Array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");

	dSelect = document.createElement("select");
	dSelect.setAttribute("name","dateDropDown");
	
	do {
		current+=direction?-dayLength:dayLength;
		prvDateObj = new Date(current);
		vDate = prvDateObj.getFullYear() + "" + prvDateObj.getMonth() + "" + prvDateObj.getDate();
		dOption = document.createElement("option");
		dOption.setAttribute("value",vDate);
		dOption.appendChild(document.createTextNode(days[prvDateObj.getDay()] + ", " + months[prvDateObj.getMonth()] + " " + prvDateObj.getDate() + " " + prvDateObj.getFullYear()));
		dSelect.appendChild(dOption);
		condition = direction?prvDateObj>maxDate:prvDateObj<maxDate;
	} while(condition);

	return dSelect;
}

// Multiple onload function created by: Simon Willison
// http://simonwillison.net/2004/May/26/addLoadEvent/
function addLoadEvent(func) {
  var oldonload = window.onload;
  if (typeof window.onload != 'function') {
    window.onload = func;
  } else {
    window.onload = function() {
      if (oldonload) {
        oldonload();
      }
      func();
    }
  }
}

addLoadEvent(function() {
  document.getElementById("myFormDemo").appendChild(so_createDateDropDown(10,0));
});

