/* 
 * ---------------------------------------------------------------------- 
 * WebDate                                                                
 *                                                                        
 * Version: 1.1                                                           
 * Release date: 2005.01.30                                               
 *                                                                        
 * Copyright (c) Amir Firdus, 2005.                                       
 * All rights reserved.                                                   
 *                                                                        
 * License:                                                               
 * This software is free to use and distribute as long as the             
 * link to Firdus Software web site (www.firdus.com) is not removed.      
 * Removing the link requires author's permission and it may cost money.  
 * ---------------------------------------------------------------------- 
 */
 
/*
 * > PAD      - short for Pick-A-Date.
 * > Receiver - html element receiving the date value.
 * > Trigger  - html element that shows PAD component.
 * 
 * > All methods are prefixed with 'pad' to allow easy integration 
 *   with existing code.
 *  
 * > Date rollover on month change is as implemented by JavaScript.
 * 
 * > As month value is zero based in JavaScript, it has to be increased 
 *   for 1 every time it is displayed and decreased for 1 for calculation. 
 *   Spots in the code that this is done are marked by the comment.
 */
 

/* receiver, html element to receive the date */
var receiverRef;

/* date delimiter */
var delimiterRef;

/* flag that indicates that mouse is down */
var active = false;

/* time to sleep before date values start scrolling when mouse is down */
var sleep = 250;

/* counter used to set variable scroll speed */
var count = 0;
 
/*
 * Create PAD component.
 *
 * Date td elements have to be initialized.
 * Have to escape ' inside document.write().
 */
function padCreate(){
  
  document.write('<div id="fs-pad-div">');
  document.write('<table id="fs-pad-table" cellspacing="1">');
  document.write(' <tr>');
  document.write('  <td class="buttonOut" onMouseDown="javascript:this.className=\'buttonIn\';padSetActive(true);padMoveYear(\'+\');"  onMouseUp="javascript:this.className=\'buttonOut\';padSetActive(false);" onMouseOut="javascript:this.className=\'buttonOut\';padSetActive(false);">Y+</td>');
  document.write('  <td class="buttonOut" onMouseDown="javascript:this.className=\'buttonIn\';padSetActive(true);padMoveMonth(\'+\');" onMouseUp="javascript:this.className=\'buttonOut\';padSetActive(false);" onMouseOut="javascript:this.className=\'buttonOut\';padSetActive(false);">M+</td>');
  document.write('  <td class="buttonOut" onMouseDown="javascript:this.className=\'buttonIn\';padSetActive(true);padMoveDay(\'+\');"   onMouseUp="javascript:this.className=\'buttonOut\';padSetActive(false);" onMouseOut="javascript:this.className=\'buttonOut\';padSetActive(false);">D+</td>');
  document.write('  <td class="task" rowspan="4">');
  document.write('	<a class="taskLink" href="javascript:padOk();">Ok</a><br>');
  document.write('	<a class="taskLink" href="javascript:padCancel();">Cancle</a><br>');
  document.write('	<a class="taskLink" href="javascript:padClear();">Clear</a><br>');
  document.write('	<a class="taskLink" href="javascript:padToday();">Today</a><br>');
  document.write('  </td>');
  document.write(' </tr>');
  document.write(' <tr>');
  document.write('  <td class="date">0</td>');
  document.write('  <td class="date">0</td>');
  document.write('  <td class="date">0</td>');
  document.write(' </tr>');
  document.write(' <tr>');
  document.write('  <td class="buttonOut" onMouseDown="javascript:this.className=\'buttonIn\';padSetActive(true);padMoveYear(\'-\');"  onMouseUp="javascript:this.className=\'buttonOut\';padSetActive(false);" onMouseOut="javascript:this.className=\'buttonOut\';padSetActive(false);">Y-</td>');
  document.write('  <td class="buttonOut" onMouseDown="javascript:this.className=\'buttonIn\';padSetActive(true);padMoveMonth(\'-\');" onMouseUp="javascript:this.className=\'buttonOut\';padSetActive(false);" onMouseOut="javascript:this.className=\'buttonOut\';padSetActive(false);">M-</td>');
  document.write('  <td class="buttonOut" onMouseDown="javascript:this.className=\'buttonIn\';padSetActive(true);padMoveDay(\'-\');"   onMouseUp="javascript:this.className=\'buttonOut\';padSetActive(false);" onMouseOut="javascript:this.className=\'buttonOut\';padSetActive(false);">D-</td>');
  document.write(' </tr>');
  document.write(' <tr>');
  document.write('  <td colspan="3">');
  document.write('    <a class="logoLink" href="http://www.firdus.com" target="_blank">Firdus Software</a>');
  document.write('  </td>');
  document.write(' </tr>');
  document.write('</table>');
  document.write('</div>  ');
}

/*
 * Set mouse down flag. 
 */ 
function padSetActive(value){
   active = value;
}

/*
 * Show PAD component.
 *
 * note:
 * Style property is only for inline style elements, 
 * those that are defined in style element attribute.
 */ 
function padShow(receiver, trigger, delimiter){
  
  var divRef = document.getElementById("fs-pad-div");
  var triggerRef = document.getElementById(trigger);

  // set component position over the trigger element
  divRef.style.top = findOffsetTop(triggerRef);
  divRef.style.left = findOffsetLeft(triggerRef);
  
  // make it visible
  divRef.style.visibility = "visible";
    
  // set receiver reference, required for ok and cancel events
  receiverRef = document.getElementById(receiver);

  // initialize component
  // if no value -> today, otherwise parse existing value 
  // from the receiver based on yyyy-mm-dd format
  if (receiverRef.value == ""){  
    padToday();
  }else{
    var date = new String(receiverRef.value);
    padSetYear(date.substring(0,4));
    padSetMonth(date.substring(5,7)); // no need to increase month for display
    padSetDay(date.substring(8,10));
  }
  
  // set delimiter reference
  delimiterRef = delimiter;
}

/*
 * Ok click, update receiver element with picked date and hide PAD component.
 */ 
function padOk(){
  document.getElementById("fs-pad-div").style.visibility = "hidden";
  receiverRef.value = padGetYear() + delimiterRef + padGetMonth() + delimiterRef + padGetDay();
}

/*
 * Cancel click, hide PAD component.
 */ 
function padCancel(){
  document.getElementById("fs-pad-div").style.visibility = "hidden";
}

/*
 * Clear click, clear the receiver and hide PAD component.
 */ 
function padClear(){
  document.getElementById("fs-pad-div").style.visibility = "hidden";
  receiverRef.value = "";
}

/*
 * Set PAD date values to today.
 */ 
function padToday(){
  var today = new Date();
  padSetYear(today.getFullYear());
  padSetMonth(today.getMonth() + 1); // increase month for display
  padSetDay(today.getDate());
}

/*
 * Move year value.
 * If direction is + than year is increased.
 * If direction is - than year is decreased.
 */ 
function padMoveYear(direction){
  
  if(active) {
  
    // calc new year value
    var newYear;
    if (direction == "+"){
      newYear = eval(padGetYear()) + 1;
    }else if (direction == "-"){
      newYear = eval(padGetYear()) - 1;
    }else{
      alert("Invalid argument for padMoveYear().");
    }
  
    // create new date  
    var newDate = new Date(newYear, padGetMonth() - 1, padGetDay()); // decrease month for calculation
  
    // update the component
    padSetYear(newDate.getFullYear());
    padSetMonth(newDate.getMonth() + 1); // increase month for display
    padSetDay(newDate.getDate());
 
    // calculate sleep period for variable scroll speed.
    var currentSpeed;
    if (count < 3){
      currentSpeed = sleep;
    } else if (count >= 3 && count < 10) {
      currentSpeed = 0.7 * sleep;
    } else if (count >= 10){
      currentSpeed = 0.4 * sleep;
    }
    count = count + 1;    

    // recursive timer call, scrolls year when mouse is down   
    setTimeout("padMoveYear('" + direction + "')",currentSpeed); 
    
  } else {
    // mouse not active (mouse up)
    count = 0;
  }    
  
}

/*
 * Move month value.
 * If direction is + than year is increased.
 * If direction is - than year is decreased.
 */ 
function padMoveMonth(direction){
  
  if(active) {
  
    // calc new month value
    var newMonth;
    if (direction == "+"){
      newMonth = eval(padGetMonth()) + 1;
    }else if (direction == "-"){
      newMonth = eval(padGetMonth()) - 1;
    }else{
      alert("Invalid argument for padMoveMonth().");
    }
  
    // create new date  
    var newDate = new Date(padGetYear(), newMonth - 1, padGetDay()); // decrease month for calculation
  
    // update the component
    padSetYear(newDate.getFullYear());
    padSetMonth(newDate.getMonth() + 1); // increase month for display
    padSetDay(newDate.getDate());
   
    // calculate sleep period for variable scroll speed.
    var currentSpeed;
    if (count < 3){
      currentSpeed = sleep;
    } else if (count >= 3 && count < 10) {
      currentSpeed = 0.7 * sleep;
    } else if (count >= 10){
      currentSpeed = 0.4 * sleep;
    }
    count = count + 1;    

    // recursive timer call, scrolls month when mouse is down   
    setTimeout("padMoveMonth('" + direction + "')",currentSpeed); 
    
  } else {
    // mouse not active (mouse up)
    count = 0;
  }    
}

/*
 * Move day value.
 * If direction is + than year is increased.
 * If direction is - than year is decreased.
 */ 
function padMoveDay(direction){
  
  if(active) {

    // calc new day value
    var newDay;
    if (direction == "+"){
      newDay = eval(padGetDay()) + 1;
    }else if (direction == "-"){
      newDay = eval(padGetDay()) - 1;
    }else{
      alert("Invalid argument for padMoveDay().");
    }
  
    // create new date  
    var newDate = new Date(padGetYear(), padGetMonth() - 1, newDay); // decrease month for calculation
  
    // update the component
    padSetYear(newDate.getFullYear());
    padSetMonth(newDate.getMonth() + 1); // increase month for display
    padSetDay(newDate.getDate());
  
 
    // calculate sleep period for variable scroll speed.
    var currentSpeed;
    if (count < 3){
      currentSpeed = sleep;
    } else if (count >= 3 && count < 10) {
      currentSpeed = 0.7 * sleep;
    } else if (count >= 10){
      currentSpeed = 0.4 * sleep;
    }
    count = count + 1;    

    // recursive timer call, scrolls day when mouse is down    
    setTimeout("padMoveDay('" + direction + "')",currentSpeed); 
  
  
  } else {
    // mouse not active (mouse up)
    count = 0;
  }  
}

/*
 * Get year value.
 */ 
function padGetYear(){
  var table = document.getElementById("fs-pad-table");
  var row = table.rows[1];
  var cell = row.cells[0];
  return cell.firstChild.nodeValue;
}

/*
 * Set year value.
 */ 
function padSetYear(year){
  var table = document.getElementById("fs-pad-table");
  var row = table.rows[1];
  var cell = row.cells[0];
  cell.firstChild.nodeValue = padZeroLeftPad(year, 4);
}

/*
 * Get month value.
 */ 
function padGetMonth(){
  var table = document.getElementById("fs-pad-table");
  var row = table.rows[1];
  var cell = row.cells[1];
  return cell.firstChild.nodeValue;
}

/*
 * Set month value.
 */ 
function padSetMonth(month){
  var table = document.getElementById("fs-pad-table");
  var row = table.rows[1];
  var cell = row.cells[1];
  cell.firstChild.nodeValue = padZeroLeftPad(month, 2);
}

/*
 * Get day value.
 */ 
function padGetDay(){
  var table = document.getElementById("fs-pad-table");
  var row = table.rows[1];
  var cell = row.cells[2];
  return cell.firstChild.nodeValue;
}

/*
 * Set day value.
 */ 
function padSetDay(day){
  var table = document.getElementById("fs-pad-table");
  var row = table.rows[1];
  var cell = row.cells[2];
  cell.firstChild.nodeValue = padZeroLeftPad(day, 2);
}

/*
 * Leftpad the value with zeros.
 */ 
function padZeroLeftPad(value, length) {
  
  // build the zeros string
  var zeros = new String();
  for (i=0; i<length; i++) {
    zeros = zeros + "0";
  }

  // prepend zeros to the value
  var longValue = zeros + value;

  // return the last length characters
  return longValue.substring(longValue.length - length, longValue.length);
}


/*
 * Find total left offset.
 */ 
function findOffsetLeft(obj){
  var curleft = 0;
  if (obj.offsetParent){
    while (obj.offsetParent){
      curleft += obj.offsetLeft
        obj = obj.offsetParent;
    }
  }else if (obj.x){
    curleft += obj.x;
  }
  
  return curleft;
}

/*
 * Find total top offset.
 */ 
function findOffsetTop(obj){
  var curtop = 0;
  if (obj.offsetParent)	{
    while (obj.offsetParent){
      curtop += obj.offsetTop
      obj = obj.offsetParent;
    }
  }else if (obj.y){
    curtop += obj.y;
  }
		
  return curtop;
}
