/*
* jQuery UI Numeric Up/Down v1.3
*
* Copyright 2011, Tony Kramer
* Dual licensed under the MIT or GPL Version 2 licenses.
* http://jquery.org/license
*
* Dependencies:
* - jQuery (1.4.2)
* - jQuery-ui (1.8.6 - core, widget, button)
*/
(function(e){function h(a){if(typeof a!=="number")a=Number(a);if(isNaN(a))return 0;return a}function m(a,b){for(var c="",d=0;d<b;d++)c+=a;return c}function j(a){return a.replace(n,"\\$1")}e.widget("ui.numeric",{version:"1.3",options:{disabled:false,keyboard:true,showCurrency:false,currencySymbol:"$",title:"Type a new value or use the buttons or keyboard arrow keys to change the value. Hold Ctrl or Shift for a smaller or larger increment, respectively.",buttons:true,upButtonIcon:"ui-icon-triangle-1-n",
upButtonTitle:"Increment the value. Hold Ctrl or Shift for a smaller or larger increment, respectively.",downButtonIcon:"ui-icon-triangle-1-s",downButtonTitle:"Decrement the value. Hold Ctrl or Shift for a smaller or larger increment, respectively.",emptyValue:0,minValue:false,maxValue:false,smallIncrement:1,increment:5,largeIncrement:10,calc:null,format:{format:"0",decimalChar:".",thousandsChar:","}},_adjustmentFlag:false,_keyDownFlag:false,_timer:null,_name:"numeric",_value:0,_create:function(){var a=
this,b=a.options,c=a.widget(),d=c.attr("type").toLowerCase();if(d!=="text"&&d!=="number")throw"numeric widget can only be applied to text and number inputs.";a._checkFormat();a._name=c.attr("id")||c.attr("name");a._value=a._getInputValue(c.attr("value"),true);if(b.minValue!==false&&a._value<b.minValue)a._value=b.minValue;if(b.maxValue!==false&&a._value>b.maxValue)a._value=b.maxValue;a.widget().attr("value",a._format(a._value));c.attr("title",b.title).wrap(e('<div class="ui-widget ui-widget-content ui-corner-all ui-numeric" />'));
b.showCurrency&&a._createCurrency();b.buttons&&a._createButtons();c.bind({keydown:function(g){return a._onKeyDown(g)},keyup:function(g){return a._onKeyUp(g)},change:function(g){return a._onChange(g)}});if(b.disabled||c.attr("disabled"))a._setOption("disabled",true);e(window).bind("unload",function(){a.destroy()})},destroy:function(){var a=this,b=a.widget();b.unbind({keydown:function(c){return a._onKeyDown(c)},keyup:function(c){return a._onKeyUp(c)},change:function(c){return a._onChange(c)}});a.options.showCurrency&&
e("#"+a._name+"_currency").remove();a.options.buttons&&e("#"+a._name+"_buttons").remove();b.unwrap();e.Widget.prototype.destroy.apply(a);e(window).unbind("unload",function(){a.destroy()})},_createCurrency:function(){this.widget().before(e("<div/>").attr("id",this._name+"_currency").addClass("ui-numeric-currency").html(this.options.currencySymbol))},_createButtons:function(){function a(f,i){if(f.which==32||f.which==13){b(f,i);f.target.focus()}}function b(f,i){(i?d:g).blur();var k=c._getIncrement(f.ctrlKey,
f.shiftKey);c._adjustValueRecursive(i?-k.value:k.value,k.type)}var c=this,d=e('<button type="button"></button>').attr("title",c.options.upButtonTitle).bind({keydown:function(f){a(f,false)},keyup:function(){clearTimeout(c._timer)},mousedown:function(f){b(f,false)},mouseup:function(){clearTimeout(c._timer)}}).button({text:false,label:"U",icons:{primary:c.options.upButtonIcon}}),g=e('<button type="button"></button>').attr("title",c.options.downButtonTitle).bind({keydown:function(f){a(f,true)},keyup:function(){clearTimeout(c._timer)},
mousedown:function(f){b(f,true)},mouseup:function(){clearTimeout(c._timer)}}).button({text:false,label:"D",icons:{primary:c.options.downButtonIcon}});c._addButtons(d,g)},_addButtons:function(a,b){this.widget().after(e("<div/>").attr("id",this._name+"_buttons").addClass("ui-numeric-buttons").append(a).append(b))},_setOption:function(a,b){var c=this.options;switch(a){case "disabled":var d=this.widget();d.parent()[b?"addClass":"removeClass"]("ui-numeric-disabled ui-state-disabled").attr("aria-disabled",
b);this._adjustmentFlag=true;b?d.attr({disabled:"disabled",value:""}):d.removeAttr("disabled").attr("value",this._format(this._value));this._adjustmentFlag=false;if(c.buttons)e("#"+this._name+"_buttons button").button(b?"disable":"enable");break;case "emptyValue":c.emptyValue=b;this._setValue(this._value);break;case "minValue":c.minValue=b===false?false:h(b);c.minValue!==false&&this._value<c.minValue&&this._setValue(c.minValue);break;case "maxValue":c.maxValue=b===false?false:h(b);c.maxValue!==false&&
this._value>c.maxValue&&this._setValue(c.maxValue);break;case "format":c.format=b;this._checkFormat();this._setValue(this._value);break;case "title":c.title=b;this.widget().attr("title",b);break;case "showCurrency":if(b&&!c.showCurrency)this._createCurrency();else!b&&c.showCurrency&&e("#"+this._name+"_currency").remove();c.showCurrency=b;break;case "currencySymbol":c.currencySymbol=b;c.showCurrency&&e("#"+this._name+"_currency").html(b);break;case "buttons":if(b&&!c.buttons)this._createButtons();
else!b&&c.buttons&&e("#"+this._name+"_buttons").remove();c.buttons=b;break;case "upButtonIcon":c.upButtonIcon=b;c.buttons&&e("#"+this._name+"_buttons").find("button:eq(0)").button("option","icons",{primary:b});break;case "upButtonTitle":c.upButtonTitle=b;c.buttons&&e("#"+this._name+"_buttons").find("button:eq(0)").attr("title",b);break;case "downButtonIcon":c.downButtonIcon=b;c.buttons&&e("#"+this._name+"_buttons").find("button:eq(1)").button("option","icons",{primary:b});break;case "downButtonTitle":c.downButtonTitle=
b;c.buttons&&e("#"+this._name+"_buttons").find("button:eq(1)").attr("title",b);break;default:e.Widget.prototype._setOption.apply(this,a,b)}return this},_checkFormat:function(){var a=this.options;a.format=typeof a.format==="string"?{format:a.format,decimalChar:".",thousandsChar:","}:e.extend({format:"0",decimalChar:".",thousandsChar:","},a.format)},_getInputValue:function(a,b){a=a.replace(RegExp(j(this.options.format.thousandsChar),"g"),"");if(this.options.format.decimalChar!==".")a=a.replace(RegExp(j(this.options.format.decimalChar),
"g"),".");return b?h(a):a},_setInputValue:function(a){this._adjustmentFlag=true;this.widget().attr("value",this._format(a)).change();this._adjustmentFlag=false},_setValue:function(a){a=h(a);if(this.options.minValue!==false&&a<this.options.minValue)a=this.options.minValue;if(this.options.maxValue!==false&&a>this.options.maxValue)a=this.options.maxValue;this._value=a;this.options.disabled||this._setInputValue(a)},_format:function(a){var b=this.options;return isNaN(a)||b.emptyValue!==false&&a===b.emptyValue?
"":e.formatNumber(a,b.format)},_getIncrement:function(a,b){if(a)return{value:this.options.smallIncrement,type:2};else if(b)return{value:this.options.largeIncrement,type:3};return{value:this.options.increment,type:1}},_adjustValue:function(a,b){if(!this.options.disabled){this._setValue(e.isFunction(this.options.calc)?this.options.calc(this._value,b,a<0?2:1):this._value+a);this.select()}},_adjustValueRecursive:function(a,b){e.ui.numeric._current=this;e.ui.numeric._timerCallback(a,b,true)},_onKeyDown:function(a){var b=
this.options;if(!b.disabled){switch(a.which){case 109:case 110:case 190:this._keyDownFlag=true;return;case 38:case 40:if(b.keyboard){b=this._getIncrement(a.ctrlKey,a.shiftKey);this._adjustValue(a.which==40?-b.value:b.value,b.type)}return;case 33:b.keyboard&&this._adjustValue(b.largeIncrement,3);return;case 34:b.keyboard&&this._adjustValue(-b.largeIncrement,3);return;case 65:case 67:case 86:case 88:case 89:case 90:if(a.ctrlKey)return}if(!(a.which<=47&&a.which!=32||a.which>=91&&a.which<=95||a.which>=
112&&[188,190,191,192,219,220,221,222].indexOf(a.which)==-1))if(!(a.which>=48&&a.which<=57||a.which>=96&&a.which<=105)){a.preventDefault();a.stopPropagation()}}},_onKeyUp:function(){var a=parseFloat(this._getInputValue(this.widget().attr("value"),false));if(!isNaN(a))this._value=a;this._keyDownFlag=false},_onChange:function(a){!this._adjustmentFlag&&!this._keyDownFlag&&this._setValue(this._getInputValue(a.target.value),true)},value:function(a){if(a===undefined)return this._value;this._setValue(a);
return this},select:function(){this.options.disabled||this.widget().select();return this}});e.ui=e.ui||{};e.ui.numeric._current=null;e.ui.numeric._timerCallback=function(a,b,c){clearTimeout(e.ui.numeric._current._timer);e.ui.numeric._current._adjustValue(a,b);e.ui.numeric._current._timer=setTimeout("jQuery.ui.numeric._timerCallback("+a+","+b+",false)",c?1E3:50)};var n=RegExp("(\\/|\\.|\\*|\\+|\\?|\\||\\(|\\)|\\[|\\]|\\{|\\}|\\\\)","g");e.formatNumber=function(a,b){a=h(a);if(typeof b==="string")b=
{format:b};b=e.extend({format:null,decimalChar:".",thousandsChar:","},b);if(typeof b.format!=="string"||b.format.length<=0)return a.toString();b.decimalChar=typeof b.decimalChar!=="string"||b.decimalChar.length<=0?".":b.decimalChar;b.thousandsChar=typeof b.thousandsChar!=="string"?",":b.thousandsChar;if(b.decimalChar.length>1)throw"NumberFormatException: Can not have multiple characters as the decimal character.";if(b.thousandsChar.length>1)throw"NumberFormatException: Can not have multiple characters as the thousands separator.";
var c=b.format.indexOf(b.decimalChar);if(c>=0&&b.format.indexOf(b.decimalChar,c+1)>=0)throw"NumberFormatException: Format string has multiple decimal characters.";var d=a.toString().replace(/-/g,""),g=b.format.replace(RegExp("[^0#"+j(b.decimalChar)+"]","g"),"");d=d.indexOf(b.decimalChar)<0?[d,""]:d.split(b.decimalChar);g=c<0?[g,""]:g.split(b.decimalChar);if(parseInt(a)===0)d[0]=g[0].indexOf("0")>=0?"0":"";if(b.format.indexOf(b.thousandsChar)>=0&&d[0].length>3){var f=[],i=d[0].length,k=Math.floor(i/
3),l=d[0].length%3||3;for(c=0;c<i;c+=l){if(c!=0)l=3;f[f.length]=d[0].substr(c,l);k-=1}d[0]=f.join(b.thousandsChar)}if(g[1].length>0)if(d[1].length>0){g=g[1].split("");f=d[1].split("");for(c=0;c<f.length;c++){if(c>=g.length)break;g[c]=f[c]}d[1]=g.join("").replace(/#/g,"")}else{c=0;for(d[1]="";g[1].charAt(c)==="0";){d[1]+="0";c++}}else d[1]="";d=d[1].length<=0?d[0]:d[0]+b.decimalChar+d[1];if(a<0)d="-"+d;return b.format.replace(RegExp("[0|#|"+j(b.thousandsChar)+"|"+j(b.decimalChar)+"]+"),d)};Number.prototype.roundRight=
function(a){a=h(a);a=Math.pow(10,a);return Math.round(this*a)/a};Number.prototype.pad=function(a){a=h(a);var b=String(this.valueOf()),c=b.length;if(c<a)for(c=c;c<a;c++)b="0"+b;return b};Number.prototype.padRight=function(a){a=h(a);var b=String(this.valueOf()),c=b.length-(this%1>0?1:0);if(c<a)for(c=c;c<a;c++)b+="0";return b};Number.prototype.padDecimals=function(a){a=h(a);var b=String(this.valueOf()).split(".");if(b.length<=0)return a>0?"0."+m("0",a):"0";if(b.length==1)return b[0]+(a>0?"."+m("0",a):
"");return b[0]+(a>0?"."+parseInt(b[1]).padRight(a):"")};Number.prototype.getOrdinal=function(){if(this>100)return(this%100).getOrdinal();if(this>=11&&this<=19)return"th";switch(this%10){case 1:return"st";case 2:return"nd";case 3:return"rd"}return"th"};Number.prototype.format=function(a){e.formatNumber(this,a)};Number.prototype.formatCurrency=function(a){a=e.extend({symbol:"$",noParens:false,format:"#,##0.00",decimalChar:".",thousandsChar:","},a);var b=Math.abs(this).format(a);if(this<0)return a.noParens?
"-"+a.symbol+b:"("+a.symbol+b+")";return b}})(jQuery);
