/*
#########################################################################################
# jQuery Tech Talk jPointer jQuery Plugin. Min Req: jQuery 1.4.1+ and jQueryUI 1.8.3+	#
# Developed by Rahul.									#
# www.jquerytechtalk.appspot.com							#
# May 5 2010										#
# Please Leave This Message Intact							#
# Licensed under the MIT license: http://www.opensource.org/licenses/mit-license.php 	#
# Copyright (c) 2011 Rahul - rahul@jquerytechtalk.com					#
#########################################################################################
*/

(function( $ , undefined){

  $.fn.jpointer = function(options) {
    var defaults = {
       		msg: 'Please provide message to this jPoiter',
       		type: 'alert', 			// pointertype tells the nature of pointer     : accept alert or info
       		showTypeInMes: true,		// It allow to show Alert/ Info before message : accept true or false
       		position: 'bottom', 		// position tells position of the pointer      : accept bottom or top
       		jqueryuienabled: true,		// 
       		width: 250,
       		effect: 'blind',
       		hideAfterDisplay: true,
       		displayDuration: 4500,
       		fontweight: 'normal',
       		fontstyle: 'normal'
            };
    var settings = $.extend({}, defaults, options);
    this.each(function() {
    	 var 
    	 	divClazz = 'ui-state-error',
    	 	divImageClazz = 'ui-state-error',
    	 	divClazzShape = 'ui-corner-all',
    	 	divImageClazzShape = 'ui-corner-top',
    	 	iconClazz = 'ui-icon ui-icon-alert',
    	 	iconImageClazz = 'ui-icon ui-icon-carat-1-n',
    	 	iconImageAddCSS = {'border-bottom':'none'},
    	 	iconImageId = 'carat-1-n',
    	 	typeInMes = 'Alert',
    		headingTag = '';
    	 //------------------------------------------
         var position = $(this).offset();
         var thisWidth = $(this).width();
         var thisHeight = $(this).height();
       
       	if(settings.fontweight=='bold'){
       		settings.width = settings.width+30;
       	}
         if(typeof this.timeoutID == "number"){
              	window.clearTimeout(this.timeoutID);
         }
        
         var top = position.top + (thisHeight+21);
         var topImage = top-16;
         var left = position.left+thisWidth/2-settings.width/2;
         var leftImage = position.left+thisWidth/2-8;
         if(settings.position=='top'){
         	top = position.top -51;
         	topImage = position.top-16;
               	if(top<0){
         		top = position.top + (thisHeight+20);
         	}
         	divImageClazzShape = 'ui-corner-bottom';
         	iconImageClazz = 'ui-icon ui-icon-carat-1-s';
         	iconImageId = 'carat-1-s';
         	iconImageAddCSS = {'border-top':'none'};
         }
          if(left<0){
         	left = position.left;
         }
         //------------------------------------------
         if(settings.type=='info'){
         	divClazz = 'ui-state-highlight';
         	divClazzShape = 'ui-corner-all';
         	iconClazz = 'ui-icon ui-icon-info';
         	typeInMes = 'Info';
         }
        
         if(settings.showTypeInMes){
         	headingTag = '<strong>'+typeInMes+':</strong> ';
         }
         //------------------------------------------

         $('#jpointerMain').remove();
         $('body').append('<div id="jpointerMain"><div id="jpointerPoint" style="display:none;background-color:transparent;position:absolute;z-index:99999;" class="'+divClazz+'"><span id="'+iconImageId+'" class="'+iconImageClazz+'"/></div>'+
         			'<div class="'+divClazz+'" id="jpointerDiv" '+'style="display:none;padding: 0 .7em;z-index:9999;position:absolute;'+
         			'px;-moz-box-shadow: 5px 5px 5px #ccc;-webkit-box-shadow: 5px 5px 5px #ccc;box-shadow: 5px 5px 5px #ccc;">'+
         			'<p style="font-weight:'+settings.fontweight+';font-style:'+settings.fontstyle+'"><span class="'+iconClazz+'" style="float: left; margin-right: .3em;"></span>'+
         			headingTag+settings.msg+'</p>'+
         			'</div></div>');
	 
	 if(settings.position=='top'){
	  	 $('#jpointerDiv').css("bottom",$(window).height()-topImage).css("left",left).css("width",settings.width);
		 if($.browser.msie){
		 	$('#jpointerDiv').css("bottom",$(window).height()-topImage-5).css("left",left).css("width",settings.width);
	   	 }
	 }else{
	  	 $('#jpointerDiv').css("top",top).css("left",left).css("width",settings.width);
	 }
	 $('#jpointerPoint').css("top",topImage).css("left",leftImage).css("width","16px").css("height","16px ").css(iconImageAddCSS);
	 $('#jpointerDiv').addClass(divClazz).addClass(divClazzShape);
	 $('#jpointerPoint').addClass(divClazz).addClass(divImageClazzShape);


	
	 if(settings.position=='top'){
	 	$('#jpointerDiv').show(settings.effect,100, function() {
    			$('#jpointerPoint').show(settings.effect,100);
  	 	}).addClass('shadow');
  	 }else{
  	  	$('#jpointerPoint').show(settings.effect,100, function() {
	     		$('#jpointerDiv').show(settings.effect,100).addClass('shadow');
  	 	});
  	 }
	 
         this.focus();
         if(settings.hideAfterDisplay){
         	this.timeoutID = setTimeout(function() {
	 		$('#jpointerMain').remove(); 		
	 	}, settings.displayDuration);
	 	
	 }
	 
         
    });
    	$('#jpointerMain').click(function(){
    		$('#jpointerMain').remove(); 
    	});
	return $('#jpointerMain');

  };
  
})( jQuery );