// Scroll.js - (C) 2007 Panic, Inc.
 
var sidebar;
var currentLink = "";
var scrollArea = "scroller";
 
// Clicked Internal Link. Add to history, and scroll
 
function clickLink(link)
{
	currentLink = link;		// Set the global link we're on
		
	if (clickHistory.length == 0)
	{
        // Initialize history array with "top" if it's empty
    	clickHistory.push("top");
		clickCurrent++;
	}
	else if (clickCurrent < clickHistory.length)
	{
	   // History trail was interrupted while in the "middle", so cut everything from where we are
	   clickCurrent++;
	   clickHistory = clickHistory.slice(0, clickCurrent);
    }
    
    // Add the just-clicked link to the history
 
    clickHistory.push(link);
    clickCurrent++;
 
    // Go to it!
 
    scrollToElem(link);
    updateButtons();
 
}
 
// Scroll the page manually to the position of element "link", passed to us.
 
function scrollToElem(link)
{
    if (link != "top")
    {
	    theLink = document.getElementById(link);
        elemY = findElementPos(theLink) - 80;				// Element top + 100 pixels to make up for the top bar
    }
    else
    {
    	elemY = 0;
    }
 
	theScroll = document.getElementById(scrollArea);
 
	// If the target falls on the "last page", scroll to the bottom of the window
 
	if (elemY > (scroller.scrollHeight - scroller.clientHeight))
	{
		elemY = scroller.scrollHeight - scroller.clientHeight;
	}
	
	scrollStart(theScroll, theScroll.scrollTop, elemY);
	return false;
}
 
// Find the Y position of an element on a page
 
function findElementPos(elemFind)
{
	elemY = 0;
	elemX = 0;
	do {
		elemY += elemFind.offsetTop;
		elemX += elemFind.offsetLeft;
	} while ( elemFind = elemFind.offsetParent )
 
	return elemY;
}
 
//
// Animated Scroll Functions
//
 
var scrollanim = {time:0, begin:0, change:0.0, duration:0.0, element:null, timer:null};
 
function scrollStart(elem, start, end)
{
	//console.log("scrollStart from "+start+" to "+end);
	if (scrollanim.timer != null) {
		clearInterval(scrollanim.timer);
		scrollanim.timer = null;
	}
	scrollanim.time = 0;
	scrollanim.begin = start;
	scrollanim.change = end - start;
	scrollanim.duration = 15;
	scrollanim.element = elem;
	scrollanim.timer = setInterval("scrollAnim();", 13);
}
 
function scrollAnim()
{
	if (scrollanim.time > scrollanim.duration) {
		clearInterval(scrollanim.timer);
		scrollanim.timer = null;
	}
	else {
		move = cubicInOut(scrollanim.time, scrollanim.begin, scrollanim.change, scrollanim.duration);
		//console.log("Move to: "+move);
		scrollanim.element.scrollTop = move;
		scrollanim.time++;
	}
}
 
// t = time, b = begin, c = change, d = duration
// begin is fixed, change is basically finish-begin, duration is fixed (frames), but time changes (current frame).
// From http://www.robertpenner.com/easing/
 
function sineInOut(t, b, c, d)
{
	return -c/2 * (Math.cos(Math.PI*t/d) - 1) + b;
}
 
function cubicInOut(t, b, c, d)
{
	if ((t/=d/2) < 1) return c/2*t*t*t + b;
	return c/2*((t-=2)*t*t + 2) + b;
}
 
function bounceOut(t, b, c, d)
{
	if ((t/=d) < (1/2.75)){
		return c*(7.5625*t*t) + b;
	} else if (t < (2/2.75)){
		return c*(7.5625*(t-=(1.5/2.75))*t + .75) + b;
	} else if (t < (2.5/2.75)){
		return c*(7.5625*(t-=(2.25/2.75))*t + .9375) + b;
	} else {
		return c*(7.5625*(t-=(2.625/2.75))*t + .984375) + b;
	}
}
 
// slipDiffScroll
//
// Adapted from Safari RSS, documented by Cabel so I can remember what the crap is actually going on
 
function slipDiffScroll(scroller)
{
    if( sidebar === undefined ) sidebar = document.getElementById("sidebar");
    // console.log("clientHeight="+scroller.clientHeight+", scrollTop="+scroller.scrollTop);
 
    // sidebarTop basics: take how much of the page we're showing, and subtract the size of the sidebar.
    //
    // For example, if we're scrolled 397 pixels down (357 visible+40 scrolled), and the sidebar is 624 pixels long,
    // then sidebarTop is -227, meaning 200 pixels remain off-screen below.
    //
    // While the number remains negative (some is off-screen below), we keep the sidebar pinned at 0px, so
    // that it basically scrolls with the page to reveal the rest.
    //
    // Once the number flips positive (no more is off-screen below, pageVisible => sidebarHeight), the number becomes
    // the offset that we use to reposition the sidebar, so it remains always visible. I.e., it stops scrolling with
    // the page, and moves the same amount as has scrolled, so that it appears "fixed".
 
    var viewTop = scroller.scrollTop + 0;
    var pageVisible = scroller.clientHeight + scroller.scrollTop;
    var sidebarTop = pageVisible - 0 - sidebar.offsetHeight;
 
    //console.log("pageVisible="+pageVisible+" - sidebarHeight="+sidebar.offsetHeight+" / viewTop="+viewTop+", sidebarTop="+sidebarTop);
 
    if (sidebarTop < 0) {
        sidebarTop = 0;                                     // Scroll. Set to "0" so it sticks to the top and scrolls w/page.
    } else if (sidebarTop > viewTop) {
        sidebarTop = viewTop;                               // Don't let top of sidebar go below top of visible area
    }
    sidebar.style.top = sidebarTop - 0;
 
    //console.log("sidebar.style.top = "+sidebar.style.top);    
    
}