//
// Buttons.js - (C) 2007 Panic Inc.
//
 
var debug = 0;			// Turn on/off select debugging messages
 
var clickHistory = new Array();
var clickCurrent = 0;
 
var areRealPagesBack = 0;         // TO BE SET VIA COCOA
var areRealPagesForward = 0;      // TO BE SET VIA COCOA
 
//
// Create the CSS and HTML for the nav buttons, and handle graphic state changes.
//
 
// Preload relevant images
 
backOn      = new Image(); backOn.src = "http://iantearle.com/expanse/themes/Books/images/nav-button-left.png";
backOff     = new Image(); backOff.src = "http://iantearle.com/expanse/themes/Books/images/nav-button-left-disabled.png";
backDown    = new Image(); backDown.src = "http://iantearle.com/expanse/themes/Books/images/nav-button-pressed-left.png";
forwardOn   = new Image(); forwardOn.src = "http://iantearle.com/expanse/themes/Books/images/nav-button-right.png";
forwardOff  = new Image(); forwardOff.src = "http://iantearle.com/expanse/themes/Books/images/nav-button-right-disabled.png";
forwardDown = new Image(); forwardDown.src = "http://iantearle.com/expanse/themes/Books/images/nav-button-pressed-right.png";
home        = new Image(); home.src = "http://iantearle.com/expanse/themes/Books/images/nav-button-home.png";
homeDown    = new Image(); homeDown.src = "http://iantearle.com/expanse/themes/Books/images/nav-button-home-pressed.png";
homeOff     = new Image(); homeOff.src = "http://iantearle.com/expanse/themes/Books/images/nav-button-home-disabled.png";
 
// Write out the CSS
 
function NavButtonsStyle()
{
    document.write("<style type=\"text/css\" media=\"screen\">");
    document.write("#nav-buttons {");
    document.write("position: fixed;");
    document.write("top: 10px;");
    document.write("left: 12px;");
    document.write("-apple-text-size-adjust: none;");
    // document.write("font-size: 2.3em;");
    // document.write("line-height: 0.5em;");
    document.write("z-index: 9999;");
    document.write("white-space: nowrap;");
    document.write("}");
    document.write("img#nav-buttons-home {");
    document.write("margin-left: 12px;");
    document.write("white-space: nowrap;");
    document.write("}");
    document.write("</style>");
}
 
// Write out the HTML
// Back/fwd button events are initialized in updateButtons();
	
function CreateNavButtons()
{
	document.write("<div id=\"nav-buttons\">");
    document.write("<img src=\"http://iantearle.com/expanse/themes/Books/images/nav-button-left-disabled.png\" id=\"nav-buttons-back\" alt=\"Show the previous page.\" title=\"Show the previous page.\" />");
    document.write("<img src=\"http://iantearle.com/expanse/themes/Books/images/nav-button-mid.png\" alt=\"\"/>");
    document.write("<img src=\"http://iantearle.com/expanse/themes/Books/images/nav-button-right-disabled.png\" id=\"nav-buttons-forward\" alt=\"Show the next page.\" title=\"Show the next page.\" />");
	document.write("<img src=\"http://iantearle.com/expanse/themes/Books/images/nav-button-home.png\" id=\"nav-buttons-home\" alt=\"Go to this book's top page.\" title=\"Go to this book's top page.\" />");
    document.write("</div>");
}
 
// Set button graphics
 
function doBackDown()
{
    document.getElementById("nav-buttons-back").src = backDown.src;
}
function doBackUp()
{
    document.getElementById("nav-buttons-back").src = backOn.src;
}
function doFwdDown()
{
    document.getElementById("nav-buttons-forward").src = forwardDown.src;
}
function doFwdUp()
{
    document.getElementById("nav-buttons-forward").src = forwardOn.src;
}
function doHomeDown()
{
    document.getElementById("nav-buttons-home").src = homeDown.src;    
}
function doHomeUp()
{
    document.getElementById("nav-buttons-home").src = home.src;
}
 
 
// Change buttons states
 
function disableBack()
{
    document.getElementById("nav-buttons-back").src = backOff.src;
    document.getElementById("nav-buttons-back").onmousedown = null;
    document.getElementById("nav-buttons-back").onmouseup = null;
    document.getElementById("nav-buttons-back").onclick = null;
}
 
function disableForward()
{
    document.getElementById("nav-buttons-forward").src = forwardOff.src;
    document.getElementById("nav-buttons-forward").onmousedown = null;
    document.getElementById("nav-buttons-forward").onmouseup = null;
    document.getElementById("nav-buttons-forward").onclick = null;
}
 
function enableBack()
{
    doBackUp();
    document.getElementById("nav-buttons-back").onmousedown = doBackDown;
    document.getElementById("nav-buttons-back").onmouseup = doBackUp;
    document.getElementById("nav-buttons-back").onclick = goBack;
}
 
function enableForward()
{
    doFwdUp();
    document.getElementById("nav-buttons-forward").onmousedown = doFwdDown;
    document.getElementById("nav-buttons-forward").onmouseup = doFwdUp;
    document.getElementById("nav-buttons-forward").onclick = goForward;
}
 
function enableHome()
{
    doHomeUp();
    document.getElementById("nav-buttons-home").onmousedown = doHomeDown;
    document.getElementById("nav-buttons-home").onmouseup = doHomeUp;
    document.getElementById("nav-buttons-home").onclick = goHome;
}
 
function disableHome()
{
    document.getElementById("nav-buttons-home").src = homeOff.src;
    document.getElementById("nav-buttons-home").onmousedown = null;
    document.getElementById("nav-buttons-home").onmouseup = null;
    document.getElementById("nav-buttons-home").onclick = null;
}
 
// Update back/forward buttons based on where we are, and what's "really" behind / infront.
 
function updateButtons()
{
 
    if (debug == 1) { alert("Updating Buttons. ClkCurrent: "+clickCurrent+" ClkHistory: "+clickHistory.length+" RealBack: "+areRealPagesBack+" RealFwd: "+areRealPagesForward) }
 
    // Three states: no history at all, internal history, or "real" history.
    // Update: you'll always be able to go back, at least to the overall books page. So this check isn't necessary!
    //
    // if (areRealPagesBack == 0 && clickHistory.length == 0) {         // No real, no internal, disable.
    //     disableBack();
    // } else if (areRealPagesBack != 0 && clickHistory.length == 0) {  // Real, no internal, enable
    //     enableBack();
    // } else if (clickCurrent > 0 && clickHistory.length > 0) {        // Internal, and we're somewhere forward, enable
    //     enableBack();
    // } else if (clickCurrent == 0 && clickHistory.length > 0) {       // Internal, but at the back, only enable if there are real
    //     if (areRealPagesBack != 0) {
    //         enableBack();
    //     } else {
    //         disableBack();
    //     }
    // }
    
    enableBack();
 
    if (areRealPagesForward == 0 && clickHistory.length == 0) {
        disableForward();
    } else if (areRealPagesForward != 0 && clickHistory.length == 0) {
        enableForward();        
    } else if ((clickCurrent + 1) < clickHistory.length) {
        enableForward();
    } else if ((clickCurrent + 1) == clickHistory.length && clickHistory.length > 0) {
        if (areRealPagesForward != 0) {
            enableForward();
        } else {
            disableForward();
        }
    }
 
    // Enable "Home" if we're anywhere but root and "search"
 
    if (debug == 1) { alert("Checking home button. We're at: "+location.pathname+" 1: "+location.pathname.split('/')[1]+" 2: "+location.pathname.split('/')[2]) }
 
    if (location.pathname.split('/')[1] == "search") {
	enableHome();
    } else {
        if (! location.pathname.split('/')[2] || location.pathname.split('/')[2] == "index.html") {
       	    disableHome();
        } else {
            enableHome();
        }
    }
}
 
// CODA: Get the state from Coda, and set the key history variables. This is called at page load.
 
function setRealHistory(realBack, realForward)
{
    if (debug == 1) { alert("Setting real history: "+realBack+"/"+realForward) }
    areRealPagesBack = realBack;
    areRealPagesForward = realForward;
    updateButtons();
}
 
//
// Actually handle the clicks on the navigation buttons.
//
 
function goBack()
{
 
    if (debug == 1) { alert("ClkCurrent: "+clickCurrent+" ClkHistory: "+clickHistory.length+" RealBack: "+areRealPagesBack+" RealFwd: "+areRealPagesForward) }
 
    if (clickCurrent > 0)
    {
    	// There are internal links to go backwards to. So, do it!
        clickCurrent--;
        this.lastPage = clickHistory[clickCurrent];
        
        if (this.lastPage == currentLink)
        {
            // If the link we got back was the one we just went hit, grab one more link in the history.
        	clickCurrent--;
            this.lastPage = clickHistory[clickCurrent];
        }
        scrollToElem(this.lastPage);
        updateButtons();
    }
    else
    {
        // Actually go back, either to the Books page via a special call, or to the last page
        if (areRealPagesBack == 0) {
            if (debug == 1) { alert("  - CodaBooks.showBookshelf") }
            //window.CodaBooks.showBookshelf();   // CODA: Special call to go back to the bookshelf.
            history.back();
        } else {
            if (debug == 1) { alert("  - history.back") }
            history.back();
        }
    }
}
 
function goForward()
{
 
        if (debug == 1) { alert("ClkCurrent: "+clickCurrent+" ClkHistory: "+clickHistory.length+" RealBack: "+areRealPagesBack+" RealFwd: "+areRealPagesForward) }
 
	if ((clickCurrent + 1) < clickHistory.length)
	{
		// There are internal links to go forward to. Make it 'appen, guvnor.
	    clickCurrent++;
        this.lastPage = clickHistory[clickCurrent];
        scrollToElem(this.lastPage);
        updateButtons();
    }
    else
    {
        // Actually go forward.
        if (debug == 1) { alert("  - history.forward") }
        history.forward();
    }
}
 
// Go Home
 
function goHome()
{
    currentRoot = location.pathname.split('/')[1];
    if (debug == 1) { alert(currentRoot); }
 
    if (location.pathname.split('/')[1] == "search") {
	window.CodaBooks.showBookshelf();
    } else {
        location.pathname = '/'+currentRoot+'/';
    }
}
 
if (debug == 1) { alert("Buttons.js Initialized.") }