/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Bus;
import com.fluendo.jst.BusSyncHandler;
import com.fluendo.jst.Clock;
import com.fluendo.jst.ClockProvider;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Object;
import com.fluendo.jst.Pad;
import com.fluendo.jst.Query;
import com.fluendo.jst.SystemClock;
import com.fluendo.utils.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Pipeline
extends Element
implements BusSyncHandler {
    protected Vector elements = new Vector();
    protected Clock defClock;
    protected Clock fixedClock = null;
    protected Element clockProvider = null;
    protected Vector messages = new Vector();
    protected Bus internalBus;
    private BusThread busThread;
    private StateThread stateThread;
    private boolean stateDirty = false;
    private boolean polling = false;
    protected long streamTime;

    public Pipeline() {
        this(null);
    }

    public String getFactoryName() {
        return "pipeline";
    }

    public Pipeline(String string) {
        super(string);
        this.defClock = new SystemClock();
        this.internalBus = new Bus();
        this.internalBus.setSyncHandler(this);
        this.bus = new Bus();
        this.busThread = new BusThread(this.bus);
        this.busThread.start();
        this.stateThread = new StateThread();
        this.stateThread.start();
    }

    public synchronized void shutDown() {
        if (this.stateThread != null) {
            this.stateThread.shutDown();
            this.stateThread = null;
        }
        if (this.busThread != null) {
            this.busThread.shutDown();
            this.busThread = null;
        }
    }

    public void useClock(Clock clock) {
        this.fixedClock = clock;
    }

    public boolean add(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof ClockProvider) {
            this.defClock = ((ClockProvider)((java.lang.Object)element)).provideClock();
            this.clockProvider = element;
        }
        this.elements.addElement(element);
        element.baseTime = this.baseTime;
        element.setBus(this.internalBus);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Element element) {
        if (element == null) {
            return false;
        }
        boolean bl = this.elements.removeElement(element);
        if (bl) {
            if (element == this.clockProvider) {
                this.defClock = new SystemClock();
                this.clockProvider = null;
            }
            element.setBus(null);
            element.setClock(null);
            Pipeline pipeline = this;
            synchronized (pipeline) {
                this.stateDirty = true;
            }
        }
        return bl;
    }

    public Enumeration enumElements() {
        return this.elements.elements();
    }

    public Enumeration enumSorted() {
        return new SortedEnumerator();
    }

    public Enumeration enumSinks() {
        return new SinkEnumerator();
    }

    private void replaceMessage(Message message, int n) {
        int n2 = this.messages.size();
        Object object = message.getSrc();
        for (int i = 0; i < n2; ++i) {
            Message message2 = (Message)this.messages.elementAt(i);
            if (message2.getType() != n || message2.getSrc() != object) continue;
            this.messages.setElementAt(message, i);
            return;
        }
        this.messages.addElement(message);
    }

    private boolean findMessage(Object object, int n) {
        int n2 = this.messages.size();
        for (int i = 0; i < n2; ++i) {
            Message message = (Message)this.messages.elementAt(i);
            if (message.getType() != n || message.getSrc() != object) continue;
            return true;
        }
        return false;
    }

    protected boolean isEOS() {
        Enumeration enumeration = this.enumSinks();
        while (enumeration.hasMoreElements()) {
            Object object = (Object)enumeration.nextElement();
            if (this.findMessage(object, 1)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handleSyncMessage(Message message) {
        switch (message.getType()) {
            case 1: {
                boolean bl;
                Pipeline pipeline = this;
                synchronized (pipeline) {
                    Debug.log(3, this + " got EOS from sink: " + message.getSrc());
                    this.replaceMessage(message, 1);
                    bl = this.isEOS();
                }
                if (!bl) break;
                Debug.log(3, "all sinks posted EOS " + this);
                this.postMessage(Message.newEOS(this));
                break;
            }
            case 128: {
                this.scheduleReCalcState();
                break;
            }
            default: {
                this.postMessage(message);
            }
        }
        return 0;
    }

    public int getState(int[] nArray, int[] nArray2, long l) {
        this.reCalcState(false);
        return super.getState(nArray, nArray2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleReCalcState() {
        Pipeline pipeline = this;
        synchronized (pipeline) {
            this.stateDirty = true;
            this.stateThread.stateDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reCalcState(boolean bl) {
        boolean bl2;
        boolean bl3;
        int n = 1;
        Debug.debug("Pipeline.reCalcState");
        java.lang.Object object = this;
        synchronized (object) {
            if (bl) {
                this.stateDirty = true;
            }
            if (!this.stateDirty) {
                return;
            }
            if (this.polling) {
                return;
            }
            this.polling = true;
            this.stateDirty = false;
            bl3 = false;
            bl2 = false;
        }
        object = this.elements.elements();
        while (object.hasMoreElements()) {
            Element element = (Element)object.nextElement();
            n = element.getState(null, null, 1L);
            switch (n) {
                case 2: {
                    bl3 = true;
                    break;
                }
                case 3: {
                    bl2 = true;
                }
            }
            if (n != 0) continue;
            break;
        }
        if (n != 0) {
            if (bl2) {
                n = 3;
            }
            if (bl3) {
                n = 2;
            }
        }
        object = this;
        synchronized (object) {
            this.polling = false;
        }
        switch (n) {
            case 1: 
            case 3: {
                n = this.continueState(n);
                break;
            }
            case 2: {
                this.lostState();
                break;
            }
            case 0: {
                this.abortState();
                break;
            }
        }
    }

    protected int doChildStateChange(int n) {
        int n2;
        int n3 = this.getTransitionNext(n);
        boolean bl = false;
        boolean bl2 = false;
        Enumeration enumeration = this.enumSorted();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)enumeration.nextElement();
            element.setBus(this.internalBus);
            element.setClock(this.defClock);
            element.baseTime = this.baseTime;
            Debug.log(4, this + " setting state " + Element.getStateName(n3) + " on " + element);
            n2 = element.setState(n3);
            Debug.log(4, this + " " + element + " changed state, result = " + Element.getStateReturnName(n2));
            switch (n2) {
                case 2: {
                    bl = true;
                    break;
                }
                case 3: {
                    bl2 = true;
                    break;
                }
                case 0: {
                    return n2;
                }
            }
        }
        n2 = super.changeState(n);
        if (n2 == 0) {
            return n2;
        }
        if (bl2) {
            n2 = 3;
        } else if (bl) {
            n2 = 2;
        }
        return n2;
    }

    protected int changeState(int n) {
        long l;
        switch (n) {
            case 18: {
                this.messages.setSize(0);
                break;
            }
            case 35: {
                l = this.defClock.getTime();
                this.baseTime = l - this.streamTime;
                break;
            }
        }
        int n2 = this.doChildStateChange(n);
        switch (n) {
            case 18: {
                this.streamTime = 0L;
                break;
            }
            case 50: {
                l = this.defClock.getTime();
                this.streamTime = l - this.baseTime;
                this.messages.setSize(0);
                break;
            }
            case 33: {
                this.messages.setSize(0);
                break;
            }
        }
        return n2;
    }

    protected boolean doSendEvent(Event event) {
        boolean bl = true;
        Enumeration enumeration = this.enumSinks();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)enumeration.nextElement();
            bl &= element.sendEvent(event);
        }
        return bl;
    }

    private boolean doSeek(Event event) {
        boolean bl;
        boolean bl2;
        int[] nArray = new int[1];
        this.getState(nArray, null, 0L);
        boolean bl3 = bl2 = nArray[0] == 3;
        if (bl2) {
            this.setState(2);
        }
        if (bl = this.doSendEvent(event)) {
            this.streamTime = 0L;
        }
        if (bl2) {
            this.setState(3);
        }
        return bl;
    }

    public boolean sendEvent(Event event) {
        switch (event.getType()) {
            case 5: {
                return this.doSeek(event);
            }
        }
        return this.doSendEvent(event);
    }

    public boolean query(Query query) {
        Element element;
        boolean bl = true;
        Enumeration enumeration = this.enumSinks();
        while (enumeration.hasMoreElements() && !(bl = (element = (Element)enumeration.nextElement()).query(query))) {
        }
        return bl;
    }

    private class SinkEnumerator
    implements Enumeration {
        private Enumeration e;
        private java.lang.Object next;

        public SinkEnumerator() {
            this.e = Pipeline.this.enumElements();
            this.queueNextElement();
        }

        private void queueNextElement() {
            this.next = null;
            while (this.e.hasMoreElements()) {
                Element element = (Element)this.e.nextElement();
                if (!element.isFlagSet(32)) continue;
                this.next = element;
                break;
            }
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public java.lang.Object nextElement() throws NoSuchElementException {
            java.lang.Object object = this.next;
            if (object == null) {
                throw new NoSuchElementException();
            }
            this.queueNextElement();
            return object;
        }
    }

    private class SortedEnumerator
    implements Enumeration {
        private Vector queue = new Vector();
        private Hashtable hash = new Hashtable();
        private java.lang.Object next;
        private int mode;

        private void addToQueue(Element element) {
            this.queue.addElement(element);
            this.hash.put(element, new Integer(-1));
        }

        private void updateDegree(Element element) {
            Enumeration enumeration = element.enumPads();
            while (enumeration.hasMoreElements()) {
                Element element2;
                Pad pad;
                Pad pad2 = (Pad)enumeration.nextElement();
                if (pad2.direction != 2 || (pad = pad2.peer) == null || (element2 = (Element)pad.parent) == null) continue;
                int n = (Integer)this.hash.get(element2);
                int n2 = n + this.mode;
                if (n2 == 0) {
                    this.addToQueue(element2);
                    continue;
                }
                this.hash.put(element2, new Integer(n2));
            }
        }

        public SortedEnumerator() {
            Enumeration enumeration = Pipeline.this.enumElements();
            while (enumeration.hasMoreElements()) {
                Element element = (Element)enumeration.nextElement();
                if (element.isFlagSet(32)) {
                    this.addToQueue(element);
                    continue;
                }
                this.hash.put(element, new Integer(0));
            }
            this.mode = 1;
            enumeration = Pipeline.this.enumElements();
            while (enumeration.hasMoreElements()) {
                this.updateDegree((Element)enumeration.nextElement());
            }
            this.mode = -1;
            this.queueNextElement();
        }

        private void queueNextElement() {
            if (this.queue.isEmpty()) {
                int n = Integer.MAX_VALUE;
                Element element = null;
                Enumeration enumeration = Pipeline.this.enumElements();
                while (enumeration.hasMoreElements()) {
                    Element element2 = (Element)enumeration.nextElement();
                    int n2 = (Integer)this.hash.get(element2);
                    if (n2 < 0 || element != null && n <= n2) continue;
                    element = element2;
                    n = n2;
                }
                if (element != null) {
                    if (n != 0) {
                        System.out.println(this + " loop detected in pipeline!!");
                    }
                    this.next = element;
                    this.hash.put(this.next, new Integer(-1));
                } else {
                    this.next = null;
                }
            } else {
                this.next = this.queue.elementAt(0);
                this.queue.removeElementAt(0);
            }
            if (this.next != null) {
                this.updateDegree((Element)this.next);
            }
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public java.lang.Object nextElement() throws NoSuchElementException {
            java.lang.Object object = this.next;
            if (object == null) {
                throw new NoSuchElementException();
            }
            this.queueNextElement();
            return object;
        }
    }

    private class StateThread
    extends Thread {
        private boolean stopping = false;
        private boolean stateDirty = false;

        public StateThread() {
            super("cortado-StateThread-" + Debug.genId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stopping) {
                java.lang.Object object = this;
                synchronized (object) {
                    while (!this.stateDirty && !this.stopping) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.stateDirty = false;
                }
                if (this.stopping) continue;
                object = Pipeline.this.stateLock;
                synchronized (object) {
                    Pipeline.this.reCalcState(false);
                }
            }
        }

        public synchronized void stateDirty() {
            this.stateDirty = true;
            this.notifyAll();
        }

        public synchronized void shutDown() {
            this.stopping = true;
            this.notifyAll();
        }
    }

    private class BusThread
    extends Thread {
        private Bus bus;
        private boolean stopping;

        public BusThread(Bus bus) {
            super("cortado-BusThread-" + Debug.genId());
            this.bus = bus;
            this.stopping = false;
        }

        public void run() {
            while (!this.stopping) {
                this.bus.waitAndDispatch();
            }
        }

        public void shutDown() {
            this.stopping = true;
            this.bus.setFlushing(true);
        }
    }
}

